# This file is generated by SciPy's build process
# It contains system_info results at the time of building this package.
from enum import Enum

__all__ = ["show"]
_built_with_meson = True


class DisplayModes(Enum):
    stdout = "stdout"
    dicts = "dicts"


def _cleanup(d):
    """
    Removes empty values in a `dict` recursively
    This ensures we remove values that Meson could not provide to CONFIG
    """
    if isinstance(d, dict):
        return { k: _cleanup(v) for k, v in d.items() if v != '' and _cleanup(v) != '' }
    else:
        return d


CONFIG = _cleanup(
    {
        "Compilers": {
            "c": {
                "name": "gcc",
                "linker": r"ld.bfd",
                "version": "15.2.0",
                "commands": r"gcc",
                "args": r"-march=nocona, -msahf, -mtune=generic, -O2, -pipe, -Wp,-D_FORTIFY_SOURCE=2, -fstack-protector-strong, -Wp,-D__USE_MINGW_ANSI_STDIO=1",
                "linker args": r"-march=nocona, -msahf, -mtune=generic, -O2, -pipe, -Wp,-D_FORTIFY_SOURCE=2, -fstack-protector-strong, -Wp,-D__USE_MINGW_ANSI_STDIO=1",
            },
            "cython": {
                "name": r"cython",
                "linker": r"cython",
                "version": r"3.2.4",
                "commands": r"cython",
                "args": r"",
                "linker args": r"",
            },
            "c++": {
                "name": "gcc",
                "linker": r"ld.bfd",
                "version": "15.2.0",
                "commands": r"g++",
                "args": r"-march=nocona, -msahf, -mtune=generic, -O2, -pipe, -Wp,-D_FORTIFY_SOURCE=2, -fstack-protector-strong, -Wp,-D__USE_MINGW_ANSI_STDIO=1",
                "linker args": r"-march=nocona, -msahf, -mtune=generic, -O2, -pipe, -Wp,-D_FORTIFY_SOURCE=2, -fstack-protector-strong, -Wp,-D__USE_MINGW_ANSI_STDIO=1",
            },
            "fortran": {
                "name": "gcc",
                "linker": r"ld.bfd",
                "version": "15.2.0",
                "commands": r"gfortran",
                "args": r"",
                "linker args": r"",
            },
            "pythran": {
                "version": r"0.18.1",
                "include directory": r"../../../../../M/msys64/ucrt64/lib/python3.14/site-packages/pythran"
            },
        },
        "Machine Information": {
            "host": {
                "cpu": r"x86_64",
                "family": r"x86_64",
                "endian": r"little",
                "system": r"windows",
            },
            "build": {
                "cpu": r"x86_64",
                "family": r"x86_64",
                "endian": r"little",
                "system": r"windows",
            },
            "cross-compiled": bool("False".lower().replace('false', '')),
        },
        "Build Dependencies": {
            "blas": {
                "name": "openblas",
                "found": bool("True".lower().replace('false', '')),
                "version": "0.3.31",
                "detection method": "pkgconfig",
                "include directory": r"D:/M/msys64/ucrt64/include/openblas",
                "lib directory": r"D:/M/msys64/ucrt64/lib",
                "openblas configuration": r"USE_64BITINT= NO_CBLAS= NO_LAPACK= NO_LAPACKE= DYNAMIC_ARCH=ON DYNAMIC_OLDER=OFF NO_AFFINITY=1 USE_OPENMP=ON CORE2 MAX_THREADS=64",
                "pc file directory": r"D:/M/msys64/ucrt64/lib/pkgconfig",
                "has ilp64": bool(r"False".lower().replace('false', '')),
            },
            "lapack": {
                "name": "openblas",
                "found": bool("True".lower().replace('false', '')),
                "version": "0.3.31",
                "detection method": "pkgconfig",
                "include directory": r"D:/M/msys64/ucrt64/include/openblas",
                "lib directory": r"D:/M/msys64/ucrt64/lib",
                "openblas configuration": r"USE_64BITINT= NO_CBLAS= NO_LAPACK= NO_LAPACKE= DYNAMIC_ARCH=ON DYNAMIC_OLDER=OFF NO_AFFINITY=1 USE_OPENMP=ON CORE2 MAX_THREADS=64",
                "pc file directory": r"D:/M/msys64/ucrt64/lib/pkgconfig",
                "has ilp64": bool(r"False".lower().replace('false', '')),
            },
            "pybind11": {
                "name": "pybind11",
                "version": "3.0.2",
                "detection method": "pkgconfig",
                "include directory": r"D:/M/msys64/ucrt64/include",
            },
        },
        "Python Information": {
            "path": r"D:/M/msys64/ucrt64/bin/python.exe",
            "version": "3.14",
        },
    }
)


def _check_pyyaml():
    import yaml

    return yaml


def show(mode=DisplayModes.stdout.value):
    """
    Show libraries and system information on which SciPy was built
    and is being used

    Parameters
    ----------
    mode : {`'stdout'`, `'dicts'`}, optional.
        Indicates how to display the config information.
        `'stdout'` prints to console, `'dicts'` returns a dictionary
        of the configuration.

    Returns
    -------
    out : {`dict`, `None`}
        If mode is `'dicts'`, a dict is returned, else None

    Examples
    --------
    >>> import scipy
    >>> scipy.show_config()
    ... # formatted output is printed to the console

    >>> config_dict = scipy.show_config(mode='dicts')
    >>> list(config_dict.keys())
    ['Compilers', 'Machine Information', 'Build Dependencies', 'Python Information']

    Notes
    -----
    1. The `'stdout'` mode will give more readable
       output if ``pyyaml`` is installed

    """
    if mode == DisplayModes.stdout.value:
        try:  # Non-standard library, check import
            yaml = _check_pyyaml()

            print(yaml.dump(CONFIG))
        except ModuleNotFoundError:
            import warnings
            import json

            warnings.warn("Install `pyyaml` for better output", stacklevel=1)
            print(json.dumps(CONFIG, indent=2))
    elif mode == DisplayModes.dicts.value:
        return CONFIG
    else:
        raise AttributeError(
            f"Invalid `mode`, use one of: {', '.join([e.value for e in DisplayModes])}"
        )
