/*
 * Copyright 2024 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.gradle.internal.declarativedsl.dom.mutation.common

import org.gradle.internal.declarativedsl.dom.DeclarativeDocument.DocumentNode
import org.gradle.internal.declarativedsl.dom.data.NodeDataContainer


data class NodeRepresentationFlagsContainer(
    val forceEmptyBlockForNodes: Set<DocumentNode>
) : NodeDataContainer<TextRepresentationFlags, TextRepresentationFlags, Nothing, Nothing> {
    override fun data(node: DocumentNode.ElementNode) = TextRepresentationFlags(node in forceEmptyBlockForNodes)
    override fun data(node: DocumentNode.PropertyNode) = throw UnsupportedOperationException("can't query for property")
    override fun data(node: DocumentNode.ErrorNode) = throw UnsupportedOperationException("can't query for error node")

    companion object {
        fun composite(containers: Iterable<NodeRepresentationFlagsContainer>) =
            NodeRepresentationFlagsContainer(
                containers.flatMapTo(mutableSetOf(), NodeRepresentationFlagsContainer::forceEmptyBlockForNodes)
            )
    }
}


data class TextRepresentationFlags(val forceEmptyBlock: Boolean) {
    companion object {
        val default = TextRepresentationFlags(false)
    }
}
