#include <stdbool.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <mosquitto.h>

static int run = -1;
static int first_connection = 1;


static void on_connect(struct mosquitto *mosq, void *obj, int rc)
{
	(void)obj;

	if(rc){
		exit(1);
	}else{
		if(first_connection == 1){
			mosquitto_publish(mosq, NULL, "pub/qos1/test", strlen("message"), "message", 1, false);
			first_connection = 0;
		}
	}
}


static void on_publish(struct mosquitto *mosq, void *obj, int mid)
{
	(void)obj;
	(void)mid;

	mosquitto_disconnect(mosq);
}


static void on_disconnect(struct mosquitto *mosq, void *obj, int rc)
{
	(void)obj;

	if(rc){
		mosquitto_reconnect(mosq);
	}else{
		run = 0;
	}
}


int main(int argc, char *argv[])
{
	int rc;
	struct mosquitto *mosq;
	int port;

	if(argc < 2){
		return 1;
	}
	port = atoi(argv[1]);

	mosquitto_lib_init();

	mosq = mosquitto_new("publish-qos1-test", true, NULL);
	if(mosq == NULL){
		return 1;
	}
	mosquitto_connect_callback_set(mosq, on_connect);
	mosquitto_disconnect_callback_set(mosq, on_disconnect);
	mosquitto_publish_callback_set(mosq, on_publish);

	rc = mosquitto_connect(mosq, "localhost", port, 60);
	if(rc != MOSQ_ERR_SUCCESS){
		return rc;
	}

	while(run == -1){
		mosquitto_loop(mosq, 300, 1);
	}
	mosquitto_destroy(mosq);

	mosquitto_lib_cleanup();
	return run;
}
