/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath.transforms;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.codehaus.groovy.runtime.ProcessGroovyMethods;
import org.gradle.internal.classpath.Instrumented;
import org.gradle.internal.classpath.transforms.CommonTypes;
import org.gradle.internal.instrumentation.api.jvmbytecode.BridgeMethodBuilder;
import org.gradle.internal.instrumentation.api.jvmbytecode.DefaultBridgeMethodBuilder;
import org.gradle.internal.instrumentation.api.jvmbytecode.JvmBytecodeCallInterceptor;
import org.gradle.internal.instrumentation.api.types.BytecodeInterceptorType;
import org.gradle.model.internal.asm.MethodVisitorScope;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.MethodNode;

public class AdhocInterceptors
implements JvmBytecodeCallInterceptor {
    private static final Type SYSTEM_TYPE = Type.getType(System.class);
    private static final Type INTEGER_TYPE = Type.getType(Integer.class);
    private static final Type INSTRUMENTED_TYPE = Type.getType(Instrumented.class);
    private static final Type LONG_TYPE = Type.getType(Long.class);
    private static final Type BOOLEAN_TYPE = Type.getType(Boolean.class);
    private static final Type PROPERTIES_TYPE = Type.getType(Properties.class);
    private static final String RETURN_STRING_FROM_STRING = Type.getMethodDescriptor((Type)CommonTypes.STRING_TYPE, (Type[])new Type[]{CommonTypes.STRING_TYPE});
    private static final String RETURN_STRING_FROM_STRING_STRING = Type.getMethodDescriptor((Type)CommonTypes.STRING_TYPE, (Type[])new Type[]{CommonTypes.STRING_TYPE, CommonTypes.STRING_TYPE});
    private static final String RETURN_STRING_FROM_STRING_STRING_STRING = Type.getMethodDescriptor((Type)CommonTypes.STRING_TYPE, (Type[])new Type[]{CommonTypes.STRING_TYPE, CommonTypes.STRING_TYPE, CommonTypes.STRING_TYPE});
    private static final String RETURN_INTEGER_FROM_STRING = Type.getMethodDescriptor((Type)INTEGER_TYPE, (Type[])new Type[]{CommonTypes.STRING_TYPE});
    private static final String RETURN_INTEGER_FROM_STRING_INT = Type.getMethodDescriptor((Type)INTEGER_TYPE, (Type[])new Type[]{CommonTypes.STRING_TYPE, Type.INT_TYPE});
    private static final String RETURN_INTEGER_FROM_STRING_INTEGER = Type.getMethodDescriptor((Type)INTEGER_TYPE, (Type[])new Type[]{CommonTypes.STRING_TYPE, INTEGER_TYPE});
    private static final String RETURN_INTEGER_FROM_STRING_STRING = Type.getMethodDescriptor((Type)INTEGER_TYPE, (Type[])new Type[]{CommonTypes.STRING_TYPE, CommonTypes.STRING_TYPE});
    private static final String RETURN_INTEGER_FROM_STRING_INT_STRING = Type.getMethodDescriptor((Type)INTEGER_TYPE, (Type[])new Type[]{CommonTypes.STRING_TYPE, Type.INT_TYPE, CommonTypes.STRING_TYPE});
    private static final String RETURN_INTEGER_FROM_STRING_INTEGER_STRING = Type.getMethodDescriptor((Type)INTEGER_TYPE, (Type[])new Type[]{CommonTypes.STRING_TYPE, INTEGER_TYPE, CommonTypes.STRING_TYPE});
    private static final String RETURN_LONG_FROM_STRING = Type.getMethodDescriptor((Type)LONG_TYPE, (Type[])new Type[]{CommonTypes.STRING_TYPE});
    private static final String RETURN_LONG_FROM_STRING_PRIMITIVE_LONG = Type.getMethodDescriptor((Type)LONG_TYPE, (Type[])new Type[]{CommonTypes.STRING_TYPE, Type.LONG_TYPE});
    private static final String RETURN_LONG_FROM_STRING_LONG = Type.getMethodDescriptor((Type)LONG_TYPE, (Type[])new Type[]{CommonTypes.STRING_TYPE, LONG_TYPE});
    private static final String RETURN_LONG_FROM_STRING_STRING = Type.getMethodDescriptor((Type)LONG_TYPE, (Type[])new Type[]{CommonTypes.STRING_TYPE, CommonTypes.STRING_TYPE});
    private static final String RETURN_LONG_FROM_STRING_PRIMITIVE_LONG_STRING = Type.getMethodDescriptor((Type)LONG_TYPE, (Type[])new Type[]{CommonTypes.STRING_TYPE, Type.LONG_TYPE, CommonTypes.STRING_TYPE});
    private static final String RETURN_LONG_FROM_STRING_LONG_STRING = Type.getMethodDescriptor((Type)LONG_TYPE, (Type[])new Type[]{CommonTypes.STRING_TYPE, LONG_TYPE, CommonTypes.STRING_TYPE});
    private static final String RETURN_PRIMITIVE_BOOLEAN_FROM_STRING = Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[]{CommonTypes.STRING_TYPE});
    private static final String RETURN_PRIMITIVE_BOOLEAN_FROM_STRING_STRING = Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[]{CommonTypes.STRING_TYPE, CommonTypes.STRING_TYPE});
    private static final String RETURN_PROPERTIES = Type.getMethodDescriptor((Type)PROPERTIES_TYPE, (Type[])new Type[0]);
    private static final String RETURN_PROPERTIES_FROM_STRING = Type.getMethodDescriptor((Type)PROPERTIES_TYPE, (Type[])new Type[]{CommonTypes.STRING_TYPE});
    private static final String RETURN_VOID_FROM_PROPERTIES = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{PROPERTIES_TYPE});
    private static final String RETURN_VOID_FROM_PROPERTIES_STRING = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{PROPERTIES_TYPE, CommonTypes.STRING_TYPE});
    private static final String RETURN_MAP = Type.getMethodDescriptor((Type)Type.getType(Map.class), (Type[])new Type[0]);
    private static final String RETURN_MAP_FROM_STRING = Type.getMethodDescriptor((Type)Type.getType(Map.class), (Type[])new Type[]{CommonTypes.STRING_TYPE});
    private static final Type PROCESS_TYPE = Type.getType(Process.class);
    private static final Type PROCESS_BUILDER_TYPE = Type.getType(ProcessBuilder.class);
    private static final Type RUNTIME_TYPE = Type.getType(Runtime.class);
    private static final Type PROCESS_GROOVY_METHODS_TYPE = Type.getType(ProcessGroovyMethods.class);
    private static final Type STRING_ARRAY_TYPE = Type.getType(String[].class);
    private static final Type FILE_TYPE = Type.getType(File.class);
    private static final Type LIST_TYPE = Type.getType(List.class);
    private static final String RETURN_PROCESS = Type.getMethodDescriptor((Type)PROCESS_TYPE, (Type[])new Type[0]);
    private static final String RETURN_PROCESS_FROM_PROCESS_BUILDER_STRING = Type.getMethodDescriptor((Type)PROCESS_TYPE, (Type[])new Type[]{PROCESS_BUILDER_TYPE, CommonTypes.STRING_TYPE});
    private static final String RETURN_LIST_FROM_LIST = Type.getMethodDescriptor((Type)LIST_TYPE, (Type[])new Type[]{LIST_TYPE});
    private static final String RETURN_LIST_FROM_LIST_STRING = Type.getMethodDescriptor((Type)LIST_TYPE, (Type[])new Type[]{LIST_TYPE, CommonTypes.STRING_TYPE});
    private static final String RETURN_PROCESS_FROM_STRING = Type.getMethodDescriptor((Type)PROCESS_TYPE, (Type[])new Type[]{CommonTypes.STRING_TYPE});
    private static final String RETURN_PROCESS_FROM_RUNTIME_STRING_STRING = Type.getMethodDescriptor((Type)PROCESS_TYPE, (Type[])new Type[]{RUNTIME_TYPE, CommonTypes.STRING_TYPE, CommonTypes.STRING_TYPE});
    private static final String RETURN_PROCESS_FROM_STRING_STRING = Type.getMethodDescriptor((Type)PROCESS_TYPE, (Type[])new Type[]{CommonTypes.STRING_TYPE, CommonTypes.STRING_TYPE});
    private static final String RETURN_PROCESS_FROM_STRING_ARRAY = Type.getMethodDescriptor((Type)PROCESS_TYPE, (Type[])new Type[]{STRING_ARRAY_TYPE});
    private static final String RETURN_PROCESS_FROM_RUNTIME_STRING_ARRAY_STRING = Type.getMethodDescriptor((Type)PROCESS_TYPE, (Type[])new Type[]{RUNTIME_TYPE, STRING_ARRAY_TYPE, CommonTypes.STRING_TYPE});
    private static final String RETURN_PROCESS_FROM_STRING_ARRAY_STRING = Type.getMethodDescriptor((Type)PROCESS_TYPE, (Type[])new Type[]{STRING_ARRAY_TYPE, CommonTypes.STRING_TYPE});
    private static final String RETURN_PROCESS_FROM_LIST = Type.getMethodDescriptor((Type)PROCESS_TYPE, (Type[])new Type[]{LIST_TYPE});
    private static final String RETURN_PROCESS_FROM_LIST_STRING = Type.getMethodDescriptor((Type)PROCESS_TYPE, (Type[])new Type[]{LIST_TYPE, CommonTypes.STRING_TYPE});
    private static final String RETURN_PROCESS_FROM_STRING_STRING_ARRAY = Type.getMethodDescriptor((Type)PROCESS_TYPE, (Type[])new Type[]{CommonTypes.STRING_TYPE, STRING_ARRAY_TYPE});
    private static final String RETURN_PROCESS_FROM_RUNTIME_STRING_STRING_ARRAY_STRING = Type.getMethodDescriptor((Type)PROCESS_TYPE, (Type[])new Type[]{RUNTIME_TYPE, CommonTypes.STRING_TYPE, STRING_ARRAY_TYPE, CommonTypes.STRING_TYPE});
    private static final String RETURN_PROCESS_FROM_STRING_ARRAY_STRING_ARRAY = Type.getMethodDescriptor((Type)PROCESS_TYPE, (Type[])new Type[]{STRING_ARRAY_TYPE, STRING_ARRAY_TYPE});
    private static final String RETURN_PROCESS_FROM_RUNTIME_STRING_ARRAY_STRING_ARRAY_STRING = Type.getMethodDescriptor((Type)PROCESS_TYPE, (Type[])new Type[]{RUNTIME_TYPE, STRING_ARRAY_TYPE, STRING_ARRAY_TYPE, CommonTypes.STRING_TYPE});
    private static final String RETURN_PROCESS_FROM_STRING_STRING_ARRAY_FILE = Type.getMethodDescriptor((Type)PROCESS_TYPE, (Type[])new Type[]{CommonTypes.STRING_TYPE, STRING_ARRAY_TYPE, FILE_TYPE});
    private static final String RETURN_PROCESS_FROM_RUNTIME_STRING_STRING_ARRAY_FILE_STRING = Type.getMethodDescriptor((Type)PROCESS_TYPE, (Type[])new Type[]{RUNTIME_TYPE, CommonTypes.STRING_TYPE, STRING_ARRAY_TYPE, FILE_TYPE, CommonTypes.STRING_TYPE});
    private static final String RETURN_PROCESS_FROM_STRING_STRING_ARRAY_FILE_STRING = Type.getMethodDescriptor((Type)PROCESS_TYPE, (Type[])new Type[]{CommonTypes.STRING_TYPE, STRING_ARRAY_TYPE, FILE_TYPE, CommonTypes.STRING_TYPE});
    private static final String RETURN_PROCESS_FROM_STRING_ARRAY_STRING_ARRAY_FILE = Type.getMethodDescriptor((Type)PROCESS_TYPE, (Type[])new Type[]{STRING_ARRAY_TYPE, STRING_ARRAY_TYPE, FILE_TYPE});
    private static final String RETURN_PROCESS_FROM_RUNTIME_STRING_ARRAY_STRING_ARRAY_FILE_STRING = Type.getMethodDescriptor((Type)PROCESS_TYPE, (Type[])new Type[]{RUNTIME_TYPE, STRING_ARRAY_TYPE, STRING_ARRAY_TYPE, FILE_TYPE, CommonTypes.STRING_TYPE});
    private static final String RETURN_PROCESS_FROM_STRING_ARRAY_STRING_ARRAY_FILE_STRING = Type.getMethodDescriptor((Type)PROCESS_TYPE, (Type[])new Type[]{STRING_ARRAY_TYPE, STRING_ARRAY_TYPE, FILE_TYPE, CommonTypes.STRING_TYPE});
    private static final String RETURN_PROCESS_FROM_LIST_STRING_ARRAY_FILE = Type.getMethodDescriptor((Type)PROCESS_TYPE, (Type[])new Type[]{LIST_TYPE, STRING_ARRAY_TYPE, FILE_TYPE});
    private static final String RETURN_PROCESS_FROM_LIST_STRING_ARRAY_FILE_STRING = Type.getMethodDescriptor((Type)PROCESS_TYPE, (Type[])new Type[]{LIST_TYPE, STRING_ARRAY_TYPE, FILE_TYPE, CommonTypes.STRING_TYPE});
    private static final String RETURN_PROCESS_FROM_STRING_LIST_FILE = Type.getMethodDescriptor((Type)PROCESS_TYPE, (Type[])new Type[]{CommonTypes.STRING_TYPE, LIST_TYPE, FILE_TYPE});
    private static final String RETURN_PROCESS_FROM_STRING_LIST_FILE_STRING = Type.getMethodDescriptor((Type)PROCESS_TYPE, (Type[])new Type[]{CommonTypes.STRING_TYPE, LIST_TYPE, FILE_TYPE, CommonTypes.STRING_TYPE});
    private static final String RETURN_PROCESS_FROM_STRING_ARRAY_LIST_FILE = Type.getMethodDescriptor((Type)PROCESS_TYPE, (Type[])new Type[]{STRING_ARRAY_TYPE, LIST_TYPE, FILE_TYPE});
    private static final String RETURN_PROCESS_FROM_STRING_ARRAY_LIST_FILE_STRING = Type.getMethodDescriptor((Type)PROCESS_TYPE, (Type[])new Type[]{STRING_ARRAY_TYPE, LIST_TYPE, FILE_TYPE, CommonTypes.STRING_TYPE});
    private static final String RETURN_PROCESS_FROM_LIST_LIST_FILE = Type.getMethodDescriptor((Type)PROCESS_TYPE, (Type[])new Type[]{LIST_TYPE, LIST_TYPE, FILE_TYPE});
    private static final String RETURN_PROCESS_FROM_LIST_LIST_FILE_STRING = Type.getMethodDescriptor((Type)PROCESS_TYPE, (Type[])new Type[]{LIST_TYPE, LIST_TYPE, FILE_TYPE, CommonTypes.STRING_TYPE});

    public boolean visitMethodInsn(MethodVisitorScope mv, String className, int opcode, String owner, String name, String descriptor, boolean isInterface, Supplier<MethodNode> readMethodNode) {
        switch (opcode) {
            case 184: {
                return this.visitINVOKESTATIC(mv, className, owner, name, descriptor);
            }
            case 182: {
                return this.visitINVOKEVIRTUAL(mv, className, owner, name, descriptor);
            }
        }
        return false;
    }

    public BytecodeInterceptorType getType() {
        return BytecodeInterceptorType.INSTRUMENTATION;
    }

    private boolean visitINVOKESTATIC(MethodVisitorScope mv, String className, String owner, String name, String descriptor) {
        if (owner.equals(SYSTEM_TYPE.getInternalName())) {
            if (name.equals("getProperty")) {
                if (descriptor.equals(RETURN_STRING_FROM_STRING)) {
                    mv._LDC((Object)this.binaryClassNameOf(className));
                    mv._INVOKESTATIC(INSTRUMENTED_TYPE, "systemProperty", RETURN_STRING_FROM_STRING_STRING);
                    return true;
                }
                if (descriptor.equals(RETURN_STRING_FROM_STRING_STRING)) {
                    mv._LDC((Object)this.binaryClassNameOf(className));
                    mv._INVOKESTATIC(INSTRUMENTED_TYPE, "systemProperty", RETURN_STRING_FROM_STRING_STRING_STRING);
                    return true;
                }
            } else {
                if (name.equals("getProperties") && descriptor.equals(RETURN_PROPERTIES)) {
                    mv._LDC((Object)this.binaryClassNameOf(className));
                    mv._INVOKESTATIC(INSTRUMENTED_TYPE, "systemProperties", RETURN_PROPERTIES_FROM_STRING);
                    return true;
                }
                if (name.equals("setProperties") && descriptor.equals(RETURN_VOID_FROM_PROPERTIES)) {
                    mv._LDC((Object)this.binaryClassNameOf(className));
                    mv._INVOKESTATIC(INSTRUMENTED_TYPE, "setSystemProperties", RETURN_VOID_FROM_PROPERTIES_STRING);
                    return true;
                }
                if (name.equals("setProperty") && descriptor.equals(RETURN_STRING_FROM_STRING_STRING)) {
                    mv._LDC((Object)this.binaryClassNameOf(className));
                    mv._INVOKESTATIC(INSTRUMENTED_TYPE, "setSystemProperty", RETURN_STRING_FROM_STRING_STRING_STRING);
                    return true;
                }
                if (name.equals("clearProperty") && descriptor.equals(RETURN_STRING_FROM_STRING)) {
                    mv._LDC((Object)this.binaryClassNameOf(className));
                    mv._INVOKESTATIC(INSTRUMENTED_TYPE, "clearSystemProperty", RETURN_STRING_FROM_STRING_STRING);
                    return true;
                }
                if (name.equals("getenv")) {
                    if (descriptor.equals(RETURN_STRING_FROM_STRING)) {
                        mv._LDC((Object)this.binaryClassNameOf(className));
                        mv._INVOKESTATIC(INSTRUMENTED_TYPE, "getenv", RETURN_STRING_FROM_STRING_STRING);
                        return true;
                    }
                    if (descriptor.equals(RETURN_MAP)) {
                        mv._LDC((Object)this.binaryClassNameOf(className));
                        mv._INVOKESTATIC(INSTRUMENTED_TYPE, "getenv", RETURN_MAP_FROM_STRING);
                        return true;
                    }
                }
            }
        } else if (owner.equals(INTEGER_TYPE.getInternalName()) && name.equals("getInteger")) {
            if (descriptor.equals(RETURN_INTEGER_FROM_STRING)) {
                mv._LDC((Object)this.binaryClassNameOf(className));
                mv._INVOKESTATIC(INSTRUMENTED_TYPE, "getInteger", RETURN_INTEGER_FROM_STRING_STRING);
                return true;
            }
            if (descriptor.equals(RETURN_INTEGER_FROM_STRING_INT)) {
                mv._LDC((Object)this.binaryClassNameOf(className));
                mv._INVOKESTATIC(INSTRUMENTED_TYPE, "getInteger", RETURN_INTEGER_FROM_STRING_INT_STRING);
                return true;
            }
            if (descriptor.equals(RETURN_INTEGER_FROM_STRING_INTEGER)) {
                mv._LDC((Object)this.binaryClassNameOf(className));
                mv._INVOKESTATIC(INSTRUMENTED_TYPE, "getInteger", RETURN_INTEGER_FROM_STRING_INTEGER_STRING);
                return true;
            }
        } else if (owner.equals(LONG_TYPE.getInternalName()) && name.equals("getLong")) {
            if (descriptor.equals(RETURN_LONG_FROM_STRING)) {
                mv._LDC((Object)this.binaryClassNameOf(className));
                mv._INVOKESTATIC(INSTRUMENTED_TYPE, "getLong", RETURN_LONG_FROM_STRING_STRING);
                return true;
            }
            if (descriptor.equals(RETURN_LONG_FROM_STRING_PRIMITIVE_LONG)) {
                mv._LDC((Object)this.binaryClassNameOf(className));
                mv._INVOKESTATIC(INSTRUMENTED_TYPE, "getLong", RETURN_LONG_FROM_STRING_PRIMITIVE_LONG_STRING);
                return true;
            }
            if (descriptor.equals(RETURN_LONG_FROM_STRING_LONG)) {
                mv._LDC((Object)this.binaryClassNameOf(className));
                mv._INVOKESTATIC(INSTRUMENTED_TYPE, "getLong", RETURN_LONG_FROM_STRING_LONG_STRING);
                return true;
            }
        } else {
            if (owner.equals(BOOLEAN_TYPE.getInternalName()) && name.equals("getBoolean") && descriptor.equals(RETURN_PRIMITIVE_BOOLEAN_FROM_STRING)) {
                mv._LDC((Object)this.binaryClassNameOf(className));
                mv._INVOKESTATIC(INSTRUMENTED_TYPE, "getBoolean", RETURN_PRIMITIVE_BOOLEAN_FROM_STRING_STRING);
                return true;
            }
            if (owner.equals(PROCESS_GROOVY_METHODS_TYPE.getInternalName()) && name.equals("execute")) {
                Optional<String> instrumentedDescriptor = this.getInstrumentedDescriptorForProcessGroovyMethodsExecuteDescriptor(descriptor);
                if (!instrumentedDescriptor.isPresent()) {
                    return false;
                }
                mv._LDC((Object)this.binaryClassNameOf(className));
                mv._INVOKESTATIC(INSTRUMENTED_TYPE, "execute", instrumentedDescriptor.get());
                return true;
            }
        }
        if (owner.equals(PROCESS_BUILDER_TYPE.getInternalName()) && name.equals("startPipeline") && descriptor.equals(RETURN_LIST_FROM_LIST)) {
            mv._LDC((Object)this.binaryClassNameOf(className));
            mv._INVOKESTATIC(INSTRUMENTED_TYPE, "startPipeline", RETURN_LIST_FROM_LIST_STRING);
            return true;
        }
        return false;
    }

    private Optional<String> getInstrumentedDescriptorForProcessGroovyMethodsExecuteDescriptor(String descriptor) {
        if (descriptor.equals(RETURN_PROCESS_FROM_STRING)) {
            return Optional.of(RETURN_PROCESS_FROM_STRING_STRING);
        }
        if (descriptor.equals(RETURN_PROCESS_FROM_STRING_ARRAY)) {
            return Optional.of(RETURN_PROCESS_FROM_STRING_ARRAY_STRING);
        }
        if (descriptor.equals(RETURN_PROCESS_FROM_LIST)) {
            return Optional.of(RETURN_PROCESS_FROM_LIST_STRING);
        }
        if (descriptor.equals(RETURN_PROCESS_FROM_STRING_STRING_ARRAY_FILE)) {
            return Optional.of(RETURN_PROCESS_FROM_STRING_STRING_ARRAY_FILE_STRING);
        }
        if (descriptor.equals(RETURN_PROCESS_FROM_STRING_ARRAY_STRING_ARRAY_FILE)) {
            return Optional.of(RETURN_PROCESS_FROM_STRING_ARRAY_STRING_ARRAY_FILE_STRING);
        }
        if (descriptor.equals(RETURN_PROCESS_FROM_LIST_STRING_ARRAY_FILE)) {
            return Optional.of(RETURN_PROCESS_FROM_LIST_STRING_ARRAY_FILE_STRING);
        }
        if (descriptor.equals(RETURN_PROCESS_FROM_STRING_LIST_FILE)) {
            return Optional.of(RETURN_PROCESS_FROM_STRING_LIST_FILE_STRING);
        }
        if (descriptor.equals(RETURN_PROCESS_FROM_STRING_ARRAY_LIST_FILE)) {
            return Optional.of(RETURN_PROCESS_FROM_STRING_ARRAY_LIST_FILE_STRING);
        }
        if (descriptor.equals(RETURN_PROCESS_FROM_LIST_LIST_FILE)) {
            return Optional.of(RETURN_PROCESS_FROM_LIST_LIST_FILE_STRING);
        }
        return Optional.empty();
    }

    private boolean visitINVOKEVIRTUAL(MethodVisitorScope mv, String className, String owner, String name, String descriptor) {
        if (owner.equals(RUNTIME_TYPE.getInternalName()) && name.equals("exec")) {
            Optional<String> instrumentedDescriptor = this.getInstrumentedDescriptorForRuntimeExecDescriptor(descriptor);
            if (!instrumentedDescriptor.isPresent()) {
                return false;
            }
            mv._LDC((Object)this.binaryClassNameOf(className));
            mv._INVOKESTATIC(INSTRUMENTED_TYPE, "exec", instrumentedDescriptor.get());
            return true;
        }
        if (owner.equals(PROCESS_BUILDER_TYPE.getInternalName()) && name.equals("start") && descriptor.equals(RETURN_PROCESS)) {
            mv._LDC((Object)this.binaryClassNameOf(className));
            mv._INVOKESTATIC(INSTRUMENTED_TYPE, "start", RETURN_PROCESS_FROM_PROCESS_BUILDER_STRING);
            return true;
        }
        return false;
    }

    private Optional<String> getInstrumentedDescriptorForRuntimeExecDescriptor(String descriptor) {
        if (descriptor.equals(RETURN_PROCESS_FROM_STRING)) {
            return Optional.of(RETURN_PROCESS_FROM_RUNTIME_STRING_STRING);
        }
        if (descriptor.equals(RETURN_PROCESS_FROM_STRING_ARRAY)) {
            return Optional.of(RETURN_PROCESS_FROM_RUNTIME_STRING_ARRAY_STRING);
        }
        if (descriptor.equals(RETURN_PROCESS_FROM_STRING_STRING_ARRAY)) {
            return Optional.of(RETURN_PROCESS_FROM_RUNTIME_STRING_STRING_ARRAY_STRING);
        }
        if (descriptor.equals(RETURN_PROCESS_FROM_STRING_ARRAY_STRING_ARRAY)) {
            return Optional.of(RETURN_PROCESS_FROM_RUNTIME_STRING_ARRAY_STRING_ARRAY_STRING);
        }
        if (descriptor.equals(RETURN_PROCESS_FROM_STRING_STRING_ARRAY_FILE)) {
            return Optional.of(RETURN_PROCESS_FROM_RUNTIME_STRING_STRING_ARRAY_FILE_STRING);
        }
        if (descriptor.equals(RETURN_PROCESS_FROM_STRING_ARRAY_STRING_ARRAY_FILE)) {
            return Optional.of(RETURN_PROCESS_FROM_RUNTIME_STRING_ARRAY_STRING_ARRAY_FILE_STRING);
        }
        return Optional.empty();
    }

    private String binaryClassNameOf(String className) {
        return Type.getObjectType((String)className).getClassName();
    }

    @Nullable
    public BridgeMethodBuilder findBridgeMethodBuilder(String className, int tag, String owner, String name, String descriptor) {
        if (tag == 6 && owner.equals(SYSTEM_TYPE.getInternalName()) && name.equals("getProperty") && descriptor.equals(RETURN_STRING_FROM_STRING)) {
            return DefaultBridgeMethodBuilder.create((int)tag, (String)owner, (String)descriptor, (String)INSTRUMENTED_TYPE.getInternalName(), (String)"systemProperty", (String)RETURN_STRING_FROM_STRING_STRING).withClassName(className);
        }
        return null;
    }
}

