/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories.resolver;

import java.io.File;
import java.util.Collection;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ComponentResolvers;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.DescriptorParseContext;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelector;
import org.gradle.api.internal.artifacts.repositories.metadata.DefaultMetadataFileSource;
import org.gradle.api.internal.component.ArtifactType;
import org.gradle.internal.component.external.model.ModuleComponentArtifactIdentifier;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ComponentArtifactResolveState;
import org.gradle.internal.component.model.DefaultComponentOverrideMetadata;
import org.gradle.internal.component.model.MutableModuleSources;
import org.gradle.internal.hash.ChecksumService;
import org.gradle.internal.resolve.resolver.ArtifactResolver;
import org.gradle.internal.resolve.resolver.ComponentMetaDataResolver;
import org.gradle.internal.resolve.result.DefaultBuildableArtifactResolveResult;
import org.gradle.internal.resolve.result.DefaultBuildableArtifactSetResolveResult;
import org.gradle.internal.resolve.result.DefaultBuildableComponentIdResolveResult;
import org.gradle.internal.resolve.result.DefaultBuildableComponentResolveResult;
import org.gradle.internal.resource.local.FileResourceRepository;
import org.gradle.internal.resource.local.LocallyAvailableExternalResource;

public class ExternalResourceResolverDescriptorParseContext
implements DescriptorParseContext {
    private final ComponentResolvers mainResolvers;
    private final FileResourceRepository fileResourceRepository;
    private final MutableModuleSources sources = new MutableModuleSources();
    private final ChecksumService checksumService;

    public ExternalResourceResolverDescriptorParseContext(ComponentResolvers mainResolvers, FileResourceRepository fileResourceRepository, ChecksumService checksumService) {
        this.mainResolvers = mainResolvers;
        this.fileResourceRepository = fileResourceRepository;
        this.checksumService = checksumService;
    }

    @Override
    public LocallyAvailableExternalResource getMetaDataArtifact(ModuleComponentIdentifier moduleComponentIdentifier, ArtifactType artifactType) {
        return this.resolveMetaDataArtifactFile(moduleComponentIdentifier, this.mainResolvers.getComponentResolver(), this.mainResolvers.getArtifactResolver(), artifactType);
    }

    @Override
    public LocallyAvailableExternalResource getMetaDataArtifact(ModuleComponentSelector selector, VersionSelector acceptor, ArtifactType artifactType) {
        DefaultBuildableComponentIdResolveResult idResolveResult = new DefaultBuildableComponentIdResolveResult();
        this.mainResolvers.getComponentIdResolver().resolve((ComponentSelector)selector, DefaultComponentOverrideMetadata.EMPTY, acceptor, null, idResolveResult);
        return this.getMetaDataArtifact((ModuleComponentIdentifier)idResolveResult.getId(), artifactType);
    }

    private LocallyAvailableExternalResource resolveMetaDataArtifactFile(ModuleComponentIdentifier moduleComponentIdentifier, ComponentMetaDataResolver componentResolver, ArtifactResolver artifactResolver, ArtifactType artifactType) {
        DefaultBuildableComponentResolveResult moduleVersionResolveResult = new DefaultBuildableComponentResolveResult();
        componentResolver.resolve((ComponentIdentifier)moduleComponentIdentifier, DefaultComponentOverrideMetadata.EMPTY, moduleVersionResolveResult);
        DefaultBuildableArtifactSetResolveResult moduleArtifactsResolveResult = new DefaultBuildableArtifactSetResolveResult();
        ComponentArtifactResolveState artifactResolveState = moduleVersionResolveResult.getState().prepareForArtifactResolution();
        artifactResolveState.resolveArtifactsWithType(artifactResolver, artifactType, moduleArtifactsResolveResult);
        DefaultBuildableArtifactResolveResult artifactResolveResult = new DefaultBuildableArtifactResolveResult();
        ComponentArtifactMetadata artifactMetaData = (ComponentArtifactMetadata)((Collection)moduleArtifactsResolveResult.getResult()).iterator().next();
        artifactResolver.resolveArtifact(artifactResolveState.getArtifactMetadata(), artifactMetaData, artifactResolveResult);
        File file = artifactResolveResult.getResult().getFile();
        LocallyAvailableExternalResource resource = this.fileResourceRepository.resource(file);
        ComponentArtifactIdentifier id = artifactMetaData.getId();
        if (id instanceof ModuleComponentArtifactIdentifier) {
            this.sources.add(new DefaultMetadataFileSource((ModuleComponentArtifactIdentifier)id, file, this.checksumService.sha1(file)));
        }
        return resource;
    }

    public void appendSources(MutableModuleSources sources) {
        this.sources.withSources(sources::add);
    }
}

