/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.configurations;

import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Named;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.UnknownDomainObjectException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConsumableConfiguration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencyScopeConfiguration;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.LegacyConfiguration;
import org.gradle.api.artifacts.ResolvableConfiguration;
import org.gradle.api.artifacts.UnknownConfigurationException;
import org.gradle.api.internal.AbstractNamedDomainObjectContainer;
import org.gradle.api.internal.AbstractValidatingNamedDomainObjectContainer;
import org.gradle.api.internal.CollectionCallbackActionDecorator;
import org.gradle.api.internal.DefaultNamedDomainObjectCollection;
import org.gradle.api.internal.DomainObjectContext;
import org.gradle.api.internal.artifacts.ConfigurationResolver;
import org.gradle.api.internal.artifacts.configurations.ConfigurationContainerInternal;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.artifacts.configurations.ConfigurationRole;
import org.gradle.api.internal.artifacts.configurations.ConfigurationRoles;
import org.gradle.api.internal.artifacts.configurations.ConfigurationRolesForMigration;
import org.gradle.api.internal.artifacts.configurations.DefaultConfiguration;
import org.gradle.api.internal.artifacts.configurations.DefaultConfigurationFactory;
import org.gradle.api.internal.artifacts.configurations.DefaultLegacyConfiguration;
import org.gradle.api.internal.artifacts.configurations.ResolutionStrategyFactory;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.problems.ProblemGroup;
import org.gradle.api.problems.ProblemId;
import org.gradle.api.problems.Severity;
import org.gradle.api.problems.internal.GradleCoreProblemGroup;
import org.gradle.api.problems.internal.InternalProblems;
import org.gradle.api.provider.Provider;
import org.gradle.internal.Actions;
import org.gradle.internal.Cast;
import org.gradle.internal.reflect.Instantiator;
import org.jspecify.annotations.Nullable;

public class DefaultConfigurationContainer
extends AbstractValidatingNamedDomainObjectContainer<Configuration>
implements ConfigurationContainerInternal {
    public static final String DETACHED_CONFIGURATION_DEFAULT_NAME = "detachedConfiguration";
    private static final Pattern RESERVED_NAMES_FOR_DETACHED_CONFS = Pattern.compile("detachedConfiguration\\d*");
    private final DomainObjectContext owner;
    private final DefaultConfigurationFactory defaultConfigurationFactory;
    private final ResolutionStrategyFactory resolutionStrategyFactory;
    private final InternalProblems problemsService;
    private final ConfigurationResolver resolver;
    private final AtomicInteger detachedConfigurationDefaultNameCounter = new AtomicInteger(1);

    @Inject
    public DefaultConfigurationContainer(Instantiator instantiator, CollectionCallbackActionDecorator callbackDecorator, DomainObjectContext owner, DefaultConfigurationFactory defaultConfigurationFactory, ResolutionStrategyFactory resolutionStrategyFactory, InternalProblems problemsService, ConfigurationResolver.Factory resolverFactory, AttributesSchemaInternal schema) {
        super(Configuration.class, instantiator, Named.Namer.INSTANCE, callbackDecorator);
        this.owner = owner;
        this.defaultConfigurationFactory = defaultConfigurationFactory;
        this.resolutionStrategyFactory = resolutionStrategyFactory;
        this.problemsService = problemsService;
        this.resolver = resolverFactory.create(this, owner, schema);
    }

    protected Configuration doCreate(String name) {
        this.validateNameIsAllowed(name);
        return this.defaultConfigurationFactory.create(name, false, this.resolver, this.resolutionStrategyFactory, ConfigurationRoles.ALL);
    }

    protected NamedDomainObjectProvider<Configuration> createDomainObjectProvider(String name, @Nullable Action<? super Configuration> configurationAction) {
        this.assertElementNotPresent(name);
        NamedDomainObjectProvider provider = (NamedDomainObjectProvider)Cast.uncheckedCast((Object)this.getInstantiator().newInstance(AbstractNamedDomainObjectContainer.NamedDomainObjectCreatingProvider.class, new Object[]{this, name, LegacyConfiguration.class, configurationAction}));
        this.doAddLater((Provider)provider);
        return provider;
    }

    @Override
    public void visitConsumable(Consumer<ConfigurationInternal> visitor) {
        this.withType(ConsumableConfiguration.class).forEach(configuration -> visitor.accept((ConfigurationInternal)configuration));
        this.withType(LegacyConfiguration.class).forEach(configuration -> {
            if (configuration.isCanBeConsumed()) {
                visitor.accept((ConfigurationInternal)configuration);
            }
        });
    }

    public @Nullable ConfigurationInternal findByName(String name) {
        return (ConfigurationInternal)super.findByName(name);
    }

    @Override
    public ConfigurationInternal getByName(String name) {
        return (ConfigurationInternal)super.getByName(name);
    }

    public String getTypeDisplayName() {
        return "configuration";
    }

    protected UnknownDomainObjectException createNotFoundException(String name) {
        return new UnknownConfigurationException(String.format("Configuration with name '%s' not found.", name));
    }

    private RuntimeException failOnAttemptToAdd(String behavior) {
        GradleException ex = new GradleException(behavior);
        ProblemId id = ProblemId.create((String)"method-not-allowed", (String)"Method call not allowed", (ProblemGroup)GradleCoreProblemGroup.configurationUsage());
        throw this.problemsService.getInternalReporter().throwing((Throwable)ex, id, spec -> {
            spec.contextualLabel(ex.getMessage());
            spec.severity(Severity.ERROR);
        });
    }

    public boolean add(@Nullable Configuration o) {
        throw this.failOnAttemptToAdd("Adding a configuration directly to the configuration container is not allowed.  Use a factory method instead to create a new configuration in the container.");
    }

    public boolean addAll(Collection<? extends Configuration> c) {
        throw this.failOnAttemptToAdd("Adding a collection of configurations directly to the configuration container is not allowed.  Use a factory method instead to create a new configuration in the container.");
    }

    public void addLater(Provider<? extends Configuration> provider) {
        throw this.failOnAttemptToAdd("Adding a configuration provider directly to the configuration container is not allowed.  Use a factory method instead to create a new configuration in the container.");
    }

    public void addAllLater(Provider<? extends Iterable<Configuration>> provider) {
        throw this.failOnAttemptToAdd("Adding a provider of configurations directly to the configuration container is not allowed.  Use a factory method instead to create a new configuration in the container.");
    }

    @Override
    public ConfigurationInternal detachedConfiguration(Dependency ... dependencies) {
        String name = this.nextDetachedConfigurationName();
        ConfigurationRole role = ConfigurationRoles.RESOLVABLE_DEPENDENCY_SCOPE;
        DefaultLegacyConfiguration detachedConfiguration = this.defaultConfigurationFactory.create(name, true, this.resolver, this.resolutionStrategyFactory, role);
        this.copyAllTo(detachedConfiguration, dependencies);
        return detachedConfiguration;
    }

    private String nextDetachedConfigurationName() {
        return DETACHED_CONFIGURATION_DEFAULT_NAME + this.detachedConfigurationDefaultNameCounter.getAndIncrement();
    }

    private void copyAllTo(DefaultConfiguration detachedConfiguration, Dependency[] dependencies) {
        DependencySet detachedDependencies = detachedConfiguration.getDependencies();
        for (Dependency dependency : dependencies) {
            detachedDependencies.add((Object)dependency.copy());
        }
    }

    public NamedDomainObjectProvider<ResolvableConfiguration> resolvable(String name) {
        this.assertCanMutate("resolvable(String)");
        return this.registerResolvableConfiguration(name, (Action<? super ResolvableConfiguration>)Actions.doNothing());
    }

    public NamedDomainObjectProvider<ResolvableConfiguration> resolvable(String name, Action<? super ResolvableConfiguration> action) {
        this.assertCanMutate("resolvable(String, Action)");
        return this.registerResolvableConfiguration(name, action);
    }

    public Configuration resolvableLocked(String name) {
        this.assertCanMutate("resolvableLocked(String)");
        return this.createLockedLegacyConfiguration(name, ConfigurationRoles.RESOLVABLE, (Action<? super Configuration>)Actions.doNothing());
    }

    public Configuration resolvableLocked(String name, Action<? super Configuration> action) {
        this.assertCanMutate("resolvableLocked(String, Action)");
        return this.createLockedLegacyConfiguration(name, ConfigurationRoles.RESOLVABLE, action);
    }

    public NamedDomainObjectProvider<ConsumableConfiguration> consumable(String name) {
        this.assertCanMutate("consumable(String)");
        return this.registerConsumableConfiguration(name, (Action<? super ConsumableConfiguration>)Actions.doNothing());
    }

    public NamedDomainObjectProvider<ConsumableConfiguration> consumable(String name, Action<? super ConsumableConfiguration> action) {
        this.assertCanMutate("consumable(String, Action)");
        return this.registerConsumableConfiguration(name, action);
    }

    public Configuration consumableLocked(String name) {
        this.assertCanMutate("consumableLocked(String)");
        return this.createLockedLegacyConfiguration(name, ConfigurationRoles.CONSUMABLE, (Action<? super Configuration>)Actions.doNothing());
    }

    public Configuration consumableLocked(String name, Action<? super Configuration> action) {
        this.assertCanMutate("consumableLocked(String, Action)");
        return this.createLockedLegacyConfiguration(name, ConfigurationRoles.CONSUMABLE, action);
    }

    public NamedDomainObjectProvider<DependencyScopeConfiguration> dependencyScope(String name) {
        this.assertCanMutate("dependencyScope(String)");
        return this.registerDependencyScopeConfiguration(name, (Action<? super DependencyScopeConfiguration>)Actions.doNothing());
    }

    public NamedDomainObjectProvider<DependencyScopeConfiguration> dependencyScope(String name, Action<? super DependencyScopeConfiguration> action) {
        this.assertCanMutate("dependencyScope(String, Action)");
        return this.registerDependencyScopeConfiguration(name, action);
    }

    public Configuration dependencyScopeLocked(String name) {
        this.assertCanMutate("dependencyScopeLocked(String)");
        return this.createLockedLegacyConfiguration(name, ConfigurationRoles.DEPENDENCY_SCOPE, (Action<? super Configuration>)Actions.doNothing());
    }

    public Configuration dependencyScopeLocked(String name, Action<? super Configuration> action) {
        this.assertCanMutate("dependencyScopeLocked(String, Action)");
        return this.createLockedLegacyConfiguration(name, ConfigurationRoles.DEPENDENCY_SCOPE, action);
    }

    @Deprecated
    public Configuration resolvableDependencyScopeLocked(String name) {
        this.assertCanMutate("resolvableDependencyScopeLocked(String)");
        return this.createLockedLegacyConfiguration(name, ConfigurationRoles.RESOLVABLE_DEPENDENCY_SCOPE, (Action<? super Configuration>)Actions.doNothing());
    }

    @Deprecated
    public Configuration resolvableDependencyScopeLocked(String name, Action<? super Configuration> action) {
        this.assertCanMutate("resolvableDependencyScopeLocked(String, Action)");
        return this.createLockedLegacyConfiguration(name, ConfigurationRoles.RESOLVABLE_DEPENDENCY_SCOPE, action);
    }

    public Configuration migratingLocked(String name, ConfigurationRole role) {
        this.assertCanMutate("migratingLocked(String, ConfigurationRole)");
        return this.migratingLocked(name, role, (Action<? super Configuration>)Actions.doNothing());
    }

    public Configuration migratingLocked(String name, ConfigurationRole role, Action<? super Configuration> action) {
        this.assertCanMutate("migratingLocked(String, ConfigurationRole, Action)");
        if (ConfigurationRolesForMigration.ALL.contains(role)) {
            return this.createLockedLegacyConfiguration(name, role, action);
        }
        throw new InvalidUserDataException("Unknown migration role: " + role);
    }

    public Configuration maybeCreateDependencyScopeLocked(String name, boolean verifyPrexisting) {
        ConfigurationInternal conf = this.findByName(name);
        if (null != conf) {
            if (verifyPrexisting) {
                throw this.failOnReservedName(name);
            }
            return this.getByName(name);
        }
        return this.createLockedLegacyConfiguration(name, ConfigurationRoles.DEPENDENCY_SCOPE, (Action<? super Configuration>)Actions.doNothing());
    }

    private RuntimeException failOnReservedName(String confName) {
        GradleException ex = new GradleException("The configuration " + confName + " was created explicitly. This configuration name is reserved for creation by Gradle.");
        ProblemId id = ProblemId.create((String)"unexpected configuration usage", (String)"Unexpected configuration usage", (ProblemGroup)GradleCoreProblemGroup.configurationUsage());
        throw this.problemsService.getInternalReporter().throwing((Throwable)ex, id, spec -> {
            spec.contextualLabel(ex.getMessage());
            spec.severity(Severity.ERROR);
        });
    }

    private NamedDomainObjectProvider<ConsumableConfiguration> registerConsumableConfiguration(String name, Action<? super ConsumableConfiguration> configureAction) {
        return this.registerConfiguration(name, configureAction, ConsumableConfiguration.class, n -> this.defaultConfigurationFactory.createConsumable(name, this.resolver, this.resolutionStrategyFactory));
    }

    private NamedDomainObjectProvider<ResolvableConfiguration> registerResolvableConfiguration(String name, Action<? super ResolvableConfiguration> configureAction) {
        return this.registerConfiguration(name, configureAction, ResolvableConfiguration.class, n -> this.defaultConfigurationFactory.createResolvable(name, this.resolver, this.resolutionStrategyFactory));
    }

    private NamedDomainObjectProvider<DependencyScopeConfiguration> registerDependencyScopeConfiguration(String name, Action<? super DependencyScopeConfiguration> configureAction) {
        return this.registerConfiguration(name, configureAction, DependencyScopeConfiguration.class, n -> this.defaultConfigurationFactory.createDependencyScope(name, this.resolver, this.resolutionStrategyFactory));
    }

    private ConfigurationInternal createLockedLegacyConfiguration(String name, ConfigurationRole role, Action<? super Configuration> configureAction) {
        this.assertElementNotPresent(name);
        this.validateNameIsAllowed(name);
        DefaultLegacyConfiguration configuration = this.defaultConfigurationFactory.create(name, false, this.resolver, this.resolutionStrategyFactory, role);
        super.add((Object)configuration);
        configureAction.execute((Object)configuration);
        configuration.preventUsageMutation();
        return configuration;
    }

    private <T extends Configuration> NamedDomainObjectProvider<T> registerConfiguration(String name, Action<? super T> configureAction, Class<T> publicType, Function<String, T> factory) {
        this.assertElementNotPresent(name);
        this.validateNameIsAllowed(name);
        NamedDomainObjectProvider configuration = (NamedDomainObjectProvider)Cast.uncheckedCast((Object)this.getInstantiator().newInstance(NamedDomainObjectCreatingProvider.class, new Object[]{this, name, publicType, configureAction, factory}));
        this.doAddLater((Provider)configuration);
        return configuration;
    }

    private void validateNameIsAllowed(String name) {
        if (RESERVED_NAMES_FOR_DETACHED_CONFS.matcher(name).matches()) {
            GradleException ex = new GradleException(String.format("Creating a configuration with a name that starts with 'detachedConfiguration' is not allowed.  Use a different name for the configuration '%s'", name));
            ProblemId id = ProblemId.create((String)"name-not-allowed", (String)"Configuration name not allowed", (ProblemGroup)GradleCoreProblemGroup.configurationUsage());
            throw this.problemsService.getInternalReporter().throwing((Throwable)ex, id, spec -> {
                spec.contextualLabel(ex.getMessage());
                spec.severity(Severity.ERROR);
            });
        }
    }

    public String getDisplayName() {
        return "configuration container for " + this.owner.getDisplayName();
    }

    public class NamedDomainObjectCreatingProvider<I extends Configuration>
    extends DefaultNamedDomainObjectCollection.AbstractDomainObjectCreatingProvider<I> {
        private final Function<String, I> factory;

        public NamedDomainObjectCreatingProvider(String name, @Nullable Class<I> type, Action<? super I> configureAction, Function<String, I> factory) {
            super((DefaultNamedDomainObjectCollection)DefaultConfigurationContainer.this, name, type, configureAction);
            this.factory = factory;
        }

        protected I createDomainObject() {
            return (I)((Configuration)this.factory.apply(this.getName()));
        }
    }
}

