/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.platform.base.internal.registry;

import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectRegistry;
import org.gradle.api.internal.resolve.DefaultProjectModelResolver;
import org.gradle.api.internal.resolve.ProjectModelResolver;
import org.gradle.internal.service.Provides;
import org.gradle.internal.service.ServiceRegistration;
import org.gradle.internal.service.ServiceRegistrationProvider;
import org.gradle.internal.service.scopes.AbstractGradleModuleServices;
import org.gradle.model.internal.inspect.MethodModelRuleExtractor;
import org.gradle.model.internal.manage.schema.ModelSchemaStore;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaAspectExtractionStrategy;
import org.gradle.platform.base.internal.VariantAspectExtractionStrategy;
import org.gradle.platform.base.internal.registry.BinaryTasksModelRuleExtractor;
import org.gradle.platform.base.internal.registry.ComponentBinariesModelRuleExtractor;
import org.gradle.platform.base.internal.registry.ComponentTypeModelRuleExtractor;

public class ComponentModelBaseServices
extends AbstractGradleModuleServices {
    public void registerGlobalServices(ServiceRegistration registration) {
        registration.addProvider((ServiceRegistrationProvider)new GlobalScopeServices());
    }

    public void registerBuildServices(ServiceRegistration registration) {
        registration.addProvider((ServiceRegistrationProvider)new BuildScopeServices());
    }

    private static class GlobalScopeServices
    implements ServiceRegistrationProvider {
        private GlobalScopeServices() {
        }

        @Provides
        MethodModelRuleExtractor createComponentModelPluginInspector(ModelSchemaStore schemaStore) {
            return new ComponentTypeModelRuleExtractor(schemaStore);
        }

        @Provides
        MethodModelRuleExtractor createComponentBinariesPluginInspector() {
            return new ComponentBinariesModelRuleExtractor();
        }

        @Provides
        MethodModelRuleExtractor createBinaryTaskPluginInspector() {
            return new BinaryTasksModelRuleExtractor();
        }

        @Provides
        ModelSchemaAspectExtractionStrategy createVariantAspectExtractionStrategy() {
            return new VariantAspectExtractionStrategy();
        }
    }

    private static class BuildScopeServices
    implements ServiceRegistrationProvider {
        private BuildScopeServices() {
        }

        @Provides
        ProjectModelResolver createProjectLocator(ProjectRegistry<ProjectInternal> projectRegistry) {
            return new DefaultProjectModelResolver(projectRegistry);
        }
    }
}

