/*
 * Decompiled with CFR 0.152.
 */
package org.testng.xml.internal;

import java.util.List;
import org.testng.TestNGException;
import org.testng.collections.Lists;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

public final class TestNamesMatcher {
    private final List<XmlSuite> cloneSuites = Lists.newArrayList();
    private final List<String> matchedTestNames = Lists.newArrayList();
    private final List<XmlTest> matchedTests = Lists.newArrayList();
    private final List<String> testNames;

    public TestNamesMatcher(XmlSuite xmlSuite, List<String> testNames) {
        this.testNames = testNames;
        this.cloneIfContainsTestsWithNamesMatchingAny(xmlSuite, this.testNames);
    }

    private void cloneIfContainsTestsWithNamesMatchingAny(XmlSuite xmlSuite, List<String> testNames) {
        if (testNames == null || testNames.isEmpty()) {
            throw new TestNGException("Please provide a valid list of names to check.");
        }
        this.addIfNotNull(this.cloneIfSuiteContainTestsWithNamesMatchingAny(xmlSuite));
        for (XmlSuite suite : xmlSuite.getChildSuites()) {
            this.cloneIfContainsTestsWithNamesMatchingAny(suite, testNames);
        }
    }

    public List<XmlSuite> getSuitesMatchingTestNames() {
        return this.cloneSuites;
    }

    public List<String> getMissMatchedTestNames() {
        List<String> tmpTestNames = Lists.newArrayList();
        tmpTestNames.addAll(this.testNames);
        tmpTestNames.removeIf(this.matchedTestNames::contains);
        return tmpTestNames;
    }

    public List<XmlTest> getMatchedTests() {
        return this.matchedTests;
    }

    private void addIfNotNull(XmlSuite xmlSuite) {
        if (xmlSuite != null) {
            this.cloneSuites.add(xmlSuite);
        }
    }

    private XmlSuite cloneIfSuiteContainTestsWithNamesMatchingAny(XmlSuite suite) {
        List<XmlTest> tests = Lists.newLinkedList();
        for (XmlTest xt : suite.getTests()) {
            if (!xt.nameMatchesAny(this.testNames)) continue;
            tests.add(xt);
            this.matchedTestNames.add(xt.getName());
            this.matchedTests.add(xt);
        }
        if (tests.isEmpty()) {
            return null;
        }
        return TestNamesMatcher.cleanClone(suite, tests);
    }

    private static XmlSuite cleanClone(XmlSuite xmlSuite, List<XmlTest> tests) {
        XmlSuite result = (XmlSuite)xmlSuite.clone();
        result.getTests().clear();
        result.getTests().addAll(tests);
        return result;
    }
}

