/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.netbeans.modules.php.editor.indent.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;
import javax.swing.SwingConstants;
import org.netbeans.api.annotations.common.StaticResource;
import org.netbeans.modules.options.editor.spi.PreferencesCustomizer;
import static org.netbeans.modules.php.editor.indent.FmtOptions.*;
import org.netbeans.modules.php.editor.indent.FmtOptions.CategorySupport;
import static org.netbeans.modules.php.editor.indent.FmtOptions.CategorySupport.OPTION_ID;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;


/**
 *
 * @author  phrebejk
 */
public class FmtBraces extends javax.swing.JPanel {

    @StaticResource
    private static final String PREVIEW_FILE = "org/netbeans/modules/php/editor/indent/ui/Spaces.php"; // NOI18N
    private static final Logger LOGGER = Logger.getLogger(FmtBraces.class.getName());
    private static final long serialVersionUID = -5170484158871845819L;

    public FmtBraces() {
        initComponents();

        mainScrollPane.getViewport().setBackground(java.awt.SystemColor.controlLtHighlight);
        mainScrollPane.getVerticalScrollBar().setUnitIncrement(20);

        classDeclCombo.putClientProperty(OPTION_ID, CLASS_DECL_BRACE_PLACEMENT);
        anonymousClassCombo.putClientProperty(OPTION_ID, ANONYMOUS_CLASS_BRACE_PLACEMENT);
        methodDeclCombo.putClientProperty(OPTION_ID, METHOD_DECL_BRACE_PLACEMENT);
        ifCombo.putClientProperty(OPTION_ID, IF_BRACE_PLACEMENT);
        forCombo.putClientProperty(OPTION_ID, FOR_BRACE_PLACEMENT);
        switchCombo.putClientProperty(OPTION_ID, SWITCH_BRACE_PLACEMENT);
        matchCombo.putClientProperty(OPTION_ID, MATCH_BRACE_PLACEMENT);
        whileCombo.putClientProperty(OPTION_ID, WHILE_BRACE_PLACEMENT);
        catchCombo.putClientProperty(OPTION_ID, CATCH_BRACE_PLACEMENT);
        useTraitCombo.putClientProperty(OPTION_ID, USE_TRAIT_BODY_BRACE_PLACEMENT);
        groupUseCombo.putClientProperty(OPTION_ID, GROUP_USE_BRACE_PLACEMENT);
        otherCombo.putClientProperty(OPTION_ID, OTHER_BRACE_PLACEMENT);
    }

    public static PreferencesCustomizer.Factory getController() {
        String preview = ""; // NOI18N
        try {
            preview = Utils.loadPreviewText(FmtBlankLines.class.getClassLoader().getResourceAsStream(PREVIEW_FILE));
        } catch (IOException ex) {
            LOGGER.log(Level.WARNING, null, ex);
        }
        return new CategorySupport.Factory("braces", FmtBraces.class, preview); // NOI18N
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        mainScrollPane = new JScrollPane();
        mainPanel = new JPanel();
        bracesPlacementLabel = new JLabel();
        jSeparator1 = new JSeparator();
        classDeclLabel = new JLabel();
        classDeclCombo = new JComboBox();
        anonymousClassLabel = new JLabel();
        anonymousClassCombo = new JComboBox<>();
        methodDeclLabel = new JLabel();
        methodDeclCombo = new JComboBox();
        ifLabel = new JLabel();
        ifCombo = new JComboBox();
        forLabel = new JLabel();
        forCombo = new JComboBox();
        whileLabel = new JLabel();
        whileCombo = new JComboBox();
        switchLabel = new JLabel();
        switchCombo = new JComboBox();
        catchLabel = new JLabel();
        catchCombo = new JComboBox();
        useTraitLabel = new JLabel();
        useTraitCombo = new JComboBox();
        groupUseLabel = new JLabel();
        groupUseCombo = new JComboBox<>();
        otherLabel = new JLabel();
        otherCombo = new JComboBox();
        matchLabel = new JLabel();
        matchCombo = new JComboBox<>();

        setName(NbBundle.getMessage(FmtBraces.class, "LBL_Braces")); // NOI18N
        setOpaque(false);
        setLayout(new BorderLayout());

        bracesPlacementLabel.setLabelFor(bracesPlacementLabel);
        Mnemonics.setLocalizedText(bracesPlacementLabel, NbBundle.getMessage(FmtBraces.class, "LBL_br_bracesPlacement")); // NOI18N

        classDeclLabel.setLabelFor(classDeclCombo);
        Mnemonics.setLocalizedText(classDeclLabel, NbBundle.getMessage(FmtBraces.class, "LBL_bp_ClassDecl")); // NOI18N

        classDeclCombo.setModel(new DefaultComboBoxModel(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));

        anonymousClassLabel.setLabelFor(anonymousClassCombo);
        Mnemonics.setLocalizedText(anonymousClassLabel, NbBundle.getMessage(FmtBraces.class, "FmtBraces.anonymousClassLabel.text")); // NOI18N

        anonymousClassCombo.setModel(new DefaultComboBoxModel<>(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));

        methodDeclLabel.setLabelFor(methodDeclCombo);
        Mnemonics.setLocalizedText(methodDeclLabel, NbBundle.getMessage(FmtBraces.class, "LBL_bp_MethodDecl")); // NOI18N

        methodDeclCombo.setModel(new DefaultComboBoxModel(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));

        ifLabel.setLabelFor(ifCombo);
        Mnemonics.setLocalizedText(ifLabel, NbBundle.getMessage(FmtBraces.class, "LBL_bp_If")); // NOI18N

        ifCombo.setModel(new DefaultComboBoxModel(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));

        forLabel.setLabelFor(forCombo);
        Mnemonics.setLocalizedText(forLabel, NbBundle.getMessage(FmtBraces.class, "LBL_bp_FOR")); // NOI18N

        forCombo.setModel(new DefaultComboBoxModel(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));

        whileLabel.setLabelFor(whileCombo);
        Mnemonics.setLocalizedText(whileLabel, NbBundle.getMessage(FmtBraces.class, "LBL_bp_WHILE")); // NOI18N

        whileCombo.setModel(new DefaultComboBoxModel(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));

        switchLabel.setLabelFor(switchCombo);
        Mnemonics.setLocalizedText(switchLabel, NbBundle.getMessage(FmtBraces.class, "LBL_bp_SWITCH")); // NOI18N

        switchCombo.setModel(new DefaultComboBoxModel(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));

        catchLabel.setLabelFor(catchCombo);
        Mnemonics.setLocalizedText(catchLabel, NbBundle.getMessage(FmtBraces.class, "LBL_bp_catch")); // NOI18N

        catchCombo.setModel(new DefaultComboBoxModel(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));

        Mnemonics.setLocalizedText(useTraitLabel, NbBundle.getMessage(FmtBraces.class, "FmtBraces.useTraitLabel.text")); // NOI18N

        useTraitCombo.setModel(new DefaultComboBoxModel(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));

        groupUseLabel.setLabelFor(groupUseCombo);
        Mnemonics.setLocalizedText(groupUseLabel, NbBundle.getMessage(FmtBraces.class, "FmtBraces.groupUseLabel.text")); // NOI18N

        groupUseCombo.setModel(new DefaultComboBoxModel<>(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));

        otherLabel.setLabelFor(otherCombo);
        Mnemonics.setLocalizedText(otherLabel, NbBundle.getMessage(FmtBraces.class, "LBL_bp_Other")); // NOI18N

        otherCombo.setModel(new DefaultComboBoxModel(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));

        matchLabel.setLabelFor(matchCombo);
        Mnemonics.setLocalizedText(matchLabel, NbBundle.getMessage(FmtBraces.class, "FmtBraces.matchLabel.text")); // NOI18N

        matchCombo.setModel(new DefaultComboBoxModel<>(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));

        GroupLayout mainPanelLayout = new GroupLayout(mainPanel);
        mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING)
            .addGroup(mainPanelLayout.createSequentialGroup()
                .addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING)
                    .addGroup(mainPanelLayout.createSequentialGroup()
                        .addContainerGap()
                        .addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING)
                            .addComponent(forLabel)
                            .addComponent(ifLabel)
                            .addComponent(whileLabel)
                            .addComponent(switchLabel)
                            .addComponent(catchLabel)
                            .addComponent(useTraitLabel)
                            .addComponent(otherLabel)
                            .addComponent(methodDeclLabel)
                            .addComponent(classDeclLabel)
                            .addComponent(anonymousClassLabel)
                            .addComponent(groupUseLabel))
                        .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING)
                            .addComponent(classDeclCombo, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
                            .addComponent(anonymousClassCombo, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
                            .addComponent(methodDeclCombo, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
                            .addComponent(ifCombo, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
                            .addComponent(forCombo, 0, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
                            .addComponent(whileCombo, 0, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
                            .addComponent(switchCombo, 0, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
                            .addComponent(catchCombo, 0, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
                            .addComponent(useTraitCombo, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
                            .addComponent(groupUseCombo, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
                            .addComponent(otherCombo, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)))
                    .addGroup(mainPanelLayout.createSequentialGroup()
                        .addGap(12, 12, 12)
                        .addComponent(bracesPlacementLabel)
                        .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jSeparator1))
                    .addGroup(mainPanelLayout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(matchLabel)
                        .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addComponent(matchCombo, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)))
                .addContainerGap())
        );

        mainPanelLayout.linkSize(SwingConstants.HORIZONTAL, new Component[] {classDeclCombo, methodDeclCombo});

        mainPanelLayout.setVerticalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING)
            .addGroup(mainPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING)
                    .addComponent(bracesPlacementLabel)
                    .addComponent(jSeparator1, GroupLayout.PREFERRED_SIZE, 10, GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE)
                    .addComponent(classDeclLabel, GroupLayout.PREFERRED_SIZE, 18, GroupLayout.PREFERRED_SIZE)
                    .addComponent(classDeclCombo, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE)
                    .addComponent(anonymousClassLabel)
                    .addComponent(anonymousClassCombo, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE)
                    .addComponent(methodDeclLabel)
                    .addComponent(methodDeclCombo, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE)
                    .addComponent(ifCombo, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
                    .addComponent(ifLabel))
                .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE)
                    .addComponent(forCombo, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
                    .addComponent(forLabel))
                .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE)
                    .addComponent(whileCombo, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
                    .addComponent(whileLabel))
                .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE)
                    .addComponent(switchCombo, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
                    .addComponent(switchLabel))
                .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE)
                    .addComponent(matchCombo, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
                    .addComponent(matchLabel))
                .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE)
                    .addComponent(catchCombo, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
                    .addComponent(catchLabel))
                .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE)
                    .addComponent(useTraitCombo, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
                    .addComponent(useTraitLabel))
                .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE)
                    .addComponent(groupUseLabel)
                    .addComponent(groupUseCombo, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE)
                    .addComponent(otherCombo, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
                    .addComponent(otherLabel))
                .addContainerGap(GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        bracesPlacementLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FmtBraces.class, "FmtBraces.bracesPlacementLabel.AccessibleContext.accessibleName")); // NOI18N
        bracesPlacementLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FmtBraces.class, "FmtBraces.bracesPlacementLabel.AccessibleContext.accessibleDescription")); // NOI18N
        jSeparator1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FmtBraces.class, "FmtBraces.jSeparator1.AccessibleContext.accessibleName")); // NOI18N
        jSeparator1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FmtBraces.class, "FmtBraces.jSeparator1.AccessibleContext.accessibleDescription")); // NOI18N
        classDeclLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FmtBraces.class, "FmtBraces.classDeclLabel.AccessibleContext.accessibleName")); // NOI18N
        classDeclLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FmtBraces.class, "FmtBraces.classDeclLabel.AccessibleContext.accessibleDescription")); // NOI18N
        classDeclCombo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FmtBraces.class, "FmtBraces.classDeclCombo.AccessibleContext.accessibleName")); // NOI18N
        classDeclCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FmtBraces.class, "FmtBraces.classDeclCombo.AccessibleContext.accessibleDescription")); // NOI18N
        methodDeclLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FmtBraces.class, "FmtBraces.methodDeclLabel.AccessibleContext.accessibleName")); // NOI18N
        methodDeclLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FmtBraces.class, "FmtBraces.methodDeclLabel.AccessibleContext.accessibleDescription")); // NOI18N
        methodDeclCombo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FmtBraces.class, "FmtBraces.methodDeclCombo.AccessibleContext.accessibleName")); // NOI18N
        methodDeclCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FmtBraces.class, "FmtBraces.methodDeclCombo.AccessibleContext.accessibleDescription")); // NOI18N
        ifLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FmtBraces.class, "FmtBraces.ifLabel.AccessibleContext.accessibleName")); // NOI18N
        ifLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FmtBraces.class, "FmtBraces.ifLabel.AccessibleContext.accessibleDescription")); // NOI18N
        ifCombo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FmtBraces.class, "FmtBraces.ifCombo.AccessibleContext.accessibleName")); // NOI18N
        ifCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FmtBraces.class, "FmtBraces.ifCombo.AccessibleContext.accessibleDescription")); // NOI18N
        forLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FmtBraces.class, "FmtBraces.forLabel.AccessibleContext.accessibleName")); // NOI18N
        forLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FmtBraces.class, "FmtBraces.forLabel.AccessibleContext.accessibleDescription")); // NOI18N
        forCombo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FmtBraces.class, "FmtBraces.forCombo.AccessibleContext.accessibleName")); // NOI18N
        forCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FmtBraces.class, "FmtBraces.forCombo.AccessibleContext.accessibleDescription")); // NOI18N
        whileLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FmtBraces.class, "FmtBraces.whileLabel.AccessibleContext.accessibleName")); // NOI18N
        whileLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FmtBraces.class, "FmtBraces.whileLabel.AccessibleContext.accessibleDescription")); // NOI18N
        whileCombo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FmtBraces.class, "FmtBraces.whileCombo.AccessibleContext.accessibleName")); // NOI18N
        whileCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FmtBraces.class, "FmtBraces.whileCombo.AccessibleContext.accessibleDescription")); // NOI18N
        switchLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FmtBraces.class, "FmtBraces.switchLabel.AccessibleContext.accessibleName")); // NOI18N
        switchLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FmtBraces.class, "FmtBraces.switchLabel.AccessibleContext.accessibleDescription")); // NOI18N
        switchCombo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FmtBraces.class, "FmtBraces.switchCombo.AccessibleContext.accessibleName")); // NOI18N
        switchCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FmtBraces.class, "FmtBraces.switchCombo.AccessibleContext.accessibleDescription")); // NOI18N
        catchLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FmtBraces.class, "FmtBraces.catchLabel.AccessibleContext.accessibleName")); // NOI18N
        catchLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FmtBraces.class, "FmtBraces.catchLabel.AccessibleContext.accessibleDescription")); // NOI18N
        catchCombo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FmtBraces.class, "FmtBraces.catchCombo.AccessibleContext.accessibleName")); // NOI18N
        catchCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FmtBraces.class, "FmtBraces.catchCombo.AccessibleContext.accessibleDescription")); // NOI18N
        otherLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FmtBraces.class, "FmtBraces.otherLabel.AccessibleContext.accessibleName")); // NOI18N
        otherLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FmtBraces.class, "FmtBraces.otherLabel.AccessibleContext.accessibleDescription")); // NOI18N
        otherCombo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FmtBraces.class, "FmtBraces.otherCombo.AccessibleContext.accessibleName")); // NOI18N
        otherCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FmtBraces.class, "FmtBraces.otherCombo.AccessibleContext.accessibleDescription")); // NOI18N
        matchCombo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FmtBraces.class, "FmtBraces.matchCombo.AccessibleContext.accessibleName")); // NOI18N
        matchCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FmtBraces.class, "FmtBraces.matchCombo.AccessibleContext.accessibleDescription")); // NOI18N

        mainScrollPane.setViewportView(mainPanel);

        add(mainScrollPane, BorderLayout.CENTER);

        getAccessibleContext().setAccessibleName(NbBundle.getMessage(FmtBraces.class, "FmtBraces.AccessibleContext.accessibleName")); // NOI18N
        getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FmtBraces.class, "FmtBraces.AccessibleContext.accessibleDescription")); // NOI18N
    }// </editor-fold>//GEN-END:initComponents

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private JComboBox<String> anonymousClassCombo;
    private JLabel anonymousClassLabel;
    private JLabel bracesPlacementLabel;
    private JComboBox catchCombo;
    private JLabel catchLabel;
    private JComboBox classDeclCombo;
    private JLabel classDeclLabel;
    private JComboBox forCombo;
    private JLabel forLabel;
    private JComboBox<String> groupUseCombo;
    private JLabel groupUseLabel;
    private JComboBox ifCombo;
    private JLabel ifLabel;
    private JSeparator jSeparator1;
    private JPanel mainPanel;
    private JScrollPane mainScrollPane;
    private JComboBox<String> matchCombo;
    private JLabel matchLabel;
    private JComboBox methodDeclCombo;
    private JLabel methodDeclLabel;
    private JComboBox otherCombo;
    private JLabel otherLabel;
    private JComboBox switchCombo;
    private JLabel switchLabel;
    private JComboBox useTraitCombo;
    private JLabel useTraitLabel;
    private JComboBox whileCombo;
    private JLabel whileLabel;
    // End of variables declaration//GEN-END:variables

}
