/* This file is generated by venus-protocol.  See vn_protocol_renderer.h. */

/*
 * Copyright 2020 Google LLC
 * SPDX-License-Identifier: MIT
 */

#ifndef VN_PROTOCOL_RENDERER_COMMAND_BUFFER_H
#define VN_PROTOCOL_RENDERER_COMMAND_BUFFER_H

#include "vn_protocol_renderer_structs.h"

#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wpointer-arith"
#pragma GCC diagnostic ignored "-Wunused-parameter"

/* struct VkCommandBufferAllocateInfo chain */

static inline void *
vn_decode_VkCommandBufferAllocateInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkCommandBufferAllocateInfo_self_temp(struct vn_cs_decoder *dec, VkCommandBufferAllocateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkCommandPool_lookup(dec, &val->commandPool);
    vn_decode_VkCommandBufferLevel(dec, &val->level);
    vn_decode_uint32_t(dec, &val->commandBufferCount);
}

static inline void
vn_decode_VkCommandBufferAllocateInfo_temp(struct vn_cs_decoder *dec, VkCommandBufferAllocateInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_COMMAND_BUFFER_ALLOCATE_INFO)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkCommandBufferAllocateInfo_pnext_temp(dec);
    vn_decode_VkCommandBufferAllocateInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkCommandBufferAllocateInfo_handle_self(VkCommandBufferAllocateInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    vn_replace_VkCommandPool_handle(&val->commandPool);
    /* skip val->level */
    /* skip val->commandBufferCount */
}

static inline void
vn_replace_VkCommandBufferAllocateInfo_handle(VkCommandBufferAllocateInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_COMMAND_BUFFER_ALLOCATE_INFO:
            vn_replace_VkCommandBufferAllocateInfo_handle_self((VkCommandBufferAllocateInfo *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkCommandBufferInheritanceConditionalRenderingInfoEXT chain */

static inline void *
vn_decode_VkCommandBufferInheritanceConditionalRenderingInfoEXT_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkCommandBufferInheritanceConditionalRenderingInfoEXT_self_temp(struct vn_cs_decoder *dec, VkCommandBufferInheritanceConditionalRenderingInfoEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->conditionalRenderingEnable);
}

static inline void
vn_decode_VkCommandBufferInheritanceConditionalRenderingInfoEXT_temp(struct vn_cs_decoder *dec, VkCommandBufferInheritanceConditionalRenderingInfoEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_CONDITIONAL_RENDERING_INFO_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkCommandBufferInheritanceConditionalRenderingInfoEXT_pnext_temp(dec);
    vn_decode_VkCommandBufferInheritanceConditionalRenderingInfoEXT_self_temp(dec, val);
}

static inline void
vn_replace_VkCommandBufferInheritanceConditionalRenderingInfoEXT_handle_self(VkCommandBufferInheritanceConditionalRenderingInfoEXT *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->conditionalRenderingEnable */
}

static inline void
vn_replace_VkCommandBufferInheritanceConditionalRenderingInfoEXT_handle(VkCommandBufferInheritanceConditionalRenderingInfoEXT *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_CONDITIONAL_RENDERING_INFO_EXT:
            vn_replace_VkCommandBufferInheritanceConditionalRenderingInfoEXT_handle_self((VkCommandBufferInheritanceConditionalRenderingInfoEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkCommandBufferInheritanceRenderingInfo chain */

static inline void *
vn_decode_VkCommandBufferInheritanceRenderingInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkCommandBufferInheritanceRenderingInfo_self_temp(struct vn_cs_decoder *dec, VkCommandBufferInheritanceRenderingInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkFlags(dec, &val->flags);
    vn_decode_uint32_t(dec, &val->viewMask);
    vn_decode_uint32_t(dec, &val->colorAttachmentCount);
    if (vn_peek_array_size(dec)) {
        const size_t array_size = vn_decode_array_size(dec, val->colorAttachmentCount);
        val->pColorAttachmentFormats = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pColorAttachmentFormats) * array_size);
        if (!val->pColorAttachmentFormats) return;
        vn_decode_VkFormat_array(dec, (VkFormat *)val->pColorAttachmentFormats, array_size);
    } else {
        vn_decode_array_size(dec, val->colorAttachmentCount);
        val->pColorAttachmentFormats = NULL;
    }
    vn_decode_VkFormat(dec, &val->depthAttachmentFormat);
    vn_decode_VkFormat(dec, &val->stencilAttachmentFormat);
    vn_decode_VkSampleCountFlagBits(dec, &val->rasterizationSamples);
}

static inline void
vn_decode_VkCommandBufferInheritanceRenderingInfo_temp(struct vn_cs_decoder *dec, VkCommandBufferInheritanceRenderingInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_RENDERING_INFO)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkCommandBufferInheritanceRenderingInfo_pnext_temp(dec);
    vn_decode_VkCommandBufferInheritanceRenderingInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkCommandBufferInheritanceRenderingInfo_handle_self(VkCommandBufferInheritanceRenderingInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->flags */
    /* skip val->viewMask */
    /* skip val->colorAttachmentCount */
    /* skip val->pColorAttachmentFormats */
    /* skip val->depthAttachmentFormat */
    /* skip val->stencilAttachmentFormat */
    /* skip val->rasterizationSamples */
}

static inline void
vn_replace_VkCommandBufferInheritanceRenderingInfo_handle(VkCommandBufferInheritanceRenderingInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_RENDERING_INFO:
            vn_replace_VkCommandBufferInheritanceRenderingInfo_handle_self((VkCommandBufferInheritanceRenderingInfo *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkCommandBufferInheritanceInfo chain */

static inline void *
vn_decode_VkCommandBufferInheritanceInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    VkBaseOutStructure *pnext;
    VkStructureType stype;

    if (!vn_decode_simple_pointer(dec))
        return NULL;

    vn_decode_VkStructureType(dec, &stype);
    switch ((int32_t)stype) {
    case VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_CONDITIONAL_RENDERING_INFO_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkCommandBufferInheritanceConditionalRenderingInfoEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkCommandBufferInheritanceInfo_pnext_temp(dec);
            vn_decode_VkCommandBufferInheritanceConditionalRenderingInfoEXT_self_temp(dec, (VkCommandBufferInheritanceConditionalRenderingInfoEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_RENDERING_INFO:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkCommandBufferInheritanceRenderingInfo));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkCommandBufferInheritanceInfo_pnext_temp(dec);
            vn_decode_VkCommandBufferInheritanceRenderingInfo_self_temp(dec, (VkCommandBufferInheritanceRenderingInfo *)pnext);
        }
        break;
    default:
        /* unexpected struct */
        pnext = NULL;
        vn_cs_decoder_set_fatal(dec);
        break;
    }

    return pnext;
}

static inline void
vn_decode_VkCommandBufferInheritanceInfo_self_temp(struct vn_cs_decoder *dec, VkCommandBufferInheritanceInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkRenderPass_lookup(dec, &val->renderPass);
    vn_decode_uint32_t(dec, &val->subpass);
    vn_decode_VkFramebuffer_lookup(dec, &val->framebuffer);
    vn_decode_VkBool32(dec, &val->occlusionQueryEnable);
    vn_decode_VkFlags(dec, &val->queryFlags);
    vn_decode_VkFlags(dec, &val->pipelineStatistics);
}

static inline void
vn_decode_VkCommandBufferInheritanceInfo_temp(struct vn_cs_decoder *dec, VkCommandBufferInheritanceInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_INFO)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkCommandBufferInheritanceInfo_pnext_temp(dec);
    vn_decode_VkCommandBufferInheritanceInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkCommandBufferInheritanceInfo_handle_self(VkCommandBufferInheritanceInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    vn_replace_VkRenderPass_handle(&val->renderPass);
    /* skip val->subpass */
    vn_replace_VkFramebuffer_handle(&val->framebuffer);
    /* skip val->occlusionQueryEnable */
    /* skip val->queryFlags */
    /* skip val->pipelineStatistics */
}

static inline void
vn_replace_VkCommandBufferInheritanceInfo_handle(VkCommandBufferInheritanceInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_INFO:
            vn_replace_VkCommandBufferInheritanceInfo_handle_self((VkCommandBufferInheritanceInfo *)pnext);
            break;
        case VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_CONDITIONAL_RENDERING_INFO_EXT:
            vn_replace_VkCommandBufferInheritanceConditionalRenderingInfoEXT_handle_self((VkCommandBufferInheritanceConditionalRenderingInfoEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_RENDERING_INFO:
            vn_replace_VkCommandBufferInheritanceRenderingInfo_handle_self((VkCommandBufferInheritanceRenderingInfo *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkDeviceGroupCommandBufferBeginInfo chain */

static inline void *
vn_decode_VkDeviceGroupCommandBufferBeginInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkDeviceGroupCommandBufferBeginInfo_self_temp(struct vn_cs_decoder *dec, VkDeviceGroupCommandBufferBeginInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_uint32_t(dec, &val->deviceMask);
}

static inline void
vn_decode_VkDeviceGroupCommandBufferBeginInfo_temp(struct vn_cs_decoder *dec, VkDeviceGroupCommandBufferBeginInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_DEVICE_GROUP_COMMAND_BUFFER_BEGIN_INFO)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkDeviceGroupCommandBufferBeginInfo_pnext_temp(dec);
    vn_decode_VkDeviceGroupCommandBufferBeginInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkDeviceGroupCommandBufferBeginInfo_handle_self(VkDeviceGroupCommandBufferBeginInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->deviceMask */
}

static inline void
vn_replace_VkDeviceGroupCommandBufferBeginInfo_handle(VkDeviceGroupCommandBufferBeginInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_COMMAND_BUFFER_BEGIN_INFO:
            vn_replace_VkDeviceGroupCommandBufferBeginInfo_handle_self((VkDeviceGroupCommandBufferBeginInfo *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkCommandBufferBeginInfo chain */

static inline void *
vn_decode_VkCommandBufferBeginInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    VkBaseOutStructure *pnext;
    VkStructureType stype;

    if (!vn_decode_simple_pointer(dec))
        return NULL;

    vn_decode_VkStructureType(dec, &stype);
    switch ((int32_t)stype) {
    case VK_STRUCTURE_TYPE_DEVICE_GROUP_COMMAND_BUFFER_BEGIN_INFO:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkDeviceGroupCommandBufferBeginInfo));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkCommandBufferBeginInfo_pnext_temp(dec);
            vn_decode_VkDeviceGroupCommandBufferBeginInfo_self_temp(dec, (VkDeviceGroupCommandBufferBeginInfo *)pnext);
        }
        break;
    default:
        /* unexpected struct */
        pnext = NULL;
        vn_cs_decoder_set_fatal(dec);
        break;
    }

    return pnext;
}

static inline void
vn_decode_VkCommandBufferBeginInfo_self_temp(struct vn_cs_decoder *dec, VkCommandBufferBeginInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkFlags(dec, &val->flags);
    if (vn_decode_simple_pointer(dec)) {
        val->pInheritanceInfo = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pInheritanceInfo));
        if (!val->pInheritanceInfo) return;
        vn_decode_VkCommandBufferInheritanceInfo_temp(dec, (VkCommandBufferInheritanceInfo *)val->pInheritanceInfo);
    } else {
        val->pInheritanceInfo = NULL;
    }
}

static inline void
vn_decode_VkCommandBufferBeginInfo_temp(struct vn_cs_decoder *dec, VkCommandBufferBeginInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_COMMAND_BUFFER_BEGIN_INFO)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkCommandBufferBeginInfo_pnext_temp(dec);
    vn_decode_VkCommandBufferBeginInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkCommandBufferBeginInfo_handle_self(VkCommandBufferBeginInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->flags */
    if (val->pInheritanceInfo)
        vn_replace_VkCommandBufferInheritanceInfo_handle((VkCommandBufferInheritanceInfo *)val->pInheritanceInfo);
}

static inline void
vn_replace_VkCommandBufferBeginInfo_handle(VkCommandBufferBeginInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_COMMAND_BUFFER_BEGIN_INFO:
            vn_replace_VkCommandBufferBeginInfo_handle_self((VkCommandBufferBeginInfo *)pnext);
            break;
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_COMMAND_BUFFER_BEGIN_INFO:
            vn_replace_VkDeviceGroupCommandBufferBeginInfo_handle_self((VkDeviceGroupCommandBufferBeginInfo *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkMultiDrawInfoEXT */

static inline void
vn_decode_VkMultiDrawInfoEXT_temp(struct vn_cs_decoder *dec, VkMultiDrawInfoEXT *val)
{
    vn_decode_uint32_t(dec, &val->firstVertex);
    vn_decode_uint32_t(dec, &val->vertexCount);
}

static inline void
vn_replace_VkMultiDrawInfoEXT_handle(VkMultiDrawInfoEXT *val)
{
    /* skip val->firstVertex */
    /* skip val->vertexCount */
}

/* struct VkMultiDrawIndexedInfoEXT */

static inline void
vn_decode_VkMultiDrawIndexedInfoEXT_temp(struct vn_cs_decoder *dec, VkMultiDrawIndexedInfoEXT *val)
{
    vn_decode_uint32_t(dec, &val->firstIndex);
    vn_decode_uint32_t(dec, &val->indexCount);
    vn_decode_int32_t(dec, &val->vertexOffset);
}

static inline void
vn_replace_VkMultiDrawIndexedInfoEXT_handle(VkMultiDrawIndexedInfoEXT *val)
{
    /* skip val->firstIndex */
    /* skip val->indexCount */
    /* skip val->vertexOffset */
}

/* struct VkBufferCopy */

static inline void
vn_decode_VkBufferCopy_temp(struct vn_cs_decoder *dec, VkBufferCopy *val)
{
    vn_decode_VkDeviceSize(dec, &val->srcOffset);
    vn_decode_VkDeviceSize(dec, &val->dstOffset);
    vn_decode_VkDeviceSize(dec, &val->size);
}

static inline void
vn_replace_VkBufferCopy_handle(VkBufferCopy *val)
{
    /* skip val->srcOffset */
    /* skip val->dstOffset */
    /* skip val->size */
}

/* struct VkImageSubresourceLayers */

static inline void
vn_decode_VkImageSubresourceLayers_temp(struct vn_cs_decoder *dec, VkImageSubresourceLayers *val)
{
    vn_decode_VkFlags(dec, &val->aspectMask);
    vn_decode_uint32_t(dec, &val->mipLevel);
    vn_decode_uint32_t(dec, &val->baseArrayLayer);
    vn_decode_uint32_t(dec, &val->layerCount);
}

static inline void
vn_replace_VkImageSubresourceLayers_handle(VkImageSubresourceLayers *val)
{
    /* skip val->aspectMask */
    /* skip val->mipLevel */
    /* skip val->baseArrayLayer */
    /* skip val->layerCount */
}

/* struct VkImageCopy */

static inline void
vn_decode_VkImageCopy_temp(struct vn_cs_decoder *dec, VkImageCopy *val)
{
    vn_decode_VkImageSubresourceLayers_temp(dec, &val->srcSubresource);
    vn_decode_VkOffset3D_temp(dec, &val->srcOffset);
    vn_decode_VkImageSubresourceLayers_temp(dec, &val->dstSubresource);
    vn_decode_VkOffset3D_temp(dec, &val->dstOffset);
    vn_decode_VkExtent3D_temp(dec, &val->extent);
}

static inline void
vn_replace_VkImageCopy_handle(VkImageCopy *val)
{
    vn_replace_VkImageSubresourceLayers_handle(&val->srcSubresource);
    vn_replace_VkOffset3D_handle(&val->srcOffset);
    vn_replace_VkImageSubresourceLayers_handle(&val->dstSubresource);
    vn_replace_VkOffset3D_handle(&val->dstOffset);
    vn_replace_VkExtent3D_handle(&val->extent);
}

/* struct VkImageBlit */

static inline void
vn_decode_VkImageBlit_temp(struct vn_cs_decoder *dec, VkImageBlit *val)
{
    vn_decode_VkImageSubresourceLayers_temp(dec, &val->srcSubresource);
    {
        const uint32_t iter_count = vn_decode_array_size(dec, 2);
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkOffset3D_temp(dec, &val->srcOffsets[i]);
    }
    vn_decode_VkImageSubresourceLayers_temp(dec, &val->dstSubresource);
    {
        const uint32_t iter_count = vn_decode_array_size(dec, 2);
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkOffset3D_temp(dec, &val->dstOffsets[i]);
    }
}

static inline void
vn_replace_VkImageBlit_handle(VkImageBlit *val)
{
    vn_replace_VkImageSubresourceLayers_handle(&val->srcSubresource);
    for (uint32_t i = 0; i < 2; i++)
        vn_replace_VkOffset3D_handle(&val->srcOffsets[i]);
    vn_replace_VkImageSubresourceLayers_handle(&val->dstSubresource);
    for (uint32_t i = 0; i < 2; i++)
        vn_replace_VkOffset3D_handle(&val->dstOffsets[i]);
}

/* struct VkBufferImageCopy */

static inline void
vn_decode_VkBufferImageCopy_temp(struct vn_cs_decoder *dec, VkBufferImageCopy *val)
{
    vn_decode_VkDeviceSize(dec, &val->bufferOffset);
    vn_decode_uint32_t(dec, &val->bufferRowLength);
    vn_decode_uint32_t(dec, &val->bufferImageHeight);
    vn_decode_VkImageSubresourceLayers_temp(dec, &val->imageSubresource);
    vn_decode_VkOffset3D_temp(dec, &val->imageOffset);
    vn_decode_VkExtent3D_temp(dec, &val->imageExtent);
}

static inline void
vn_replace_VkBufferImageCopy_handle(VkBufferImageCopy *val)
{
    /* skip val->bufferOffset */
    /* skip val->bufferRowLength */
    /* skip val->bufferImageHeight */
    vn_replace_VkImageSubresourceLayers_handle(&val->imageSubresource);
    vn_replace_VkOffset3D_handle(&val->imageOffset);
    vn_replace_VkExtent3D_handle(&val->imageExtent);
}

/* struct VkClearDepthStencilValue */

static inline void
vn_decode_VkClearDepthStencilValue_temp(struct vn_cs_decoder *dec, VkClearDepthStencilValue *val)
{
    vn_decode_float(dec, &val->depth);
    vn_decode_uint32_t(dec, &val->stencil);
}

static inline void
vn_replace_VkClearDepthStencilValue_handle(VkClearDepthStencilValue *val)
{
    /* skip val->depth */
    /* skip val->stencil */
}

/* union VkClearValue */

static inline void
vn_decode_VkClearValue_temp(struct vn_cs_decoder *dec, VkClearValue *val)
{
    uint32_t tag;
    vn_decode_uint32_t(dec, &tag);
    switch (tag) {
    case 0:
        vn_decode_VkClearColorValue_temp(dec, &val->color);
        break;
    case 1:
        vn_decode_VkClearDepthStencilValue_temp(dec, &val->depthStencil);
        break;
    default:
        vn_cs_decoder_set_fatal(dec);
        break;
    }
}

/* struct VkClearAttachment */

static inline void
vn_decode_VkClearAttachment_temp(struct vn_cs_decoder *dec, VkClearAttachment *val)
{
    vn_decode_VkFlags(dec, &val->aspectMask);
    vn_decode_uint32_t(dec, &val->colorAttachment);
    vn_decode_VkClearValue_temp(dec, &val->clearValue);
}

static inline void
vn_replace_VkClearAttachment_handle(VkClearAttachment *val)
{
    /* skip val->aspectMask */
    /* skip val->colorAttachment */
    /* skip val->clearValue */
}

/* struct VkClearRect */

static inline void
vn_decode_VkClearRect_temp(struct vn_cs_decoder *dec, VkClearRect *val)
{
    vn_decode_VkRect2D_temp(dec, &val->rect);
    vn_decode_uint32_t(dec, &val->baseArrayLayer);
    vn_decode_uint32_t(dec, &val->layerCount);
}

static inline void
vn_replace_VkClearRect_handle(VkClearRect *val)
{
    vn_replace_VkRect2D_handle(&val->rect);
    /* skip val->baseArrayLayer */
    /* skip val->layerCount */
}

/* struct VkImageResolve */

static inline void
vn_decode_VkImageResolve_temp(struct vn_cs_decoder *dec, VkImageResolve *val)
{
    vn_decode_VkImageSubresourceLayers_temp(dec, &val->srcSubresource);
    vn_decode_VkOffset3D_temp(dec, &val->srcOffset);
    vn_decode_VkImageSubresourceLayers_temp(dec, &val->dstSubresource);
    vn_decode_VkOffset3D_temp(dec, &val->dstOffset);
    vn_decode_VkExtent3D_temp(dec, &val->extent);
}

static inline void
vn_replace_VkImageResolve_handle(VkImageResolve *val)
{
    vn_replace_VkImageSubresourceLayers_handle(&val->srcSubresource);
    vn_replace_VkOffset3D_handle(&val->srcOffset);
    vn_replace_VkImageSubresourceLayers_handle(&val->dstSubresource);
    vn_replace_VkOffset3D_handle(&val->dstOffset);
    vn_replace_VkExtent3D_handle(&val->extent);
}

/* struct VkMemoryBarrier chain */

static inline void *
vn_decode_VkMemoryBarrier_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkMemoryBarrier_self_temp(struct vn_cs_decoder *dec, VkMemoryBarrier *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkFlags(dec, &val->srcAccessMask);
    vn_decode_VkFlags(dec, &val->dstAccessMask);
}

static inline void
vn_decode_VkMemoryBarrier_temp(struct vn_cs_decoder *dec, VkMemoryBarrier *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_MEMORY_BARRIER)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkMemoryBarrier_pnext_temp(dec);
    vn_decode_VkMemoryBarrier_self_temp(dec, val);
}

static inline void
vn_replace_VkMemoryBarrier_handle_self(VkMemoryBarrier *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->srcAccessMask */
    /* skip val->dstAccessMask */
}

static inline void
vn_replace_VkMemoryBarrier_handle(VkMemoryBarrier *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_MEMORY_BARRIER:
            vn_replace_VkMemoryBarrier_handle_self((VkMemoryBarrier *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkBufferMemoryBarrier chain */

static inline void *
vn_decode_VkBufferMemoryBarrier_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkBufferMemoryBarrier_self_temp(struct vn_cs_decoder *dec, VkBufferMemoryBarrier *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkFlags(dec, &val->srcAccessMask);
    vn_decode_VkFlags(dec, &val->dstAccessMask);
    vn_decode_uint32_t(dec, &val->srcQueueFamilyIndex);
    vn_decode_uint32_t(dec, &val->dstQueueFamilyIndex);
    vn_decode_VkBuffer_lookup(dec, &val->buffer);
    vn_decode_VkDeviceSize(dec, &val->offset);
    vn_decode_VkDeviceSize(dec, &val->size);
}

static inline void
vn_decode_VkBufferMemoryBarrier_temp(struct vn_cs_decoder *dec, VkBufferMemoryBarrier *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_BUFFER_MEMORY_BARRIER)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkBufferMemoryBarrier_pnext_temp(dec);
    vn_decode_VkBufferMemoryBarrier_self_temp(dec, val);
}

static inline void
vn_replace_VkBufferMemoryBarrier_handle_self(VkBufferMemoryBarrier *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->srcAccessMask */
    /* skip val->dstAccessMask */
    /* skip val->srcQueueFamilyIndex */
    /* skip val->dstQueueFamilyIndex */
    vn_replace_VkBuffer_handle(&val->buffer);
    /* skip val->offset */
    /* skip val->size */
}

static inline void
vn_replace_VkBufferMemoryBarrier_handle(VkBufferMemoryBarrier *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_BUFFER_MEMORY_BARRIER:
            vn_replace_VkBufferMemoryBarrier_handle_self((VkBufferMemoryBarrier *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkImageMemoryBarrier chain */

static inline void *
vn_decode_VkImageMemoryBarrier_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkImageMemoryBarrier_self_temp(struct vn_cs_decoder *dec, VkImageMemoryBarrier *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkFlags(dec, &val->srcAccessMask);
    vn_decode_VkFlags(dec, &val->dstAccessMask);
    vn_decode_VkImageLayout(dec, &val->oldLayout);
    vn_decode_VkImageLayout(dec, &val->newLayout);
    vn_decode_uint32_t(dec, &val->srcQueueFamilyIndex);
    vn_decode_uint32_t(dec, &val->dstQueueFamilyIndex);
    vn_decode_VkImage_lookup(dec, &val->image);
    vn_decode_VkImageSubresourceRange_temp(dec, &val->subresourceRange);
}

static inline void
vn_decode_VkImageMemoryBarrier_temp(struct vn_cs_decoder *dec, VkImageMemoryBarrier *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_IMAGE_MEMORY_BARRIER)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkImageMemoryBarrier_pnext_temp(dec);
    vn_decode_VkImageMemoryBarrier_self_temp(dec, val);
}

static inline void
vn_replace_VkImageMemoryBarrier_handle_self(VkImageMemoryBarrier *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->srcAccessMask */
    /* skip val->dstAccessMask */
    /* skip val->oldLayout */
    /* skip val->newLayout */
    /* skip val->srcQueueFamilyIndex */
    /* skip val->dstQueueFamilyIndex */
    vn_replace_VkImage_handle(&val->image);
    vn_replace_VkImageSubresourceRange_handle(&val->subresourceRange);
}

static inline void
vn_replace_VkImageMemoryBarrier_handle(VkImageMemoryBarrier *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_IMAGE_MEMORY_BARRIER:
            vn_replace_VkImageMemoryBarrier_handle_self((VkImageMemoryBarrier *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkConditionalRenderingBeginInfoEXT chain */

static inline void *
vn_decode_VkConditionalRenderingBeginInfoEXT_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkConditionalRenderingBeginInfoEXT_self_temp(struct vn_cs_decoder *dec, VkConditionalRenderingBeginInfoEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBuffer_lookup(dec, &val->buffer);
    vn_decode_VkDeviceSize(dec, &val->offset);
    vn_decode_VkFlags(dec, &val->flags);
}

static inline void
vn_decode_VkConditionalRenderingBeginInfoEXT_temp(struct vn_cs_decoder *dec, VkConditionalRenderingBeginInfoEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_CONDITIONAL_RENDERING_BEGIN_INFO_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkConditionalRenderingBeginInfoEXT_pnext_temp(dec);
    vn_decode_VkConditionalRenderingBeginInfoEXT_self_temp(dec, val);
}

static inline void
vn_replace_VkConditionalRenderingBeginInfoEXT_handle_self(VkConditionalRenderingBeginInfoEXT *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    vn_replace_VkBuffer_handle(&val->buffer);
    /* skip val->offset */
    /* skip val->flags */
}

static inline void
vn_replace_VkConditionalRenderingBeginInfoEXT_handle(VkConditionalRenderingBeginInfoEXT *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_CONDITIONAL_RENDERING_BEGIN_INFO_EXT:
            vn_replace_VkConditionalRenderingBeginInfoEXT_handle_self((VkConditionalRenderingBeginInfoEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkDeviceGroupRenderPassBeginInfo chain */

static inline void *
vn_decode_VkDeviceGroupRenderPassBeginInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkDeviceGroupRenderPassBeginInfo_self_temp(struct vn_cs_decoder *dec, VkDeviceGroupRenderPassBeginInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_uint32_t(dec, &val->deviceMask);
    vn_decode_uint32_t(dec, &val->deviceRenderAreaCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, val->deviceRenderAreaCount);
        val->pDeviceRenderAreas = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pDeviceRenderAreas) * iter_count);
        if (!val->pDeviceRenderAreas) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkRect2D_temp(dec, &((VkRect2D *)val->pDeviceRenderAreas)[i]);
    } else {
        vn_decode_array_size(dec, val->deviceRenderAreaCount);
        val->pDeviceRenderAreas = NULL;
    }
}

static inline void
vn_decode_VkDeviceGroupRenderPassBeginInfo_temp(struct vn_cs_decoder *dec, VkDeviceGroupRenderPassBeginInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_DEVICE_GROUP_RENDER_PASS_BEGIN_INFO)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkDeviceGroupRenderPassBeginInfo_pnext_temp(dec);
    vn_decode_VkDeviceGroupRenderPassBeginInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkDeviceGroupRenderPassBeginInfo_handle_self(VkDeviceGroupRenderPassBeginInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->deviceMask */
    /* skip val->deviceRenderAreaCount */
    if (val->pDeviceRenderAreas) {
       for (uint32_t i = 0; i < val->deviceRenderAreaCount; i++)
            vn_replace_VkRect2D_handle(&((VkRect2D *)val->pDeviceRenderAreas)[i]);
    }
}

static inline void
vn_replace_VkDeviceGroupRenderPassBeginInfo_handle(VkDeviceGroupRenderPassBeginInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_RENDER_PASS_BEGIN_INFO:
            vn_replace_VkDeviceGroupRenderPassBeginInfo_handle_self((VkDeviceGroupRenderPassBeginInfo *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkRenderPassAttachmentBeginInfo chain */

static inline void *
vn_decode_VkRenderPassAttachmentBeginInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkRenderPassAttachmentBeginInfo_self_temp(struct vn_cs_decoder *dec, VkRenderPassAttachmentBeginInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_uint32_t(dec, &val->attachmentCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, val->attachmentCount);
        val->pAttachments = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pAttachments) * iter_count);
        if (!val->pAttachments) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkImageView_lookup(dec, &((VkImageView *)val->pAttachments)[i]);
    } else {
        vn_decode_array_size(dec, val->attachmentCount);
        val->pAttachments = NULL;
    }
}

static inline void
vn_decode_VkRenderPassAttachmentBeginInfo_temp(struct vn_cs_decoder *dec, VkRenderPassAttachmentBeginInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_RENDER_PASS_ATTACHMENT_BEGIN_INFO)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkRenderPassAttachmentBeginInfo_pnext_temp(dec);
    vn_decode_VkRenderPassAttachmentBeginInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkRenderPassAttachmentBeginInfo_handle_self(VkRenderPassAttachmentBeginInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->attachmentCount */
    if (val->pAttachments) {
       for (uint32_t i = 0; i < val->attachmentCount; i++)
            vn_replace_VkImageView_handle(&((VkImageView *)val->pAttachments)[i]);
    }
}

static inline void
vn_replace_VkRenderPassAttachmentBeginInfo_handle(VkRenderPassAttachmentBeginInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_RENDER_PASS_ATTACHMENT_BEGIN_INFO:
            vn_replace_VkRenderPassAttachmentBeginInfo_handle_self((VkRenderPassAttachmentBeginInfo *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkRenderPassBeginInfo chain */

static inline void *
vn_decode_VkRenderPassBeginInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    VkBaseOutStructure *pnext;
    VkStructureType stype;

    if (!vn_decode_simple_pointer(dec))
        return NULL;

    vn_decode_VkStructureType(dec, &stype);
    switch ((int32_t)stype) {
    case VK_STRUCTURE_TYPE_DEVICE_GROUP_RENDER_PASS_BEGIN_INFO:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkDeviceGroupRenderPassBeginInfo));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkRenderPassBeginInfo_pnext_temp(dec);
            vn_decode_VkDeviceGroupRenderPassBeginInfo_self_temp(dec, (VkDeviceGroupRenderPassBeginInfo *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_RENDER_PASS_ATTACHMENT_BEGIN_INFO:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkRenderPassAttachmentBeginInfo));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkRenderPassBeginInfo_pnext_temp(dec);
            vn_decode_VkRenderPassAttachmentBeginInfo_self_temp(dec, (VkRenderPassAttachmentBeginInfo *)pnext);
        }
        break;
    default:
        /* unexpected struct */
        pnext = NULL;
        vn_cs_decoder_set_fatal(dec);
        break;
    }

    return pnext;
}

static inline void
vn_decode_VkRenderPassBeginInfo_self_temp(struct vn_cs_decoder *dec, VkRenderPassBeginInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkRenderPass_lookup(dec, &val->renderPass);
    vn_decode_VkFramebuffer_lookup(dec, &val->framebuffer);
    vn_decode_VkRect2D_temp(dec, &val->renderArea);
    vn_decode_uint32_t(dec, &val->clearValueCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, val->clearValueCount);
        val->pClearValues = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pClearValues) * iter_count);
        if (!val->pClearValues) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkClearValue_temp(dec, &((VkClearValue *)val->pClearValues)[i]);
    } else {
        vn_decode_array_size_unchecked(dec);
        val->pClearValues = NULL;
    }
}

static inline void
vn_decode_VkRenderPassBeginInfo_temp(struct vn_cs_decoder *dec, VkRenderPassBeginInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_RENDER_PASS_BEGIN_INFO)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkRenderPassBeginInfo_pnext_temp(dec);
    vn_decode_VkRenderPassBeginInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkRenderPassBeginInfo_handle_self(VkRenderPassBeginInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    vn_replace_VkRenderPass_handle(&val->renderPass);
    vn_replace_VkFramebuffer_handle(&val->framebuffer);
    vn_replace_VkRect2D_handle(&val->renderArea);
    /* skip val->clearValueCount */
    /* skip val->pClearValues */
}

static inline void
vn_replace_VkRenderPassBeginInfo_handle(VkRenderPassBeginInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_RENDER_PASS_BEGIN_INFO:
            vn_replace_VkRenderPassBeginInfo_handle_self((VkRenderPassBeginInfo *)pnext);
            break;
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_RENDER_PASS_BEGIN_INFO:
            vn_replace_VkDeviceGroupRenderPassBeginInfo_handle_self((VkDeviceGroupRenderPassBeginInfo *)pnext);
            break;
        case VK_STRUCTURE_TYPE_RENDER_PASS_ATTACHMENT_BEGIN_INFO:
            vn_replace_VkRenderPassAttachmentBeginInfo_handle_self((VkRenderPassAttachmentBeginInfo *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkSubpassBeginInfo chain */

static inline void *
vn_decode_VkSubpassBeginInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkSubpassBeginInfo_self_temp(struct vn_cs_decoder *dec, VkSubpassBeginInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkSubpassContents(dec, &val->contents);
}

static inline void
vn_decode_VkSubpassBeginInfo_temp(struct vn_cs_decoder *dec, VkSubpassBeginInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_SUBPASS_BEGIN_INFO)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkSubpassBeginInfo_pnext_temp(dec);
    vn_decode_VkSubpassBeginInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkSubpassBeginInfo_handle_self(VkSubpassBeginInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->contents */
}

static inline void
vn_replace_VkSubpassBeginInfo_handle(VkSubpassBeginInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_SUBPASS_BEGIN_INFO:
            vn_replace_VkSubpassBeginInfo_handle_self((VkSubpassBeginInfo *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkSubpassEndInfo chain */

static inline void *
vn_decode_VkSubpassEndInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkSubpassEndInfo_self_temp(struct vn_cs_decoder *dec, VkSubpassEndInfo *val)
{
    /* skip val->{sType,pNext} */
}

static inline void
vn_decode_VkSubpassEndInfo_temp(struct vn_cs_decoder *dec, VkSubpassEndInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_SUBPASS_END_INFO)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkSubpassEndInfo_pnext_temp(dec);
    vn_decode_VkSubpassEndInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkSubpassEndInfo_handle_self(VkSubpassEndInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
}

static inline void
vn_replace_VkSubpassEndInfo_handle(VkSubpassEndInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_SUBPASS_END_INFO:
            vn_replace_VkSubpassEndInfo_handle_self((VkSubpassEndInfo *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkBufferCopy2 chain */

static inline void *
vn_decode_VkBufferCopy2_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkBufferCopy2_self_temp(struct vn_cs_decoder *dec, VkBufferCopy2 *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkDeviceSize(dec, &val->srcOffset);
    vn_decode_VkDeviceSize(dec, &val->dstOffset);
    vn_decode_VkDeviceSize(dec, &val->size);
}

static inline void
vn_decode_VkBufferCopy2_temp(struct vn_cs_decoder *dec, VkBufferCopy2 *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_BUFFER_COPY_2)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkBufferCopy2_pnext_temp(dec);
    vn_decode_VkBufferCopy2_self_temp(dec, val);
}

static inline void
vn_replace_VkBufferCopy2_handle_self(VkBufferCopy2 *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->srcOffset */
    /* skip val->dstOffset */
    /* skip val->size */
}

static inline void
vn_replace_VkBufferCopy2_handle(VkBufferCopy2 *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_BUFFER_COPY_2:
            vn_replace_VkBufferCopy2_handle_self((VkBufferCopy2 *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkCopyBufferInfo2 chain */

static inline void *
vn_decode_VkCopyBufferInfo2_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkCopyBufferInfo2_self_temp(struct vn_cs_decoder *dec, VkCopyBufferInfo2 *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBuffer_lookup(dec, &val->srcBuffer);
    vn_decode_VkBuffer_lookup(dec, &val->dstBuffer);
    vn_decode_uint32_t(dec, &val->regionCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, val->regionCount);
        val->pRegions = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pRegions) * iter_count);
        if (!val->pRegions) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkBufferCopy2_temp(dec, &((VkBufferCopy2 *)val->pRegions)[i]);
    } else {
        vn_decode_array_size(dec, val->regionCount);
        val->pRegions = NULL;
    }
}

static inline void
vn_decode_VkCopyBufferInfo2_temp(struct vn_cs_decoder *dec, VkCopyBufferInfo2 *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_COPY_BUFFER_INFO_2)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkCopyBufferInfo2_pnext_temp(dec);
    vn_decode_VkCopyBufferInfo2_self_temp(dec, val);
}

static inline void
vn_replace_VkCopyBufferInfo2_handle_self(VkCopyBufferInfo2 *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    vn_replace_VkBuffer_handle(&val->srcBuffer);
    vn_replace_VkBuffer_handle(&val->dstBuffer);
    /* skip val->regionCount */
    if (val->pRegions) {
       for (uint32_t i = 0; i < val->regionCount; i++)
            vn_replace_VkBufferCopy2_handle(&((VkBufferCopy2 *)val->pRegions)[i]);
    }
}

static inline void
vn_replace_VkCopyBufferInfo2_handle(VkCopyBufferInfo2 *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_COPY_BUFFER_INFO_2:
            vn_replace_VkCopyBufferInfo2_handle_self((VkCopyBufferInfo2 *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkImageCopy2 chain */

static inline void *
vn_decode_VkImageCopy2_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkImageCopy2_self_temp(struct vn_cs_decoder *dec, VkImageCopy2 *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkImageSubresourceLayers_temp(dec, &val->srcSubresource);
    vn_decode_VkOffset3D_temp(dec, &val->srcOffset);
    vn_decode_VkImageSubresourceLayers_temp(dec, &val->dstSubresource);
    vn_decode_VkOffset3D_temp(dec, &val->dstOffset);
    vn_decode_VkExtent3D_temp(dec, &val->extent);
}

static inline void
vn_decode_VkImageCopy2_temp(struct vn_cs_decoder *dec, VkImageCopy2 *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_IMAGE_COPY_2)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkImageCopy2_pnext_temp(dec);
    vn_decode_VkImageCopy2_self_temp(dec, val);
}

static inline void
vn_replace_VkImageCopy2_handle_self(VkImageCopy2 *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    vn_replace_VkImageSubresourceLayers_handle(&val->srcSubresource);
    vn_replace_VkOffset3D_handle(&val->srcOffset);
    vn_replace_VkImageSubresourceLayers_handle(&val->dstSubresource);
    vn_replace_VkOffset3D_handle(&val->dstOffset);
    vn_replace_VkExtent3D_handle(&val->extent);
}

static inline void
vn_replace_VkImageCopy2_handle(VkImageCopy2 *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_IMAGE_COPY_2:
            vn_replace_VkImageCopy2_handle_self((VkImageCopy2 *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkCopyImageInfo2 chain */

static inline void *
vn_decode_VkCopyImageInfo2_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkCopyImageInfo2_self_temp(struct vn_cs_decoder *dec, VkCopyImageInfo2 *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkImage_lookup(dec, &val->srcImage);
    vn_decode_VkImageLayout(dec, &val->srcImageLayout);
    vn_decode_VkImage_lookup(dec, &val->dstImage);
    vn_decode_VkImageLayout(dec, &val->dstImageLayout);
    vn_decode_uint32_t(dec, &val->regionCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, val->regionCount);
        val->pRegions = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pRegions) * iter_count);
        if (!val->pRegions) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkImageCopy2_temp(dec, &((VkImageCopy2 *)val->pRegions)[i]);
    } else {
        vn_decode_array_size(dec, val->regionCount);
        val->pRegions = NULL;
    }
}

static inline void
vn_decode_VkCopyImageInfo2_temp(struct vn_cs_decoder *dec, VkCopyImageInfo2 *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_COPY_IMAGE_INFO_2)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkCopyImageInfo2_pnext_temp(dec);
    vn_decode_VkCopyImageInfo2_self_temp(dec, val);
}

static inline void
vn_replace_VkCopyImageInfo2_handle_self(VkCopyImageInfo2 *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    vn_replace_VkImage_handle(&val->srcImage);
    /* skip val->srcImageLayout */
    vn_replace_VkImage_handle(&val->dstImage);
    /* skip val->dstImageLayout */
    /* skip val->regionCount */
    if (val->pRegions) {
       for (uint32_t i = 0; i < val->regionCount; i++)
            vn_replace_VkImageCopy2_handle(&((VkImageCopy2 *)val->pRegions)[i]);
    }
}

static inline void
vn_replace_VkCopyImageInfo2_handle(VkCopyImageInfo2 *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_COPY_IMAGE_INFO_2:
            vn_replace_VkCopyImageInfo2_handle_self((VkCopyImageInfo2 *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkImageBlit2 chain */

static inline void *
vn_decode_VkImageBlit2_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkImageBlit2_self_temp(struct vn_cs_decoder *dec, VkImageBlit2 *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkImageSubresourceLayers_temp(dec, &val->srcSubresource);
    {
        const uint32_t iter_count = vn_decode_array_size(dec, 2);
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkOffset3D_temp(dec, &val->srcOffsets[i]);
    }
    vn_decode_VkImageSubresourceLayers_temp(dec, &val->dstSubresource);
    {
        const uint32_t iter_count = vn_decode_array_size(dec, 2);
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkOffset3D_temp(dec, &val->dstOffsets[i]);
    }
}

static inline void
vn_decode_VkImageBlit2_temp(struct vn_cs_decoder *dec, VkImageBlit2 *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_IMAGE_BLIT_2)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkImageBlit2_pnext_temp(dec);
    vn_decode_VkImageBlit2_self_temp(dec, val);
}

static inline void
vn_replace_VkImageBlit2_handle_self(VkImageBlit2 *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    vn_replace_VkImageSubresourceLayers_handle(&val->srcSubresource);
    for (uint32_t i = 0; i < 2; i++)
        vn_replace_VkOffset3D_handle(&val->srcOffsets[i]);
    vn_replace_VkImageSubresourceLayers_handle(&val->dstSubresource);
    for (uint32_t i = 0; i < 2; i++)
        vn_replace_VkOffset3D_handle(&val->dstOffsets[i]);
}

static inline void
vn_replace_VkImageBlit2_handle(VkImageBlit2 *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_IMAGE_BLIT_2:
            vn_replace_VkImageBlit2_handle_self((VkImageBlit2 *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkBlitImageInfo2 chain */

static inline void *
vn_decode_VkBlitImageInfo2_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkBlitImageInfo2_self_temp(struct vn_cs_decoder *dec, VkBlitImageInfo2 *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkImage_lookup(dec, &val->srcImage);
    vn_decode_VkImageLayout(dec, &val->srcImageLayout);
    vn_decode_VkImage_lookup(dec, &val->dstImage);
    vn_decode_VkImageLayout(dec, &val->dstImageLayout);
    vn_decode_uint32_t(dec, &val->regionCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, val->regionCount);
        val->pRegions = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pRegions) * iter_count);
        if (!val->pRegions) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkImageBlit2_temp(dec, &((VkImageBlit2 *)val->pRegions)[i]);
    } else {
        vn_decode_array_size(dec, val->regionCount);
        val->pRegions = NULL;
    }
    vn_decode_VkFilter(dec, &val->filter);
}

static inline void
vn_decode_VkBlitImageInfo2_temp(struct vn_cs_decoder *dec, VkBlitImageInfo2 *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_BLIT_IMAGE_INFO_2)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkBlitImageInfo2_pnext_temp(dec);
    vn_decode_VkBlitImageInfo2_self_temp(dec, val);
}

static inline void
vn_replace_VkBlitImageInfo2_handle_self(VkBlitImageInfo2 *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    vn_replace_VkImage_handle(&val->srcImage);
    /* skip val->srcImageLayout */
    vn_replace_VkImage_handle(&val->dstImage);
    /* skip val->dstImageLayout */
    /* skip val->regionCount */
    if (val->pRegions) {
       for (uint32_t i = 0; i < val->regionCount; i++)
            vn_replace_VkImageBlit2_handle(&((VkImageBlit2 *)val->pRegions)[i]);
    }
    /* skip val->filter */
}

static inline void
vn_replace_VkBlitImageInfo2_handle(VkBlitImageInfo2 *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_BLIT_IMAGE_INFO_2:
            vn_replace_VkBlitImageInfo2_handle_self((VkBlitImageInfo2 *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkBufferImageCopy2 chain */

static inline void *
vn_decode_VkBufferImageCopy2_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkBufferImageCopy2_self_temp(struct vn_cs_decoder *dec, VkBufferImageCopy2 *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkDeviceSize(dec, &val->bufferOffset);
    vn_decode_uint32_t(dec, &val->bufferRowLength);
    vn_decode_uint32_t(dec, &val->bufferImageHeight);
    vn_decode_VkImageSubresourceLayers_temp(dec, &val->imageSubresource);
    vn_decode_VkOffset3D_temp(dec, &val->imageOffset);
    vn_decode_VkExtent3D_temp(dec, &val->imageExtent);
}

static inline void
vn_decode_VkBufferImageCopy2_temp(struct vn_cs_decoder *dec, VkBufferImageCopy2 *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_BUFFER_IMAGE_COPY_2)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkBufferImageCopy2_pnext_temp(dec);
    vn_decode_VkBufferImageCopy2_self_temp(dec, val);
}

static inline void
vn_replace_VkBufferImageCopy2_handle_self(VkBufferImageCopy2 *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->bufferOffset */
    /* skip val->bufferRowLength */
    /* skip val->bufferImageHeight */
    vn_replace_VkImageSubresourceLayers_handle(&val->imageSubresource);
    vn_replace_VkOffset3D_handle(&val->imageOffset);
    vn_replace_VkExtent3D_handle(&val->imageExtent);
}

static inline void
vn_replace_VkBufferImageCopy2_handle(VkBufferImageCopy2 *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_BUFFER_IMAGE_COPY_2:
            vn_replace_VkBufferImageCopy2_handle_self((VkBufferImageCopy2 *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkCopyBufferToImageInfo2 chain */

static inline void *
vn_decode_VkCopyBufferToImageInfo2_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkCopyBufferToImageInfo2_self_temp(struct vn_cs_decoder *dec, VkCopyBufferToImageInfo2 *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBuffer_lookup(dec, &val->srcBuffer);
    vn_decode_VkImage_lookup(dec, &val->dstImage);
    vn_decode_VkImageLayout(dec, &val->dstImageLayout);
    vn_decode_uint32_t(dec, &val->regionCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, val->regionCount);
        val->pRegions = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pRegions) * iter_count);
        if (!val->pRegions) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkBufferImageCopy2_temp(dec, &((VkBufferImageCopy2 *)val->pRegions)[i]);
    } else {
        vn_decode_array_size(dec, val->regionCount);
        val->pRegions = NULL;
    }
}

static inline void
vn_decode_VkCopyBufferToImageInfo2_temp(struct vn_cs_decoder *dec, VkCopyBufferToImageInfo2 *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_COPY_BUFFER_TO_IMAGE_INFO_2)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkCopyBufferToImageInfo2_pnext_temp(dec);
    vn_decode_VkCopyBufferToImageInfo2_self_temp(dec, val);
}

static inline void
vn_replace_VkCopyBufferToImageInfo2_handle_self(VkCopyBufferToImageInfo2 *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    vn_replace_VkBuffer_handle(&val->srcBuffer);
    vn_replace_VkImage_handle(&val->dstImage);
    /* skip val->dstImageLayout */
    /* skip val->regionCount */
    if (val->pRegions) {
       for (uint32_t i = 0; i < val->regionCount; i++)
            vn_replace_VkBufferImageCopy2_handle(&((VkBufferImageCopy2 *)val->pRegions)[i]);
    }
}

static inline void
vn_replace_VkCopyBufferToImageInfo2_handle(VkCopyBufferToImageInfo2 *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_COPY_BUFFER_TO_IMAGE_INFO_2:
            vn_replace_VkCopyBufferToImageInfo2_handle_self((VkCopyBufferToImageInfo2 *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkCopyImageToBufferInfo2 chain */

static inline void *
vn_decode_VkCopyImageToBufferInfo2_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkCopyImageToBufferInfo2_self_temp(struct vn_cs_decoder *dec, VkCopyImageToBufferInfo2 *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkImage_lookup(dec, &val->srcImage);
    vn_decode_VkImageLayout(dec, &val->srcImageLayout);
    vn_decode_VkBuffer_lookup(dec, &val->dstBuffer);
    vn_decode_uint32_t(dec, &val->regionCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, val->regionCount);
        val->pRegions = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pRegions) * iter_count);
        if (!val->pRegions) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkBufferImageCopy2_temp(dec, &((VkBufferImageCopy2 *)val->pRegions)[i]);
    } else {
        vn_decode_array_size(dec, val->regionCount);
        val->pRegions = NULL;
    }
}

static inline void
vn_decode_VkCopyImageToBufferInfo2_temp(struct vn_cs_decoder *dec, VkCopyImageToBufferInfo2 *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_COPY_IMAGE_TO_BUFFER_INFO_2)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkCopyImageToBufferInfo2_pnext_temp(dec);
    vn_decode_VkCopyImageToBufferInfo2_self_temp(dec, val);
}

static inline void
vn_replace_VkCopyImageToBufferInfo2_handle_self(VkCopyImageToBufferInfo2 *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    vn_replace_VkImage_handle(&val->srcImage);
    /* skip val->srcImageLayout */
    vn_replace_VkBuffer_handle(&val->dstBuffer);
    /* skip val->regionCount */
    if (val->pRegions) {
       for (uint32_t i = 0; i < val->regionCount; i++)
            vn_replace_VkBufferImageCopy2_handle(&((VkBufferImageCopy2 *)val->pRegions)[i]);
    }
}

static inline void
vn_replace_VkCopyImageToBufferInfo2_handle(VkCopyImageToBufferInfo2 *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_COPY_IMAGE_TO_BUFFER_INFO_2:
            vn_replace_VkCopyImageToBufferInfo2_handle_self((VkCopyImageToBufferInfo2 *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkImageResolve2 chain */

static inline void *
vn_decode_VkImageResolve2_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkImageResolve2_self_temp(struct vn_cs_decoder *dec, VkImageResolve2 *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkImageSubresourceLayers_temp(dec, &val->srcSubresource);
    vn_decode_VkOffset3D_temp(dec, &val->srcOffset);
    vn_decode_VkImageSubresourceLayers_temp(dec, &val->dstSubresource);
    vn_decode_VkOffset3D_temp(dec, &val->dstOffset);
    vn_decode_VkExtent3D_temp(dec, &val->extent);
}

static inline void
vn_decode_VkImageResolve2_temp(struct vn_cs_decoder *dec, VkImageResolve2 *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_IMAGE_RESOLVE_2)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkImageResolve2_pnext_temp(dec);
    vn_decode_VkImageResolve2_self_temp(dec, val);
}

static inline void
vn_replace_VkImageResolve2_handle_self(VkImageResolve2 *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    vn_replace_VkImageSubresourceLayers_handle(&val->srcSubresource);
    vn_replace_VkOffset3D_handle(&val->srcOffset);
    vn_replace_VkImageSubresourceLayers_handle(&val->dstSubresource);
    vn_replace_VkOffset3D_handle(&val->dstOffset);
    vn_replace_VkExtent3D_handle(&val->extent);
}

static inline void
vn_replace_VkImageResolve2_handle(VkImageResolve2 *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_IMAGE_RESOLVE_2:
            vn_replace_VkImageResolve2_handle_self((VkImageResolve2 *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkResolveImageInfo2 chain */

static inline void *
vn_decode_VkResolveImageInfo2_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkResolveImageInfo2_self_temp(struct vn_cs_decoder *dec, VkResolveImageInfo2 *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkImage_lookup(dec, &val->srcImage);
    vn_decode_VkImageLayout(dec, &val->srcImageLayout);
    vn_decode_VkImage_lookup(dec, &val->dstImage);
    vn_decode_VkImageLayout(dec, &val->dstImageLayout);
    vn_decode_uint32_t(dec, &val->regionCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, val->regionCount);
        val->pRegions = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pRegions) * iter_count);
        if (!val->pRegions) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkImageResolve2_temp(dec, &((VkImageResolve2 *)val->pRegions)[i]);
    } else {
        vn_decode_array_size(dec, val->regionCount);
        val->pRegions = NULL;
    }
}

static inline void
vn_decode_VkResolveImageInfo2_temp(struct vn_cs_decoder *dec, VkResolveImageInfo2 *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_RESOLVE_IMAGE_INFO_2)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkResolveImageInfo2_pnext_temp(dec);
    vn_decode_VkResolveImageInfo2_self_temp(dec, val);
}

static inline void
vn_replace_VkResolveImageInfo2_handle_self(VkResolveImageInfo2 *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    vn_replace_VkImage_handle(&val->srcImage);
    /* skip val->srcImageLayout */
    vn_replace_VkImage_handle(&val->dstImage);
    /* skip val->dstImageLayout */
    /* skip val->regionCount */
    if (val->pRegions) {
       for (uint32_t i = 0; i < val->regionCount; i++)
            vn_replace_VkImageResolve2_handle(&((VkImageResolve2 *)val->pRegions)[i]);
    }
}

static inline void
vn_replace_VkResolveImageInfo2_handle(VkResolveImageInfo2 *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_RESOLVE_IMAGE_INFO_2:
            vn_replace_VkResolveImageInfo2_handle_self((VkResolveImageInfo2 *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkBufferMemoryBarrier2 chain */

static inline void *
vn_decode_VkBufferMemoryBarrier2_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkBufferMemoryBarrier2_self_temp(struct vn_cs_decoder *dec, VkBufferMemoryBarrier2 *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkFlags64(dec, &val->srcStageMask);
    vn_decode_VkFlags64(dec, &val->srcAccessMask);
    vn_decode_VkFlags64(dec, &val->dstStageMask);
    vn_decode_VkFlags64(dec, &val->dstAccessMask);
    vn_decode_uint32_t(dec, &val->srcQueueFamilyIndex);
    vn_decode_uint32_t(dec, &val->dstQueueFamilyIndex);
    vn_decode_VkBuffer_lookup(dec, &val->buffer);
    vn_decode_VkDeviceSize(dec, &val->offset);
    vn_decode_VkDeviceSize(dec, &val->size);
}

static inline void
vn_decode_VkBufferMemoryBarrier2_temp(struct vn_cs_decoder *dec, VkBufferMemoryBarrier2 *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_BUFFER_MEMORY_BARRIER_2)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkBufferMemoryBarrier2_pnext_temp(dec);
    vn_decode_VkBufferMemoryBarrier2_self_temp(dec, val);
}

static inline void
vn_replace_VkBufferMemoryBarrier2_handle_self(VkBufferMemoryBarrier2 *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->srcStageMask */
    /* skip val->srcAccessMask */
    /* skip val->dstStageMask */
    /* skip val->dstAccessMask */
    /* skip val->srcQueueFamilyIndex */
    /* skip val->dstQueueFamilyIndex */
    vn_replace_VkBuffer_handle(&val->buffer);
    /* skip val->offset */
    /* skip val->size */
}

static inline void
vn_replace_VkBufferMemoryBarrier2_handle(VkBufferMemoryBarrier2 *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_BUFFER_MEMORY_BARRIER_2:
            vn_replace_VkBufferMemoryBarrier2_handle_self((VkBufferMemoryBarrier2 *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkImageMemoryBarrier2 chain */

static inline void *
vn_decode_VkImageMemoryBarrier2_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkImageMemoryBarrier2_self_temp(struct vn_cs_decoder *dec, VkImageMemoryBarrier2 *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkFlags64(dec, &val->srcStageMask);
    vn_decode_VkFlags64(dec, &val->srcAccessMask);
    vn_decode_VkFlags64(dec, &val->dstStageMask);
    vn_decode_VkFlags64(dec, &val->dstAccessMask);
    vn_decode_VkImageLayout(dec, &val->oldLayout);
    vn_decode_VkImageLayout(dec, &val->newLayout);
    vn_decode_uint32_t(dec, &val->srcQueueFamilyIndex);
    vn_decode_uint32_t(dec, &val->dstQueueFamilyIndex);
    vn_decode_VkImage_lookup(dec, &val->image);
    vn_decode_VkImageSubresourceRange_temp(dec, &val->subresourceRange);
}

static inline void
vn_decode_VkImageMemoryBarrier2_temp(struct vn_cs_decoder *dec, VkImageMemoryBarrier2 *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_IMAGE_MEMORY_BARRIER_2)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkImageMemoryBarrier2_pnext_temp(dec);
    vn_decode_VkImageMemoryBarrier2_self_temp(dec, val);
}

static inline void
vn_replace_VkImageMemoryBarrier2_handle_self(VkImageMemoryBarrier2 *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->srcStageMask */
    /* skip val->srcAccessMask */
    /* skip val->dstStageMask */
    /* skip val->dstAccessMask */
    /* skip val->oldLayout */
    /* skip val->newLayout */
    /* skip val->srcQueueFamilyIndex */
    /* skip val->dstQueueFamilyIndex */
    vn_replace_VkImage_handle(&val->image);
    vn_replace_VkImageSubresourceRange_handle(&val->subresourceRange);
}

static inline void
vn_replace_VkImageMemoryBarrier2_handle(VkImageMemoryBarrier2 *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_IMAGE_MEMORY_BARRIER_2:
            vn_replace_VkImageMemoryBarrier2_handle_self((VkImageMemoryBarrier2 *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkDependencyInfo chain */

static inline void *
vn_decode_VkDependencyInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkDependencyInfo_self_temp(struct vn_cs_decoder *dec, VkDependencyInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkFlags(dec, &val->dependencyFlags);
    vn_decode_uint32_t(dec, &val->memoryBarrierCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, val->memoryBarrierCount);
        val->pMemoryBarriers = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pMemoryBarriers) * iter_count);
        if (!val->pMemoryBarriers) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkMemoryBarrier2_temp(dec, &((VkMemoryBarrier2 *)val->pMemoryBarriers)[i]);
    } else {
        vn_decode_array_size(dec, val->memoryBarrierCount);
        val->pMemoryBarriers = NULL;
    }
    vn_decode_uint32_t(dec, &val->bufferMemoryBarrierCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, val->bufferMemoryBarrierCount);
        val->pBufferMemoryBarriers = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pBufferMemoryBarriers) * iter_count);
        if (!val->pBufferMemoryBarriers) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkBufferMemoryBarrier2_temp(dec, &((VkBufferMemoryBarrier2 *)val->pBufferMemoryBarriers)[i]);
    } else {
        vn_decode_array_size(dec, val->bufferMemoryBarrierCount);
        val->pBufferMemoryBarriers = NULL;
    }
    vn_decode_uint32_t(dec, &val->imageMemoryBarrierCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, val->imageMemoryBarrierCount);
        val->pImageMemoryBarriers = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pImageMemoryBarriers) * iter_count);
        if (!val->pImageMemoryBarriers) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkImageMemoryBarrier2_temp(dec, &((VkImageMemoryBarrier2 *)val->pImageMemoryBarriers)[i]);
    } else {
        vn_decode_array_size(dec, val->imageMemoryBarrierCount);
        val->pImageMemoryBarriers = NULL;
    }
}

static inline void
vn_decode_VkDependencyInfo_temp(struct vn_cs_decoder *dec, VkDependencyInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_DEPENDENCY_INFO)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkDependencyInfo_pnext_temp(dec);
    vn_decode_VkDependencyInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkDependencyInfo_handle_self(VkDependencyInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->dependencyFlags */
    /* skip val->memoryBarrierCount */
    if (val->pMemoryBarriers) {
       for (uint32_t i = 0; i < val->memoryBarrierCount; i++)
            vn_replace_VkMemoryBarrier2_handle(&((VkMemoryBarrier2 *)val->pMemoryBarriers)[i]);
    }
    /* skip val->bufferMemoryBarrierCount */
    if (val->pBufferMemoryBarriers) {
       for (uint32_t i = 0; i < val->bufferMemoryBarrierCount; i++)
            vn_replace_VkBufferMemoryBarrier2_handle(&((VkBufferMemoryBarrier2 *)val->pBufferMemoryBarriers)[i]);
    }
    /* skip val->imageMemoryBarrierCount */
    if (val->pImageMemoryBarriers) {
       for (uint32_t i = 0; i < val->imageMemoryBarrierCount; i++)
            vn_replace_VkImageMemoryBarrier2_handle(&((VkImageMemoryBarrier2 *)val->pImageMemoryBarriers)[i]);
    }
}

static inline void
vn_replace_VkDependencyInfo_handle(VkDependencyInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_DEPENDENCY_INFO:
            vn_replace_VkDependencyInfo_handle_self((VkDependencyInfo *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkRenderingAttachmentInfo chain */

static inline void *
vn_decode_VkRenderingAttachmentInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkRenderingAttachmentInfo_self_temp(struct vn_cs_decoder *dec, VkRenderingAttachmentInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkImageView_lookup(dec, &val->imageView);
    vn_decode_VkImageLayout(dec, &val->imageLayout);
    vn_decode_VkResolveModeFlagBits(dec, &val->resolveMode);
    vn_decode_VkImageView_lookup(dec, &val->resolveImageView);
    vn_decode_VkImageLayout(dec, &val->resolveImageLayout);
    vn_decode_VkAttachmentLoadOp(dec, &val->loadOp);
    vn_decode_VkAttachmentStoreOp(dec, &val->storeOp);
    vn_decode_VkClearValue_temp(dec, &val->clearValue);
}

static inline void
vn_decode_VkRenderingAttachmentInfo_temp(struct vn_cs_decoder *dec, VkRenderingAttachmentInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_RENDERING_ATTACHMENT_INFO)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkRenderingAttachmentInfo_pnext_temp(dec);
    vn_decode_VkRenderingAttachmentInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkRenderingAttachmentInfo_handle_self(VkRenderingAttachmentInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    vn_replace_VkImageView_handle(&val->imageView);
    /* skip val->imageLayout */
    /* skip val->resolveMode */
    vn_replace_VkImageView_handle(&val->resolveImageView);
    /* skip val->resolveImageLayout */
    /* skip val->loadOp */
    /* skip val->storeOp */
    /* skip val->clearValue */
}

static inline void
vn_replace_VkRenderingAttachmentInfo_handle(VkRenderingAttachmentInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_RENDERING_ATTACHMENT_INFO:
            vn_replace_VkRenderingAttachmentInfo_handle_self((VkRenderingAttachmentInfo *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkRenderingInfo chain */

static inline void *
vn_decode_VkRenderingInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    VkBaseOutStructure *pnext;
    VkStructureType stype;

    if (!vn_decode_simple_pointer(dec))
        return NULL;

    vn_decode_VkStructureType(dec, &stype);
    switch ((int32_t)stype) {
    case VK_STRUCTURE_TYPE_DEVICE_GROUP_RENDER_PASS_BEGIN_INFO:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkDeviceGroupRenderPassBeginInfo));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkRenderingInfo_pnext_temp(dec);
            vn_decode_VkDeviceGroupRenderPassBeginInfo_self_temp(dec, (VkDeviceGroupRenderPassBeginInfo *)pnext);
        }
        break;
    default:
        /* unexpected struct */
        pnext = NULL;
        vn_cs_decoder_set_fatal(dec);
        break;
    }

    return pnext;
}

static inline void
vn_decode_VkRenderingInfo_self_temp(struct vn_cs_decoder *dec, VkRenderingInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkFlags(dec, &val->flags);
    vn_decode_VkRect2D_temp(dec, &val->renderArea);
    vn_decode_uint32_t(dec, &val->layerCount);
    vn_decode_uint32_t(dec, &val->viewMask);
    vn_decode_uint32_t(dec, &val->colorAttachmentCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, val->colorAttachmentCount);
        val->pColorAttachments = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pColorAttachments) * iter_count);
        if (!val->pColorAttachments) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkRenderingAttachmentInfo_temp(dec, &((VkRenderingAttachmentInfo *)val->pColorAttachments)[i]);
    } else {
        vn_decode_array_size(dec, val->colorAttachmentCount);
        val->pColorAttachments = NULL;
    }
    if (vn_decode_simple_pointer(dec)) {
        val->pDepthAttachment = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pDepthAttachment));
        if (!val->pDepthAttachment) return;
        vn_decode_VkRenderingAttachmentInfo_temp(dec, (VkRenderingAttachmentInfo *)val->pDepthAttachment);
    } else {
        val->pDepthAttachment = NULL;
    }
    if (vn_decode_simple_pointer(dec)) {
        val->pStencilAttachment = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pStencilAttachment));
        if (!val->pStencilAttachment) return;
        vn_decode_VkRenderingAttachmentInfo_temp(dec, (VkRenderingAttachmentInfo *)val->pStencilAttachment);
    } else {
        val->pStencilAttachment = NULL;
    }
}

static inline void
vn_decode_VkRenderingInfo_temp(struct vn_cs_decoder *dec, VkRenderingInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_RENDERING_INFO)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkRenderingInfo_pnext_temp(dec);
    vn_decode_VkRenderingInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkRenderingInfo_handle_self(VkRenderingInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->flags */
    vn_replace_VkRect2D_handle(&val->renderArea);
    /* skip val->layerCount */
    /* skip val->viewMask */
    /* skip val->colorAttachmentCount */
    if (val->pColorAttachments) {
       for (uint32_t i = 0; i < val->colorAttachmentCount; i++)
            vn_replace_VkRenderingAttachmentInfo_handle(&((VkRenderingAttachmentInfo *)val->pColorAttachments)[i]);
    }
    if (val->pDepthAttachment)
        vn_replace_VkRenderingAttachmentInfo_handle((VkRenderingAttachmentInfo *)val->pDepthAttachment);
    if (val->pStencilAttachment)
        vn_replace_VkRenderingAttachmentInfo_handle((VkRenderingAttachmentInfo *)val->pStencilAttachment);
}

static inline void
vn_replace_VkRenderingInfo_handle(VkRenderingInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_RENDERING_INFO:
            vn_replace_VkRenderingInfo_handle_self((VkRenderingInfo *)pnext);
            break;
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_RENDER_PASS_BEGIN_INFO:
            vn_replace_VkDeviceGroupRenderPassBeginInfo_handle_self((VkDeviceGroupRenderPassBeginInfo *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

static inline void vn_decode_vkAllocateCommandBuffers_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkAllocateCommandBuffers *args)
{
    vn_decode_VkDevice_lookup(dec, &args->device);
    if (vn_decode_simple_pointer(dec)) {
        args->pAllocateInfo = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pAllocateInfo));
        if (!args->pAllocateInfo) return;
        vn_decode_VkCommandBufferAllocateInfo_temp(dec, (VkCommandBufferAllocateInfo *)args->pAllocateInfo);
    } else {
        args->pAllocateInfo = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, (args->pAllocateInfo ? args->pAllocateInfo->commandBufferCount : 0));
        args->pCommandBuffers = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pCommandBuffers) * iter_count);
        if (!args->pCommandBuffers) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkCommandBuffer_temp(dec, &args->pCommandBuffers[i]);
    } else {
        vn_decode_array_size(dec, (args->pAllocateInfo ? args->pAllocateInfo->commandBufferCount : 0));
        args->pCommandBuffers = NULL;
    }
}

static inline void vn_replace_vkAllocateCommandBuffers_args_handle(struct vn_command_vkAllocateCommandBuffers *args)
{
    vn_replace_VkDevice_handle(&args->device);
    if (args->pAllocateInfo)
        vn_replace_VkCommandBufferAllocateInfo_handle((VkCommandBufferAllocateInfo *)args->pAllocateInfo);
    /* skip args->pCommandBuffers */
}

static inline void vn_encode_vkAllocateCommandBuffers_reply(struct vn_cs_encoder *enc, const struct vn_command_vkAllocateCommandBuffers *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkAllocateCommandBuffers_EXT});

    vn_encode_VkResult(enc, &args->ret);
    /* skip args->device */
    /* skip args->pAllocateInfo */
    if (args->pCommandBuffers) {
        vn_encode_array_size(enc, (args->pAllocateInfo ? args->pAllocateInfo->commandBufferCount : 0));
        for (uint32_t i = 0; i < (args->pAllocateInfo ? args->pAllocateInfo->commandBufferCount : 0); i++)
            vn_encode_VkCommandBuffer(enc, &args->pCommandBuffers[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline void vn_decode_vkFreeCommandBuffers_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkFreeCommandBuffers *args)
{
    vn_decode_VkDevice_lookup(dec, &args->device);
    vn_decode_VkCommandPool_lookup(dec, &args->commandPool);
    vn_decode_uint32_t(dec, &args->commandBufferCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, args->commandBufferCount);
        args->pCommandBuffers = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pCommandBuffers) * iter_count);
        if (!args->pCommandBuffers) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkCommandBuffer_lookup(dec, &((VkCommandBuffer *)args->pCommandBuffers)[i]);
    } else {
        vn_decode_array_size_unchecked(dec);
        args->pCommandBuffers = NULL;
    }
}

static inline void vn_replace_vkFreeCommandBuffers_args_handle(struct vn_command_vkFreeCommandBuffers *args)
{
    vn_replace_VkDevice_handle(&args->device);
    vn_replace_VkCommandPool_handle(&args->commandPool);
    /* skip args->commandBufferCount */
    if (args->pCommandBuffers) {
       for (uint32_t i = 0; i < args->commandBufferCount; i++)
            vn_replace_VkCommandBuffer_handle(&((VkCommandBuffer *)args->pCommandBuffers)[i]);
    }
}

static inline void vn_encode_vkFreeCommandBuffers_reply(struct vn_cs_encoder *enc, const struct vn_command_vkFreeCommandBuffers *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkFreeCommandBuffers_EXT});

    /* skip args->device */
    /* skip args->commandPool */
    /* skip args->commandBufferCount */
    /* skip args->pCommandBuffers */
}

static inline void vn_decode_vkBeginCommandBuffer_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkBeginCommandBuffer *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    if (vn_decode_simple_pointer(dec)) {
        args->pBeginInfo = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pBeginInfo));
        if (!args->pBeginInfo) return;
        vn_decode_VkCommandBufferBeginInfo_temp(dec, (VkCommandBufferBeginInfo *)args->pBeginInfo);
    } else {
        args->pBeginInfo = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
}

static inline void vn_replace_vkBeginCommandBuffer_args_handle(struct vn_command_vkBeginCommandBuffer *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    if (args->pBeginInfo)
        vn_replace_VkCommandBufferBeginInfo_handle((VkCommandBufferBeginInfo *)args->pBeginInfo);
}

static inline void vn_encode_vkBeginCommandBuffer_reply(struct vn_cs_encoder *enc, const struct vn_command_vkBeginCommandBuffer *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkBeginCommandBuffer_EXT});

    vn_encode_VkResult(enc, &args->ret);
    /* skip args->commandBuffer */
    /* skip args->pBeginInfo */
}

static inline void vn_decode_vkEndCommandBuffer_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkEndCommandBuffer *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
}

static inline void vn_replace_vkEndCommandBuffer_args_handle(struct vn_command_vkEndCommandBuffer *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
}

static inline void vn_encode_vkEndCommandBuffer_reply(struct vn_cs_encoder *enc, const struct vn_command_vkEndCommandBuffer *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkEndCommandBuffer_EXT});

    vn_encode_VkResult(enc, &args->ret);
    /* skip args->commandBuffer */
}

static inline void vn_decode_vkResetCommandBuffer_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkResetCommandBuffer *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_VkFlags(dec, &args->flags);
}

static inline void vn_replace_vkResetCommandBuffer_args_handle(struct vn_command_vkResetCommandBuffer *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    /* skip args->flags */
}

static inline void vn_encode_vkResetCommandBuffer_reply(struct vn_cs_encoder *enc, const struct vn_command_vkResetCommandBuffer *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkResetCommandBuffer_EXT});

    vn_encode_VkResult(enc, &args->ret);
    /* skip args->commandBuffer */
    /* skip args->flags */
}

static inline void vn_decode_vkCmdBindPipeline_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdBindPipeline *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_VkPipelineBindPoint(dec, &args->pipelineBindPoint);
    vn_decode_VkPipeline_lookup(dec, &args->pipeline);
}

static inline void vn_replace_vkCmdBindPipeline_args_handle(struct vn_command_vkCmdBindPipeline *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    /* skip args->pipelineBindPoint */
    vn_replace_VkPipeline_handle(&args->pipeline);
}

static inline void vn_encode_vkCmdBindPipeline_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdBindPipeline *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdBindPipeline_EXT});

    /* skip args->commandBuffer */
    /* skip args->pipelineBindPoint */
    /* skip args->pipeline */
}

static inline void vn_decode_vkCmdSetViewport_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdSetViewport *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_uint32_t(dec, &args->firstViewport);
    vn_decode_uint32_t(dec, &args->viewportCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, args->viewportCount);
        args->pViewports = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pViewports) * iter_count);
        if (!args->pViewports) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkViewport_temp(dec, &((VkViewport *)args->pViewports)[i]);
    } else {
        vn_decode_array_size(dec, args->viewportCount);
        args->pViewports = NULL;
    }
}

static inline void vn_replace_vkCmdSetViewport_args_handle(struct vn_command_vkCmdSetViewport *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    /* skip args->firstViewport */
    /* skip args->viewportCount */
    if (args->pViewports) {
       for (uint32_t i = 0; i < args->viewportCount; i++)
            vn_replace_VkViewport_handle(&((VkViewport *)args->pViewports)[i]);
    }
}

static inline void vn_encode_vkCmdSetViewport_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdSetViewport *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdSetViewport_EXT});

    /* skip args->commandBuffer */
    /* skip args->firstViewport */
    /* skip args->viewportCount */
    /* skip args->pViewports */
}

static inline void vn_decode_vkCmdSetScissor_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdSetScissor *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_uint32_t(dec, &args->firstScissor);
    vn_decode_uint32_t(dec, &args->scissorCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, args->scissorCount);
        args->pScissors = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pScissors) * iter_count);
        if (!args->pScissors) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkRect2D_temp(dec, &((VkRect2D *)args->pScissors)[i]);
    } else {
        vn_decode_array_size(dec, args->scissorCount);
        args->pScissors = NULL;
    }
}

static inline void vn_replace_vkCmdSetScissor_args_handle(struct vn_command_vkCmdSetScissor *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    /* skip args->firstScissor */
    /* skip args->scissorCount */
    if (args->pScissors) {
       for (uint32_t i = 0; i < args->scissorCount; i++)
            vn_replace_VkRect2D_handle(&((VkRect2D *)args->pScissors)[i]);
    }
}

static inline void vn_encode_vkCmdSetScissor_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdSetScissor *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdSetScissor_EXT});

    /* skip args->commandBuffer */
    /* skip args->firstScissor */
    /* skip args->scissorCount */
    /* skip args->pScissors */
}

static inline void vn_decode_vkCmdSetLineWidth_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdSetLineWidth *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_float(dec, &args->lineWidth);
}

static inline void vn_replace_vkCmdSetLineWidth_args_handle(struct vn_command_vkCmdSetLineWidth *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    /* skip args->lineWidth */
}

static inline void vn_encode_vkCmdSetLineWidth_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdSetLineWidth *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdSetLineWidth_EXT});

    /* skip args->commandBuffer */
    /* skip args->lineWidth */
}

static inline void vn_decode_vkCmdSetDepthBias_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdSetDepthBias *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_float(dec, &args->depthBiasConstantFactor);
    vn_decode_float(dec, &args->depthBiasClamp);
    vn_decode_float(dec, &args->depthBiasSlopeFactor);
}

static inline void vn_replace_vkCmdSetDepthBias_args_handle(struct vn_command_vkCmdSetDepthBias *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    /* skip args->depthBiasConstantFactor */
    /* skip args->depthBiasClamp */
    /* skip args->depthBiasSlopeFactor */
}

static inline void vn_encode_vkCmdSetDepthBias_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdSetDepthBias *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdSetDepthBias_EXT});

    /* skip args->commandBuffer */
    /* skip args->depthBiasConstantFactor */
    /* skip args->depthBiasClamp */
    /* skip args->depthBiasSlopeFactor */
}

static inline void vn_decode_vkCmdSetBlendConstants_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdSetBlendConstants *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    {
        const size_t array_size = vn_decode_array_size(dec, 4);
        vn_decode_float_array(dec, (float *)args->blendConstants, array_size);
    }
}

static inline void vn_replace_vkCmdSetBlendConstants_args_handle(struct vn_command_vkCmdSetBlendConstants *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    /* skip args->blendConstants */
}

static inline void vn_encode_vkCmdSetBlendConstants_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdSetBlendConstants *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdSetBlendConstants_EXT});

    /* skip args->commandBuffer */
    /* skip args->blendConstants */
}

static inline void vn_decode_vkCmdSetDepthBounds_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdSetDepthBounds *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_float(dec, &args->minDepthBounds);
    vn_decode_float(dec, &args->maxDepthBounds);
}

static inline void vn_replace_vkCmdSetDepthBounds_args_handle(struct vn_command_vkCmdSetDepthBounds *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    /* skip args->minDepthBounds */
    /* skip args->maxDepthBounds */
}

static inline void vn_encode_vkCmdSetDepthBounds_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdSetDepthBounds *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdSetDepthBounds_EXT});

    /* skip args->commandBuffer */
    /* skip args->minDepthBounds */
    /* skip args->maxDepthBounds */
}

static inline void vn_decode_vkCmdSetStencilCompareMask_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdSetStencilCompareMask *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_VkFlags(dec, &args->faceMask);
    vn_decode_uint32_t(dec, &args->compareMask);
}

static inline void vn_replace_vkCmdSetStencilCompareMask_args_handle(struct vn_command_vkCmdSetStencilCompareMask *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    /* skip args->faceMask */
    /* skip args->compareMask */
}

static inline void vn_encode_vkCmdSetStencilCompareMask_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdSetStencilCompareMask *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdSetStencilCompareMask_EXT});

    /* skip args->commandBuffer */
    /* skip args->faceMask */
    /* skip args->compareMask */
}

static inline void vn_decode_vkCmdSetStencilWriteMask_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdSetStencilWriteMask *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_VkFlags(dec, &args->faceMask);
    vn_decode_uint32_t(dec, &args->writeMask);
}

static inline void vn_replace_vkCmdSetStencilWriteMask_args_handle(struct vn_command_vkCmdSetStencilWriteMask *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    /* skip args->faceMask */
    /* skip args->writeMask */
}

static inline void vn_encode_vkCmdSetStencilWriteMask_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdSetStencilWriteMask *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdSetStencilWriteMask_EXT});

    /* skip args->commandBuffer */
    /* skip args->faceMask */
    /* skip args->writeMask */
}

static inline void vn_decode_vkCmdSetStencilReference_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdSetStencilReference *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_VkFlags(dec, &args->faceMask);
    vn_decode_uint32_t(dec, &args->reference);
}

static inline void vn_replace_vkCmdSetStencilReference_args_handle(struct vn_command_vkCmdSetStencilReference *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    /* skip args->faceMask */
    /* skip args->reference */
}

static inline void vn_encode_vkCmdSetStencilReference_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdSetStencilReference *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdSetStencilReference_EXT});

    /* skip args->commandBuffer */
    /* skip args->faceMask */
    /* skip args->reference */
}

static inline void vn_decode_vkCmdBindDescriptorSets_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdBindDescriptorSets *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_VkPipelineBindPoint(dec, &args->pipelineBindPoint);
    vn_decode_VkPipelineLayout_lookup(dec, &args->layout);
    vn_decode_uint32_t(dec, &args->firstSet);
    vn_decode_uint32_t(dec, &args->descriptorSetCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, args->descriptorSetCount);
        args->pDescriptorSets = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pDescriptorSets) * iter_count);
        if (!args->pDescriptorSets) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkDescriptorSet_lookup(dec, &((VkDescriptorSet *)args->pDescriptorSets)[i]);
    } else {
        vn_decode_array_size(dec, args->descriptorSetCount);
        args->pDescriptorSets = NULL;
    }
    vn_decode_uint32_t(dec, &args->dynamicOffsetCount);
    if (vn_peek_array_size(dec)) {
        const size_t array_size = vn_decode_array_size(dec, args->dynamicOffsetCount);
        args->pDynamicOffsets = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pDynamicOffsets) * array_size);
        if (!args->pDynamicOffsets) return;
        vn_decode_uint32_t_array(dec, (uint32_t *)args->pDynamicOffsets, array_size);
    } else {
        vn_decode_array_size(dec, args->dynamicOffsetCount);
        args->pDynamicOffsets = NULL;
    }
}

static inline void vn_replace_vkCmdBindDescriptorSets_args_handle(struct vn_command_vkCmdBindDescriptorSets *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    /* skip args->pipelineBindPoint */
    vn_replace_VkPipelineLayout_handle(&args->layout);
    /* skip args->firstSet */
    /* skip args->descriptorSetCount */
    if (args->pDescriptorSets) {
       for (uint32_t i = 0; i < args->descriptorSetCount; i++)
            vn_replace_VkDescriptorSet_handle(&((VkDescriptorSet *)args->pDescriptorSets)[i]);
    }
    /* skip args->dynamicOffsetCount */
    /* skip args->pDynamicOffsets */
}

static inline void vn_encode_vkCmdBindDescriptorSets_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdBindDescriptorSets *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdBindDescriptorSets_EXT});

    /* skip args->commandBuffer */
    /* skip args->pipelineBindPoint */
    /* skip args->layout */
    /* skip args->firstSet */
    /* skip args->descriptorSetCount */
    /* skip args->pDescriptorSets */
    /* skip args->dynamicOffsetCount */
    /* skip args->pDynamicOffsets */
}

static inline void vn_decode_vkCmdBindIndexBuffer_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdBindIndexBuffer *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_VkBuffer_lookup(dec, &args->buffer);
    vn_decode_VkDeviceSize(dec, &args->offset);
    vn_decode_VkIndexType(dec, &args->indexType);
}

static inline void vn_replace_vkCmdBindIndexBuffer_args_handle(struct vn_command_vkCmdBindIndexBuffer *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    vn_replace_VkBuffer_handle(&args->buffer);
    /* skip args->offset */
    /* skip args->indexType */
}

static inline void vn_encode_vkCmdBindIndexBuffer_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdBindIndexBuffer *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdBindIndexBuffer_EXT});

    /* skip args->commandBuffer */
    /* skip args->buffer */
    /* skip args->offset */
    /* skip args->indexType */
}

static inline void vn_decode_vkCmdBindVertexBuffers_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdBindVertexBuffers *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_uint32_t(dec, &args->firstBinding);
    vn_decode_uint32_t(dec, &args->bindingCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, args->bindingCount);
        args->pBuffers = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pBuffers) * iter_count);
        if (!args->pBuffers) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkBuffer_lookup(dec, &((VkBuffer *)args->pBuffers)[i]);
    } else {
        vn_decode_array_size(dec, args->bindingCount);
        args->pBuffers = NULL;
    }
    if (vn_peek_array_size(dec)) {
        const size_t array_size = vn_decode_array_size(dec, args->bindingCount);
        args->pOffsets = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pOffsets) * array_size);
        if (!args->pOffsets) return;
        vn_decode_VkDeviceSize_array(dec, (VkDeviceSize *)args->pOffsets, array_size);
    } else {
        vn_decode_array_size(dec, args->bindingCount);
        args->pOffsets = NULL;
    }
}

static inline void vn_replace_vkCmdBindVertexBuffers_args_handle(struct vn_command_vkCmdBindVertexBuffers *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    /* skip args->firstBinding */
    /* skip args->bindingCount */
    if (args->pBuffers) {
       for (uint32_t i = 0; i < args->bindingCount; i++)
            vn_replace_VkBuffer_handle(&((VkBuffer *)args->pBuffers)[i]);
    }
    /* skip args->pOffsets */
}

static inline void vn_encode_vkCmdBindVertexBuffers_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdBindVertexBuffers *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdBindVertexBuffers_EXT});

    /* skip args->commandBuffer */
    /* skip args->firstBinding */
    /* skip args->bindingCount */
    /* skip args->pBuffers */
    /* skip args->pOffsets */
}

static inline void vn_decode_vkCmdDraw_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdDraw *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_uint32_t(dec, &args->vertexCount);
    vn_decode_uint32_t(dec, &args->instanceCount);
    vn_decode_uint32_t(dec, &args->firstVertex);
    vn_decode_uint32_t(dec, &args->firstInstance);
}

static inline void vn_replace_vkCmdDraw_args_handle(struct vn_command_vkCmdDraw *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    /* skip args->vertexCount */
    /* skip args->instanceCount */
    /* skip args->firstVertex */
    /* skip args->firstInstance */
}

static inline void vn_encode_vkCmdDraw_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdDraw *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdDraw_EXT});

    /* skip args->commandBuffer */
    /* skip args->vertexCount */
    /* skip args->instanceCount */
    /* skip args->firstVertex */
    /* skip args->firstInstance */
}

static inline void vn_decode_vkCmdDrawIndexed_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdDrawIndexed *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_uint32_t(dec, &args->indexCount);
    vn_decode_uint32_t(dec, &args->instanceCount);
    vn_decode_uint32_t(dec, &args->firstIndex);
    vn_decode_int32_t(dec, &args->vertexOffset);
    vn_decode_uint32_t(dec, &args->firstInstance);
}

static inline void vn_replace_vkCmdDrawIndexed_args_handle(struct vn_command_vkCmdDrawIndexed *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    /* skip args->indexCount */
    /* skip args->instanceCount */
    /* skip args->firstIndex */
    /* skip args->vertexOffset */
    /* skip args->firstInstance */
}

static inline void vn_encode_vkCmdDrawIndexed_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdDrawIndexed *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdDrawIndexed_EXT});

    /* skip args->commandBuffer */
    /* skip args->indexCount */
    /* skip args->instanceCount */
    /* skip args->firstIndex */
    /* skip args->vertexOffset */
    /* skip args->firstInstance */
}

static inline void vn_decode_vkCmdDrawMultiEXT_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdDrawMultiEXT *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_uint32_t(dec, &args->drawCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, args->drawCount);
        args->pVertexInfo = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pVertexInfo) * iter_count);
        if (!args->pVertexInfo) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkMultiDrawInfoEXT_temp(dec, &((VkMultiDrawInfoEXT *)args->pVertexInfo)[i]);
    } else {
        vn_decode_array_size_unchecked(dec);
        args->pVertexInfo = NULL;
    }
    vn_decode_uint32_t(dec, &args->instanceCount);
    vn_decode_uint32_t(dec, &args->firstInstance);
    vn_decode_uint32_t(dec, &args->stride);
}

static inline void vn_replace_vkCmdDrawMultiEXT_args_handle(struct vn_command_vkCmdDrawMultiEXT *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    /* skip args->drawCount */
    if (args->pVertexInfo) {
       for (uint32_t i = 0; i < args->drawCount; i++)
            vn_replace_VkMultiDrawInfoEXT_handle(&((VkMultiDrawInfoEXT *)args->pVertexInfo)[i]);
    }
    /* skip args->instanceCount */
    /* skip args->firstInstance */
    /* skip args->stride */
}

static inline void vn_encode_vkCmdDrawMultiEXT_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdDrawMultiEXT *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdDrawMultiEXT_EXT});

    /* skip args->commandBuffer */
    /* skip args->drawCount */
    /* skip args->pVertexInfo */
    /* skip args->instanceCount */
    /* skip args->firstInstance */
    /* skip args->stride */
}

static inline void vn_decode_vkCmdDrawMultiIndexedEXT_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdDrawMultiIndexedEXT *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_uint32_t(dec, &args->drawCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, args->drawCount);
        args->pIndexInfo = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pIndexInfo) * iter_count);
        if (!args->pIndexInfo) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkMultiDrawIndexedInfoEXT_temp(dec, &((VkMultiDrawIndexedInfoEXT *)args->pIndexInfo)[i]);
    } else {
        vn_decode_array_size_unchecked(dec);
        args->pIndexInfo = NULL;
    }
    vn_decode_uint32_t(dec, &args->instanceCount);
    vn_decode_uint32_t(dec, &args->firstInstance);
    vn_decode_uint32_t(dec, &args->stride);
    if (vn_decode_simple_pointer(dec)) {
        args->pVertexOffset = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pVertexOffset));
        if (!args->pVertexOffset) return;
        vn_decode_int32_t(dec, (int32_t *)args->pVertexOffset);
    } else {
        args->pVertexOffset = NULL;
    }
}

static inline void vn_replace_vkCmdDrawMultiIndexedEXT_args_handle(struct vn_command_vkCmdDrawMultiIndexedEXT *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    /* skip args->drawCount */
    if (args->pIndexInfo) {
       for (uint32_t i = 0; i < args->drawCount; i++)
            vn_replace_VkMultiDrawIndexedInfoEXT_handle(&((VkMultiDrawIndexedInfoEXT *)args->pIndexInfo)[i]);
    }
    /* skip args->instanceCount */
    /* skip args->firstInstance */
    /* skip args->stride */
    /* skip args->pVertexOffset */
}

static inline void vn_encode_vkCmdDrawMultiIndexedEXT_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdDrawMultiIndexedEXT *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdDrawMultiIndexedEXT_EXT});

    /* skip args->commandBuffer */
    /* skip args->drawCount */
    /* skip args->pIndexInfo */
    /* skip args->instanceCount */
    /* skip args->firstInstance */
    /* skip args->stride */
    /* skip args->pVertexOffset */
}

static inline void vn_decode_vkCmdDrawIndirect_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdDrawIndirect *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_VkBuffer_lookup(dec, &args->buffer);
    vn_decode_VkDeviceSize(dec, &args->offset);
    vn_decode_uint32_t(dec, &args->drawCount);
    vn_decode_uint32_t(dec, &args->stride);
}

static inline void vn_replace_vkCmdDrawIndirect_args_handle(struct vn_command_vkCmdDrawIndirect *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    vn_replace_VkBuffer_handle(&args->buffer);
    /* skip args->offset */
    /* skip args->drawCount */
    /* skip args->stride */
}

static inline void vn_encode_vkCmdDrawIndirect_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdDrawIndirect *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdDrawIndirect_EXT});

    /* skip args->commandBuffer */
    /* skip args->buffer */
    /* skip args->offset */
    /* skip args->drawCount */
    /* skip args->stride */
}

static inline void vn_decode_vkCmdDrawIndexedIndirect_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdDrawIndexedIndirect *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_VkBuffer_lookup(dec, &args->buffer);
    vn_decode_VkDeviceSize(dec, &args->offset);
    vn_decode_uint32_t(dec, &args->drawCount);
    vn_decode_uint32_t(dec, &args->stride);
}

static inline void vn_replace_vkCmdDrawIndexedIndirect_args_handle(struct vn_command_vkCmdDrawIndexedIndirect *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    vn_replace_VkBuffer_handle(&args->buffer);
    /* skip args->offset */
    /* skip args->drawCount */
    /* skip args->stride */
}

static inline void vn_encode_vkCmdDrawIndexedIndirect_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdDrawIndexedIndirect *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdDrawIndexedIndirect_EXT});

    /* skip args->commandBuffer */
    /* skip args->buffer */
    /* skip args->offset */
    /* skip args->drawCount */
    /* skip args->stride */
}

static inline void vn_decode_vkCmdDispatch_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdDispatch *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_uint32_t(dec, &args->groupCountX);
    vn_decode_uint32_t(dec, &args->groupCountY);
    vn_decode_uint32_t(dec, &args->groupCountZ);
}

static inline void vn_replace_vkCmdDispatch_args_handle(struct vn_command_vkCmdDispatch *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    /* skip args->groupCountX */
    /* skip args->groupCountY */
    /* skip args->groupCountZ */
}

static inline void vn_encode_vkCmdDispatch_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdDispatch *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdDispatch_EXT});

    /* skip args->commandBuffer */
    /* skip args->groupCountX */
    /* skip args->groupCountY */
    /* skip args->groupCountZ */
}

static inline void vn_decode_vkCmdDispatchIndirect_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdDispatchIndirect *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_VkBuffer_lookup(dec, &args->buffer);
    vn_decode_VkDeviceSize(dec, &args->offset);
}

static inline void vn_replace_vkCmdDispatchIndirect_args_handle(struct vn_command_vkCmdDispatchIndirect *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    vn_replace_VkBuffer_handle(&args->buffer);
    /* skip args->offset */
}

static inline void vn_encode_vkCmdDispatchIndirect_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdDispatchIndirect *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdDispatchIndirect_EXT});

    /* skip args->commandBuffer */
    /* skip args->buffer */
    /* skip args->offset */
}

static inline void vn_decode_vkCmdCopyBuffer_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdCopyBuffer *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_VkBuffer_lookup(dec, &args->srcBuffer);
    vn_decode_VkBuffer_lookup(dec, &args->dstBuffer);
    vn_decode_uint32_t(dec, &args->regionCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, args->regionCount);
        args->pRegions = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pRegions) * iter_count);
        if (!args->pRegions) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkBufferCopy_temp(dec, &((VkBufferCopy *)args->pRegions)[i]);
    } else {
        vn_decode_array_size(dec, args->regionCount);
        args->pRegions = NULL;
    }
}

static inline void vn_replace_vkCmdCopyBuffer_args_handle(struct vn_command_vkCmdCopyBuffer *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    vn_replace_VkBuffer_handle(&args->srcBuffer);
    vn_replace_VkBuffer_handle(&args->dstBuffer);
    /* skip args->regionCount */
    if (args->pRegions) {
       for (uint32_t i = 0; i < args->regionCount; i++)
            vn_replace_VkBufferCopy_handle(&((VkBufferCopy *)args->pRegions)[i]);
    }
}

static inline void vn_encode_vkCmdCopyBuffer_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdCopyBuffer *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdCopyBuffer_EXT});

    /* skip args->commandBuffer */
    /* skip args->srcBuffer */
    /* skip args->dstBuffer */
    /* skip args->regionCount */
    /* skip args->pRegions */
}

static inline void vn_decode_vkCmdCopyImage_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdCopyImage *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_VkImage_lookup(dec, &args->srcImage);
    vn_decode_VkImageLayout(dec, &args->srcImageLayout);
    vn_decode_VkImage_lookup(dec, &args->dstImage);
    vn_decode_VkImageLayout(dec, &args->dstImageLayout);
    vn_decode_uint32_t(dec, &args->regionCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, args->regionCount);
        args->pRegions = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pRegions) * iter_count);
        if (!args->pRegions) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkImageCopy_temp(dec, &((VkImageCopy *)args->pRegions)[i]);
    } else {
        vn_decode_array_size(dec, args->regionCount);
        args->pRegions = NULL;
    }
}

static inline void vn_replace_vkCmdCopyImage_args_handle(struct vn_command_vkCmdCopyImage *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    vn_replace_VkImage_handle(&args->srcImage);
    /* skip args->srcImageLayout */
    vn_replace_VkImage_handle(&args->dstImage);
    /* skip args->dstImageLayout */
    /* skip args->regionCount */
    if (args->pRegions) {
       for (uint32_t i = 0; i < args->regionCount; i++)
            vn_replace_VkImageCopy_handle(&((VkImageCopy *)args->pRegions)[i]);
    }
}

static inline void vn_encode_vkCmdCopyImage_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdCopyImage *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdCopyImage_EXT});

    /* skip args->commandBuffer */
    /* skip args->srcImage */
    /* skip args->srcImageLayout */
    /* skip args->dstImage */
    /* skip args->dstImageLayout */
    /* skip args->regionCount */
    /* skip args->pRegions */
}

static inline void vn_decode_vkCmdBlitImage_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdBlitImage *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_VkImage_lookup(dec, &args->srcImage);
    vn_decode_VkImageLayout(dec, &args->srcImageLayout);
    vn_decode_VkImage_lookup(dec, &args->dstImage);
    vn_decode_VkImageLayout(dec, &args->dstImageLayout);
    vn_decode_uint32_t(dec, &args->regionCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, args->regionCount);
        args->pRegions = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pRegions) * iter_count);
        if (!args->pRegions) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkImageBlit_temp(dec, &((VkImageBlit *)args->pRegions)[i]);
    } else {
        vn_decode_array_size(dec, args->regionCount);
        args->pRegions = NULL;
    }
    vn_decode_VkFilter(dec, &args->filter);
}

static inline void vn_replace_vkCmdBlitImage_args_handle(struct vn_command_vkCmdBlitImage *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    vn_replace_VkImage_handle(&args->srcImage);
    /* skip args->srcImageLayout */
    vn_replace_VkImage_handle(&args->dstImage);
    /* skip args->dstImageLayout */
    /* skip args->regionCount */
    if (args->pRegions) {
       for (uint32_t i = 0; i < args->regionCount; i++)
            vn_replace_VkImageBlit_handle(&((VkImageBlit *)args->pRegions)[i]);
    }
    /* skip args->filter */
}

static inline void vn_encode_vkCmdBlitImage_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdBlitImage *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdBlitImage_EXT});

    /* skip args->commandBuffer */
    /* skip args->srcImage */
    /* skip args->srcImageLayout */
    /* skip args->dstImage */
    /* skip args->dstImageLayout */
    /* skip args->regionCount */
    /* skip args->pRegions */
    /* skip args->filter */
}

static inline void vn_decode_vkCmdCopyBufferToImage_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdCopyBufferToImage *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_VkBuffer_lookup(dec, &args->srcBuffer);
    vn_decode_VkImage_lookup(dec, &args->dstImage);
    vn_decode_VkImageLayout(dec, &args->dstImageLayout);
    vn_decode_uint32_t(dec, &args->regionCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, args->regionCount);
        args->pRegions = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pRegions) * iter_count);
        if (!args->pRegions) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkBufferImageCopy_temp(dec, &((VkBufferImageCopy *)args->pRegions)[i]);
    } else {
        vn_decode_array_size(dec, args->regionCount);
        args->pRegions = NULL;
    }
}

static inline void vn_replace_vkCmdCopyBufferToImage_args_handle(struct vn_command_vkCmdCopyBufferToImage *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    vn_replace_VkBuffer_handle(&args->srcBuffer);
    vn_replace_VkImage_handle(&args->dstImage);
    /* skip args->dstImageLayout */
    /* skip args->regionCount */
    if (args->pRegions) {
       for (uint32_t i = 0; i < args->regionCount; i++)
            vn_replace_VkBufferImageCopy_handle(&((VkBufferImageCopy *)args->pRegions)[i]);
    }
}

static inline void vn_encode_vkCmdCopyBufferToImage_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdCopyBufferToImage *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdCopyBufferToImage_EXT});

    /* skip args->commandBuffer */
    /* skip args->srcBuffer */
    /* skip args->dstImage */
    /* skip args->dstImageLayout */
    /* skip args->regionCount */
    /* skip args->pRegions */
}

static inline void vn_decode_vkCmdCopyImageToBuffer_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdCopyImageToBuffer *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_VkImage_lookup(dec, &args->srcImage);
    vn_decode_VkImageLayout(dec, &args->srcImageLayout);
    vn_decode_VkBuffer_lookup(dec, &args->dstBuffer);
    vn_decode_uint32_t(dec, &args->regionCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, args->regionCount);
        args->pRegions = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pRegions) * iter_count);
        if (!args->pRegions) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkBufferImageCopy_temp(dec, &((VkBufferImageCopy *)args->pRegions)[i]);
    } else {
        vn_decode_array_size(dec, args->regionCount);
        args->pRegions = NULL;
    }
}

static inline void vn_replace_vkCmdCopyImageToBuffer_args_handle(struct vn_command_vkCmdCopyImageToBuffer *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    vn_replace_VkImage_handle(&args->srcImage);
    /* skip args->srcImageLayout */
    vn_replace_VkBuffer_handle(&args->dstBuffer);
    /* skip args->regionCount */
    if (args->pRegions) {
       for (uint32_t i = 0; i < args->regionCount; i++)
            vn_replace_VkBufferImageCopy_handle(&((VkBufferImageCopy *)args->pRegions)[i]);
    }
}

static inline void vn_encode_vkCmdCopyImageToBuffer_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdCopyImageToBuffer *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdCopyImageToBuffer_EXT});

    /* skip args->commandBuffer */
    /* skip args->srcImage */
    /* skip args->srcImageLayout */
    /* skip args->dstBuffer */
    /* skip args->regionCount */
    /* skip args->pRegions */
}

static inline void vn_decode_vkCmdUpdateBuffer_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdUpdateBuffer *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_VkBuffer_lookup(dec, &args->dstBuffer);
    vn_decode_VkDeviceSize(dec, &args->dstOffset);
    vn_decode_VkDeviceSize(dec, &args->dataSize);
    if (vn_peek_array_size(dec)) {
        const size_t array_size = vn_decode_array_size(dec, args->dataSize);
        args->pData = vn_cs_decoder_alloc_temp(dec, array_size);
        if (!args->pData) return;
        vn_decode_blob_array(dec, (void *)args->pData, array_size);
    } else {
        vn_decode_array_size(dec, args->dataSize);
        args->pData = NULL;
    }
}

static inline void vn_replace_vkCmdUpdateBuffer_args_handle(struct vn_command_vkCmdUpdateBuffer *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    vn_replace_VkBuffer_handle(&args->dstBuffer);
    /* skip args->dstOffset */
    /* skip args->dataSize */
    /* skip args->pData */
}

static inline void vn_encode_vkCmdUpdateBuffer_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdUpdateBuffer *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdUpdateBuffer_EXT});

    /* skip args->commandBuffer */
    /* skip args->dstBuffer */
    /* skip args->dstOffset */
    /* skip args->dataSize */
    /* skip args->pData */
}

static inline void vn_decode_vkCmdFillBuffer_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdFillBuffer *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_VkBuffer_lookup(dec, &args->dstBuffer);
    vn_decode_VkDeviceSize(dec, &args->dstOffset);
    vn_decode_VkDeviceSize(dec, &args->size);
    vn_decode_uint32_t(dec, &args->data);
}

static inline void vn_replace_vkCmdFillBuffer_args_handle(struct vn_command_vkCmdFillBuffer *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    vn_replace_VkBuffer_handle(&args->dstBuffer);
    /* skip args->dstOffset */
    /* skip args->size */
    /* skip args->data */
}

static inline void vn_encode_vkCmdFillBuffer_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdFillBuffer *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdFillBuffer_EXT});

    /* skip args->commandBuffer */
    /* skip args->dstBuffer */
    /* skip args->dstOffset */
    /* skip args->size */
    /* skip args->data */
}

static inline void vn_decode_vkCmdClearColorImage_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdClearColorImage *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_VkImage_lookup(dec, &args->image);
    vn_decode_VkImageLayout(dec, &args->imageLayout);
    if (vn_decode_simple_pointer(dec)) {
        args->pColor = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pColor));
        if (!args->pColor) return;
        vn_decode_VkClearColorValue_temp(dec, (VkClearColorValue *)args->pColor);
    } else {
        args->pColor = NULL;
    }
    vn_decode_uint32_t(dec, &args->rangeCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, args->rangeCount);
        args->pRanges = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pRanges) * iter_count);
        if (!args->pRanges) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkImageSubresourceRange_temp(dec, &((VkImageSubresourceRange *)args->pRanges)[i]);
    } else {
        vn_decode_array_size(dec, args->rangeCount);
        args->pRanges = NULL;
    }
}

static inline void vn_replace_vkCmdClearColorImage_args_handle(struct vn_command_vkCmdClearColorImage *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    vn_replace_VkImage_handle(&args->image);
    /* skip args->imageLayout */
    /* skip args->pColor */
    /* skip args->rangeCount */
    if (args->pRanges) {
       for (uint32_t i = 0; i < args->rangeCount; i++)
            vn_replace_VkImageSubresourceRange_handle(&((VkImageSubresourceRange *)args->pRanges)[i]);
    }
}

static inline void vn_encode_vkCmdClearColorImage_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdClearColorImage *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdClearColorImage_EXT});

    /* skip args->commandBuffer */
    /* skip args->image */
    /* skip args->imageLayout */
    /* skip args->pColor */
    /* skip args->rangeCount */
    /* skip args->pRanges */
}

static inline void vn_decode_vkCmdClearDepthStencilImage_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdClearDepthStencilImage *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_VkImage_lookup(dec, &args->image);
    vn_decode_VkImageLayout(dec, &args->imageLayout);
    if (vn_decode_simple_pointer(dec)) {
        args->pDepthStencil = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pDepthStencil));
        if (!args->pDepthStencil) return;
        vn_decode_VkClearDepthStencilValue_temp(dec, (VkClearDepthStencilValue *)args->pDepthStencil);
    } else {
        args->pDepthStencil = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
    vn_decode_uint32_t(dec, &args->rangeCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, args->rangeCount);
        args->pRanges = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pRanges) * iter_count);
        if (!args->pRanges) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkImageSubresourceRange_temp(dec, &((VkImageSubresourceRange *)args->pRanges)[i]);
    } else {
        vn_decode_array_size(dec, args->rangeCount);
        args->pRanges = NULL;
    }
}

static inline void vn_replace_vkCmdClearDepthStencilImage_args_handle(struct vn_command_vkCmdClearDepthStencilImage *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    vn_replace_VkImage_handle(&args->image);
    /* skip args->imageLayout */
    if (args->pDepthStencil)
        vn_replace_VkClearDepthStencilValue_handle((VkClearDepthStencilValue *)args->pDepthStencil);
    /* skip args->rangeCount */
    if (args->pRanges) {
       for (uint32_t i = 0; i < args->rangeCount; i++)
            vn_replace_VkImageSubresourceRange_handle(&((VkImageSubresourceRange *)args->pRanges)[i]);
    }
}

static inline void vn_encode_vkCmdClearDepthStencilImage_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdClearDepthStencilImage *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdClearDepthStencilImage_EXT});

    /* skip args->commandBuffer */
    /* skip args->image */
    /* skip args->imageLayout */
    /* skip args->pDepthStencil */
    /* skip args->rangeCount */
    /* skip args->pRanges */
}

static inline void vn_decode_vkCmdClearAttachments_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdClearAttachments *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_uint32_t(dec, &args->attachmentCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, args->attachmentCount);
        args->pAttachments = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pAttachments) * iter_count);
        if (!args->pAttachments) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkClearAttachment_temp(dec, &((VkClearAttachment *)args->pAttachments)[i]);
    } else {
        vn_decode_array_size(dec, args->attachmentCount);
        args->pAttachments = NULL;
    }
    vn_decode_uint32_t(dec, &args->rectCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, args->rectCount);
        args->pRects = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pRects) * iter_count);
        if (!args->pRects) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkClearRect_temp(dec, &((VkClearRect *)args->pRects)[i]);
    } else {
        vn_decode_array_size(dec, args->rectCount);
        args->pRects = NULL;
    }
}

static inline void vn_replace_vkCmdClearAttachments_args_handle(struct vn_command_vkCmdClearAttachments *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    /* skip args->attachmentCount */
    if (args->pAttachments) {
       for (uint32_t i = 0; i < args->attachmentCount; i++)
            vn_replace_VkClearAttachment_handle(&((VkClearAttachment *)args->pAttachments)[i]);
    }
    /* skip args->rectCount */
    if (args->pRects) {
       for (uint32_t i = 0; i < args->rectCount; i++)
            vn_replace_VkClearRect_handle(&((VkClearRect *)args->pRects)[i]);
    }
}

static inline void vn_encode_vkCmdClearAttachments_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdClearAttachments *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdClearAttachments_EXT});

    /* skip args->commandBuffer */
    /* skip args->attachmentCount */
    /* skip args->pAttachments */
    /* skip args->rectCount */
    /* skip args->pRects */
}

static inline void vn_decode_vkCmdResolveImage_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdResolveImage *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_VkImage_lookup(dec, &args->srcImage);
    vn_decode_VkImageLayout(dec, &args->srcImageLayout);
    vn_decode_VkImage_lookup(dec, &args->dstImage);
    vn_decode_VkImageLayout(dec, &args->dstImageLayout);
    vn_decode_uint32_t(dec, &args->regionCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, args->regionCount);
        args->pRegions = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pRegions) * iter_count);
        if (!args->pRegions) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkImageResolve_temp(dec, &((VkImageResolve *)args->pRegions)[i]);
    } else {
        vn_decode_array_size(dec, args->regionCount);
        args->pRegions = NULL;
    }
}

static inline void vn_replace_vkCmdResolveImage_args_handle(struct vn_command_vkCmdResolveImage *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    vn_replace_VkImage_handle(&args->srcImage);
    /* skip args->srcImageLayout */
    vn_replace_VkImage_handle(&args->dstImage);
    /* skip args->dstImageLayout */
    /* skip args->regionCount */
    if (args->pRegions) {
       for (uint32_t i = 0; i < args->regionCount; i++)
            vn_replace_VkImageResolve_handle(&((VkImageResolve *)args->pRegions)[i]);
    }
}

static inline void vn_encode_vkCmdResolveImage_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdResolveImage *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdResolveImage_EXT});

    /* skip args->commandBuffer */
    /* skip args->srcImage */
    /* skip args->srcImageLayout */
    /* skip args->dstImage */
    /* skip args->dstImageLayout */
    /* skip args->regionCount */
    /* skip args->pRegions */
}

static inline void vn_decode_vkCmdSetEvent_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdSetEvent *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_VkEvent_lookup(dec, &args->event);
    vn_decode_VkFlags(dec, &args->stageMask);
}

static inline void vn_replace_vkCmdSetEvent_args_handle(struct vn_command_vkCmdSetEvent *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    vn_replace_VkEvent_handle(&args->event);
    /* skip args->stageMask */
}

static inline void vn_encode_vkCmdSetEvent_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdSetEvent *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdSetEvent_EXT});

    /* skip args->commandBuffer */
    /* skip args->event */
    /* skip args->stageMask */
}

static inline void vn_decode_vkCmdResetEvent_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdResetEvent *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_VkEvent_lookup(dec, &args->event);
    vn_decode_VkFlags(dec, &args->stageMask);
}

static inline void vn_replace_vkCmdResetEvent_args_handle(struct vn_command_vkCmdResetEvent *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    vn_replace_VkEvent_handle(&args->event);
    /* skip args->stageMask */
}

static inline void vn_encode_vkCmdResetEvent_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdResetEvent *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdResetEvent_EXT});

    /* skip args->commandBuffer */
    /* skip args->event */
    /* skip args->stageMask */
}

static inline void vn_decode_vkCmdWaitEvents_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdWaitEvents *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_uint32_t(dec, &args->eventCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, args->eventCount);
        args->pEvents = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pEvents) * iter_count);
        if (!args->pEvents) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkEvent_lookup(dec, &((VkEvent *)args->pEvents)[i]);
    } else {
        vn_decode_array_size(dec, args->eventCount);
        args->pEvents = NULL;
    }
    vn_decode_VkFlags(dec, &args->srcStageMask);
    vn_decode_VkFlags(dec, &args->dstStageMask);
    vn_decode_uint32_t(dec, &args->memoryBarrierCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, args->memoryBarrierCount);
        args->pMemoryBarriers = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pMemoryBarriers) * iter_count);
        if (!args->pMemoryBarriers) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkMemoryBarrier_temp(dec, &((VkMemoryBarrier *)args->pMemoryBarriers)[i]);
    } else {
        vn_decode_array_size(dec, args->memoryBarrierCount);
        args->pMemoryBarriers = NULL;
    }
    vn_decode_uint32_t(dec, &args->bufferMemoryBarrierCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, args->bufferMemoryBarrierCount);
        args->pBufferMemoryBarriers = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pBufferMemoryBarriers) * iter_count);
        if (!args->pBufferMemoryBarriers) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkBufferMemoryBarrier_temp(dec, &((VkBufferMemoryBarrier *)args->pBufferMemoryBarriers)[i]);
    } else {
        vn_decode_array_size(dec, args->bufferMemoryBarrierCount);
        args->pBufferMemoryBarriers = NULL;
    }
    vn_decode_uint32_t(dec, &args->imageMemoryBarrierCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, args->imageMemoryBarrierCount);
        args->pImageMemoryBarriers = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pImageMemoryBarriers) * iter_count);
        if (!args->pImageMemoryBarriers) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkImageMemoryBarrier_temp(dec, &((VkImageMemoryBarrier *)args->pImageMemoryBarriers)[i]);
    } else {
        vn_decode_array_size(dec, args->imageMemoryBarrierCount);
        args->pImageMemoryBarriers = NULL;
    }
}

static inline void vn_replace_vkCmdWaitEvents_args_handle(struct vn_command_vkCmdWaitEvents *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    /* skip args->eventCount */
    if (args->pEvents) {
       for (uint32_t i = 0; i < args->eventCount; i++)
            vn_replace_VkEvent_handle(&((VkEvent *)args->pEvents)[i]);
    }
    /* skip args->srcStageMask */
    /* skip args->dstStageMask */
    /* skip args->memoryBarrierCount */
    if (args->pMemoryBarriers) {
       for (uint32_t i = 0; i < args->memoryBarrierCount; i++)
            vn_replace_VkMemoryBarrier_handle(&((VkMemoryBarrier *)args->pMemoryBarriers)[i]);
    }
    /* skip args->bufferMemoryBarrierCount */
    if (args->pBufferMemoryBarriers) {
       for (uint32_t i = 0; i < args->bufferMemoryBarrierCount; i++)
            vn_replace_VkBufferMemoryBarrier_handle(&((VkBufferMemoryBarrier *)args->pBufferMemoryBarriers)[i]);
    }
    /* skip args->imageMemoryBarrierCount */
    if (args->pImageMemoryBarriers) {
       for (uint32_t i = 0; i < args->imageMemoryBarrierCount; i++)
            vn_replace_VkImageMemoryBarrier_handle(&((VkImageMemoryBarrier *)args->pImageMemoryBarriers)[i]);
    }
}

static inline void vn_encode_vkCmdWaitEvents_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdWaitEvents *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdWaitEvents_EXT});

    /* skip args->commandBuffer */
    /* skip args->eventCount */
    /* skip args->pEvents */
    /* skip args->srcStageMask */
    /* skip args->dstStageMask */
    /* skip args->memoryBarrierCount */
    /* skip args->pMemoryBarriers */
    /* skip args->bufferMemoryBarrierCount */
    /* skip args->pBufferMemoryBarriers */
    /* skip args->imageMemoryBarrierCount */
    /* skip args->pImageMemoryBarriers */
}

static inline void vn_decode_vkCmdPipelineBarrier_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdPipelineBarrier *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_VkFlags(dec, &args->srcStageMask);
    vn_decode_VkFlags(dec, &args->dstStageMask);
    vn_decode_VkFlags(dec, &args->dependencyFlags);
    vn_decode_uint32_t(dec, &args->memoryBarrierCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, args->memoryBarrierCount);
        args->pMemoryBarriers = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pMemoryBarriers) * iter_count);
        if (!args->pMemoryBarriers) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkMemoryBarrier_temp(dec, &((VkMemoryBarrier *)args->pMemoryBarriers)[i]);
    } else {
        vn_decode_array_size(dec, args->memoryBarrierCount);
        args->pMemoryBarriers = NULL;
    }
    vn_decode_uint32_t(dec, &args->bufferMemoryBarrierCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, args->bufferMemoryBarrierCount);
        args->pBufferMemoryBarriers = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pBufferMemoryBarriers) * iter_count);
        if (!args->pBufferMemoryBarriers) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkBufferMemoryBarrier_temp(dec, &((VkBufferMemoryBarrier *)args->pBufferMemoryBarriers)[i]);
    } else {
        vn_decode_array_size(dec, args->bufferMemoryBarrierCount);
        args->pBufferMemoryBarriers = NULL;
    }
    vn_decode_uint32_t(dec, &args->imageMemoryBarrierCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, args->imageMemoryBarrierCount);
        args->pImageMemoryBarriers = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pImageMemoryBarriers) * iter_count);
        if (!args->pImageMemoryBarriers) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkImageMemoryBarrier_temp(dec, &((VkImageMemoryBarrier *)args->pImageMemoryBarriers)[i]);
    } else {
        vn_decode_array_size(dec, args->imageMemoryBarrierCount);
        args->pImageMemoryBarriers = NULL;
    }
}

static inline void vn_replace_vkCmdPipelineBarrier_args_handle(struct vn_command_vkCmdPipelineBarrier *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    /* skip args->srcStageMask */
    /* skip args->dstStageMask */
    /* skip args->dependencyFlags */
    /* skip args->memoryBarrierCount */
    if (args->pMemoryBarriers) {
       for (uint32_t i = 0; i < args->memoryBarrierCount; i++)
            vn_replace_VkMemoryBarrier_handle(&((VkMemoryBarrier *)args->pMemoryBarriers)[i]);
    }
    /* skip args->bufferMemoryBarrierCount */
    if (args->pBufferMemoryBarriers) {
       for (uint32_t i = 0; i < args->bufferMemoryBarrierCount; i++)
            vn_replace_VkBufferMemoryBarrier_handle(&((VkBufferMemoryBarrier *)args->pBufferMemoryBarriers)[i]);
    }
    /* skip args->imageMemoryBarrierCount */
    if (args->pImageMemoryBarriers) {
       for (uint32_t i = 0; i < args->imageMemoryBarrierCount; i++)
            vn_replace_VkImageMemoryBarrier_handle(&((VkImageMemoryBarrier *)args->pImageMemoryBarriers)[i]);
    }
}

static inline void vn_encode_vkCmdPipelineBarrier_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdPipelineBarrier *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdPipelineBarrier_EXT});

    /* skip args->commandBuffer */
    /* skip args->srcStageMask */
    /* skip args->dstStageMask */
    /* skip args->dependencyFlags */
    /* skip args->memoryBarrierCount */
    /* skip args->pMemoryBarriers */
    /* skip args->bufferMemoryBarrierCount */
    /* skip args->pBufferMemoryBarriers */
    /* skip args->imageMemoryBarrierCount */
    /* skip args->pImageMemoryBarriers */
}

static inline void vn_decode_vkCmdBeginQuery_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdBeginQuery *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_VkQueryPool_lookup(dec, &args->queryPool);
    vn_decode_uint32_t(dec, &args->query);
    vn_decode_VkFlags(dec, &args->flags);
}

static inline void vn_replace_vkCmdBeginQuery_args_handle(struct vn_command_vkCmdBeginQuery *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    vn_replace_VkQueryPool_handle(&args->queryPool);
    /* skip args->query */
    /* skip args->flags */
}

static inline void vn_encode_vkCmdBeginQuery_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdBeginQuery *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdBeginQuery_EXT});

    /* skip args->commandBuffer */
    /* skip args->queryPool */
    /* skip args->query */
    /* skip args->flags */
}

static inline void vn_decode_vkCmdEndQuery_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdEndQuery *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_VkQueryPool_lookup(dec, &args->queryPool);
    vn_decode_uint32_t(dec, &args->query);
}

static inline void vn_replace_vkCmdEndQuery_args_handle(struct vn_command_vkCmdEndQuery *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    vn_replace_VkQueryPool_handle(&args->queryPool);
    /* skip args->query */
}

static inline void vn_encode_vkCmdEndQuery_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdEndQuery *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdEndQuery_EXT});

    /* skip args->commandBuffer */
    /* skip args->queryPool */
    /* skip args->query */
}

static inline void vn_decode_vkCmdBeginConditionalRenderingEXT_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdBeginConditionalRenderingEXT *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    if (vn_decode_simple_pointer(dec)) {
        args->pConditionalRenderingBegin = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pConditionalRenderingBegin));
        if (!args->pConditionalRenderingBegin) return;
        vn_decode_VkConditionalRenderingBeginInfoEXT_temp(dec, (VkConditionalRenderingBeginInfoEXT *)args->pConditionalRenderingBegin);
    } else {
        args->pConditionalRenderingBegin = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
}

static inline void vn_replace_vkCmdBeginConditionalRenderingEXT_args_handle(struct vn_command_vkCmdBeginConditionalRenderingEXT *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    if (args->pConditionalRenderingBegin)
        vn_replace_VkConditionalRenderingBeginInfoEXT_handle((VkConditionalRenderingBeginInfoEXT *)args->pConditionalRenderingBegin);
}

static inline void vn_encode_vkCmdBeginConditionalRenderingEXT_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdBeginConditionalRenderingEXT *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdBeginConditionalRenderingEXT_EXT});

    /* skip args->commandBuffer */
    /* skip args->pConditionalRenderingBegin */
}

static inline void vn_decode_vkCmdEndConditionalRenderingEXT_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdEndConditionalRenderingEXT *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
}

static inline void vn_replace_vkCmdEndConditionalRenderingEXT_args_handle(struct vn_command_vkCmdEndConditionalRenderingEXT *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
}

static inline void vn_encode_vkCmdEndConditionalRenderingEXT_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdEndConditionalRenderingEXT *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdEndConditionalRenderingEXT_EXT});

    /* skip args->commandBuffer */
}

static inline void vn_decode_vkCmdResetQueryPool_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdResetQueryPool *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_VkQueryPool_lookup(dec, &args->queryPool);
    vn_decode_uint32_t(dec, &args->firstQuery);
    vn_decode_uint32_t(dec, &args->queryCount);
}

static inline void vn_replace_vkCmdResetQueryPool_args_handle(struct vn_command_vkCmdResetQueryPool *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    vn_replace_VkQueryPool_handle(&args->queryPool);
    /* skip args->firstQuery */
    /* skip args->queryCount */
}

static inline void vn_encode_vkCmdResetQueryPool_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdResetQueryPool *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdResetQueryPool_EXT});

    /* skip args->commandBuffer */
    /* skip args->queryPool */
    /* skip args->firstQuery */
    /* skip args->queryCount */
}

static inline void vn_decode_vkCmdWriteTimestamp_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdWriteTimestamp *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_VkPipelineStageFlagBits(dec, &args->pipelineStage);
    vn_decode_VkQueryPool_lookup(dec, &args->queryPool);
    vn_decode_uint32_t(dec, &args->query);
}

static inline void vn_replace_vkCmdWriteTimestamp_args_handle(struct vn_command_vkCmdWriteTimestamp *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    /* skip args->pipelineStage */
    vn_replace_VkQueryPool_handle(&args->queryPool);
    /* skip args->query */
}

static inline void vn_encode_vkCmdWriteTimestamp_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdWriteTimestamp *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdWriteTimestamp_EXT});

    /* skip args->commandBuffer */
    /* skip args->pipelineStage */
    /* skip args->queryPool */
    /* skip args->query */
}

static inline void vn_decode_vkCmdCopyQueryPoolResults_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdCopyQueryPoolResults *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_VkQueryPool_lookup(dec, &args->queryPool);
    vn_decode_uint32_t(dec, &args->firstQuery);
    vn_decode_uint32_t(dec, &args->queryCount);
    vn_decode_VkBuffer_lookup(dec, &args->dstBuffer);
    vn_decode_VkDeviceSize(dec, &args->dstOffset);
    vn_decode_VkDeviceSize(dec, &args->stride);
    vn_decode_VkFlags(dec, &args->flags);
}

static inline void vn_replace_vkCmdCopyQueryPoolResults_args_handle(struct vn_command_vkCmdCopyQueryPoolResults *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    vn_replace_VkQueryPool_handle(&args->queryPool);
    /* skip args->firstQuery */
    /* skip args->queryCount */
    vn_replace_VkBuffer_handle(&args->dstBuffer);
    /* skip args->dstOffset */
    /* skip args->stride */
    /* skip args->flags */
}

static inline void vn_encode_vkCmdCopyQueryPoolResults_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdCopyQueryPoolResults *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdCopyQueryPoolResults_EXT});

    /* skip args->commandBuffer */
    /* skip args->queryPool */
    /* skip args->firstQuery */
    /* skip args->queryCount */
    /* skip args->dstBuffer */
    /* skip args->dstOffset */
    /* skip args->stride */
    /* skip args->flags */
}

static inline void vn_decode_vkCmdPushConstants_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdPushConstants *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_VkPipelineLayout_lookup(dec, &args->layout);
    vn_decode_VkFlags(dec, &args->stageFlags);
    vn_decode_uint32_t(dec, &args->offset);
    vn_decode_uint32_t(dec, &args->size);
    if (vn_peek_array_size(dec)) {
        const size_t array_size = vn_decode_array_size(dec, args->size);
        args->pValues = vn_cs_decoder_alloc_temp(dec, array_size);
        if (!args->pValues) return;
        vn_decode_blob_array(dec, (void *)args->pValues, array_size);
    } else {
        vn_decode_array_size(dec, args->size);
        args->pValues = NULL;
    }
}

static inline void vn_replace_vkCmdPushConstants_args_handle(struct vn_command_vkCmdPushConstants *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    vn_replace_VkPipelineLayout_handle(&args->layout);
    /* skip args->stageFlags */
    /* skip args->offset */
    /* skip args->size */
    /* skip args->pValues */
}

static inline void vn_encode_vkCmdPushConstants_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdPushConstants *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdPushConstants_EXT});

    /* skip args->commandBuffer */
    /* skip args->layout */
    /* skip args->stageFlags */
    /* skip args->offset */
    /* skip args->size */
    /* skip args->pValues */
}

static inline void vn_decode_vkCmdBeginRenderPass_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdBeginRenderPass *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    if (vn_decode_simple_pointer(dec)) {
        args->pRenderPassBegin = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pRenderPassBegin));
        if (!args->pRenderPassBegin) return;
        vn_decode_VkRenderPassBeginInfo_temp(dec, (VkRenderPassBeginInfo *)args->pRenderPassBegin);
    } else {
        args->pRenderPassBegin = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
    vn_decode_VkSubpassContents(dec, &args->contents);
}

static inline void vn_replace_vkCmdBeginRenderPass_args_handle(struct vn_command_vkCmdBeginRenderPass *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    if (args->pRenderPassBegin)
        vn_replace_VkRenderPassBeginInfo_handle((VkRenderPassBeginInfo *)args->pRenderPassBegin);
    /* skip args->contents */
}

static inline void vn_encode_vkCmdBeginRenderPass_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdBeginRenderPass *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdBeginRenderPass_EXT});

    /* skip args->commandBuffer */
    /* skip args->pRenderPassBegin */
    /* skip args->contents */
}

static inline void vn_decode_vkCmdNextSubpass_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdNextSubpass *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_VkSubpassContents(dec, &args->contents);
}

static inline void vn_replace_vkCmdNextSubpass_args_handle(struct vn_command_vkCmdNextSubpass *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    /* skip args->contents */
}

static inline void vn_encode_vkCmdNextSubpass_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdNextSubpass *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdNextSubpass_EXT});

    /* skip args->commandBuffer */
    /* skip args->contents */
}

static inline void vn_decode_vkCmdEndRenderPass_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdEndRenderPass *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
}

static inline void vn_replace_vkCmdEndRenderPass_args_handle(struct vn_command_vkCmdEndRenderPass *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
}

static inline void vn_encode_vkCmdEndRenderPass_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdEndRenderPass *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdEndRenderPass_EXT});

    /* skip args->commandBuffer */
}

static inline void vn_decode_vkCmdExecuteCommands_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdExecuteCommands *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_uint32_t(dec, &args->commandBufferCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, args->commandBufferCount);
        args->pCommandBuffers = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pCommandBuffers) * iter_count);
        if (!args->pCommandBuffers) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkCommandBuffer_lookup(dec, &((VkCommandBuffer *)args->pCommandBuffers)[i]);
    } else {
        vn_decode_array_size(dec, args->commandBufferCount);
        args->pCommandBuffers = NULL;
    }
}

static inline void vn_replace_vkCmdExecuteCommands_args_handle(struct vn_command_vkCmdExecuteCommands *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    /* skip args->commandBufferCount */
    if (args->pCommandBuffers) {
       for (uint32_t i = 0; i < args->commandBufferCount; i++)
            vn_replace_VkCommandBuffer_handle(&((VkCommandBuffer *)args->pCommandBuffers)[i]);
    }
}

static inline void vn_encode_vkCmdExecuteCommands_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdExecuteCommands *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdExecuteCommands_EXT});

    /* skip args->commandBuffer */
    /* skip args->commandBufferCount */
    /* skip args->pCommandBuffers */
}

static inline void vn_decode_vkCmdSetDeviceMask_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdSetDeviceMask *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_uint32_t(dec, &args->deviceMask);
}

static inline void vn_replace_vkCmdSetDeviceMask_args_handle(struct vn_command_vkCmdSetDeviceMask *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    /* skip args->deviceMask */
}

static inline void vn_encode_vkCmdSetDeviceMask_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdSetDeviceMask *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdSetDeviceMask_EXT});

    /* skip args->commandBuffer */
    /* skip args->deviceMask */
}

static inline void vn_decode_vkCmdDispatchBase_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdDispatchBase *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_uint32_t(dec, &args->baseGroupX);
    vn_decode_uint32_t(dec, &args->baseGroupY);
    vn_decode_uint32_t(dec, &args->baseGroupZ);
    vn_decode_uint32_t(dec, &args->groupCountX);
    vn_decode_uint32_t(dec, &args->groupCountY);
    vn_decode_uint32_t(dec, &args->groupCountZ);
}

static inline void vn_replace_vkCmdDispatchBase_args_handle(struct vn_command_vkCmdDispatchBase *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    /* skip args->baseGroupX */
    /* skip args->baseGroupY */
    /* skip args->baseGroupZ */
    /* skip args->groupCountX */
    /* skip args->groupCountY */
    /* skip args->groupCountZ */
}

static inline void vn_encode_vkCmdDispatchBase_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdDispatchBase *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdDispatchBase_EXT});

    /* skip args->commandBuffer */
    /* skip args->baseGroupX */
    /* skip args->baseGroupY */
    /* skip args->baseGroupZ */
    /* skip args->groupCountX */
    /* skip args->groupCountY */
    /* skip args->groupCountZ */
}

static inline void vn_decode_vkCmdBeginRenderPass2_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdBeginRenderPass2 *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    if (vn_decode_simple_pointer(dec)) {
        args->pRenderPassBegin = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pRenderPassBegin));
        if (!args->pRenderPassBegin) return;
        vn_decode_VkRenderPassBeginInfo_temp(dec, (VkRenderPassBeginInfo *)args->pRenderPassBegin);
    } else {
        args->pRenderPassBegin = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
    if (vn_decode_simple_pointer(dec)) {
        args->pSubpassBeginInfo = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pSubpassBeginInfo));
        if (!args->pSubpassBeginInfo) return;
        vn_decode_VkSubpassBeginInfo_temp(dec, (VkSubpassBeginInfo *)args->pSubpassBeginInfo);
    } else {
        args->pSubpassBeginInfo = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
}

static inline void vn_replace_vkCmdBeginRenderPass2_args_handle(struct vn_command_vkCmdBeginRenderPass2 *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    if (args->pRenderPassBegin)
        vn_replace_VkRenderPassBeginInfo_handle((VkRenderPassBeginInfo *)args->pRenderPassBegin);
    if (args->pSubpassBeginInfo)
        vn_replace_VkSubpassBeginInfo_handle((VkSubpassBeginInfo *)args->pSubpassBeginInfo);
}

static inline void vn_encode_vkCmdBeginRenderPass2_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdBeginRenderPass2 *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdBeginRenderPass2_EXT});

    /* skip args->commandBuffer */
    /* skip args->pRenderPassBegin */
    /* skip args->pSubpassBeginInfo */
}

static inline void vn_decode_vkCmdNextSubpass2_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdNextSubpass2 *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    if (vn_decode_simple_pointer(dec)) {
        args->pSubpassBeginInfo = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pSubpassBeginInfo));
        if (!args->pSubpassBeginInfo) return;
        vn_decode_VkSubpassBeginInfo_temp(dec, (VkSubpassBeginInfo *)args->pSubpassBeginInfo);
    } else {
        args->pSubpassBeginInfo = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
    if (vn_decode_simple_pointer(dec)) {
        args->pSubpassEndInfo = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pSubpassEndInfo));
        if (!args->pSubpassEndInfo) return;
        vn_decode_VkSubpassEndInfo_temp(dec, (VkSubpassEndInfo *)args->pSubpassEndInfo);
    } else {
        args->pSubpassEndInfo = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
}

static inline void vn_replace_vkCmdNextSubpass2_args_handle(struct vn_command_vkCmdNextSubpass2 *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    if (args->pSubpassBeginInfo)
        vn_replace_VkSubpassBeginInfo_handle((VkSubpassBeginInfo *)args->pSubpassBeginInfo);
    if (args->pSubpassEndInfo)
        vn_replace_VkSubpassEndInfo_handle((VkSubpassEndInfo *)args->pSubpassEndInfo);
}

static inline void vn_encode_vkCmdNextSubpass2_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdNextSubpass2 *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdNextSubpass2_EXT});

    /* skip args->commandBuffer */
    /* skip args->pSubpassBeginInfo */
    /* skip args->pSubpassEndInfo */
}

static inline void vn_decode_vkCmdEndRenderPass2_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdEndRenderPass2 *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    if (vn_decode_simple_pointer(dec)) {
        args->pSubpassEndInfo = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pSubpassEndInfo));
        if (!args->pSubpassEndInfo) return;
        vn_decode_VkSubpassEndInfo_temp(dec, (VkSubpassEndInfo *)args->pSubpassEndInfo);
    } else {
        args->pSubpassEndInfo = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
}

static inline void vn_replace_vkCmdEndRenderPass2_args_handle(struct vn_command_vkCmdEndRenderPass2 *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    if (args->pSubpassEndInfo)
        vn_replace_VkSubpassEndInfo_handle((VkSubpassEndInfo *)args->pSubpassEndInfo);
}

static inline void vn_encode_vkCmdEndRenderPass2_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdEndRenderPass2 *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdEndRenderPass2_EXT});

    /* skip args->commandBuffer */
    /* skip args->pSubpassEndInfo */
}

static inline void vn_decode_vkCmdDrawIndirectCount_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdDrawIndirectCount *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_VkBuffer_lookup(dec, &args->buffer);
    vn_decode_VkDeviceSize(dec, &args->offset);
    vn_decode_VkBuffer_lookup(dec, &args->countBuffer);
    vn_decode_VkDeviceSize(dec, &args->countBufferOffset);
    vn_decode_uint32_t(dec, &args->maxDrawCount);
    vn_decode_uint32_t(dec, &args->stride);
}

static inline void vn_replace_vkCmdDrawIndirectCount_args_handle(struct vn_command_vkCmdDrawIndirectCount *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    vn_replace_VkBuffer_handle(&args->buffer);
    /* skip args->offset */
    vn_replace_VkBuffer_handle(&args->countBuffer);
    /* skip args->countBufferOffset */
    /* skip args->maxDrawCount */
    /* skip args->stride */
}

static inline void vn_encode_vkCmdDrawIndirectCount_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdDrawIndirectCount *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdDrawIndirectCount_EXT});

    /* skip args->commandBuffer */
    /* skip args->buffer */
    /* skip args->offset */
    /* skip args->countBuffer */
    /* skip args->countBufferOffset */
    /* skip args->maxDrawCount */
    /* skip args->stride */
}

static inline void vn_decode_vkCmdDrawIndexedIndirectCount_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdDrawIndexedIndirectCount *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_VkBuffer_lookup(dec, &args->buffer);
    vn_decode_VkDeviceSize(dec, &args->offset);
    vn_decode_VkBuffer_lookup(dec, &args->countBuffer);
    vn_decode_VkDeviceSize(dec, &args->countBufferOffset);
    vn_decode_uint32_t(dec, &args->maxDrawCount);
    vn_decode_uint32_t(dec, &args->stride);
}

static inline void vn_replace_vkCmdDrawIndexedIndirectCount_args_handle(struct vn_command_vkCmdDrawIndexedIndirectCount *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    vn_replace_VkBuffer_handle(&args->buffer);
    /* skip args->offset */
    vn_replace_VkBuffer_handle(&args->countBuffer);
    /* skip args->countBufferOffset */
    /* skip args->maxDrawCount */
    /* skip args->stride */
}

static inline void vn_encode_vkCmdDrawIndexedIndirectCount_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdDrawIndexedIndirectCount *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdDrawIndexedIndirectCount_EXT});

    /* skip args->commandBuffer */
    /* skip args->buffer */
    /* skip args->offset */
    /* skip args->countBuffer */
    /* skip args->countBufferOffset */
    /* skip args->maxDrawCount */
    /* skip args->stride */
}

static inline void vn_decode_vkCmdBindTransformFeedbackBuffersEXT_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdBindTransformFeedbackBuffersEXT *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_uint32_t(dec, &args->firstBinding);
    vn_decode_uint32_t(dec, &args->bindingCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, args->bindingCount);
        args->pBuffers = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pBuffers) * iter_count);
        if (!args->pBuffers) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkBuffer_lookup(dec, &((VkBuffer *)args->pBuffers)[i]);
    } else {
        vn_decode_array_size(dec, args->bindingCount);
        args->pBuffers = NULL;
    }
    if (vn_peek_array_size(dec)) {
        const size_t array_size = vn_decode_array_size(dec, args->bindingCount);
        args->pOffsets = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pOffsets) * array_size);
        if (!args->pOffsets) return;
        vn_decode_VkDeviceSize_array(dec, (VkDeviceSize *)args->pOffsets, array_size);
    } else {
        vn_decode_array_size(dec, args->bindingCount);
        args->pOffsets = NULL;
    }
    if (vn_peek_array_size(dec)) {
        const size_t array_size = vn_decode_array_size(dec, args->bindingCount);
        args->pSizes = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pSizes) * array_size);
        if (!args->pSizes) return;
        vn_decode_VkDeviceSize_array(dec, (VkDeviceSize *)args->pSizes, array_size);
    } else {
        vn_decode_array_size_unchecked(dec);
        args->pSizes = NULL;
    }
}

static inline void vn_replace_vkCmdBindTransformFeedbackBuffersEXT_args_handle(struct vn_command_vkCmdBindTransformFeedbackBuffersEXT *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    /* skip args->firstBinding */
    /* skip args->bindingCount */
    if (args->pBuffers) {
       for (uint32_t i = 0; i < args->bindingCount; i++)
            vn_replace_VkBuffer_handle(&((VkBuffer *)args->pBuffers)[i]);
    }
    /* skip args->pOffsets */
    /* skip args->pSizes */
}

static inline void vn_encode_vkCmdBindTransformFeedbackBuffersEXT_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdBindTransformFeedbackBuffersEXT *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdBindTransformFeedbackBuffersEXT_EXT});

    /* skip args->commandBuffer */
    /* skip args->firstBinding */
    /* skip args->bindingCount */
    /* skip args->pBuffers */
    /* skip args->pOffsets */
    /* skip args->pSizes */
}

static inline void vn_decode_vkCmdBeginTransformFeedbackEXT_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdBeginTransformFeedbackEXT *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_uint32_t(dec, &args->firstCounterBuffer);
    vn_decode_uint32_t(dec, &args->counterBufferCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, args->counterBufferCount);
        args->pCounterBuffers = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pCounterBuffers) * iter_count);
        if (!args->pCounterBuffers) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkBuffer_lookup(dec, &((VkBuffer *)args->pCounterBuffers)[i]);
    } else {
        vn_decode_array_size_unchecked(dec);
        args->pCounterBuffers = NULL;
    }
    if (vn_peek_array_size(dec)) {
        const size_t array_size = vn_decode_array_size(dec, args->counterBufferCount);
        args->pCounterBufferOffsets = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pCounterBufferOffsets) * array_size);
        if (!args->pCounterBufferOffsets) return;
        vn_decode_VkDeviceSize_array(dec, (VkDeviceSize *)args->pCounterBufferOffsets, array_size);
    } else {
        vn_decode_array_size_unchecked(dec);
        args->pCounterBufferOffsets = NULL;
    }
}

static inline void vn_replace_vkCmdBeginTransformFeedbackEXT_args_handle(struct vn_command_vkCmdBeginTransformFeedbackEXT *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    /* skip args->firstCounterBuffer */
    /* skip args->counterBufferCount */
    if (args->pCounterBuffers) {
       for (uint32_t i = 0; i < args->counterBufferCount; i++)
            vn_replace_VkBuffer_handle(&((VkBuffer *)args->pCounterBuffers)[i]);
    }
    /* skip args->pCounterBufferOffsets */
}

static inline void vn_encode_vkCmdBeginTransformFeedbackEXT_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdBeginTransformFeedbackEXT *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdBeginTransformFeedbackEXT_EXT});

    /* skip args->commandBuffer */
    /* skip args->firstCounterBuffer */
    /* skip args->counterBufferCount */
    /* skip args->pCounterBuffers */
    /* skip args->pCounterBufferOffsets */
}

static inline void vn_decode_vkCmdEndTransformFeedbackEXT_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdEndTransformFeedbackEXT *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_uint32_t(dec, &args->firstCounterBuffer);
    vn_decode_uint32_t(dec, &args->counterBufferCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, args->counterBufferCount);
        args->pCounterBuffers = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pCounterBuffers) * iter_count);
        if (!args->pCounterBuffers) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkBuffer_lookup(dec, &((VkBuffer *)args->pCounterBuffers)[i]);
    } else {
        vn_decode_array_size_unchecked(dec);
        args->pCounterBuffers = NULL;
    }
    if (vn_peek_array_size(dec)) {
        const size_t array_size = vn_decode_array_size(dec, args->counterBufferCount);
        args->pCounterBufferOffsets = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pCounterBufferOffsets) * array_size);
        if (!args->pCounterBufferOffsets) return;
        vn_decode_VkDeviceSize_array(dec, (VkDeviceSize *)args->pCounterBufferOffsets, array_size);
    } else {
        vn_decode_array_size_unchecked(dec);
        args->pCounterBufferOffsets = NULL;
    }
}

static inline void vn_replace_vkCmdEndTransformFeedbackEXT_args_handle(struct vn_command_vkCmdEndTransformFeedbackEXT *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    /* skip args->firstCounterBuffer */
    /* skip args->counterBufferCount */
    if (args->pCounterBuffers) {
       for (uint32_t i = 0; i < args->counterBufferCount; i++)
            vn_replace_VkBuffer_handle(&((VkBuffer *)args->pCounterBuffers)[i]);
    }
    /* skip args->pCounterBufferOffsets */
}

static inline void vn_encode_vkCmdEndTransformFeedbackEXT_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdEndTransformFeedbackEXT *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdEndTransformFeedbackEXT_EXT});

    /* skip args->commandBuffer */
    /* skip args->firstCounterBuffer */
    /* skip args->counterBufferCount */
    /* skip args->pCounterBuffers */
    /* skip args->pCounterBufferOffsets */
}

static inline void vn_decode_vkCmdBeginQueryIndexedEXT_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdBeginQueryIndexedEXT *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_VkQueryPool_lookup(dec, &args->queryPool);
    vn_decode_uint32_t(dec, &args->query);
    vn_decode_VkFlags(dec, &args->flags);
    vn_decode_uint32_t(dec, &args->index);
}

static inline void vn_replace_vkCmdBeginQueryIndexedEXT_args_handle(struct vn_command_vkCmdBeginQueryIndexedEXT *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    vn_replace_VkQueryPool_handle(&args->queryPool);
    /* skip args->query */
    /* skip args->flags */
    /* skip args->index */
}

static inline void vn_encode_vkCmdBeginQueryIndexedEXT_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdBeginQueryIndexedEXT *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdBeginQueryIndexedEXT_EXT});

    /* skip args->commandBuffer */
    /* skip args->queryPool */
    /* skip args->query */
    /* skip args->flags */
    /* skip args->index */
}

static inline void vn_decode_vkCmdEndQueryIndexedEXT_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdEndQueryIndexedEXT *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_VkQueryPool_lookup(dec, &args->queryPool);
    vn_decode_uint32_t(dec, &args->query);
    vn_decode_uint32_t(dec, &args->index);
}

static inline void vn_replace_vkCmdEndQueryIndexedEXT_args_handle(struct vn_command_vkCmdEndQueryIndexedEXT *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    vn_replace_VkQueryPool_handle(&args->queryPool);
    /* skip args->query */
    /* skip args->index */
}

static inline void vn_encode_vkCmdEndQueryIndexedEXT_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdEndQueryIndexedEXT *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdEndQueryIndexedEXT_EXT});

    /* skip args->commandBuffer */
    /* skip args->queryPool */
    /* skip args->query */
    /* skip args->index */
}

static inline void vn_decode_vkCmdDrawIndirectByteCountEXT_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdDrawIndirectByteCountEXT *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_uint32_t(dec, &args->instanceCount);
    vn_decode_uint32_t(dec, &args->firstInstance);
    vn_decode_VkBuffer_lookup(dec, &args->counterBuffer);
    vn_decode_VkDeviceSize(dec, &args->counterBufferOffset);
    vn_decode_uint32_t(dec, &args->counterOffset);
    vn_decode_uint32_t(dec, &args->vertexStride);
}

static inline void vn_replace_vkCmdDrawIndirectByteCountEXT_args_handle(struct vn_command_vkCmdDrawIndirectByteCountEXT *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    /* skip args->instanceCount */
    /* skip args->firstInstance */
    vn_replace_VkBuffer_handle(&args->counterBuffer);
    /* skip args->counterBufferOffset */
    /* skip args->counterOffset */
    /* skip args->vertexStride */
}

static inline void vn_encode_vkCmdDrawIndirectByteCountEXT_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdDrawIndirectByteCountEXT *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdDrawIndirectByteCountEXT_EXT});

    /* skip args->commandBuffer */
    /* skip args->instanceCount */
    /* skip args->firstInstance */
    /* skip args->counterBuffer */
    /* skip args->counterBufferOffset */
    /* skip args->counterOffset */
    /* skip args->vertexStride */
}

static inline void vn_decode_vkCmdSetLineStippleEXT_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdSetLineStippleEXT *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_uint32_t(dec, &args->lineStippleFactor);
    vn_decode_uint16_t(dec, &args->lineStipplePattern);
}

static inline void vn_replace_vkCmdSetLineStippleEXT_args_handle(struct vn_command_vkCmdSetLineStippleEXT *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    /* skip args->lineStippleFactor */
    /* skip args->lineStipplePattern */
}

static inline void vn_encode_vkCmdSetLineStippleEXT_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdSetLineStippleEXT *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdSetLineStippleEXT_EXT});

    /* skip args->commandBuffer */
    /* skip args->lineStippleFactor */
    /* skip args->lineStipplePattern */
}

static inline void vn_decode_vkCmdSetCullMode_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdSetCullMode *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_VkFlags(dec, &args->cullMode);
}

static inline void vn_replace_vkCmdSetCullMode_args_handle(struct vn_command_vkCmdSetCullMode *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    /* skip args->cullMode */
}

static inline void vn_encode_vkCmdSetCullMode_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdSetCullMode *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdSetCullMode_EXT});

    /* skip args->commandBuffer */
    /* skip args->cullMode */
}

static inline void vn_decode_vkCmdSetFrontFace_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdSetFrontFace *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_VkFrontFace(dec, &args->frontFace);
}

static inline void vn_replace_vkCmdSetFrontFace_args_handle(struct vn_command_vkCmdSetFrontFace *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    /* skip args->frontFace */
}

static inline void vn_encode_vkCmdSetFrontFace_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdSetFrontFace *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdSetFrontFace_EXT});

    /* skip args->commandBuffer */
    /* skip args->frontFace */
}

static inline void vn_decode_vkCmdSetPrimitiveTopology_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdSetPrimitiveTopology *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_VkPrimitiveTopology(dec, &args->primitiveTopology);
}

static inline void vn_replace_vkCmdSetPrimitiveTopology_args_handle(struct vn_command_vkCmdSetPrimitiveTopology *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    /* skip args->primitiveTopology */
}

static inline void vn_encode_vkCmdSetPrimitiveTopology_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdSetPrimitiveTopology *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdSetPrimitiveTopology_EXT});

    /* skip args->commandBuffer */
    /* skip args->primitiveTopology */
}

static inline void vn_decode_vkCmdSetViewportWithCount_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdSetViewportWithCount *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_uint32_t(dec, &args->viewportCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, args->viewportCount);
        args->pViewports = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pViewports) * iter_count);
        if (!args->pViewports) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkViewport_temp(dec, &((VkViewport *)args->pViewports)[i]);
    } else {
        vn_decode_array_size(dec, args->viewportCount);
        args->pViewports = NULL;
    }
}

static inline void vn_replace_vkCmdSetViewportWithCount_args_handle(struct vn_command_vkCmdSetViewportWithCount *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    /* skip args->viewportCount */
    if (args->pViewports) {
       for (uint32_t i = 0; i < args->viewportCount; i++)
            vn_replace_VkViewport_handle(&((VkViewport *)args->pViewports)[i]);
    }
}

static inline void vn_encode_vkCmdSetViewportWithCount_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdSetViewportWithCount *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdSetViewportWithCount_EXT});

    /* skip args->commandBuffer */
    /* skip args->viewportCount */
    /* skip args->pViewports */
}

static inline void vn_decode_vkCmdSetScissorWithCount_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdSetScissorWithCount *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_uint32_t(dec, &args->scissorCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, args->scissorCount);
        args->pScissors = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pScissors) * iter_count);
        if (!args->pScissors) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkRect2D_temp(dec, &((VkRect2D *)args->pScissors)[i]);
    } else {
        vn_decode_array_size(dec, args->scissorCount);
        args->pScissors = NULL;
    }
}

static inline void vn_replace_vkCmdSetScissorWithCount_args_handle(struct vn_command_vkCmdSetScissorWithCount *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    /* skip args->scissorCount */
    if (args->pScissors) {
       for (uint32_t i = 0; i < args->scissorCount; i++)
            vn_replace_VkRect2D_handle(&((VkRect2D *)args->pScissors)[i]);
    }
}

static inline void vn_encode_vkCmdSetScissorWithCount_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdSetScissorWithCount *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdSetScissorWithCount_EXT});

    /* skip args->commandBuffer */
    /* skip args->scissorCount */
    /* skip args->pScissors */
}

static inline void vn_decode_vkCmdBindVertexBuffers2_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdBindVertexBuffers2 *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_uint32_t(dec, &args->firstBinding);
    vn_decode_uint32_t(dec, &args->bindingCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, args->bindingCount);
        args->pBuffers = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pBuffers) * iter_count);
        if (!args->pBuffers) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkBuffer_lookup(dec, &((VkBuffer *)args->pBuffers)[i]);
    } else {
        vn_decode_array_size(dec, args->bindingCount);
        args->pBuffers = NULL;
    }
    if (vn_peek_array_size(dec)) {
        const size_t array_size = vn_decode_array_size(dec, args->bindingCount);
        args->pOffsets = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pOffsets) * array_size);
        if (!args->pOffsets) return;
        vn_decode_VkDeviceSize_array(dec, (VkDeviceSize *)args->pOffsets, array_size);
    } else {
        vn_decode_array_size(dec, args->bindingCount);
        args->pOffsets = NULL;
    }
    if (vn_peek_array_size(dec)) {
        const size_t array_size = vn_decode_array_size(dec, args->bindingCount);
        args->pSizes = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pSizes) * array_size);
        if (!args->pSizes) return;
        vn_decode_VkDeviceSize_array(dec, (VkDeviceSize *)args->pSizes, array_size);
    } else {
        vn_decode_array_size_unchecked(dec);
        args->pSizes = NULL;
    }
    if (vn_peek_array_size(dec)) {
        const size_t array_size = vn_decode_array_size(dec, args->bindingCount);
        args->pStrides = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pStrides) * array_size);
        if (!args->pStrides) return;
        vn_decode_VkDeviceSize_array(dec, (VkDeviceSize *)args->pStrides, array_size);
    } else {
        vn_decode_array_size_unchecked(dec);
        args->pStrides = NULL;
    }
}

static inline void vn_replace_vkCmdBindVertexBuffers2_args_handle(struct vn_command_vkCmdBindVertexBuffers2 *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    /* skip args->firstBinding */
    /* skip args->bindingCount */
    if (args->pBuffers) {
       for (uint32_t i = 0; i < args->bindingCount; i++)
            vn_replace_VkBuffer_handle(&((VkBuffer *)args->pBuffers)[i]);
    }
    /* skip args->pOffsets */
    /* skip args->pSizes */
    /* skip args->pStrides */
}

static inline void vn_encode_vkCmdBindVertexBuffers2_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdBindVertexBuffers2 *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdBindVertexBuffers2_EXT});

    /* skip args->commandBuffer */
    /* skip args->firstBinding */
    /* skip args->bindingCount */
    /* skip args->pBuffers */
    /* skip args->pOffsets */
    /* skip args->pSizes */
    /* skip args->pStrides */
}

static inline void vn_decode_vkCmdSetDepthTestEnable_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdSetDepthTestEnable *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_VkBool32(dec, &args->depthTestEnable);
}

static inline void vn_replace_vkCmdSetDepthTestEnable_args_handle(struct vn_command_vkCmdSetDepthTestEnable *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    /* skip args->depthTestEnable */
}

static inline void vn_encode_vkCmdSetDepthTestEnable_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdSetDepthTestEnable *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdSetDepthTestEnable_EXT});

    /* skip args->commandBuffer */
    /* skip args->depthTestEnable */
}

static inline void vn_decode_vkCmdSetDepthWriteEnable_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdSetDepthWriteEnable *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_VkBool32(dec, &args->depthWriteEnable);
}

static inline void vn_replace_vkCmdSetDepthWriteEnable_args_handle(struct vn_command_vkCmdSetDepthWriteEnable *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    /* skip args->depthWriteEnable */
}

static inline void vn_encode_vkCmdSetDepthWriteEnable_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdSetDepthWriteEnable *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdSetDepthWriteEnable_EXT});

    /* skip args->commandBuffer */
    /* skip args->depthWriteEnable */
}

static inline void vn_decode_vkCmdSetDepthCompareOp_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdSetDepthCompareOp *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_VkCompareOp(dec, &args->depthCompareOp);
}

static inline void vn_replace_vkCmdSetDepthCompareOp_args_handle(struct vn_command_vkCmdSetDepthCompareOp *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    /* skip args->depthCompareOp */
}

static inline void vn_encode_vkCmdSetDepthCompareOp_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdSetDepthCompareOp *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdSetDepthCompareOp_EXT});

    /* skip args->commandBuffer */
    /* skip args->depthCompareOp */
}

static inline void vn_decode_vkCmdSetDepthBoundsTestEnable_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdSetDepthBoundsTestEnable *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_VkBool32(dec, &args->depthBoundsTestEnable);
}

static inline void vn_replace_vkCmdSetDepthBoundsTestEnable_args_handle(struct vn_command_vkCmdSetDepthBoundsTestEnable *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    /* skip args->depthBoundsTestEnable */
}

static inline void vn_encode_vkCmdSetDepthBoundsTestEnable_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdSetDepthBoundsTestEnable *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdSetDepthBoundsTestEnable_EXT});

    /* skip args->commandBuffer */
    /* skip args->depthBoundsTestEnable */
}

static inline void vn_decode_vkCmdSetStencilTestEnable_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdSetStencilTestEnable *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_VkBool32(dec, &args->stencilTestEnable);
}

static inline void vn_replace_vkCmdSetStencilTestEnable_args_handle(struct vn_command_vkCmdSetStencilTestEnable *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    /* skip args->stencilTestEnable */
}

static inline void vn_encode_vkCmdSetStencilTestEnable_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdSetStencilTestEnable *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdSetStencilTestEnable_EXT});

    /* skip args->commandBuffer */
    /* skip args->stencilTestEnable */
}

static inline void vn_decode_vkCmdSetStencilOp_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdSetStencilOp *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_VkFlags(dec, &args->faceMask);
    vn_decode_VkStencilOp(dec, &args->failOp);
    vn_decode_VkStencilOp(dec, &args->passOp);
    vn_decode_VkStencilOp(dec, &args->depthFailOp);
    vn_decode_VkCompareOp(dec, &args->compareOp);
}

static inline void vn_replace_vkCmdSetStencilOp_args_handle(struct vn_command_vkCmdSetStencilOp *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    /* skip args->faceMask */
    /* skip args->failOp */
    /* skip args->passOp */
    /* skip args->depthFailOp */
    /* skip args->compareOp */
}

static inline void vn_encode_vkCmdSetStencilOp_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdSetStencilOp *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdSetStencilOp_EXT});

    /* skip args->commandBuffer */
    /* skip args->faceMask */
    /* skip args->failOp */
    /* skip args->passOp */
    /* skip args->depthFailOp */
    /* skip args->compareOp */
}

static inline void vn_decode_vkCmdSetPatchControlPointsEXT_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdSetPatchControlPointsEXT *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_uint32_t(dec, &args->patchControlPoints);
}

static inline void vn_replace_vkCmdSetPatchControlPointsEXT_args_handle(struct vn_command_vkCmdSetPatchControlPointsEXT *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    /* skip args->patchControlPoints */
}

static inline void vn_encode_vkCmdSetPatchControlPointsEXT_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdSetPatchControlPointsEXT *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdSetPatchControlPointsEXT_EXT});

    /* skip args->commandBuffer */
    /* skip args->patchControlPoints */
}

static inline void vn_decode_vkCmdSetRasterizerDiscardEnable_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdSetRasterizerDiscardEnable *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_VkBool32(dec, &args->rasterizerDiscardEnable);
}

static inline void vn_replace_vkCmdSetRasterizerDiscardEnable_args_handle(struct vn_command_vkCmdSetRasterizerDiscardEnable *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    /* skip args->rasterizerDiscardEnable */
}

static inline void vn_encode_vkCmdSetRasterizerDiscardEnable_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdSetRasterizerDiscardEnable *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdSetRasterizerDiscardEnable_EXT});

    /* skip args->commandBuffer */
    /* skip args->rasterizerDiscardEnable */
}

static inline void vn_decode_vkCmdSetDepthBiasEnable_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdSetDepthBiasEnable *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_VkBool32(dec, &args->depthBiasEnable);
}

static inline void vn_replace_vkCmdSetDepthBiasEnable_args_handle(struct vn_command_vkCmdSetDepthBiasEnable *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    /* skip args->depthBiasEnable */
}

static inline void vn_encode_vkCmdSetDepthBiasEnable_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdSetDepthBiasEnable *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdSetDepthBiasEnable_EXT});

    /* skip args->commandBuffer */
    /* skip args->depthBiasEnable */
}

static inline void vn_decode_vkCmdSetLogicOpEXT_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdSetLogicOpEXT *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_VkLogicOp(dec, &args->logicOp);
}

static inline void vn_replace_vkCmdSetLogicOpEXT_args_handle(struct vn_command_vkCmdSetLogicOpEXT *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    /* skip args->logicOp */
}

static inline void vn_encode_vkCmdSetLogicOpEXT_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdSetLogicOpEXT *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdSetLogicOpEXT_EXT});

    /* skip args->commandBuffer */
    /* skip args->logicOp */
}

static inline void vn_decode_vkCmdSetPrimitiveRestartEnable_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdSetPrimitiveRestartEnable *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_VkBool32(dec, &args->primitiveRestartEnable);
}

static inline void vn_replace_vkCmdSetPrimitiveRestartEnable_args_handle(struct vn_command_vkCmdSetPrimitiveRestartEnable *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    /* skip args->primitiveRestartEnable */
}

static inline void vn_encode_vkCmdSetPrimitiveRestartEnable_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdSetPrimitiveRestartEnable *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdSetPrimitiveRestartEnable_EXT});

    /* skip args->commandBuffer */
    /* skip args->primitiveRestartEnable */
}

static inline void vn_decode_vkCmdCopyBuffer2_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdCopyBuffer2 *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    if (vn_decode_simple_pointer(dec)) {
        args->pCopyBufferInfo = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pCopyBufferInfo));
        if (!args->pCopyBufferInfo) return;
        vn_decode_VkCopyBufferInfo2_temp(dec, (VkCopyBufferInfo2 *)args->pCopyBufferInfo);
    } else {
        args->pCopyBufferInfo = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
}

static inline void vn_replace_vkCmdCopyBuffer2_args_handle(struct vn_command_vkCmdCopyBuffer2 *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    if (args->pCopyBufferInfo)
        vn_replace_VkCopyBufferInfo2_handle((VkCopyBufferInfo2 *)args->pCopyBufferInfo);
}

static inline void vn_encode_vkCmdCopyBuffer2_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdCopyBuffer2 *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdCopyBuffer2_EXT});

    /* skip args->commandBuffer */
    /* skip args->pCopyBufferInfo */
}

static inline void vn_decode_vkCmdCopyImage2_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdCopyImage2 *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    if (vn_decode_simple_pointer(dec)) {
        args->pCopyImageInfo = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pCopyImageInfo));
        if (!args->pCopyImageInfo) return;
        vn_decode_VkCopyImageInfo2_temp(dec, (VkCopyImageInfo2 *)args->pCopyImageInfo);
    } else {
        args->pCopyImageInfo = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
}

static inline void vn_replace_vkCmdCopyImage2_args_handle(struct vn_command_vkCmdCopyImage2 *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    if (args->pCopyImageInfo)
        vn_replace_VkCopyImageInfo2_handle((VkCopyImageInfo2 *)args->pCopyImageInfo);
}

static inline void vn_encode_vkCmdCopyImage2_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdCopyImage2 *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdCopyImage2_EXT});

    /* skip args->commandBuffer */
    /* skip args->pCopyImageInfo */
}

static inline void vn_decode_vkCmdBlitImage2_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdBlitImage2 *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    if (vn_decode_simple_pointer(dec)) {
        args->pBlitImageInfo = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pBlitImageInfo));
        if (!args->pBlitImageInfo) return;
        vn_decode_VkBlitImageInfo2_temp(dec, (VkBlitImageInfo2 *)args->pBlitImageInfo);
    } else {
        args->pBlitImageInfo = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
}

static inline void vn_replace_vkCmdBlitImage2_args_handle(struct vn_command_vkCmdBlitImage2 *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    if (args->pBlitImageInfo)
        vn_replace_VkBlitImageInfo2_handle((VkBlitImageInfo2 *)args->pBlitImageInfo);
}

static inline void vn_encode_vkCmdBlitImage2_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdBlitImage2 *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdBlitImage2_EXT});

    /* skip args->commandBuffer */
    /* skip args->pBlitImageInfo */
}

static inline void vn_decode_vkCmdCopyBufferToImage2_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdCopyBufferToImage2 *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    if (vn_decode_simple_pointer(dec)) {
        args->pCopyBufferToImageInfo = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pCopyBufferToImageInfo));
        if (!args->pCopyBufferToImageInfo) return;
        vn_decode_VkCopyBufferToImageInfo2_temp(dec, (VkCopyBufferToImageInfo2 *)args->pCopyBufferToImageInfo);
    } else {
        args->pCopyBufferToImageInfo = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
}

static inline void vn_replace_vkCmdCopyBufferToImage2_args_handle(struct vn_command_vkCmdCopyBufferToImage2 *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    if (args->pCopyBufferToImageInfo)
        vn_replace_VkCopyBufferToImageInfo2_handle((VkCopyBufferToImageInfo2 *)args->pCopyBufferToImageInfo);
}

static inline void vn_encode_vkCmdCopyBufferToImage2_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdCopyBufferToImage2 *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdCopyBufferToImage2_EXT});

    /* skip args->commandBuffer */
    /* skip args->pCopyBufferToImageInfo */
}

static inline void vn_decode_vkCmdCopyImageToBuffer2_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdCopyImageToBuffer2 *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    if (vn_decode_simple_pointer(dec)) {
        args->pCopyImageToBufferInfo = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pCopyImageToBufferInfo));
        if (!args->pCopyImageToBufferInfo) return;
        vn_decode_VkCopyImageToBufferInfo2_temp(dec, (VkCopyImageToBufferInfo2 *)args->pCopyImageToBufferInfo);
    } else {
        args->pCopyImageToBufferInfo = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
}

static inline void vn_replace_vkCmdCopyImageToBuffer2_args_handle(struct vn_command_vkCmdCopyImageToBuffer2 *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    if (args->pCopyImageToBufferInfo)
        vn_replace_VkCopyImageToBufferInfo2_handle((VkCopyImageToBufferInfo2 *)args->pCopyImageToBufferInfo);
}

static inline void vn_encode_vkCmdCopyImageToBuffer2_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdCopyImageToBuffer2 *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdCopyImageToBuffer2_EXT});

    /* skip args->commandBuffer */
    /* skip args->pCopyImageToBufferInfo */
}

static inline void vn_decode_vkCmdResolveImage2_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdResolveImage2 *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    if (vn_decode_simple_pointer(dec)) {
        args->pResolveImageInfo = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pResolveImageInfo));
        if (!args->pResolveImageInfo) return;
        vn_decode_VkResolveImageInfo2_temp(dec, (VkResolveImageInfo2 *)args->pResolveImageInfo);
    } else {
        args->pResolveImageInfo = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
}

static inline void vn_replace_vkCmdResolveImage2_args_handle(struct vn_command_vkCmdResolveImage2 *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    if (args->pResolveImageInfo)
        vn_replace_VkResolveImageInfo2_handle((VkResolveImageInfo2 *)args->pResolveImageInfo);
}

static inline void vn_encode_vkCmdResolveImage2_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdResolveImage2 *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdResolveImage2_EXT});

    /* skip args->commandBuffer */
    /* skip args->pResolveImageInfo */
}

static inline void vn_decode_vkCmdSetEvent2_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdSetEvent2 *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_VkEvent_lookup(dec, &args->event);
    if (vn_decode_simple_pointer(dec)) {
        args->pDependencyInfo = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pDependencyInfo));
        if (!args->pDependencyInfo) return;
        vn_decode_VkDependencyInfo_temp(dec, (VkDependencyInfo *)args->pDependencyInfo);
    } else {
        args->pDependencyInfo = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
}

static inline void vn_replace_vkCmdSetEvent2_args_handle(struct vn_command_vkCmdSetEvent2 *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    vn_replace_VkEvent_handle(&args->event);
    if (args->pDependencyInfo)
        vn_replace_VkDependencyInfo_handle((VkDependencyInfo *)args->pDependencyInfo);
}

static inline void vn_encode_vkCmdSetEvent2_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdSetEvent2 *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdSetEvent2_EXT});

    /* skip args->commandBuffer */
    /* skip args->event */
    /* skip args->pDependencyInfo */
}

static inline void vn_decode_vkCmdResetEvent2_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdResetEvent2 *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_VkEvent_lookup(dec, &args->event);
    vn_decode_VkFlags64(dec, &args->stageMask);
}

static inline void vn_replace_vkCmdResetEvent2_args_handle(struct vn_command_vkCmdResetEvent2 *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    vn_replace_VkEvent_handle(&args->event);
    /* skip args->stageMask */
}

static inline void vn_encode_vkCmdResetEvent2_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdResetEvent2 *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdResetEvent2_EXT});

    /* skip args->commandBuffer */
    /* skip args->event */
    /* skip args->stageMask */
}

static inline void vn_decode_vkCmdWaitEvents2_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdWaitEvents2 *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_uint32_t(dec, &args->eventCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, args->eventCount);
        args->pEvents = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pEvents) * iter_count);
        if (!args->pEvents) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkEvent_lookup(dec, &((VkEvent *)args->pEvents)[i]);
    } else {
        vn_decode_array_size(dec, args->eventCount);
        args->pEvents = NULL;
    }
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, args->eventCount);
        args->pDependencyInfos = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pDependencyInfos) * iter_count);
        if (!args->pDependencyInfos) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkDependencyInfo_temp(dec, &((VkDependencyInfo *)args->pDependencyInfos)[i]);
    } else {
        vn_decode_array_size(dec, args->eventCount);
        args->pDependencyInfos = NULL;
    }
}

static inline void vn_replace_vkCmdWaitEvents2_args_handle(struct vn_command_vkCmdWaitEvents2 *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    /* skip args->eventCount */
    if (args->pEvents) {
       for (uint32_t i = 0; i < args->eventCount; i++)
            vn_replace_VkEvent_handle(&((VkEvent *)args->pEvents)[i]);
    }
    if (args->pDependencyInfos) {
       for (uint32_t i = 0; i < args->eventCount; i++)
            vn_replace_VkDependencyInfo_handle(&((VkDependencyInfo *)args->pDependencyInfos)[i]);
    }
}

static inline void vn_encode_vkCmdWaitEvents2_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdWaitEvents2 *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdWaitEvents2_EXT});

    /* skip args->commandBuffer */
    /* skip args->eventCount */
    /* skip args->pEvents */
    /* skip args->pDependencyInfos */
}

static inline void vn_decode_vkCmdPipelineBarrier2_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdPipelineBarrier2 *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    if (vn_decode_simple_pointer(dec)) {
        args->pDependencyInfo = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pDependencyInfo));
        if (!args->pDependencyInfo) return;
        vn_decode_VkDependencyInfo_temp(dec, (VkDependencyInfo *)args->pDependencyInfo);
    } else {
        args->pDependencyInfo = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
}

static inline void vn_replace_vkCmdPipelineBarrier2_args_handle(struct vn_command_vkCmdPipelineBarrier2 *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    if (args->pDependencyInfo)
        vn_replace_VkDependencyInfo_handle((VkDependencyInfo *)args->pDependencyInfo);
}

static inline void vn_encode_vkCmdPipelineBarrier2_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdPipelineBarrier2 *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdPipelineBarrier2_EXT});

    /* skip args->commandBuffer */
    /* skip args->pDependencyInfo */
}

static inline void vn_decode_vkCmdWriteTimestamp2_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdWriteTimestamp2 *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    vn_decode_VkFlags64(dec, &args->stage);
    vn_decode_VkQueryPool_lookup(dec, &args->queryPool);
    vn_decode_uint32_t(dec, &args->query);
}

static inline void vn_replace_vkCmdWriteTimestamp2_args_handle(struct vn_command_vkCmdWriteTimestamp2 *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    /* skip args->stage */
    vn_replace_VkQueryPool_handle(&args->queryPool);
    /* skip args->query */
}

static inline void vn_encode_vkCmdWriteTimestamp2_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdWriteTimestamp2 *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdWriteTimestamp2_EXT});

    /* skip args->commandBuffer */
    /* skip args->stage */
    /* skip args->queryPool */
    /* skip args->query */
}

static inline void vn_decode_vkCmdBeginRendering_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdBeginRendering *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
    if (vn_decode_simple_pointer(dec)) {
        args->pRenderingInfo = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pRenderingInfo));
        if (!args->pRenderingInfo) return;
        vn_decode_VkRenderingInfo_temp(dec, (VkRenderingInfo *)args->pRenderingInfo);
    } else {
        args->pRenderingInfo = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
}

static inline void vn_replace_vkCmdBeginRendering_args_handle(struct vn_command_vkCmdBeginRendering *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
    if (args->pRenderingInfo)
        vn_replace_VkRenderingInfo_handle((VkRenderingInfo *)args->pRenderingInfo);
}

static inline void vn_encode_vkCmdBeginRendering_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdBeginRendering *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdBeginRendering_EXT});

    /* skip args->commandBuffer */
    /* skip args->pRenderingInfo */
}

static inline void vn_decode_vkCmdEndRendering_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCmdEndRendering *args)
{
    vn_decode_VkCommandBuffer_lookup(dec, &args->commandBuffer);
}

static inline void vn_replace_vkCmdEndRendering_args_handle(struct vn_command_vkCmdEndRendering *args)
{
    vn_replace_VkCommandBuffer_handle(&args->commandBuffer);
}

static inline void vn_encode_vkCmdEndRendering_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCmdEndRendering *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCmdEndRendering_EXT});

    /* skip args->commandBuffer */
}

static inline void vn_dispatch_vkAllocateCommandBuffers(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkAllocateCommandBuffers args;

    if (!ctx->dispatch_vkAllocateCommandBuffers) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkAllocateCommandBuffers_args_temp(ctx->decoder, &args);
    if (!args.device) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkAllocateCommandBuffers(ctx, &args);

#ifdef DEBUG
    if (!vn_cs_decoder_get_fatal(ctx->decoder) && vn_dispatch_should_log_result(args.ret))
        vn_dispatch_debug_log(ctx, "vkAllocateCommandBuffers returned %d", args.ret);
#endif

    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkAllocateCommandBuffers_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkFreeCommandBuffers(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkFreeCommandBuffers args;

    if (!ctx->dispatch_vkFreeCommandBuffers) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkFreeCommandBuffers_args_temp(ctx->decoder, &args);
    if (!args.device) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkFreeCommandBuffers(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkFreeCommandBuffers_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkBeginCommandBuffer(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkBeginCommandBuffer args;

    if (!ctx->dispatch_vkBeginCommandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkBeginCommandBuffer_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkBeginCommandBuffer(ctx, &args);

#ifdef DEBUG
    if (!vn_cs_decoder_get_fatal(ctx->decoder) && vn_dispatch_should_log_result(args.ret))
        vn_dispatch_debug_log(ctx, "vkBeginCommandBuffer returned %d", args.ret);
#endif

    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkBeginCommandBuffer_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkEndCommandBuffer(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkEndCommandBuffer args;

    if (!ctx->dispatch_vkEndCommandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkEndCommandBuffer_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkEndCommandBuffer(ctx, &args);

#ifdef DEBUG
    if (!vn_cs_decoder_get_fatal(ctx->decoder) && vn_dispatch_should_log_result(args.ret))
        vn_dispatch_debug_log(ctx, "vkEndCommandBuffer returned %d", args.ret);
#endif

    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkEndCommandBuffer_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkResetCommandBuffer(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkResetCommandBuffer args;

    if (!ctx->dispatch_vkResetCommandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkResetCommandBuffer_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkResetCommandBuffer(ctx, &args);

#ifdef DEBUG
    if (!vn_cs_decoder_get_fatal(ctx->decoder) && vn_dispatch_should_log_result(args.ret))
        vn_dispatch_debug_log(ctx, "vkResetCommandBuffer returned %d", args.ret);
#endif

    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkResetCommandBuffer_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdBindPipeline(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdBindPipeline args;

    if (!ctx->dispatch_vkCmdBindPipeline) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdBindPipeline_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdBindPipeline(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdBindPipeline_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdSetViewport(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdSetViewport args;

    if (!ctx->dispatch_vkCmdSetViewport) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdSetViewport_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdSetViewport(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdSetViewport_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdSetScissor(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdSetScissor args;

    if (!ctx->dispatch_vkCmdSetScissor) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdSetScissor_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdSetScissor(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdSetScissor_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdSetLineWidth(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdSetLineWidth args;

    if (!ctx->dispatch_vkCmdSetLineWidth) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdSetLineWidth_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdSetLineWidth(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdSetLineWidth_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdSetDepthBias(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdSetDepthBias args;

    if (!ctx->dispatch_vkCmdSetDepthBias) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdSetDepthBias_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdSetDepthBias(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdSetDepthBias_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdSetBlendConstants(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdSetBlendConstants args;

    if (!ctx->dispatch_vkCmdSetBlendConstants) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdSetBlendConstants_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdSetBlendConstants(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdSetBlendConstants_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdSetDepthBounds(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdSetDepthBounds args;

    if (!ctx->dispatch_vkCmdSetDepthBounds) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdSetDepthBounds_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdSetDepthBounds(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdSetDepthBounds_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdSetStencilCompareMask(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdSetStencilCompareMask args;

    if (!ctx->dispatch_vkCmdSetStencilCompareMask) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdSetStencilCompareMask_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdSetStencilCompareMask(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdSetStencilCompareMask_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdSetStencilWriteMask(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdSetStencilWriteMask args;

    if (!ctx->dispatch_vkCmdSetStencilWriteMask) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdSetStencilWriteMask_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdSetStencilWriteMask(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdSetStencilWriteMask_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdSetStencilReference(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdSetStencilReference args;

    if (!ctx->dispatch_vkCmdSetStencilReference) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdSetStencilReference_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdSetStencilReference(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdSetStencilReference_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdBindDescriptorSets(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdBindDescriptorSets args;

    if (!ctx->dispatch_vkCmdBindDescriptorSets) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdBindDescriptorSets_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdBindDescriptorSets(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdBindDescriptorSets_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdBindIndexBuffer(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdBindIndexBuffer args;

    if (!ctx->dispatch_vkCmdBindIndexBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdBindIndexBuffer_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdBindIndexBuffer(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdBindIndexBuffer_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdBindVertexBuffers(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdBindVertexBuffers args;

    if (!ctx->dispatch_vkCmdBindVertexBuffers) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdBindVertexBuffers_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdBindVertexBuffers(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdBindVertexBuffers_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdDraw(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdDraw args;

    if (!ctx->dispatch_vkCmdDraw) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdDraw_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdDraw(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdDraw_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdDrawIndexed(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdDrawIndexed args;

    if (!ctx->dispatch_vkCmdDrawIndexed) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdDrawIndexed_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdDrawIndexed(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdDrawIndexed_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdDrawMultiEXT(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdDrawMultiEXT args;

    if (!ctx->dispatch_vkCmdDrawMultiEXT) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdDrawMultiEXT_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdDrawMultiEXT(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdDrawMultiEXT_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdDrawMultiIndexedEXT(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdDrawMultiIndexedEXT args;

    if (!ctx->dispatch_vkCmdDrawMultiIndexedEXT) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdDrawMultiIndexedEXT_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdDrawMultiIndexedEXT(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdDrawMultiIndexedEXT_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdDrawIndirect(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdDrawIndirect args;

    if (!ctx->dispatch_vkCmdDrawIndirect) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdDrawIndirect_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdDrawIndirect(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdDrawIndirect_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdDrawIndexedIndirect(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdDrawIndexedIndirect args;

    if (!ctx->dispatch_vkCmdDrawIndexedIndirect) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdDrawIndexedIndirect_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdDrawIndexedIndirect(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdDrawIndexedIndirect_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdDispatch(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdDispatch args;

    if (!ctx->dispatch_vkCmdDispatch) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdDispatch_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdDispatch(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdDispatch_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdDispatchIndirect(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdDispatchIndirect args;

    if (!ctx->dispatch_vkCmdDispatchIndirect) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdDispatchIndirect_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdDispatchIndirect(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdDispatchIndirect_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdCopyBuffer(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdCopyBuffer args;

    if (!ctx->dispatch_vkCmdCopyBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdCopyBuffer_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdCopyBuffer(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdCopyBuffer_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdCopyImage(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdCopyImage args;

    if (!ctx->dispatch_vkCmdCopyImage) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdCopyImage_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdCopyImage(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdCopyImage_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdBlitImage(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdBlitImage args;

    if (!ctx->dispatch_vkCmdBlitImage) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdBlitImage_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdBlitImage(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdBlitImage_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdCopyBufferToImage(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdCopyBufferToImage args;

    if (!ctx->dispatch_vkCmdCopyBufferToImage) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdCopyBufferToImage_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdCopyBufferToImage(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdCopyBufferToImage_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdCopyImageToBuffer(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdCopyImageToBuffer args;

    if (!ctx->dispatch_vkCmdCopyImageToBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdCopyImageToBuffer_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdCopyImageToBuffer(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdCopyImageToBuffer_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdUpdateBuffer(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdUpdateBuffer args;

    if (!ctx->dispatch_vkCmdUpdateBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdUpdateBuffer_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdUpdateBuffer(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdUpdateBuffer_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdFillBuffer(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdFillBuffer args;

    if (!ctx->dispatch_vkCmdFillBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdFillBuffer_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdFillBuffer(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdFillBuffer_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdClearColorImage(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdClearColorImage args;

    if (!ctx->dispatch_vkCmdClearColorImage) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdClearColorImage_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdClearColorImage(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdClearColorImage_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdClearDepthStencilImage(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdClearDepthStencilImage args;

    if (!ctx->dispatch_vkCmdClearDepthStencilImage) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdClearDepthStencilImage_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdClearDepthStencilImage(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdClearDepthStencilImage_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdClearAttachments(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdClearAttachments args;

    if (!ctx->dispatch_vkCmdClearAttachments) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdClearAttachments_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdClearAttachments(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdClearAttachments_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdResolveImage(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdResolveImage args;

    if (!ctx->dispatch_vkCmdResolveImage) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdResolveImage_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdResolveImage(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdResolveImage_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdSetEvent(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdSetEvent args;

    if (!ctx->dispatch_vkCmdSetEvent) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdSetEvent_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdSetEvent(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdSetEvent_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdResetEvent(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdResetEvent args;

    if (!ctx->dispatch_vkCmdResetEvent) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdResetEvent_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdResetEvent(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdResetEvent_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdWaitEvents(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdWaitEvents args;

    if (!ctx->dispatch_vkCmdWaitEvents) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdWaitEvents_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdWaitEvents(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdWaitEvents_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdPipelineBarrier(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdPipelineBarrier args;

    if (!ctx->dispatch_vkCmdPipelineBarrier) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdPipelineBarrier_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdPipelineBarrier(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdPipelineBarrier_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdBeginQuery(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdBeginQuery args;

    if (!ctx->dispatch_vkCmdBeginQuery) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdBeginQuery_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdBeginQuery(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdBeginQuery_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdEndQuery(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdEndQuery args;

    if (!ctx->dispatch_vkCmdEndQuery) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdEndQuery_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdEndQuery(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdEndQuery_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdBeginConditionalRenderingEXT(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdBeginConditionalRenderingEXT args;

    if (!ctx->dispatch_vkCmdBeginConditionalRenderingEXT) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdBeginConditionalRenderingEXT_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdBeginConditionalRenderingEXT(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdBeginConditionalRenderingEXT_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdEndConditionalRenderingEXT(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdEndConditionalRenderingEXT args;

    if (!ctx->dispatch_vkCmdEndConditionalRenderingEXT) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdEndConditionalRenderingEXT_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdEndConditionalRenderingEXT(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdEndConditionalRenderingEXT_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdResetQueryPool(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdResetQueryPool args;

    if (!ctx->dispatch_vkCmdResetQueryPool) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdResetQueryPool_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdResetQueryPool(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdResetQueryPool_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdWriteTimestamp(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdWriteTimestamp args;

    if (!ctx->dispatch_vkCmdWriteTimestamp) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdWriteTimestamp_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdWriteTimestamp(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdWriteTimestamp_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdCopyQueryPoolResults(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdCopyQueryPoolResults args;

    if (!ctx->dispatch_vkCmdCopyQueryPoolResults) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdCopyQueryPoolResults_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdCopyQueryPoolResults(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdCopyQueryPoolResults_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdPushConstants(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdPushConstants args;

    if (!ctx->dispatch_vkCmdPushConstants) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdPushConstants_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdPushConstants(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdPushConstants_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdBeginRenderPass(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdBeginRenderPass args;

    if (!ctx->dispatch_vkCmdBeginRenderPass) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdBeginRenderPass_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdBeginRenderPass(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdBeginRenderPass_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdNextSubpass(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdNextSubpass args;

    if (!ctx->dispatch_vkCmdNextSubpass) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdNextSubpass_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdNextSubpass(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdNextSubpass_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdEndRenderPass(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdEndRenderPass args;

    if (!ctx->dispatch_vkCmdEndRenderPass) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdEndRenderPass_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdEndRenderPass(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdEndRenderPass_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdExecuteCommands(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdExecuteCommands args;

    if (!ctx->dispatch_vkCmdExecuteCommands) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdExecuteCommands_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdExecuteCommands(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdExecuteCommands_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdSetDeviceMask(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdSetDeviceMask args;

    if (!ctx->dispatch_vkCmdSetDeviceMask) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdSetDeviceMask_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdSetDeviceMask(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdSetDeviceMask_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdDispatchBase(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdDispatchBase args;

    if (!ctx->dispatch_vkCmdDispatchBase) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdDispatchBase_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdDispatchBase(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdDispatchBase_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdBeginRenderPass2(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdBeginRenderPass2 args;

    if (!ctx->dispatch_vkCmdBeginRenderPass2) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdBeginRenderPass2_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdBeginRenderPass2(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdBeginRenderPass2_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdNextSubpass2(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdNextSubpass2 args;

    if (!ctx->dispatch_vkCmdNextSubpass2) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdNextSubpass2_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdNextSubpass2(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdNextSubpass2_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdEndRenderPass2(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdEndRenderPass2 args;

    if (!ctx->dispatch_vkCmdEndRenderPass2) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdEndRenderPass2_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdEndRenderPass2(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdEndRenderPass2_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdDrawIndirectCount(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdDrawIndirectCount args;

    if (!ctx->dispatch_vkCmdDrawIndirectCount) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdDrawIndirectCount_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdDrawIndirectCount(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdDrawIndirectCount_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdDrawIndexedIndirectCount(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdDrawIndexedIndirectCount args;

    if (!ctx->dispatch_vkCmdDrawIndexedIndirectCount) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdDrawIndexedIndirectCount_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdDrawIndexedIndirectCount(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdDrawIndexedIndirectCount_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdBindTransformFeedbackBuffersEXT(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdBindTransformFeedbackBuffersEXT args;

    if (!ctx->dispatch_vkCmdBindTransformFeedbackBuffersEXT) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdBindTransformFeedbackBuffersEXT_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdBindTransformFeedbackBuffersEXT(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdBindTransformFeedbackBuffersEXT_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdBeginTransformFeedbackEXT(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdBeginTransformFeedbackEXT args;

    if (!ctx->dispatch_vkCmdBeginTransformFeedbackEXT) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdBeginTransformFeedbackEXT_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdBeginTransformFeedbackEXT(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdBeginTransformFeedbackEXT_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdEndTransformFeedbackEXT(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdEndTransformFeedbackEXT args;

    if (!ctx->dispatch_vkCmdEndTransformFeedbackEXT) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdEndTransformFeedbackEXT_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdEndTransformFeedbackEXT(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdEndTransformFeedbackEXT_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdBeginQueryIndexedEXT(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdBeginQueryIndexedEXT args;

    if (!ctx->dispatch_vkCmdBeginQueryIndexedEXT) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdBeginQueryIndexedEXT_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdBeginQueryIndexedEXT(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdBeginQueryIndexedEXT_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdEndQueryIndexedEXT(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdEndQueryIndexedEXT args;

    if (!ctx->dispatch_vkCmdEndQueryIndexedEXT) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdEndQueryIndexedEXT_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdEndQueryIndexedEXT(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdEndQueryIndexedEXT_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdDrawIndirectByteCountEXT(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdDrawIndirectByteCountEXT args;

    if (!ctx->dispatch_vkCmdDrawIndirectByteCountEXT) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdDrawIndirectByteCountEXT_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdDrawIndirectByteCountEXT(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdDrawIndirectByteCountEXT_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdSetLineStippleEXT(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdSetLineStippleEXT args;

    if (!ctx->dispatch_vkCmdSetLineStippleEXT) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdSetLineStippleEXT_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdSetLineStippleEXT(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdSetLineStippleEXT_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdSetCullMode(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdSetCullMode args;

    if (!ctx->dispatch_vkCmdSetCullMode) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdSetCullMode_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdSetCullMode(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdSetCullMode_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdSetFrontFace(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdSetFrontFace args;

    if (!ctx->dispatch_vkCmdSetFrontFace) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdSetFrontFace_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdSetFrontFace(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdSetFrontFace_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdSetPrimitiveTopology(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdSetPrimitiveTopology args;

    if (!ctx->dispatch_vkCmdSetPrimitiveTopology) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdSetPrimitiveTopology_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdSetPrimitiveTopology(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdSetPrimitiveTopology_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdSetViewportWithCount(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdSetViewportWithCount args;

    if (!ctx->dispatch_vkCmdSetViewportWithCount) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdSetViewportWithCount_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdSetViewportWithCount(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdSetViewportWithCount_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdSetScissorWithCount(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdSetScissorWithCount args;

    if (!ctx->dispatch_vkCmdSetScissorWithCount) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdSetScissorWithCount_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdSetScissorWithCount(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdSetScissorWithCount_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdBindVertexBuffers2(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdBindVertexBuffers2 args;

    if (!ctx->dispatch_vkCmdBindVertexBuffers2) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdBindVertexBuffers2_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdBindVertexBuffers2(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdBindVertexBuffers2_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdSetDepthTestEnable(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdSetDepthTestEnable args;

    if (!ctx->dispatch_vkCmdSetDepthTestEnable) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdSetDepthTestEnable_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdSetDepthTestEnable(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdSetDepthTestEnable_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdSetDepthWriteEnable(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdSetDepthWriteEnable args;

    if (!ctx->dispatch_vkCmdSetDepthWriteEnable) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdSetDepthWriteEnable_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdSetDepthWriteEnable(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdSetDepthWriteEnable_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdSetDepthCompareOp(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdSetDepthCompareOp args;

    if (!ctx->dispatch_vkCmdSetDepthCompareOp) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdSetDepthCompareOp_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdSetDepthCompareOp(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdSetDepthCompareOp_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdSetDepthBoundsTestEnable(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdSetDepthBoundsTestEnable args;

    if (!ctx->dispatch_vkCmdSetDepthBoundsTestEnable) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdSetDepthBoundsTestEnable_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdSetDepthBoundsTestEnable(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdSetDepthBoundsTestEnable_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdSetStencilTestEnable(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdSetStencilTestEnable args;

    if (!ctx->dispatch_vkCmdSetStencilTestEnable) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdSetStencilTestEnable_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdSetStencilTestEnable(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdSetStencilTestEnable_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdSetStencilOp(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdSetStencilOp args;

    if (!ctx->dispatch_vkCmdSetStencilOp) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdSetStencilOp_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdSetStencilOp(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdSetStencilOp_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdSetPatchControlPointsEXT(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdSetPatchControlPointsEXT args;

    if (!ctx->dispatch_vkCmdSetPatchControlPointsEXT) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdSetPatchControlPointsEXT_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdSetPatchControlPointsEXT(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdSetPatchControlPointsEXT_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdSetRasterizerDiscardEnable(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdSetRasterizerDiscardEnable args;

    if (!ctx->dispatch_vkCmdSetRasterizerDiscardEnable) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdSetRasterizerDiscardEnable_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdSetRasterizerDiscardEnable(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdSetRasterizerDiscardEnable_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdSetDepthBiasEnable(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdSetDepthBiasEnable args;

    if (!ctx->dispatch_vkCmdSetDepthBiasEnable) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdSetDepthBiasEnable_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdSetDepthBiasEnable(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdSetDepthBiasEnable_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdSetLogicOpEXT(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdSetLogicOpEXT args;

    if (!ctx->dispatch_vkCmdSetLogicOpEXT) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdSetLogicOpEXT_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdSetLogicOpEXT(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdSetLogicOpEXT_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdSetPrimitiveRestartEnable(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdSetPrimitiveRestartEnable args;

    if (!ctx->dispatch_vkCmdSetPrimitiveRestartEnable) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdSetPrimitiveRestartEnable_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdSetPrimitiveRestartEnable(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdSetPrimitiveRestartEnable_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdCopyBuffer2(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdCopyBuffer2 args;

    if (!ctx->dispatch_vkCmdCopyBuffer2) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdCopyBuffer2_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdCopyBuffer2(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdCopyBuffer2_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdCopyImage2(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdCopyImage2 args;

    if (!ctx->dispatch_vkCmdCopyImage2) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdCopyImage2_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdCopyImage2(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdCopyImage2_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdBlitImage2(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdBlitImage2 args;

    if (!ctx->dispatch_vkCmdBlitImage2) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdBlitImage2_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdBlitImage2(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdBlitImage2_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdCopyBufferToImage2(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdCopyBufferToImage2 args;

    if (!ctx->dispatch_vkCmdCopyBufferToImage2) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdCopyBufferToImage2_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdCopyBufferToImage2(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdCopyBufferToImage2_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdCopyImageToBuffer2(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdCopyImageToBuffer2 args;

    if (!ctx->dispatch_vkCmdCopyImageToBuffer2) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdCopyImageToBuffer2_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdCopyImageToBuffer2(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdCopyImageToBuffer2_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdResolveImage2(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdResolveImage2 args;

    if (!ctx->dispatch_vkCmdResolveImage2) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdResolveImage2_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdResolveImage2(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdResolveImage2_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdSetEvent2(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdSetEvent2 args;

    if (!ctx->dispatch_vkCmdSetEvent2) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdSetEvent2_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdSetEvent2(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdSetEvent2_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdResetEvent2(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdResetEvent2 args;

    if (!ctx->dispatch_vkCmdResetEvent2) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdResetEvent2_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdResetEvent2(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdResetEvent2_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdWaitEvents2(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdWaitEvents2 args;

    if (!ctx->dispatch_vkCmdWaitEvents2) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdWaitEvents2_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdWaitEvents2(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdWaitEvents2_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdPipelineBarrier2(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdPipelineBarrier2 args;

    if (!ctx->dispatch_vkCmdPipelineBarrier2) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdPipelineBarrier2_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdPipelineBarrier2(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdPipelineBarrier2_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdWriteTimestamp2(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdWriteTimestamp2 args;

    if (!ctx->dispatch_vkCmdWriteTimestamp2) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdWriteTimestamp2_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdWriteTimestamp2(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdWriteTimestamp2_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdBeginRendering(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdBeginRendering args;

    if (!ctx->dispatch_vkCmdBeginRendering) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdBeginRendering_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdBeginRendering(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdBeginRendering_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCmdEndRendering(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCmdEndRendering args;

    if (!ctx->dispatch_vkCmdEndRendering) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCmdEndRendering_args_temp(ctx->decoder, &args);
    if (!args.commandBuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCmdEndRendering(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCmdEndRendering_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

#pragma GCC diagnostic pop

#endif /* VN_PROTOCOL_RENDERER_COMMAND_BUFFER_H */
