"""Generated message classes for cloudidentity version v1alpha1.

API for provisioning and managing identity resources.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'cloudidentity'


class AndroidAttributes(_messages.Message):
  r"""Resource representing the Android specific attributes of a Device.

  Enums:
    OwnershipPrivilegeValueValuesEnum: Ownership privileges on device.

  Fields:
    enabledUnknownSources: Whether applications from unknown sources can be
      installed on device.
    ownerProfileAccount: Whether this account is on an owner/primary profile.
      For phones, only true for owner profiles. Android 4+ devices can have
      secondary or restricted user profiles.
    ownershipPrivilege: Ownership privileges on device.
    supportsWorkProfile: Whether device supports Android work profiles. If
      false, this service will not block access to corp data even if an
      administrator turns on the "Enforce Work Profile" policy.
  """

  class OwnershipPrivilegeValueValuesEnum(_messages.Enum):
    r"""Ownership privileges on device.

    Values:
      OWNERSHIP_PRIVILEGE_UNSPECIFIED: Ownership privilege is not set.
      DEVICE_ADMINISTRATOR: Active device administrator privileges on the
        device.
      PROFILE_OWNER: Profile Owner privileges. The account is in a managed
        corporate profile.
      DEVICE_OWNER: Device Owner privileges on the device.
    """
    OWNERSHIP_PRIVILEGE_UNSPECIFIED = 0
    DEVICE_ADMINISTRATOR = 1
    PROFILE_OWNER = 2
    DEVICE_OWNER = 3

  enabledUnknownSources = _messages.BooleanField(1)
  ownerProfileAccount = _messages.BooleanField(2)
  ownershipPrivilege = _messages.EnumField('OwnershipPrivilegeValueValuesEnum', 3)
  supportsWorkProfile = _messages.BooleanField(4)


class ApproveDeviceUserResponse(_messages.Message):
  r"""Response message for approving the device to access user data.

  Fields:
    deviceUser: Resultant DeviceUser object for the action.
  """

  deviceUser = _messages.MessageField('DeviceUser', 1)


class BlockDeviceUserResponse(_messages.Message):
  r"""Response message for blocking the device from accessing user data.

  Fields:
    deviceUser: Resultant DeviceUser object for the action.
  """

  deviceUser = _messages.MessageField('DeviceUser', 1)


class CancelWipeDeviceResponse(_messages.Message):
  r"""Response message for cancelling an unfinished device wipe.

  Fields:
    device: Resultant Device object for the action. Note that asset tags will
      not be returned in the device object.
  """

  device = _messages.MessageField('Device', 1)


class CancelWipeDeviceUserResponse(_messages.Message):
  r"""Response message for cancelling an unfinished user account wipe.

  Fields:
    deviceUser: Resultant DeviceUser object for the action.
  """

  deviceUser = _messages.MessageField('DeviceUser', 1)


class ClientState(_messages.Message):
  r"""Resource representing ClientState and supports updates from API users

  Enums:
    ComplianceStateValueValuesEnum: The compliance state of the resource as
      specified by the API client.
    HealthScoreValueValuesEnum: The Health score of the resource
    ManagedValueValuesEnum: The management state of the resource as specified
      by the API client.
    OwnerTypeValueValuesEnum: Output only. The owner of the ClientState

  Messages:
    KeyValuePairsValue: The map of key-value attributes stored by callers
      specific to a device. The total serialized length of this map may not
      exceed 10KB. No limit is placed on the number of attributes in a map.

  Fields:
    assetTags: The caller can specify asset tags for this resource
    complianceState: The compliance state of the resource as specified by the
      API client.
    createTime: Output only. The time the client state data was created.
    customId: This field may be used to store a unique identifier for the API
      resource within which these CustomAttributes are a field.
    etag: The token that needs to be passed back for concurrency control in
      updates. Token needs to be passed back in UpdateRequest
    healthScore: The Health score of the resource
    keyValuePairs: The map of key-value attributes stored by callers specific
      to a device. The total serialized length of this map may not exceed
      10KB. No limit is placed on the number of attributes in a map.
    lastUpdateTime: Output only. The time the client state data was last
      updated.
    managed: The management state of the resource as specified by the API
      client.
    name: Output only. [Resource
      name](https://cloud.google.com/apis/design/resource_names) of the
      ClientState in format: `devices/{device_id}/deviceUsers/{device_user_id}
      /clientState/{partner_id}`, where partner_id corresponds to the partner
      storing the data.
    ownerType: Output only. The owner of the ClientState
    scoreReason: A descriptive cause of the health score.
  """

  class ComplianceStateValueValuesEnum(_messages.Enum):
    r"""The compliance state of the resource as specified by the API client.

    Values:
      COMPLIANCE_STATE_UNSPECIFIED: The compliance state of the resource is
        unknown or unspecified.
      COMPLIANT: Device is compliant with third party policies
      NON_COMPLIANT: Device is not compliant with third party policies
    """
    COMPLIANCE_STATE_UNSPECIFIED = 0
    COMPLIANT = 1
    NON_COMPLIANT = 2

  class HealthScoreValueValuesEnum(_messages.Enum):
    r"""The Health score of the resource

    Values:
      HEALTH_SCORE_UNSPECIFIED: Default value
      VERY_POOR: The object is in very poor health as defined by the caller.
      POOR: The object is in poor health as defined by the caller.
      NEUTRAL: The object health is neither good nor poor, as defined by the
        caller.
      GOOD: The object is in good health as defined by the caller.
      VERY_GOOD: The object is in very good health as defined by the caller.
    """
    HEALTH_SCORE_UNSPECIFIED = 0
    VERY_POOR = 1
    POOR = 2
    NEUTRAL = 3
    GOOD = 4
    VERY_GOOD = 5

  class ManagedValueValuesEnum(_messages.Enum):
    r"""The management state of the resource as specified by the API client.

    Values:
      MANAGED_STATE_UNSPECIFIED: The management state of the resource is
        unknown or unspecified.
      MANAGED: The resource is managed.
      UNMANAGED: The resource is not managed.
    """
    MANAGED_STATE_UNSPECIFIED = 0
    MANAGED = 1
    UNMANAGED = 2

  class OwnerTypeValueValuesEnum(_messages.Enum):
    r"""Output only. The owner of the ClientState

    Values:
      OWNER_TYPE_UNSPECIFIED: Unknown owner type
      OWNER_TYPE_CUSTOMER: Customer is the owner
      OWNER_TYPE_PARTNER: Partner is the owner
    """
    OWNER_TYPE_UNSPECIFIED = 0
    OWNER_TYPE_CUSTOMER = 1
    OWNER_TYPE_PARTNER = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class KeyValuePairsValue(_messages.Message):
    r"""The map of key-value attributes stored by callers specific to a
    device. The total serialized length of this map may not exceed 10KB. No
    limit is placed on the number of attributes in a map.

    Messages:
      AdditionalProperty: An additional property for a KeyValuePairsValue
        object.

    Fields:
      additionalProperties: Additional properties of type KeyValuePairsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a KeyValuePairsValue object.

      Fields:
        key: Name of the additional property.
        value: A CustomAttributeValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('CustomAttributeValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  assetTags = _messages.StringField(1, repeated=True)
  complianceState = _messages.EnumField('ComplianceStateValueValuesEnum', 2)
  createTime = _messages.StringField(3)
  customId = _messages.StringField(4)
  etag = _messages.StringField(5)
  healthScore = _messages.EnumField('HealthScoreValueValuesEnum', 6)
  keyValuePairs = _messages.MessageField('KeyValuePairsValue', 7)
  lastUpdateTime = _messages.StringField(8)
  managed = _messages.EnumField('ManagedValueValuesEnum', 9)
  name = _messages.StringField(10)
  ownerType = _messages.EnumField('OwnerTypeValueValuesEnum', 11)
  scoreReason = _messages.StringField(12)


class CloudidentityGroupsCreateRequest(_messages.Message):
  r"""A CloudidentityGroupsCreateRequest object.

  Enums:
    InitialGroupConfigValueValuesEnum: Required. The initial configuration
      option for the `Group`.

  Fields:
    group: A Group resource to be passed as the request body.
    initialGroupConfig: Required. The initial configuration option for the
      `Group`.
  """

  class InitialGroupConfigValueValuesEnum(_messages.Enum):
    r"""Required. The initial configuration option for the `Group`.

    Values:
      INITIAL_GROUP_CONFIG_UNSPECIFIED: <no description>
      WITH_INITIAL_OWNER: <no description>
    """
    INITIAL_GROUP_CONFIG_UNSPECIFIED = 0
    WITH_INITIAL_OWNER = 1

  group = _messages.MessageField('Group', 1)
  initialGroupConfig = _messages.EnumField('InitialGroupConfigValueValuesEnum', 2)


class CloudidentityGroupsDeleteRequest(_messages.Message):
  r"""A CloudidentityGroupsDeleteRequest object.

  Fields:
    name: Required. The [resource
      name](https://cloud.google.com/apis/design/resource_names) of the
      `Group` to retrieve.  Must be of the form `groups/{group_id}`.
  """

  name = _messages.StringField(1, required=True)


class CloudidentityGroupsGetRequest(_messages.Message):
  r"""A CloudidentityGroupsGetRequest object.

  Fields:
    name: Required. The [resource
      name](https://cloud.google.com/apis/design/resource_names) of the
      `Group` to retrieve.  Must be of the form `groups/{group_id}`.
  """

  name = _messages.StringField(1, required=True)


class CloudidentityGroupsListRequest(_messages.Message):
  r"""A CloudidentityGroupsListRequest object.

  Enums:
    ViewValueValuesEnum: The level of detail to be returned.  If unspecified,
      defaults to `View.BASIC`.

  Fields:
    pageSize: The maximum number of results to return.  Note that the number
      of results returned may be less than this value even if there are more
      available results. To fetch all results, clients must continue calling
      this method repeatedly until the response no longer contains a
      `next_page_token`.  If unspecified, defaults to 200 for `View.BASIC` and
      to 50 for `View.FULL`.  Must not be greater than 1000 for `View.BASIC`
      or 500 for `View.FULL`.
    pageToken: The `next_page_token` value returned from a previous list
      request, if any.
    parent: Required. The parent resource under which to list all `Group`s.
      Must be of the form `identitysources/{identity_source_id}` for external-
      identity-mapped groups or `customers/{customer_id}` for Google Groups.
    view: The level of detail to be returned.  If unspecified, defaults to
      `View.BASIC`.
  """

  class ViewValueValuesEnum(_messages.Enum):
    r"""The level of detail to be returned.  If unspecified, defaults to
    `View.BASIC`.

    Values:
      VIEW_UNSPECIFIED: <no description>
      BASIC: <no description>
      FULL: <no description>
    """
    VIEW_UNSPECIFIED = 0
    BASIC = 1
    FULL = 2

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3)
  view = _messages.EnumField('ViewValueValuesEnum', 4)


class CloudidentityGroupsLookupRequest(_messages.Message):
  r"""A CloudidentityGroupsLookupRequest object.

  Fields:
    groupKey_id: Required. The ID of the entity.  For Google-managed entities,
      the `id` must be the email address of an existing group or user.  For
      external-identity-mapped entities, the `id` must be a string conforming
      to the Identity Source's requirements.  Must be unique within a
      `namespace`.
    groupKey_namespace: The namespace in which the entity exists.  If not
      specified, the `EntityKey` represents a Google-managed entity such as a
      Google user or a Google Group.  If specified, the `EntityKey` represents
      an external-identity-mapped group. The namespace must correspond to an
      identity source created in Admin Console and must be in the form of
      `identitysources/{identity_source_id}.
  """

  groupKey_id = _messages.StringField(1)
  groupKey_namespace = _messages.StringField(2)


class CloudidentityGroupsMembershipsCreateRequest(_messages.Message):
  r"""A CloudidentityGroupsMembershipsCreateRequest object.

  Fields:
    membership: A Membership resource to be passed as the request body.
    parent: Required. The parent `Group` resource under which to create the
      `Membership`.  Must be of the form `groups/{group_id}`.
  """

  membership = _messages.MessageField('Membership', 1)
  parent = _messages.StringField(2, required=True)


class CloudidentityGroupsMembershipsDeleteRequest(_messages.Message):
  r"""A CloudidentityGroupsMembershipsDeleteRequest object.

  Fields:
    name: Required. The [resource
      name](https://cloud.google.com/apis/design/resource_names) of the
      `Membership` to delete.  Must be of the form
      `groups/{group_id}/memberships/{membership_id}`.
  """

  name = _messages.StringField(1, required=True)


class CloudidentityGroupsMembershipsGetRequest(_messages.Message):
  r"""A CloudidentityGroupsMembershipsGetRequest object.

  Fields:
    name: Required. The [resource
      name](https://cloud.google.com/apis/design/resource_names) of the
      `Membership` to retrieve.  Must be of the form
      `groups/{group_id}/memberships/{membership_id}`.
  """

  name = _messages.StringField(1, required=True)


class CloudidentityGroupsMembershipsListRequest(_messages.Message):
  r"""A CloudidentityGroupsMembershipsListRequest object.

  Enums:
    ViewValueValuesEnum: The level of detail to be returned.  If unspecified,
      defaults to `View.BASIC`.

  Fields:
    pageSize: The maximum number of results to return.  Note that the number
      of results returned may be less than this value even if there are more
      available results. To fetch all results, clients must continue calling
      this method repeatedly until the response no longer contains a
      `next_page_token`.  If unspecified, defaults to 200 for `View.BASIC` and
      to 50 for `View.FULL`.  Must not be greater than 1000 for `View.BASIC`
      or 500 for `View.FULL`.
    pageToken: The `next_page_token` value returned from a previous list
      request, if any.
    parent: Required. The parent `Group` resource under which to lookup the
      `Membership` name.  Must be of the form `groups/{group_id}`.
    view: The level of detail to be returned.  If unspecified, defaults to
      `View.BASIC`.
  """

  class ViewValueValuesEnum(_messages.Enum):
    r"""The level of detail to be returned.  If unspecified, defaults to
    `View.BASIC`.

    Values:
      VIEW_UNSPECIFIED: <no description>
      BASIC: <no description>
      FULL: <no description>
    """
    VIEW_UNSPECIFIED = 0
    BASIC = 1
    FULL = 2

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  view = _messages.EnumField('ViewValueValuesEnum', 4)


class CloudidentityGroupsMembershipsLookupRequest(_messages.Message):
  r"""A CloudidentityGroupsMembershipsLookupRequest object.

  Fields:
    memberKey_id: Required. The ID of the entity.  For Google-managed
      entities, the `id` must be the email address of an existing group or
      user.  For external-identity-mapped entities, the `id` must be a string
      conforming to the Identity Source's requirements.  Must be unique within
      a `namespace`.
    memberKey_namespace: The namespace in which the entity exists.  If not
      specified, the `EntityKey` represents a Google-managed entity such as a
      Google user or a Google Group.  If specified, the `EntityKey` represents
      an external-identity-mapped group. The namespace must correspond to an
      identity source created in Admin Console and must be in the form of
      `identitysources/{identity_source_id}.
    parent: Required. The parent `Group` resource under which to lookup the
      `Membership` name.  Must be of the form `groups/{group_id}`.
  """

  memberKey_id = _messages.StringField(1)
  memberKey_namespace = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class CloudidentityGroupsMembershipsModifyMembershipRolesRequest(_messages.Message):
  r"""A CloudidentityGroupsMembershipsModifyMembershipRolesRequest object.

  Fields:
    modifyMembershipRolesRequest: A ModifyMembershipRolesRequest resource to
      be passed as the request body.
    name: Required. The [resource
      name](https://cloud.google.com/apis/design/resource_names) of the
      `Membership` whose roles are to be modified.  Must be of the form
      `groups/{group_id}/memberships/{membership_id}`.
  """

  modifyMembershipRolesRequest = _messages.MessageField('ModifyMembershipRolesRequest', 1)
  name = _messages.StringField(2, required=True)


class CloudidentityGroupsMembershipsPatchRequest(_messages.Message):
  r"""A CloudidentityGroupsMembershipsPatchRequest object.

  Fields:
    membership: A Membership resource to be passed as the request body.
    name: Output only. The [resource
      name](https://cloud.google.com/apis/design/resource_names) of the
      `Membership`.  Shall be of the form
      `groups/{group_id}/memberships/{membership_id}`.
    updateMask: Required. The fully-qualified names of fields to update.
  """

  membership = _messages.MessageField('Membership', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class CloudidentityGroupsPatchRequest(_messages.Message):
  r"""A CloudidentityGroupsPatchRequest object.

  Fields:
    group: A Group resource to be passed as the request body.
    name: Output only. The [resource
      name](https://cloud.google.com/apis/design/resource_names) of the
      `Group`.  Shall be of the form `groups/{group_id}`.
    updateMask: Required. The fully-qualified names of fields to update.  May
      only contain the following fields: `display_name`, `description`.
  """

  group = _messages.MessageField('Group', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class CloudidentityGroupsSearchRequest(_messages.Message):
  r"""A CloudidentityGroupsSearchRequest object.

  Enums:
    ViewValueValuesEnum: The level of detail to be returned.  If unspecified,
      defaults to `View.BASIC`.

  Fields:
    pageSize: The maximum number of results to return.  Note that the number
      of results returned may be less than this value even if there are more
      available results. To fetch all results, clients must continue calling
      this method repeatedly until the response no longer contains a
      `next_page_token`.  If unspecified, defaults to 200 for `View.BASIC` and
      to 50 for `View.FULL`.  Must not be greater than 1000 for `View.BASIC`
      or 500 for `View.FULL`.
    pageToken: The `next_page_token` value returned from a previous search
      request, if any.
    query: Required. The search query.  Must be specified in [Common
      Expression Language](https://opensource.google/projects/cel). May only
      contain equality operators on the parent and inclusion operators on
      labels (e.g., `parent == 'customers/{customer_id}' &&
      'cloudidentity.googleapis.com/groups.discussion_forum' in labels`).
    view: The level of detail to be returned.  If unspecified, defaults to
      `View.BASIC`.
  """

  class ViewValueValuesEnum(_messages.Enum):
    r"""The level of detail to be returned.  If unspecified, defaults to
    `View.BASIC`.

    Values:
      VIEW_UNSPECIFIED: <no description>
      BASIC: <no description>
      FULL: <no description>
    """
    VIEW_UNSPECIFIED = 0
    BASIC = 1
    FULL = 2

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  query = _messages.StringField(3)
  view = _messages.EnumField('ViewValueValuesEnum', 4)


class CustomAttributeValue(_messages.Message):
  r"""Additional custom attribute values may be one of these types

  Fields:
    boolValue: Represents a boolean value.
    numberValue: Represents a double value.
    stringValue: Represents a string value.
  """

  boolValue = _messages.BooleanField(1)
  numberValue = _messages.FloatField(2)
  stringValue = _messages.StringField(3)


class Device(_messages.Message):
  r"""Represents a Device known to Google Cloud, independent of the device
  ownership, type, and whether it is assigned or in use by a user.

  Enums:
    CompromisedStateValueValuesEnum: Output only. Represents whether the
      Device is compromised.
    DeviceTypeValueValuesEnum: Output only. Type of device.
    EncryptionStateValueValuesEnum: Output only. Device encryption state.
    ManagementStateValueValuesEnum: Output only. Management state of the
      device
    OwnerTypeValueValuesEnum: Output only. Whether the device is owned by the
      company or an individual

  Fields:
    androidSpecificAttributes: Output only. Attributes specific to Android
      devices.
    assetTag: Asset tag of the device.
    basebandVersion: Output only. Baseband version of the device.
    bootloaderVersion: Output only. Device bootloader version. Example: 0.6.7.
    brand: Output only. Device brand. Example: Samsung.
    buildNumber: Output only. Build number of the device.
    compromisedState: Output only. Represents whether the Device is
      compromised.
    createTime: Output only. When the Company-Owned device was imported. This
      field is empty for BYOD devices.
    deviceType: Output only. Type of device.
    enabledDeveloperOptions: Output only. Whether developer options is enabled
      on device.
    enabledUsbDebugging: Output only. Whether USB debugging is enabled on
      device.
    encryptionState: Output only. Device encryption state.
    imei: Output only. IMEI number of device if GSM device; empty otherwise.
    kernelVersion: Output only. Kernel version of the device.
    lastSyncTime: Most recent time when device synced with this service.
    managementState: Output only. Management state of the device
    manufacturer: Output only. Device manufacturer. Example: Motorola.
    meid: Output only. MEID number of device if CDMA device; empty otherwise.
    model: Output only. Model name of device. Example: Pixel 3.
    name: Output only. [Resource
      name](https://cloud.google.com/apis/design/resource_names) of the Device
      in format: `devices/{device_id}`, where device_id is the unique id
      assigned to the Device.
    networkOperator: Output only. Mobile or network operator of device, if
      available.
    osVersion: Output only. OS version of the device. Example: Android 8.1.0.
    otherAccounts: Output only. Domain name for Google accounts on device.
      Type for other accounts on device. On Android, will only be populated if
      |ownership_privilege| is |PROFILE_OWNER| or |DEVICE_OWNER|. Does not
      include the account signed in to the device policy app if that account's
      domain has only one account. Examples: "com.example", "xyz.com".
    ownerType: Output only. Whether the device is owned by the company or an
      individual
    releaseVersion: Output only. OS release version. Example: 6.0.
    securityPatchTime: Output only. OS security patch update time on device.
    serialNumber: Serial Number of device. Example: HT82V1A01076.
    wifiMacAddresses: WiFi MAC addresses of device.
  """

  class CompromisedStateValueValuesEnum(_messages.Enum):
    r"""Output only. Represents whether the Device is compromised.

    Values:
      COMPROMISED_STATE_UNSPECIFIED: Default value.
      COMPROMISED: The device is compromised (currently, this means Android
        device is rooted).
      UNCOMPROMISED: The device is safe (currently, this means Android device
        is unrooted).
    """
    COMPROMISED_STATE_UNSPECIFIED = 0
    COMPROMISED = 1
    UNCOMPROMISED = 2

  class DeviceTypeValueValuesEnum(_messages.Enum):
    r"""Output only. Type of device.

    Values:
      DEVICE_TYPE_UNSPECIFIED: Unknown device type
      ANDROID: Device is an Android device
      IOS: Device is an iOS device
      GOOGLE_SYNC: Device is a Google Sync device.
      WINDOWS: Device is a Windows device.
      MAC_OS: Device is a MacOS device.
      LINUX: Device is a Linux device.
      CHROME_OS: Device is a ChromeOS device.
    """
    DEVICE_TYPE_UNSPECIFIED = 0
    ANDROID = 1
    IOS = 2
    GOOGLE_SYNC = 3
    WINDOWS = 4
    MAC_OS = 5
    LINUX = 6
    CHROME_OS = 7

  class EncryptionStateValueValuesEnum(_messages.Enum):
    r"""Output only. Device encryption state.

    Values:
      ENCRYPTION_STATE_UNSPECIFIED: Encryption Status is not set.
      UNSUPPORTED_BY_DEVICE: Device doesn't support encryption.
      ENCRYPTED: Device is encrypted.
      NOT_ENCRYPTED: Device is not encrypted.
    """
    ENCRYPTION_STATE_UNSPECIFIED = 0
    UNSUPPORTED_BY_DEVICE = 1
    ENCRYPTED = 2
    NOT_ENCRYPTED = 3

  class ManagementStateValueValuesEnum(_messages.Enum):
    r"""Output only. Management state of the device

    Values:
      MANAGEMENT_STATE_UNSPECIFIED: Default value. This value is unused.
      APPROVED: Device is approved.
      BLOCKED: Device is blocked.
      PENDING: Device is pending approval.
      UNPROVISIONED: The device is not provisioned. Device will start from
        this state until some action is taken (i.e. a user starts using the
        device).
      WIPING: Data and settings on the device are being removed.
      WIPED: All data and settings on the device are removed.
    """
    MANAGEMENT_STATE_UNSPECIFIED = 0
    APPROVED = 1
    BLOCKED = 2
    PENDING = 3
    UNPROVISIONED = 4
    WIPING = 5
    WIPED = 6

  class OwnerTypeValueValuesEnum(_messages.Enum):
    r"""Output only. Whether the device is owned by the company or an
    individual

    Values:
      DEVICE_OWNERSHIP_UNSPECIFIED: Default value. The value is unused.
      COMPANY: Company owns the device.
      BYOD: Bring Your Own Device (i.e. individual owns the device)
    """
    DEVICE_OWNERSHIP_UNSPECIFIED = 0
    COMPANY = 1
    BYOD = 2

  androidSpecificAttributes = _messages.MessageField('AndroidAttributes', 1)
  assetTag = _messages.StringField(2)
  basebandVersion = _messages.StringField(3)
  bootloaderVersion = _messages.StringField(4)
  brand = _messages.StringField(5)
  buildNumber = _messages.StringField(6)
  compromisedState = _messages.EnumField('CompromisedStateValueValuesEnum', 7)
  createTime = _messages.StringField(8)
  deviceType = _messages.EnumField('DeviceTypeValueValuesEnum', 9)
  enabledDeveloperOptions = _messages.BooleanField(10)
  enabledUsbDebugging = _messages.BooleanField(11)
  encryptionState = _messages.EnumField('EncryptionStateValueValuesEnum', 12)
  imei = _messages.StringField(13)
  kernelVersion = _messages.StringField(14)
  lastSyncTime = _messages.StringField(15)
  managementState = _messages.EnumField('ManagementStateValueValuesEnum', 16)
  manufacturer = _messages.StringField(17)
  meid = _messages.StringField(18)
  model = _messages.StringField(19)
  name = _messages.StringField(20)
  networkOperator = _messages.StringField(21)
  osVersion = _messages.StringField(22)
  otherAccounts = _messages.StringField(23, repeated=True)
  ownerType = _messages.EnumField('OwnerTypeValueValuesEnum', 24)
  releaseVersion = _messages.StringField(25)
  securityPatchTime = _messages.StringField(26)
  serialNumber = _messages.StringField(27)
  wifiMacAddresses = _messages.StringField(28, repeated=True)


class DeviceUser(_messages.Message):
  r"""A DeviceUser is a resource representing a user's use of a Device

  Enums:
    CompromisedStateValueValuesEnum: Compromised State of the DeviceUser
      object
    ManagementStateValueValuesEnum: Output only. Management state of the user
      on the device.
    PasswordStateValueValuesEnum: Password state of the DeviceUser object

  Fields:
    compromisedState: Compromised State of the DeviceUser object
    createTime: When the user first signed in to the device
    firstSyncTime: Output only. Most recent time when user registered with
      this service.
    languageCode: Output only. Default locale used on device, in IETF BCP-47
      format.
    lastSyncTime: Output only. Last time when user synced with policies.
    managementState: Output only. Management state of the user on the device.
    name: Output only. [Resource
      name](https://cloud.google.com/apis/design/resource_names) of the
      DeviceUser in format: `devices/{device_id}/deviceUsers/{user_id}`, where
      user_id is the ID of the user associated with the user session.
    passwordState: Password state of the DeviceUser object
    userAgent: Output only. User agent on the device for this specific user
    userEmail: Email address of the user registered on the device.
  """

  class CompromisedStateValueValuesEnum(_messages.Enum):
    r"""Compromised State of the DeviceUser object

    Values:
      COMPROMISED_STATE_UNSPECIFIED: Compromised state of Device User account
        is unknown or unspecified.
      COMPROMISED: Device User Account is compromised.
      NOT_COMPROMISED: Device User Account is not compromised.
    """
    COMPROMISED_STATE_UNSPECIFIED = 0
    COMPROMISED = 1
    NOT_COMPROMISED = 2

  class ManagementStateValueValuesEnum(_messages.Enum):
    r"""Output only. Management state of the user on the device.

    Values:
      MANAGEMENT_STATE_UNSPECIFIED: Default value. This value is unused.
      WIPING: This user's data and profile is being removed from the device.
      WIPED: This user's data and profile is removed from the device.
      APPROVED: User is approved to access data on the device.
      BLOCKED: User is blocked from accessing data on the device.
      PENDING_APPROVAL: User is awaiting approval.
      UNENROLLED: User is unenrolled from Advanced Windows Management, but the
        Windows account is still intact.
    """
    MANAGEMENT_STATE_UNSPECIFIED = 0
    WIPING = 1
    WIPED = 2
    APPROVED = 3
    BLOCKED = 4
    PENDING_APPROVAL = 5
    UNENROLLED = 6

  class PasswordStateValueValuesEnum(_messages.Enum):
    r"""Password state of the DeviceUser object

    Values:
      PASSWORD_STATE_UNSPECIFIED: Password state not set.
      PASSWORD_SET: Password set in object.
      PASSWORD_NOT_SET: Password not set in object.
    """
    PASSWORD_STATE_UNSPECIFIED = 0
    PASSWORD_SET = 1
    PASSWORD_NOT_SET = 2

  compromisedState = _messages.EnumField('CompromisedStateValueValuesEnum', 1)
  createTime = _messages.StringField(2)
  firstSyncTime = _messages.StringField(3)
  languageCode = _messages.StringField(4)
  lastSyncTime = _messages.StringField(5)
  managementState = _messages.EnumField('ManagementStateValueValuesEnum', 6)
  name = _messages.StringField(7)
  passwordState = _messages.EnumField('PasswordStateValueValuesEnum', 8)
  userAgent = _messages.StringField(9)
  userEmail = _messages.StringField(10)


class DynamicGroupMetadata(_messages.Message):
  r"""Dynamic group metadata like queries and status.

  Fields:
    queries: Only one entry is supported for now. Memberships will be the
      union of all queries.
    status: Status of the dynamic group. Output only.
  """

  queries = _messages.MessageField('DynamicGroupQuery', 1, repeated=True)
  status = _messages.MessageField('DynamicGroupStatus', 2)


class DynamicGroupQuery(_messages.Message):
  r"""Defines a query on a resource.

  Enums:
    ResourceTypeValueValuesEnum:

  Fields:
    query: Query that determines the memberships of the dynamic group.
    resourceType: A ResourceTypeValueValuesEnum attribute.
  """

  class ResourceTypeValueValuesEnum(_messages.Enum):
    r"""ResourceTypeValueValuesEnum enum type.

    Values:
      RESOURCE_TYPE_UNSPECIFIED: Default value (not valid)
      USER: For queries on User
    """
    RESOURCE_TYPE_UNSPECIFIED = 0
    USER = 1

  query = _messages.StringField(1)
  resourceType = _messages.EnumField('ResourceTypeValueValuesEnum', 2)


class DynamicGroupStatus(_messages.Message):
  r"""The current status of a dynamic group along with timestamp.

  Enums:
    StatusValueValuesEnum: Status of the dynamic group.

  Fields:
    status: Status of the dynamic group.
    statusTime: The latest time at which the dynamic group is guaranteed to be
      in the given status. For example, if status is: UP_TO_DATE - The latest
      time at which this dynamic group was confirmed to be up to date.
      UPDATING_MEMBERSHIPS - The time at which dynamic group was created.
  """

  class StatusValueValuesEnum(_messages.Enum):
    r"""Status of the dynamic group.

    Values:
      STATUS_UNSPECIFIED: Default.
      UP_TO_DATE: The dynamic group is up-to-date.
      UPDATING_MEMBERSHIPS: The dynamic group has just been created and
        memberships are being updated.
    """
    STATUS_UNSPECIFIED = 0
    UP_TO_DATE = 1
    UPDATING_MEMBERSHIPS = 2

  status = _messages.EnumField('StatusValueValuesEnum', 1)
  statusTime = _messages.StringField(2)


class EndpointApp(_messages.Message):
  r"""An EndpointApp represents an app that is installed on a device

  Fields:
    displayName: Output only. Name of the app displayed to the user
    name: Output only. [Resource
      name](https://cloud.google.com/apis/design/resource_names) of the
      EndpointApp in format: `devices/{device}/deviceUsers/{device_user}/endpo
      intApps/{endpoint_app}`, where client_app_id is the ID of the app
      associated with the Device.
    packageName: Output only. Full package name of the installed app
    permissions: Output only. Names of all permissions granted to the
      installed app
    versionCode: Output only. Version code of the installed app
    versionName: Output only. Version name of the installed app
  """

  displayName = _messages.StringField(1)
  name = _messages.StringField(2)
  packageName = _messages.StringField(3)
  permissions = _messages.StringField(4, repeated=True)
  versionCode = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  versionName = _messages.StringField(6)


class EntityKey(_messages.Message):
  r"""A unique identifier for an entity in the Cloud Identity Groups API.  An
  entity can represent either a group with an optional `namespace` or a user
  without a `namespace`. The combination of `id` and `namespace` must be
  unique; however, the same `id` can be used with different `namespace`s.

  Fields:
    id: Required. The ID of the entity.  For Google-managed entities, the `id`
      must be the email address of an existing group or user.  For external-
      identity-mapped entities, the `id` must be a string conforming to the
      Identity Source's requirements.  Must be unique within a `namespace`.
    namespace: The namespace in which the entity exists.  If not specified,
      the `EntityKey` represents a Google-managed entity such as a Google user
      or a Google Group.  If specified, the `EntityKey` represents an
      external-identity-mapped group. The namespace must correspond to an
      identity source created in Admin Console and must be in the form of
      `identitysources/{identity_source_id}.
  """

  id = _messages.StringField(1)
  namespace = _messages.StringField(2)


class ExpiryDetail(_messages.Message):
  r"""Specifies Membership expiry attributes.

  Fields:
    expireTime: Expiration time for the Membership.
  """

  expireTime = _messages.StringField(1)


class GetMembershipGraphResponse(_messages.Message):
  r"""The response message for MembershipsService.GetMembershipGraph.

  Fields:
    adjacencyList: The membership graph's path information represented as an
      adjacency list.
    groups: The resources representing each group in the adjacency list. Each
      group in this list can be correlated to a 'group' of the
      MembershipAdjacencyList using the 'name' of the Group resource.
  """

  adjacencyList = _messages.MessageField('MembershipAdjacencyList', 1, repeated=True)
  groups = _messages.MessageField('Group', 2, repeated=True)


class Group(_messages.Message):
  r"""A group within the Cloud Identity Groups API.  A `Group` is a collection
  of entities, where each entity is either a user or another group.

  Messages:
    LabelsValue: Required. The labels that apply to the `Group`.  Must not
      contain more than one entry. Must contain the entry
      `'cloudidentity.googleapis.com/groups.discussion_forum': ''` if the
      `Group` is a Google Group or `'system/groups/external': ''` if the
      `Group` is an external-identity-mapped group.

  Fields:
    createTime: Output only. The time when the `Group` was created.
    description: An extended description to help users determine the purpose
      of a `Group`.  Must not be longer than 4,096 characters.
    displayName: The display name of the `Group`.
    dynamicGroupMetadata: Dynamic group metadata like queries and status.
    groupKey: Required. Immutable. The `EntityKey` of the `Group`.
    labels: Required. The labels that apply to the `Group`.  Must not contain
      more than one entry. Must contain the entry
      `'cloudidentity.googleapis.com/groups.discussion_forum': ''` if the
      `Group` is a Google Group or `'system/groups/external': ''` if the
      `Group` is an external-identity-mapped group.
    name: Output only. The [resource
      name](https://cloud.google.com/apis/design/resource_names) of the
      `Group`.  Shall be of the form `groups/{group_id}`.
    parent: Required. Immutable. The resource name of the entity under which
      this `Group` resides in the Cloud Identity resource hierarchy.  Must be
      of the form `identitysources/{identity_source_id}` for external-
      identity-mapped groups or `customers/{customer_id}` for Google Groups.
    updateTime: Output only. The time when the `Group` was last updated.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Required. The labels that apply to the `Group`.  Must not contain more
    than one entry. Must contain the entry
    `'cloudidentity.googleapis.com/groups.discussion_forum': ''` if the
    `Group` is a Google Group or `'system/groups/external': ''` if the `Group`
    is an external-identity-mapped group.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  description = _messages.StringField(2)
  displayName = _messages.StringField(3)
  dynamicGroupMetadata = _messages.MessageField('DynamicGroupMetadata', 4)
  groupKey = _messages.MessageField('EntityKey', 5)
  labels = _messages.MessageField('LabelsValue', 6)
  name = _messages.StringField(7)
  parent = _messages.StringField(8)
  updateTime = _messages.StringField(9)


class ListClientStatesResponse(_messages.Message):
  r"""Response message that is returned in LRO result of ListClientStates
  Operation.

  Fields:
    clientStates: Client states meeting the list restrictions.
    nextPageToken: Token to retrieve the next page of results. Empty if there
      are no more results.
  """

  clientStates = _messages.MessageField('ClientState', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListDeviceUsersResponse(_messages.Message):
  r"""Response message that is returned in LRO result of ListDeviceUsers
  Operation.

  Fields:
    deviceUsers: Devices meeting the list restrictions.
    nextPageToken: Token to retrieve the next page of results. Empty if there
      are no more results.
  """

  deviceUsers = _messages.MessageField('DeviceUser', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListDevicesResponse(_messages.Message):
  r"""Response message that is returned in LRO result of ListDevices
  Operation.

  Fields:
    devices: Devices meeting the list restrictions.
    nextPageToken: Token to retrieve the next page of results. Empty if there
      are no more results.
  """

  devices = _messages.MessageField('Device', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListEndpointAppsResponse(_messages.Message):
  r"""Response message for listing all apps on the device.

  Fields:
    endpointApps: The list of matching EndpointApps found as a result of the
      request.
    nextPageToken: Token to retrieve the next page of results. Empty if there
      are no more results.
  """

  endpointApps = _messages.MessageField('EndpointApp', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListGroupsResponse(_messages.Message):
  r"""The response message for GroupsService.ListGroups.

  Fields:
    groups: The `Group`s under the specified `parent`.
    nextPageToken: A continuation token to retrieve the next page of results,
      or empty if there are no more results available.
  """

  groups = _messages.MessageField('Group', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListMembershipsResponse(_messages.Message):
  r"""The response message for MembershipsService.ListMemberships.

  Fields:
    memberships: The `Membership`s under the specified `parent`.
    nextPageToken: A continuation token to retrieve the next page of results,
      or empty if there are no more results available.
  """

  memberships = _messages.MessageField('Membership', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class LookupGroupNameResponse(_messages.Message):
  r"""The response message for GroupsService.LookupGroupName.

  Fields:
    name: Output only. The [resource
      name](https://cloud.google.com/apis/design/resource_names) of the
      looked-up `Group`.
  """

  name = _messages.StringField(1)


class LookupMembershipNameResponse(_messages.Message):
  r"""The response message for MembershipsService.LookupMembershipName.

  Fields:
    name: The [resource
      name](https://cloud.google.com/apis/design/resource_names) of the
      looked-up `Membership`.  Must be of the form
      `groups/{group_id}/memberships/{membership_id}`.
  """

  name = _messages.StringField(1)


class LookupSelfDeviceUsersResponse(_messages.Message):
  r"""Response containing resource names of the DeviceUsers associated with
  the caller's credentials.

  Fields:
    customer: The obfuscated customer Id that may be passed back to other
      Devices API methods such as List, Get, etc.
    names: [Resource
      names](https://cloud.google.com/apis/design/resource_names) of the
      DeviceUsers in the format:
      `devices/{device_id}/deviceUsers/{user_resource_id}`, where device_id is
      the unique ID assigned to a Device and user_resource_id is the unique
      user ID
    nextPageToken: Token to retrieve the next page of results. Empty if there
      are no more results.
  """

  customer = _messages.StringField(1)
  names = _messages.StringField(2, repeated=True)
  nextPageToken = _messages.StringField(3)


class Membership(_messages.Message):
  r"""A membership within the Cloud Identity Groups API.  A `Membership`
  defines a relationship between a `Group` and an entity belonging to that
  `Group`, referred to as a "member".

  Enums:
    TypeValueValuesEnum: Output only. The type of the membership.

  Fields:
    createTime: Output only. The time when the `Membership` was created.
    expiryDetail: The expiry details of the `MembershipRole`.  May be set if
      the only `MembershipRole` is one with `name` `MEMBER`. Must not be set
      if any other `MembershipRole`s exist.
    name: Output only. The [resource
      name](https://cloud.google.com/apis/design/resource_names) of the
      `Membership`.  Shall be of the form
      `groups/{group_id}/memberships/{membership_id}`.
    preferredMemberKey: Required. Immutable. The `EntityKey` of the member.
    roles: The `MembershipRole`s that apply to the `Membership`.  If
      unspecified, defaults to a single `MembershipRole` with `name` `MEMBER`
      and no `expiry_detail`.  Must not contain duplicate `MembershipRole`s
      with the same `name`.
    type: Output only. The type of the membership.
    updateTime: Output only. The time when the `Membership` was last updated.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""Output only. The type of the membership.

    Values:
      TYPE_UNSPECIFIED: Default. Should not be used.
      USER: Represents user type.
      SERVICE_ACCOUNT: Represents service account type.
      GROUP: Represents group type.
      OTHER: Represents other type.
    """
    TYPE_UNSPECIFIED = 0
    USER = 1
    SERVICE_ACCOUNT = 2
    GROUP = 3
    OTHER = 4

  createTime = _messages.StringField(1)
  expiryDetail = _messages.MessageField('ExpiryDetail', 2)
  name = _messages.StringField(3)
  preferredMemberKey = _messages.MessageField('EntityKey', 4)
  roles = _messages.MessageField('MembershipRole', 5, repeated=True)
  type = _messages.EnumField('TypeValueValuesEnum', 6)
  updateTime = _messages.StringField(7)


class MembershipAdjacencyList(_messages.Message):
  r"""Membership graph's path information as an adjacency list.

  Fields:
    edges: Each edge contains information about the member that belongs to
      this group.
    group: Resource name of the group that the members belong to.
  """

  edges = _messages.MessageField('Membership', 1, repeated=True)
  group = _messages.StringField(2)


class MembershipRole(_messages.Message):
  r"""A membership role within the Cloud Identity Groups API.  A
  `MembershipRole` defines the privileges granted to a `Membership`.

  Fields:
    expiryDetail: The expiry details of the `MembershipRole`.  Expiry details
      are only supported for `MEMBER` `MembershipRoles`.  May be set if `name`
      is `MEMBER`. Must not be set if `name` is any other value.
    name: Required. Immutable. The name of the `MembershipRole`.  Must be one
      of `OWNER`, `MANAGER`, `MEMBER`.
  """

  expiryDetail = _messages.MessageField('MembershipRoleExpiryDetail', 1)
  name = _messages.StringField(2)


class MembershipRoleExpiryDetail(_messages.Message):
  r"""The `MembershipRole` expiry details.

  Fields:
    expireTime: The time at which the `MembershipRole` will expire.
  """

  expireTime = _messages.StringField(1)


class ModifyMembershipRolesRequest(_messages.Message):
  r"""The request message for MembershipsService.ModifyMembershipRoles.

  Fields:
    addRoles: The `MembershipRole`s to be added.  Adding or removing roles in
      the same request as updating roles is not supported.  Must not be set if
      `update_roles_params` is set.
    removeRoles: The `name`s of the `MembershipRole`s to be removed.  Adding
      or removing roles in the same request as updating roles is not
      supported.  It is not possible to remove the `MEMBER` `MembershipRole`.
      If you wish to delete a `Membership`, call
      MembershipsService.DeleteMembership instead.  Must not contain `MEMBER`.
      Must not be set if `update_roles_params` is set.
    updateRolesParams: The `MembershipRole`s to be updated.  Updating roles in
      the same request as adding or removing roles is not supported.  Must not
      be set if either `add_roles` or `remove_roles` is set.
  """

  addRoles = _messages.MessageField('MembershipRole', 1, repeated=True)
  removeRoles = _messages.StringField(2, repeated=True)
  updateRolesParams = _messages.MessageField('UpdateMembershipRolesParams', 3, repeated=True)


class ModifyMembershipRolesResponse(_messages.Message):
  r"""The response message for MembershipsService.ModifyMembershipRoles.

  Fields:
    membership: The `Membership` resource after modifying its
      `MembershipRole`s.
  """

  membership = _messages.MessageField('Membership', 1)


class Operation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation.
      It typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata.  Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal response of the operation in case of success.
      If the original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`.  If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource.  For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name.  For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation.  It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata.  Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal response of the operation in case of success.  If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`.  If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource.  For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name.  For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation.  It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata.  Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal response of the operation in case of success.  If the
    original method returns no data on success, such as `Delete`, the response
    is `google.protobuf.Empty`.  If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource.  For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name.  For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class SearchGroupsResponse(_messages.Message):
  r"""The response message for GroupsService.SearchGroups.

  Fields:
    groups: The `Group`s that match the search query.
    nextPageToken: A continuation token to retrieve the next page of results,
      or empty if there are no more results available.
  """

  groups = _messages.MessageField('Group', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details.  You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details.  There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class UpdateMembershipRolesParams(_messages.Message):
  r"""The details of an update to a `MembershipRole`.

  Fields:
    fieldMask: The fully-qualified names of fields to update.  May only
      contain the field `expiry_detail`.
    membershipRole: The `MembershipRole`s to be updated.  Only `MEMBER`
      `MembershipRoles` can currently be updated.  May only contain a
      `MembershipRole` with `name` `MEMBER`.
  """

  fieldMask = _messages.StringField(1)
  membershipRole = _messages.MessageField('MembershipRole', 2)


class WipeDeviceResponse(_messages.Message):
  r"""Response message for wiping all data on the device.

  Fields:
    device: Resultant Device object for the action. Note that asset tags will
      not be returned in the device object.
  """

  device = _messages.MessageField('Device', 1)


class WipeDeviceUserResponse(_messages.Message):
  r"""Response message for wiping the user's account from the device.

  Fields:
    deviceUser: Resultant DeviceUser object for the action.
  """

  deviceUser = _messages.MessageField('DeviceUser', 1)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
