"""Generated client library for run version v1alpha1."""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.py import base_api
from googlecloudsdk.third_party.apis.run.v1alpha1 import run_v1alpha1_messages as messages


class RunV1alpha1(base_api.BaseApiClient):
  """Generated client library for service run version v1alpha1."""

  MESSAGES_MODULE = messages
  BASE_URL = 'https://run.googleapis.com/'
  MTLS_BASE_URL = 'https://run.mtls.googleapis.com/'

  _PACKAGE = 'run'
  _SCOPES = ['https://www.googleapis.com/auth/cloud-platform']
  _VERSION = 'v1alpha1'
  _CLIENT_ID = '1042881264118.apps.googleusercontent.com'
  _CLIENT_SECRET = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _USER_AGENT = 'google-cloud-sdk'
  _CLIENT_CLASS_NAME = 'RunV1alpha1'
  _URL_VERSION = 'v1alpha1'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new run handle."""
    url = url or self.BASE_URL
    super(RunV1alpha1, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.namespaces_authorizeddomains = self.NamespacesAuthorizeddomainsService(self)
    self.namespaces_cloudauditlogssources = self.NamespacesCloudauditlogssourcesService(self)
    self.namespaces_cloudpubsubsources = self.NamespacesCloudpubsubsourcesService(self)
    self.namespaces_cloudschedulersources = self.NamespacesCloudschedulersourcesService(self)
    self.namespaces_cloudstoragesources = self.NamespacesCloudstoragesourcesService(self)
    self.namespaces_configurations = self.NamespacesConfigurationsService(self)
    self.namespaces_domainmappings = self.NamespacesDomainmappingsService(self)
    self.namespaces_revisions = self.NamespacesRevisionsService(self)
    self.namespaces_routes = self.NamespacesRoutesService(self)
    self.namespaces_services = self.NamespacesServicesService(self)
    self.namespaces_triggers = self.NamespacesTriggersService(self)
    self.namespaces = self.NamespacesService(self)
    self.projects_locations_authorizeddomains = self.ProjectsLocationsAuthorizeddomainsService(self)
    self.projects_locations_cloudauditlogssources = self.ProjectsLocationsCloudauditlogssourcesService(self)
    self.projects_locations_cloudpubsubsources = self.ProjectsLocationsCloudpubsubsourcesService(self)
    self.projects_locations_cloudschedulersources = self.ProjectsLocationsCloudschedulersourcesService(self)
    self.projects_locations_cloudstoragesources = self.ProjectsLocationsCloudstoragesourcesService(self)
    self.projects_locations_configurations = self.ProjectsLocationsConfigurationsService(self)
    self.projects_locations_domainmappings = self.ProjectsLocationsDomainmappingsService(self)
    self.projects_locations_revisions = self.ProjectsLocationsRevisionsService(self)
    self.projects_locations_routes = self.ProjectsLocationsRoutesService(self)
    self.projects_locations_services = self.ProjectsLocationsServicesService(self)
    self.projects_locations_triggers = self.ProjectsLocationsTriggersService(self)
    self.projects_locations = self.ProjectsLocationsService(self)
    self.projects = self.ProjectsService(self)

  class NamespacesAuthorizeddomainsService(base_api.BaseApiService):
    """Service class for the namespaces_authorizeddomains resource."""

    _NAME = 'namespaces_authorizeddomains'

    def __init__(self, client):
      super(RunV1alpha1.NamespacesAuthorizeddomainsService, self).__init__(client)
      self._upload_configs = {
          }

    def List(self, request, global_params=None):
      r"""RPC to list authorized domains.

      Args:
        request: (RunNamespacesAuthorizeddomainsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListAuthorizedDomainsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/domains.cloudrun.com/v1alpha1/namespaces/{namespacesId}/authorizeddomains',
        http_method='GET',
        method_id='run.namespaces.authorizeddomains.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken'],
        relative_path='apis/domains.cloudrun.com/v1alpha1/{+parent}/authorizeddomains',
        request_field='',
        request_type_name='RunNamespacesAuthorizeddomainsListRequest',
        response_type_name='ListAuthorizedDomainsResponse',
        supports_download=False,
    )

  class NamespacesCloudauditlogssourcesService(base_api.BaseApiService):
    """Service class for the namespaces_cloudauditlogssources resource."""

    _NAME = 'namespaces_cloudauditlogssources'

    def __init__(self, client):
      super(RunV1alpha1.NamespacesCloudauditlogssourcesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new cloudauditlogssource.

      Args:
        request: (RunNamespacesCloudauditlogssourcesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CloudAuditLogsSource) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/events.cloud.google.com/v1alpha1/namespaces/{namespacesId}/cloudauditlogssources',
        http_method='POST',
        method_id='run.namespaces.cloudauditlogssources.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='apis/events.cloud.google.com/v1alpha1/{+parent}/cloudauditlogssources',
        request_field='cloudAuditLogsSource',
        request_type_name='RunNamespacesCloudauditlogssourcesCreateRequest',
        response_type_name='CloudAuditLogsSource',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Rpc to delete a cloudauditlogssource.

      Args:
        request: (RunNamespacesCloudauditlogssourcesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/events.cloud.google.com/v1alpha1/namespaces/{namespacesId}/cloudauditlogssources/{cloudauditlogssourcesId}',
        http_method='DELETE',
        method_id='run.namespaces.cloudauditlogssources.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['apiVersion', 'kind', 'propagationPolicy'],
        relative_path='apis/events.cloud.google.com/v1alpha1/{+name}',
        request_field='',
        request_type_name='RunNamespacesCloudauditlogssourcesDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Rpc to get information about a cloudauditlogssource.

      Args:
        request: (RunNamespacesCloudauditlogssourcesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CloudAuditLogsSource) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/events.cloud.google.com/v1alpha1/namespaces/{namespacesId}/cloudauditlogssources/{cloudauditlogssourcesId}',
        http_method='GET',
        method_id='run.namespaces.cloudauditlogssources.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='apis/events.cloud.google.com/v1alpha1/{+name}',
        request_field='',
        request_type_name='RunNamespacesCloudauditlogssourcesGetRequest',
        response_type_name='CloudAuditLogsSource',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Rpc to list cloudauditlogssources.

      Args:
        request: (RunNamespacesCloudauditlogssourcesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListCloudAuditLogsSourcesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/events.cloud.google.com/v1alpha1/namespaces/{namespacesId}/cloudauditlogssources',
        http_method='GET',
        method_id='run.namespaces.cloudauditlogssources.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['continue_', 'fieldSelector', 'includeUninitialized', 'labelSelector', 'limit', 'resourceVersion', 'watch'],
        relative_path='apis/events.cloud.google.com/v1alpha1/{+parent}/cloudauditlogssources',
        request_field='',
        request_type_name='RunNamespacesCloudauditlogssourcesListRequest',
        response_type_name='ListCloudAuditLogsSourcesResponse',
        supports_download=False,
    )

  class NamespacesCloudpubsubsourcesService(base_api.BaseApiService):
    """Service class for the namespaces_cloudpubsubsources resource."""

    _NAME = 'namespaces_cloudpubsubsources'

    def __init__(self, client):
      super(RunV1alpha1.NamespacesCloudpubsubsourcesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new cloudpubsubsource.

      Args:
        request: (RunNamespacesCloudpubsubsourcesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CloudPubSubSource) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/events.cloud.google.com/v1alpha1/namespaces/{namespacesId}/cloudpubsubsources',
        http_method='POST',
        method_id='run.namespaces.cloudpubsubsources.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='apis/events.cloud.google.com/v1alpha1/{+parent}/cloudpubsubsources',
        request_field='cloudPubSubSource',
        request_type_name='RunNamespacesCloudpubsubsourcesCreateRequest',
        response_type_name='CloudPubSubSource',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Rpc to delete a cloudpubsubsource.

      Args:
        request: (RunNamespacesCloudpubsubsourcesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/events.cloud.google.com/v1alpha1/namespaces/{namespacesId}/cloudpubsubsources/{cloudpubsubsourcesId}',
        http_method='DELETE',
        method_id='run.namespaces.cloudpubsubsources.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['apiVersion', 'kind', 'propagationPolicy'],
        relative_path='apis/events.cloud.google.com/v1alpha1/{+name}',
        request_field='',
        request_type_name='RunNamespacesCloudpubsubsourcesDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Rpc to get information about a cloudpubsubsource.

      Args:
        request: (RunNamespacesCloudpubsubsourcesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CloudPubSubSource) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/events.cloud.google.com/v1alpha1/namespaces/{namespacesId}/cloudpubsubsources/{cloudpubsubsourcesId}',
        http_method='GET',
        method_id='run.namespaces.cloudpubsubsources.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='apis/events.cloud.google.com/v1alpha1/{+name}',
        request_field='',
        request_type_name='RunNamespacesCloudpubsubsourcesGetRequest',
        response_type_name='CloudPubSubSource',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Rpc to list cloudpubsubsources.

      Args:
        request: (RunNamespacesCloudpubsubsourcesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListCloudPubSubSourcesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/events.cloud.google.com/v1alpha1/namespaces/{namespacesId}/cloudpubsubsources',
        http_method='GET',
        method_id='run.namespaces.cloudpubsubsources.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['continue_', 'fieldSelector', 'includeUninitialized', 'labelSelector', 'limit', 'resourceVersion', 'watch'],
        relative_path='apis/events.cloud.google.com/v1alpha1/{+parent}/cloudpubsubsources',
        request_field='',
        request_type_name='RunNamespacesCloudpubsubsourcesListRequest',
        response_type_name='ListCloudPubSubSourcesResponse',
        supports_download=False,
    )

  class NamespacesCloudschedulersourcesService(base_api.BaseApiService):
    """Service class for the namespaces_cloudschedulersources resource."""

    _NAME = 'namespaces_cloudschedulersources'

    def __init__(self, client):
      super(RunV1alpha1.NamespacesCloudschedulersourcesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new cloudschedulersource.

      Args:
        request: (RunNamespacesCloudschedulersourcesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CloudSchedulerSource) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/events.cloud.google.com/v1alpha1/namespaces/{namespacesId}/cloudschedulersources',
        http_method='POST',
        method_id='run.namespaces.cloudschedulersources.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='apis/events.cloud.google.com/v1alpha1/{+parent}/cloudschedulersources',
        request_field='cloudSchedulerSource',
        request_type_name='RunNamespacesCloudschedulersourcesCreateRequest',
        response_type_name='CloudSchedulerSource',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Rpc to delete a cloudschedulersource.

      Args:
        request: (RunNamespacesCloudschedulersourcesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/events.cloud.google.com/v1alpha1/namespaces/{namespacesId}/cloudschedulersources/{cloudschedulersourcesId}',
        http_method='DELETE',
        method_id='run.namespaces.cloudschedulersources.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['apiVersion', 'kind', 'propagationPolicy'],
        relative_path='apis/events.cloud.google.com/v1alpha1/{+name}',
        request_field='',
        request_type_name='RunNamespacesCloudschedulersourcesDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Rpc to get information about a cloudschedulersource.

      Args:
        request: (RunNamespacesCloudschedulersourcesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CloudSchedulerSource) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/events.cloud.google.com/v1alpha1/namespaces/{namespacesId}/cloudschedulersources/{cloudschedulersourcesId}',
        http_method='GET',
        method_id='run.namespaces.cloudschedulersources.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='apis/events.cloud.google.com/v1alpha1/{+name}',
        request_field='',
        request_type_name='RunNamespacesCloudschedulersourcesGetRequest',
        response_type_name='CloudSchedulerSource',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Rpc to list cloudschedulersources.

      Args:
        request: (RunNamespacesCloudschedulersourcesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListCloudSchedulerSourcesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/events.cloud.google.com/v1alpha1/namespaces/{namespacesId}/cloudschedulersources',
        http_method='GET',
        method_id='run.namespaces.cloudschedulersources.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['continue_', 'fieldSelector', 'includeUninitialized', 'labelSelector', 'limit', 'resourceVersion', 'watch'],
        relative_path='apis/events.cloud.google.com/v1alpha1/{+parent}/cloudschedulersources',
        request_field='',
        request_type_name='RunNamespacesCloudschedulersourcesListRequest',
        response_type_name='ListCloudSchedulerSourcesResponse',
        supports_download=False,
    )

    def ReplaceCloudSchedulerSource(self, request, global_params=None):
      r"""Rpc to replace a cloudschedulersource.

Only the spec and metadata labels and annotations are modifiable. After
the Update request, Cloud Run will work to make the 'status'
match the requested 'spec'.

May provide metadata.resourceVersion to enforce update from last read for
optimistic concurrency control.

      Args:
        request: (RunNamespacesCloudschedulersourcesReplaceCloudSchedulerSourceRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CloudSchedulerSource) The response message.
      """
      config = self.GetMethodConfig('ReplaceCloudSchedulerSource')
      return self._RunMethod(
          config, request, global_params=global_params)

    ReplaceCloudSchedulerSource.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/events.cloud.google.com/v1alpha1/namespaces/{namespacesId}/cloudschedulersources/{cloudschedulersourcesId}',
        http_method='PUT',
        method_id='run.namespaces.cloudschedulersources.replaceCloudSchedulerSource',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='apis/events.cloud.google.com/v1alpha1/{+name}',
        request_field='cloudSchedulerSource',
        request_type_name='RunNamespacesCloudschedulersourcesReplaceCloudSchedulerSourceRequest',
        response_type_name='CloudSchedulerSource',
        supports_download=False,
    )

  class NamespacesCloudstoragesourcesService(base_api.BaseApiService):
    """Service class for the namespaces_cloudstoragesources resource."""

    _NAME = 'namespaces_cloudstoragesources'

    def __init__(self, client):
      super(RunV1alpha1.NamespacesCloudstoragesourcesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new cloudstoragesource.

      Args:
        request: (RunNamespacesCloudstoragesourcesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CloudStorageSource) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/events.cloud.google.com/v1alpha1/namespaces/{namespacesId}/cloudstoragesources',
        http_method='POST',
        method_id='run.namespaces.cloudstoragesources.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='apis/events.cloud.google.com/v1alpha1/{+parent}/cloudstoragesources',
        request_field='cloudStorageSource',
        request_type_name='RunNamespacesCloudstoragesourcesCreateRequest',
        response_type_name='CloudStorageSource',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Rpc to delete a cloudstoragesource.

      Args:
        request: (RunNamespacesCloudstoragesourcesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/events.cloud.google.com/v1alpha1/namespaces/{namespacesId}/cloudstoragesources/{cloudstoragesourcesId}',
        http_method='DELETE',
        method_id='run.namespaces.cloudstoragesources.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['apiVersion', 'kind', 'propagationPolicy'],
        relative_path='apis/events.cloud.google.com/v1alpha1/{+name}',
        request_field='',
        request_type_name='RunNamespacesCloudstoragesourcesDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Rpc to get information about a cloudstoragesource.

      Args:
        request: (RunNamespacesCloudstoragesourcesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CloudStorageSource) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/events.cloud.google.com/v1alpha1/namespaces/{namespacesId}/cloudstoragesources/{cloudstoragesourcesId}',
        http_method='GET',
        method_id='run.namespaces.cloudstoragesources.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='apis/events.cloud.google.com/v1alpha1/{+name}',
        request_field='',
        request_type_name='RunNamespacesCloudstoragesourcesGetRequest',
        response_type_name='CloudStorageSource',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Rpc to list cloudstoragesources.

      Args:
        request: (RunNamespacesCloudstoragesourcesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListCloudStorageSourcesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/events.cloud.google.com/v1alpha1/namespaces/{namespacesId}/cloudstoragesources',
        http_method='GET',
        method_id='run.namespaces.cloudstoragesources.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['continue_', 'fieldSelector', 'includeUninitialized', 'labelSelector', 'limit', 'resourceVersion', 'watch'],
        relative_path='apis/events.cloud.google.com/v1alpha1/{+parent}/cloudstoragesources',
        request_field='',
        request_type_name='RunNamespacesCloudstoragesourcesListRequest',
        response_type_name='ListCloudStorageSourcesResponse',
        supports_download=False,
    )

    def ReplaceCloudStorageSource(self, request, global_params=None):
      r"""Rpc to replace a cloudstoragesource.

Only the spec and metadata labels and annotations are modifiable. After
the Update request, Cloud Run will work to make the 'status'
match the requested 'spec'.

May provide metadata.resourceVersion to enforce update from last read for
optimistic concurrency control.

      Args:
        request: (RunNamespacesCloudstoragesourcesReplaceCloudStorageSourceRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CloudStorageSource) The response message.
      """
      config = self.GetMethodConfig('ReplaceCloudStorageSource')
      return self._RunMethod(
          config, request, global_params=global_params)

    ReplaceCloudStorageSource.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/events.cloud.google.com/v1alpha1/namespaces/{namespacesId}/cloudstoragesources/{cloudstoragesourcesId}',
        http_method='PUT',
        method_id='run.namespaces.cloudstoragesources.replaceCloudStorageSource',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='apis/events.cloud.google.com/v1alpha1/{+name}',
        request_field='cloudStorageSource',
        request_type_name='RunNamespacesCloudstoragesourcesReplaceCloudStorageSourceRequest',
        response_type_name='CloudStorageSource',
        supports_download=False,
    )

  class NamespacesConfigurationsService(base_api.BaseApiService):
    """Service class for the namespaces_configurations resource."""

    _NAME = 'namespaces_configurations'

    def __init__(self, client):
      super(RunV1alpha1.NamespacesConfigurationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Rpc to get information about a configuration.

      Args:
        request: (RunNamespacesConfigurationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Configuration) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/serving.knative.dev/v1alpha1/namespaces/{namespacesId}/configurations/{configurationsId}',
        http_method='GET',
        method_id='run.namespaces.configurations.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='apis/serving.knative.dev/v1alpha1/{+name}',
        request_field='',
        request_type_name='RunNamespacesConfigurationsGetRequest',
        response_type_name='Configuration',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Rpc to list configurations.

      Args:
        request: (RunNamespacesConfigurationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListConfigurationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/serving.knative.dev/v1alpha1/namespaces/{namespacesId}/configurations',
        http_method='GET',
        method_id='run.namespaces.configurations.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['continue_', 'fieldSelector', 'includeUninitialized', 'labelSelector', 'limit', 'resourceVersion', 'watch'],
        relative_path='apis/serving.knative.dev/v1alpha1/{+parent}/configurations',
        request_field='',
        request_type_name='RunNamespacesConfigurationsListRequest',
        response_type_name='ListConfigurationsResponse',
        supports_download=False,
    )

  class NamespacesDomainmappingsService(base_api.BaseApiService):
    """Service class for the namespaces_domainmappings resource."""

    _NAME = 'namespaces_domainmappings'

    def __init__(self, client):
      super(RunV1alpha1.NamespacesDomainmappingsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new domain mapping.

      Args:
        request: (RunNamespacesDomainmappingsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (DomainMapping) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/domains.cloudrun.com/v1alpha1/namespaces/{namespacesId}/domainmappings',
        http_method='POST',
        method_id='run.namespaces.domainmappings.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='apis/domains.cloudrun.com/v1alpha1/{+parent}/domainmappings',
        request_field='domainMapping',
        request_type_name='RunNamespacesDomainmappingsCreateRequest',
        response_type_name='DomainMapping',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Rpc to delete a domain mapping.

      Args:
        request: (RunNamespacesDomainmappingsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/domains.cloudrun.com/v1alpha1/namespaces/{namespacesId}/domainmappings/{domainmappingsId}',
        http_method='DELETE',
        method_id='run.namespaces.domainmappings.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['apiVersion', 'kind', 'orphanDependents', 'propagationPolicy'],
        relative_path='apis/domains.cloudrun.com/v1alpha1/{+name}',
        request_field='',
        request_type_name='RunNamespacesDomainmappingsDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Rpc to get information about a domain mapping.

      Args:
        request: (RunNamespacesDomainmappingsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (DomainMapping) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/domains.cloudrun.com/v1alpha1/namespaces/{namespacesId}/domainmappings/{domainmappingsId}',
        http_method='GET',
        method_id='run.namespaces.domainmappings.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='apis/domains.cloudrun.com/v1alpha1/{+name}',
        request_field='',
        request_type_name='RunNamespacesDomainmappingsGetRequest',
        response_type_name='DomainMapping',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Rpc to list domain mappings.

      Args:
        request: (RunNamespacesDomainmappingsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListDomainMappingsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/domains.cloudrun.com/v1alpha1/namespaces/{namespacesId}/domainmappings',
        http_method='GET',
        method_id='run.namespaces.domainmappings.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['continue_', 'fieldSelector', 'includeUninitialized', 'labelSelector', 'limit', 'resourceVersion', 'watch'],
        relative_path='apis/domains.cloudrun.com/v1alpha1/{+parent}/domainmappings',
        request_field='',
        request_type_name='RunNamespacesDomainmappingsListRequest',
        response_type_name='ListDomainMappingsResponse',
        supports_download=False,
    )

  class NamespacesRevisionsService(base_api.BaseApiService):
    """Service class for the namespaces_revisions resource."""

    _NAME = 'namespaces_revisions'

    def __init__(self, client):
      super(RunV1alpha1.NamespacesRevisionsService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Rpc to delete a revision.

      Args:
        request: (RunNamespacesRevisionsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/serving.knative.dev/v1alpha1/namespaces/{namespacesId}/revisions/{revisionsId}',
        http_method='DELETE',
        method_id='run.namespaces.revisions.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['apiVersion', 'kind', 'orphanDependents', 'propagationPolicy'],
        relative_path='apis/serving.knative.dev/v1alpha1/{+name}',
        request_field='',
        request_type_name='RunNamespacesRevisionsDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Rpc to get information about a revision.

      Args:
        request: (RunNamespacesRevisionsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Revision) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/serving.knative.dev/v1alpha1/namespaces/{namespacesId}/revisions/{revisionsId}',
        http_method='GET',
        method_id='run.namespaces.revisions.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='apis/serving.knative.dev/v1alpha1/{+name}',
        request_field='',
        request_type_name='RunNamespacesRevisionsGetRequest',
        response_type_name='Revision',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Rpc to list revisions.

      Args:
        request: (RunNamespacesRevisionsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListRevisionsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/serving.knative.dev/v1alpha1/namespaces/{namespacesId}/revisions',
        http_method='GET',
        method_id='run.namespaces.revisions.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['continue_', 'fieldSelector', 'includeUninitialized', 'labelSelector', 'limit', 'resourceVersion', 'watch'],
        relative_path='apis/serving.knative.dev/v1alpha1/{+parent}/revisions',
        request_field='',
        request_type_name='RunNamespacesRevisionsListRequest',
        response_type_name='ListRevisionsResponse',
        supports_download=False,
    )

  class NamespacesRoutesService(base_api.BaseApiService):
    """Service class for the namespaces_routes resource."""

    _NAME = 'namespaces_routes'

    def __init__(self, client):
      super(RunV1alpha1.NamespacesRoutesService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Rpc to get information about a route.

      Args:
        request: (RunNamespacesRoutesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Route) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/serving.knative.dev/v1alpha1/namespaces/{namespacesId}/routes/{routesId}',
        http_method='GET',
        method_id='run.namespaces.routes.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='apis/serving.knative.dev/v1alpha1/{+name}',
        request_field='',
        request_type_name='RunNamespacesRoutesGetRequest',
        response_type_name='Route',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Rpc to list routes.

      Args:
        request: (RunNamespacesRoutesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListRoutesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/serving.knative.dev/v1alpha1/namespaces/{namespacesId}/routes',
        http_method='GET',
        method_id='run.namespaces.routes.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['continue_', 'fieldSelector', 'includeUninitialized', 'labelSelector', 'limit', 'resourceVersion', 'watch'],
        relative_path='apis/serving.knative.dev/v1alpha1/{+parent}/routes',
        request_field='',
        request_type_name='RunNamespacesRoutesListRequest',
        response_type_name='ListRoutesResponse',
        supports_download=False,
    )

  class NamespacesServicesService(base_api.BaseApiService):
    """Service class for the namespaces_services resource."""

    _NAME = 'namespaces_services'

    def __init__(self, client):
      super(RunV1alpha1.NamespacesServicesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Rpc to create a service.

      Args:
        request: (RunNamespacesServicesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Service) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/serving.knative.dev/v1alpha1/namespaces/{namespacesId}/services',
        http_method='POST',
        method_id='run.namespaces.services.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='apis/serving.knative.dev/v1alpha1/{+parent}/services',
        request_field='service',
        request_type_name='RunNamespacesServicesCreateRequest',
        response_type_name='Service',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Rpc to delete a service.
This will cause the Service to stop serving traffic and will delete the
child entities like Routes, Configurations and Revisions.

      Args:
        request: (RunNamespacesServicesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/serving.knative.dev/v1alpha1/namespaces/{namespacesId}/services/{servicesId}',
        http_method='DELETE',
        method_id='run.namespaces.services.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['apiVersion', 'kind', 'orphanDependents', 'propagationPolicy'],
        relative_path='apis/serving.knative.dev/v1alpha1/{+name}',
        request_field='',
        request_type_name='RunNamespacesServicesDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Rpc to get information about a service.

      Args:
        request: (RunNamespacesServicesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Service) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/serving.knative.dev/v1alpha1/namespaces/{namespacesId}/services/{servicesId}',
        http_method='GET',
        method_id='run.namespaces.services.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='apis/serving.knative.dev/v1alpha1/{+name}',
        request_field='',
        request_type_name='RunNamespacesServicesGetRequest',
        response_type_name='Service',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Rpc to list services.

      Args:
        request: (RunNamespacesServicesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListServicesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/serving.knative.dev/v1alpha1/namespaces/{namespacesId}/services',
        http_method='GET',
        method_id='run.namespaces.services.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['continue_', 'fieldSelector', 'includeUninitialized', 'labelSelector', 'limit', 'resourceVersion', 'watch'],
        relative_path='apis/serving.knative.dev/v1alpha1/{+parent}/services',
        request_field='',
        request_type_name='RunNamespacesServicesListRequest',
        response_type_name='ListServicesResponse',
        supports_download=False,
    )

    def ReplaceService(self, request, global_params=None):
      r"""Rpc to replace a service.

Only the spec and metadata labels and annotations are modifiable. After
the Update request, Cloud Run will work to make the 'status'
match the requested 'spec'.

May provide metadata.resourceVersion to enforce update from last read for
optimistic concurrency control.

      Args:
        request: (RunNamespacesServicesReplaceServiceRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Service) The response message.
      """
      config = self.GetMethodConfig('ReplaceService')
      return self._RunMethod(
          config, request, global_params=global_params)

    ReplaceService.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/serving.knative.dev/v1alpha1/namespaces/{namespacesId}/services/{servicesId}',
        http_method='PUT',
        method_id='run.namespaces.services.replaceService',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='apis/serving.knative.dev/v1alpha1/{+name}',
        request_field='service',
        request_type_name='RunNamespacesServicesReplaceServiceRequest',
        response_type_name='Service',
        supports_download=False,
    )

  class NamespacesTriggersService(base_api.BaseApiService):
    """Service class for the namespaces_triggers resource."""

    _NAME = 'namespaces_triggers'

    def __init__(self, client):
      super(RunV1alpha1.NamespacesTriggersService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new trigger.

      Args:
        request: (RunNamespacesTriggersCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Trigger) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/eventing.knative.dev/v1alpha1/namespaces/{namespacesId}/triggers',
        http_method='POST',
        method_id='run.namespaces.triggers.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='apis/eventing.knative.dev/v1alpha1/{+parent}/triggers',
        request_field='trigger',
        request_type_name='RunNamespacesTriggersCreateRequest',
        response_type_name='Trigger',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Rpc to delete a trigger.

      Args:
        request: (RunNamespacesTriggersDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/eventing.knative.dev/v1alpha1/namespaces/{namespacesId}/triggers/{triggersId}',
        http_method='DELETE',
        method_id='run.namespaces.triggers.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['apiVersion', 'kind', 'propagationPolicy'],
        relative_path='apis/eventing.knative.dev/v1alpha1/{+name}',
        request_field='',
        request_type_name='RunNamespacesTriggersDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Rpc to get information about a trigger.

      Args:
        request: (RunNamespacesTriggersGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Trigger) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/eventing.knative.dev/v1alpha1/namespaces/{namespacesId}/triggers/{triggersId}',
        http_method='GET',
        method_id='run.namespaces.triggers.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='apis/eventing.knative.dev/v1alpha1/{+name}',
        request_field='',
        request_type_name='RunNamespacesTriggersGetRequest',
        response_type_name='Trigger',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Rpc to list triggers.

      Args:
        request: (RunNamespacesTriggersListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListTriggersResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/eventing.knative.dev/v1alpha1/namespaces/{namespacesId}/triggers',
        http_method='GET',
        method_id='run.namespaces.triggers.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['continue_', 'fieldSelector', 'includeUninitialized', 'labelSelector', 'limit', 'resourceVersion', 'watch'],
        relative_path='apis/eventing.knative.dev/v1alpha1/{+parent}/triggers',
        request_field='',
        request_type_name='RunNamespacesTriggersListRequest',
        response_type_name='ListTriggersResponse',
        supports_download=False,
    )

  class NamespacesService(base_api.BaseApiService):
    """Service class for the namespaces resource."""

    _NAME = 'namespaces'

    def __init__(self, client):
      super(RunV1alpha1.NamespacesService, self).__init__(client)
      self._upload_configs = {
          }

  class ProjectsLocationsAuthorizeddomainsService(base_api.BaseApiService):
    """Service class for the projects_locations_authorizeddomains resource."""

    _NAME = 'projects_locations_authorizeddomains'

    def __init__(self, client):
      super(RunV1alpha1.ProjectsLocationsAuthorizeddomainsService, self).__init__(client)
      self._upload_configs = {
          }

    def List(self, request, global_params=None):
      r"""RPC to list authorized domains.

      Args:
        request: (RunProjectsLocationsAuthorizeddomainsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListAuthorizedDomainsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/authorizeddomains',
        http_method='GET',
        method_id='run.projects.locations.authorizeddomains.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken'],
        relative_path='v1alpha1/{+parent}/authorizeddomains',
        request_field='',
        request_type_name='RunProjectsLocationsAuthorizeddomainsListRequest',
        response_type_name='ListAuthorizedDomainsResponse',
        supports_download=False,
    )

  class ProjectsLocationsCloudauditlogssourcesService(base_api.BaseApiService):
    """Service class for the projects_locations_cloudauditlogssources resource."""

    _NAME = 'projects_locations_cloudauditlogssources'

    def __init__(self, client):
      super(RunV1alpha1.ProjectsLocationsCloudauditlogssourcesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new cloudauditlogssource.

      Args:
        request: (RunProjectsLocationsCloudauditlogssourcesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CloudAuditLogsSource) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/cloudauditlogssources',
        http_method='POST',
        method_id='run.projects.locations.cloudauditlogssources.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v1alpha1/{+parent}/cloudauditlogssources',
        request_field='cloudAuditLogsSource',
        request_type_name='RunProjectsLocationsCloudauditlogssourcesCreateRequest',
        response_type_name='CloudAuditLogsSource',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Rpc to delete a cloudauditlogssource.

      Args:
        request: (RunProjectsLocationsCloudauditlogssourcesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/cloudauditlogssources/{cloudauditlogssourcesId}',
        http_method='DELETE',
        method_id='run.projects.locations.cloudauditlogssources.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['apiVersion', 'kind', 'propagationPolicy'],
        relative_path='v1alpha1/{+name}',
        request_field='',
        request_type_name='RunProjectsLocationsCloudauditlogssourcesDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Rpc to get information about a cloudauditlogssource.

      Args:
        request: (RunProjectsLocationsCloudauditlogssourcesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CloudAuditLogsSource) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/cloudauditlogssources/{cloudauditlogssourcesId}',
        http_method='GET',
        method_id='run.projects.locations.cloudauditlogssources.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}',
        request_field='',
        request_type_name='RunProjectsLocationsCloudauditlogssourcesGetRequest',
        response_type_name='CloudAuditLogsSource',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Rpc to list cloudauditlogssources.

      Args:
        request: (RunProjectsLocationsCloudauditlogssourcesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListCloudAuditLogsSourcesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/cloudauditlogssources',
        http_method='GET',
        method_id='run.projects.locations.cloudauditlogssources.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['continue_', 'fieldSelector', 'includeUninitialized', 'labelSelector', 'limit', 'resourceVersion', 'watch'],
        relative_path='v1alpha1/{+parent}/cloudauditlogssources',
        request_field='',
        request_type_name='RunProjectsLocationsCloudauditlogssourcesListRequest',
        response_type_name='ListCloudAuditLogsSourcesResponse',
        supports_download=False,
    )

  class ProjectsLocationsCloudpubsubsourcesService(base_api.BaseApiService):
    """Service class for the projects_locations_cloudpubsubsources resource."""

    _NAME = 'projects_locations_cloudpubsubsources'

    def __init__(self, client):
      super(RunV1alpha1.ProjectsLocationsCloudpubsubsourcesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new cloudpubsubsource.

      Args:
        request: (RunProjectsLocationsCloudpubsubsourcesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CloudPubSubSource) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/cloudpubsubsources',
        http_method='POST',
        method_id='run.projects.locations.cloudpubsubsources.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v1alpha1/{+parent}/cloudpubsubsources',
        request_field='cloudPubSubSource',
        request_type_name='RunProjectsLocationsCloudpubsubsourcesCreateRequest',
        response_type_name='CloudPubSubSource',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Rpc to delete a cloudpubsubsource.

      Args:
        request: (RunProjectsLocationsCloudpubsubsourcesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/cloudpubsubsources/{cloudpubsubsourcesId}',
        http_method='DELETE',
        method_id='run.projects.locations.cloudpubsubsources.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['apiVersion', 'kind', 'propagationPolicy'],
        relative_path='v1alpha1/{+name}',
        request_field='',
        request_type_name='RunProjectsLocationsCloudpubsubsourcesDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Rpc to get information about a cloudpubsubsource.

      Args:
        request: (RunProjectsLocationsCloudpubsubsourcesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CloudPubSubSource) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/cloudpubsubsources/{cloudpubsubsourcesId}',
        http_method='GET',
        method_id='run.projects.locations.cloudpubsubsources.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}',
        request_field='',
        request_type_name='RunProjectsLocationsCloudpubsubsourcesGetRequest',
        response_type_name='CloudPubSubSource',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Rpc to list cloudpubsubsources.

      Args:
        request: (RunProjectsLocationsCloudpubsubsourcesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListCloudPubSubSourcesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/cloudpubsubsources',
        http_method='GET',
        method_id='run.projects.locations.cloudpubsubsources.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['continue_', 'fieldSelector', 'includeUninitialized', 'labelSelector', 'limit', 'resourceVersion', 'watch'],
        relative_path='v1alpha1/{+parent}/cloudpubsubsources',
        request_field='',
        request_type_name='RunProjectsLocationsCloudpubsubsourcesListRequest',
        response_type_name='ListCloudPubSubSourcesResponse',
        supports_download=False,
    )

  class ProjectsLocationsCloudschedulersourcesService(base_api.BaseApiService):
    """Service class for the projects_locations_cloudschedulersources resource."""

    _NAME = 'projects_locations_cloudschedulersources'

    def __init__(self, client):
      super(RunV1alpha1.ProjectsLocationsCloudschedulersourcesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new cloudschedulersource.

      Args:
        request: (RunProjectsLocationsCloudschedulersourcesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CloudSchedulerSource) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/cloudschedulersources',
        http_method='POST',
        method_id='run.projects.locations.cloudschedulersources.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v1alpha1/{+parent}/cloudschedulersources',
        request_field='cloudSchedulerSource',
        request_type_name='RunProjectsLocationsCloudschedulersourcesCreateRequest',
        response_type_name='CloudSchedulerSource',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Rpc to delete a cloudschedulersource.

      Args:
        request: (RunProjectsLocationsCloudschedulersourcesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/cloudschedulersources/{cloudschedulersourcesId}',
        http_method='DELETE',
        method_id='run.projects.locations.cloudschedulersources.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['apiVersion', 'kind', 'propagationPolicy'],
        relative_path='v1alpha1/{+name}',
        request_field='',
        request_type_name='RunProjectsLocationsCloudschedulersourcesDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Rpc to get information about a cloudschedulersource.

      Args:
        request: (RunProjectsLocationsCloudschedulersourcesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CloudSchedulerSource) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/cloudschedulersources/{cloudschedulersourcesId}',
        http_method='GET',
        method_id='run.projects.locations.cloudschedulersources.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}',
        request_field='',
        request_type_name='RunProjectsLocationsCloudschedulersourcesGetRequest',
        response_type_name='CloudSchedulerSource',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Rpc to list cloudschedulersources.

      Args:
        request: (RunProjectsLocationsCloudschedulersourcesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListCloudSchedulerSourcesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/cloudschedulersources',
        http_method='GET',
        method_id='run.projects.locations.cloudschedulersources.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['continue_', 'fieldSelector', 'includeUninitialized', 'labelSelector', 'limit', 'resourceVersion', 'watch'],
        relative_path='v1alpha1/{+parent}/cloudschedulersources',
        request_field='',
        request_type_name='RunProjectsLocationsCloudschedulersourcesListRequest',
        response_type_name='ListCloudSchedulerSourcesResponse',
        supports_download=False,
    )

    def ReplaceCloudSchedulerSource(self, request, global_params=None):
      r"""Rpc to replace a cloudschedulersource.

Only the spec and metadata labels and annotations are modifiable. After
the Update request, Cloud Run will work to make the 'status'
match the requested 'spec'.

May provide metadata.resourceVersion to enforce update from last read for
optimistic concurrency control.

      Args:
        request: (RunProjectsLocationsCloudschedulersourcesReplaceCloudSchedulerSourceRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CloudSchedulerSource) The response message.
      """
      config = self.GetMethodConfig('ReplaceCloudSchedulerSource')
      return self._RunMethod(
          config, request, global_params=global_params)

    ReplaceCloudSchedulerSource.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/cloudschedulersources/{cloudschedulersourcesId}',
        http_method='PUT',
        method_id='run.projects.locations.cloudschedulersources.replaceCloudSchedulerSource',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}',
        request_field='cloudSchedulerSource',
        request_type_name='RunProjectsLocationsCloudschedulersourcesReplaceCloudSchedulerSourceRequest',
        response_type_name='CloudSchedulerSource',
        supports_download=False,
    )

  class ProjectsLocationsCloudstoragesourcesService(base_api.BaseApiService):
    """Service class for the projects_locations_cloudstoragesources resource."""

    _NAME = 'projects_locations_cloudstoragesources'

    def __init__(self, client):
      super(RunV1alpha1.ProjectsLocationsCloudstoragesourcesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new cloudstoragesource.

      Args:
        request: (RunProjectsLocationsCloudstoragesourcesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CloudStorageSource) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/cloudstoragesources',
        http_method='POST',
        method_id='run.projects.locations.cloudstoragesources.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v1alpha1/{+parent}/cloudstoragesources',
        request_field='cloudStorageSource',
        request_type_name='RunProjectsLocationsCloudstoragesourcesCreateRequest',
        response_type_name='CloudStorageSource',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Rpc to delete a cloudstoragesource.

      Args:
        request: (RunProjectsLocationsCloudstoragesourcesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/cloudstoragesources/{cloudstoragesourcesId}',
        http_method='DELETE',
        method_id='run.projects.locations.cloudstoragesources.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['apiVersion', 'kind', 'propagationPolicy'],
        relative_path='v1alpha1/{+name}',
        request_field='',
        request_type_name='RunProjectsLocationsCloudstoragesourcesDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Rpc to get information about a cloudstoragesource.

      Args:
        request: (RunProjectsLocationsCloudstoragesourcesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CloudStorageSource) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/cloudstoragesources/{cloudstoragesourcesId}',
        http_method='GET',
        method_id='run.projects.locations.cloudstoragesources.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}',
        request_field='',
        request_type_name='RunProjectsLocationsCloudstoragesourcesGetRequest',
        response_type_name='CloudStorageSource',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Rpc to list cloudstoragesources.

      Args:
        request: (RunProjectsLocationsCloudstoragesourcesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListCloudStorageSourcesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/cloudstoragesources',
        http_method='GET',
        method_id='run.projects.locations.cloudstoragesources.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['continue_', 'fieldSelector', 'includeUninitialized', 'labelSelector', 'limit', 'resourceVersion', 'watch'],
        relative_path='v1alpha1/{+parent}/cloudstoragesources',
        request_field='',
        request_type_name='RunProjectsLocationsCloudstoragesourcesListRequest',
        response_type_name='ListCloudStorageSourcesResponse',
        supports_download=False,
    )

    def ReplaceCloudStorageSource(self, request, global_params=None):
      r"""Rpc to replace a cloudstoragesource.

Only the spec and metadata labels and annotations are modifiable. After
the Update request, Cloud Run will work to make the 'status'
match the requested 'spec'.

May provide metadata.resourceVersion to enforce update from last read for
optimistic concurrency control.

      Args:
        request: (RunProjectsLocationsCloudstoragesourcesReplaceCloudStorageSourceRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CloudStorageSource) The response message.
      """
      config = self.GetMethodConfig('ReplaceCloudStorageSource')
      return self._RunMethod(
          config, request, global_params=global_params)

    ReplaceCloudStorageSource.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/cloudstoragesources/{cloudstoragesourcesId}',
        http_method='PUT',
        method_id='run.projects.locations.cloudstoragesources.replaceCloudStorageSource',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}',
        request_field='cloudStorageSource',
        request_type_name='RunProjectsLocationsCloudstoragesourcesReplaceCloudStorageSourceRequest',
        response_type_name='CloudStorageSource',
        supports_download=False,
    )

  class ProjectsLocationsConfigurationsService(base_api.BaseApiService):
    """Service class for the projects_locations_configurations resource."""

    _NAME = 'projects_locations_configurations'

    def __init__(self, client):
      super(RunV1alpha1.ProjectsLocationsConfigurationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Rpc to get information about a configuration.

      Args:
        request: (RunProjectsLocationsConfigurationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Configuration) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/configurations/{configurationsId}',
        http_method='GET',
        method_id='run.projects.locations.configurations.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}',
        request_field='',
        request_type_name='RunProjectsLocationsConfigurationsGetRequest',
        response_type_name='Configuration',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Rpc to list configurations.

      Args:
        request: (RunProjectsLocationsConfigurationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListConfigurationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/configurations',
        http_method='GET',
        method_id='run.projects.locations.configurations.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['continue_', 'fieldSelector', 'includeUninitialized', 'labelSelector', 'limit', 'resourceVersion', 'watch'],
        relative_path='v1alpha1/{+parent}/configurations',
        request_field='',
        request_type_name='RunProjectsLocationsConfigurationsListRequest',
        response_type_name='ListConfigurationsResponse',
        supports_download=False,
    )

  class ProjectsLocationsDomainmappingsService(base_api.BaseApiService):
    """Service class for the projects_locations_domainmappings resource."""

    _NAME = 'projects_locations_domainmappings'

    def __init__(self, client):
      super(RunV1alpha1.ProjectsLocationsDomainmappingsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new domain mapping.

      Args:
        request: (RunProjectsLocationsDomainmappingsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (DomainMapping) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/domainmappings',
        http_method='POST',
        method_id='run.projects.locations.domainmappings.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v1alpha1/{+parent}/domainmappings',
        request_field='domainMapping',
        request_type_name='RunProjectsLocationsDomainmappingsCreateRequest',
        response_type_name='DomainMapping',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Rpc to delete a domain mapping.

      Args:
        request: (RunProjectsLocationsDomainmappingsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/domainmappings/{domainmappingsId}',
        http_method='DELETE',
        method_id='run.projects.locations.domainmappings.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['apiVersion', 'kind', 'orphanDependents', 'propagationPolicy'],
        relative_path='v1alpha1/{+name}',
        request_field='',
        request_type_name='RunProjectsLocationsDomainmappingsDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Rpc to get information about a domain mapping.

      Args:
        request: (RunProjectsLocationsDomainmappingsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (DomainMapping) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/domainmappings/{domainmappingsId}',
        http_method='GET',
        method_id='run.projects.locations.domainmappings.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}',
        request_field='',
        request_type_name='RunProjectsLocationsDomainmappingsGetRequest',
        response_type_name='DomainMapping',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Rpc to list domain mappings.

      Args:
        request: (RunProjectsLocationsDomainmappingsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListDomainMappingsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/domainmappings',
        http_method='GET',
        method_id='run.projects.locations.domainmappings.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['continue_', 'fieldSelector', 'includeUninitialized', 'labelSelector', 'limit', 'resourceVersion', 'watch'],
        relative_path='v1alpha1/{+parent}/domainmappings',
        request_field='',
        request_type_name='RunProjectsLocationsDomainmappingsListRequest',
        response_type_name='ListDomainMappingsResponse',
        supports_download=False,
    )

  class ProjectsLocationsRevisionsService(base_api.BaseApiService):
    """Service class for the projects_locations_revisions resource."""

    _NAME = 'projects_locations_revisions'

    def __init__(self, client):
      super(RunV1alpha1.ProjectsLocationsRevisionsService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Rpc to delete a revision.

      Args:
        request: (RunProjectsLocationsRevisionsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/revisions/{revisionsId}',
        http_method='DELETE',
        method_id='run.projects.locations.revisions.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['apiVersion', 'kind', 'orphanDependents', 'propagationPolicy'],
        relative_path='v1alpha1/{+name}',
        request_field='',
        request_type_name='RunProjectsLocationsRevisionsDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Rpc to get information about a revision.

      Args:
        request: (RunProjectsLocationsRevisionsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Revision) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/revisions/{revisionsId}',
        http_method='GET',
        method_id='run.projects.locations.revisions.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}',
        request_field='',
        request_type_name='RunProjectsLocationsRevisionsGetRequest',
        response_type_name='Revision',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Rpc to list revisions.

      Args:
        request: (RunProjectsLocationsRevisionsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListRevisionsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/revisions',
        http_method='GET',
        method_id='run.projects.locations.revisions.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['continue_', 'fieldSelector', 'includeUninitialized', 'labelSelector', 'limit', 'resourceVersion', 'watch'],
        relative_path='v1alpha1/{+parent}/revisions',
        request_field='',
        request_type_name='RunProjectsLocationsRevisionsListRequest',
        response_type_name='ListRevisionsResponse',
        supports_download=False,
    )

  class ProjectsLocationsRoutesService(base_api.BaseApiService):
    """Service class for the projects_locations_routes resource."""

    _NAME = 'projects_locations_routes'

    def __init__(self, client):
      super(RunV1alpha1.ProjectsLocationsRoutesService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Rpc to get information about a route.

      Args:
        request: (RunProjectsLocationsRoutesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Route) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/routes/{routesId}',
        http_method='GET',
        method_id='run.projects.locations.routes.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}',
        request_field='',
        request_type_name='RunProjectsLocationsRoutesGetRequest',
        response_type_name='Route',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Rpc to list routes.

      Args:
        request: (RunProjectsLocationsRoutesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListRoutesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/routes',
        http_method='GET',
        method_id='run.projects.locations.routes.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['continue_', 'fieldSelector', 'includeUninitialized', 'labelSelector', 'limit', 'resourceVersion', 'watch'],
        relative_path='v1alpha1/{+parent}/routes',
        request_field='',
        request_type_name='RunProjectsLocationsRoutesListRequest',
        response_type_name='ListRoutesResponse',
        supports_download=False,
    )

  class ProjectsLocationsServicesService(base_api.BaseApiService):
    """Service class for the projects_locations_services resource."""

    _NAME = 'projects_locations_services'

    def __init__(self, client):
      super(RunV1alpha1.ProjectsLocationsServicesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Rpc to create a service.

      Args:
        request: (RunProjectsLocationsServicesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Service) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/services',
        http_method='POST',
        method_id='run.projects.locations.services.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v1alpha1/{+parent}/services',
        request_field='service',
        request_type_name='RunProjectsLocationsServicesCreateRequest',
        response_type_name='Service',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Rpc to delete a service.
This will cause the Service to stop serving traffic and will delete the
child entities like Routes, Configurations and Revisions.

      Args:
        request: (RunProjectsLocationsServicesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/services/{servicesId}',
        http_method='DELETE',
        method_id='run.projects.locations.services.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['apiVersion', 'kind', 'orphanDependents', 'propagationPolicy'],
        relative_path='v1alpha1/{+name}',
        request_field='',
        request_type_name='RunProjectsLocationsServicesDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Rpc to get information about a service.

      Args:
        request: (RunProjectsLocationsServicesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Service) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/services/{servicesId}',
        http_method='GET',
        method_id='run.projects.locations.services.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}',
        request_field='',
        request_type_name='RunProjectsLocationsServicesGetRequest',
        response_type_name='Service',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Get the IAM Access Control policy currently in effect for the given.
Cloud Run service. This result does not include any inherited policies.

      Args:
        request: (RunProjectsLocationsServicesGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/services/{servicesId}:getIamPolicy',
        http_method='GET',
        method_id='run.projects.locations.services.getIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=['options_requestedPolicyVersion'],
        relative_path='v1alpha1/{+resource}:getIamPolicy',
        request_field='',
        request_type_name='RunProjectsLocationsServicesGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Rpc to list services.

      Args:
        request: (RunProjectsLocationsServicesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListServicesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/services',
        http_method='GET',
        method_id='run.projects.locations.services.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['continue_', 'fieldSelector', 'includeUninitialized', 'labelSelector', 'limit', 'resourceVersion', 'watch'],
        relative_path='v1alpha1/{+parent}/services',
        request_field='',
        request_type_name='RunProjectsLocationsServicesListRequest',
        response_type_name='ListServicesResponse',
        supports_download=False,
    )

    def ReplaceService(self, request, global_params=None):
      r"""Rpc to replace a service.

Only the spec and metadata labels and annotations are modifiable. After
the Update request, Cloud Run will work to make the 'status'
match the requested 'spec'.

May provide metadata.resourceVersion to enforce update from last read for
optimistic concurrency control.

      Args:
        request: (RunProjectsLocationsServicesReplaceServiceRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Service) The response message.
      """
      config = self.GetMethodConfig('ReplaceService')
      return self._RunMethod(
          config, request, global_params=global_params)

    ReplaceService.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/services/{servicesId}',
        http_method='PUT',
        method_id='run.projects.locations.services.replaceService',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}',
        request_field='service',
        request_type_name='RunProjectsLocationsServicesReplaceServiceRequest',
        response_type_name='Service',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the IAM Access control policy for the specified Service. Overwrites.
any existing policy.

      Args:
        request: (RunProjectsLocationsServicesSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/services/{servicesId}:setIamPolicy',
        http_method='POST',
        method_id='run.projects.locations.services.setIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1alpha1/{+resource}:setIamPolicy',
        request_field='setIamPolicyRequest',
        request_type_name='RunProjectsLocationsServicesSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified Project.

There are no permissions required for making this API call.

      Args:
        request: (RunProjectsLocationsServicesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/services/{servicesId}:testIamPermissions',
        http_method='POST',
        method_id='run.projects.locations.services.testIamPermissions',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1alpha1/{+resource}:testIamPermissions',
        request_field='testIamPermissionsRequest',
        request_type_name='RunProjectsLocationsServicesTestIamPermissionsRequest',
        response_type_name='TestIamPermissionsResponse',
        supports_download=False,
    )

  class ProjectsLocationsTriggersService(base_api.BaseApiService):
    """Service class for the projects_locations_triggers resource."""

    _NAME = 'projects_locations_triggers'

    def __init__(self, client):
      super(RunV1alpha1.ProjectsLocationsTriggersService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new trigger.

      Args:
        request: (RunProjectsLocationsTriggersCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Trigger) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/triggers',
        http_method='POST',
        method_id='run.projects.locations.triggers.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v1alpha1/{+parent}/triggers',
        request_field='trigger',
        request_type_name='RunProjectsLocationsTriggersCreateRequest',
        response_type_name='Trigger',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Rpc to delete a trigger.

      Args:
        request: (RunProjectsLocationsTriggersDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/triggers/{triggersId}',
        http_method='DELETE',
        method_id='run.projects.locations.triggers.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['apiVersion', 'kind', 'propagationPolicy'],
        relative_path='v1alpha1/{+name}',
        request_field='',
        request_type_name='RunProjectsLocationsTriggersDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Rpc to get information about a trigger.

      Args:
        request: (RunProjectsLocationsTriggersGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Trigger) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/triggers/{triggersId}',
        http_method='GET',
        method_id='run.projects.locations.triggers.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}',
        request_field='',
        request_type_name='RunProjectsLocationsTriggersGetRequest',
        response_type_name='Trigger',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Rpc to list triggers.

      Args:
        request: (RunProjectsLocationsTriggersListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListTriggersResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/triggers',
        http_method='GET',
        method_id='run.projects.locations.triggers.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['continue_', 'fieldSelector', 'includeUninitialized', 'labelSelector', 'limit', 'resourceVersion', 'watch'],
        relative_path='v1alpha1/{+parent}/triggers',
        request_field='',
        request_type_name='RunProjectsLocationsTriggersListRequest',
        response_type_name='ListTriggersResponse',
        supports_download=False,
    )

  class ProjectsLocationsService(base_api.BaseApiService):
    """Service class for the projects_locations resource."""

    _NAME = 'projects_locations'

    def __init__(self, client):
      super(RunV1alpha1.ProjectsLocationsService, self).__init__(client)
      self._upload_configs = {
          }

    def List(self, request, global_params=None):
      r"""Lists information about the supported locations for this service.

      Args:
        request: (RunProjectsLocationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListLocationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations',
        http_method='GET',
        method_id='run.projects.locations.list',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['filter', 'pageSize', 'pageToken'],
        relative_path='v1alpha1/{+name}/locations',
        request_field='',
        request_type_name='RunProjectsLocationsListRequest',
        response_type_name='ListLocationsResponse',
        supports_download=False,
    )

  class ProjectsService(base_api.BaseApiService):
    """Service class for the projects resource."""

    _NAME = 'projects'

    def __init__(self, client):
      super(RunV1alpha1.ProjectsService, self).__init__(client)
      self._upload_configs = {
          }
