#!/usr/local/bin/python3.8
# -*- coding: utf-8 -*-

# Copyright: (c) 2018, Ansible Project
# GNU General Public License v3.0+ (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

DOCUMENTATION = r'''
---
module: win_pester
short_description: Run Pester tests on Windows hosts
description:
  - Run Pester tests on Windows hosts.
  - Test files have to be available on the remote host.
requirements:
  - Pester
options:
  path:
    description:
      - Path to a pester test file or a folder where tests can be found.
      - If the path is a folder, the module will consider all ps1 files as Pester tests.
    type: str
    required: true
  tags:
    description:
      - Runs only tests in Describe blocks with specified Tags values.
      - Accepts multiple comma separated tags.
    type: list
    elements: str
  output_file:
    description:
      - Generates an output test report.
    type: str
  output_format:
    description:
      - Format of the test report to be generated.
      - This parameter is to be used with output_file option.
    type: str
    default: NunitXML
  test_parameters:
    description:
      - Allows to specify parameters to the test script.
    type: dict
  version:
    description:
      - Minimum version of the pester module that has to be available on the remote host.
    type: str
    aliases:
    - minimum_version
author:
    - Erwan Quelin (@equelin)
    - Prasoon Karunan V (@prasoonkarunan)
'''

EXAMPLES = r'''
- name: Get facts
  ansible.windows.setup:

- name: Add Pester module
  action:
    module_name: "{{ 'community.windows.win_psmodule' if ansible_powershell_version >= 5 else 'chocolatey.chocolatey.win_chocolatey' }}"
    name: Pester
    state: present

- name: Run the pester test provided in the path parameter.
  community.windows.win_pester:
    path: C:\Pester

- name: Run the pester tests only for the tags specified.
  community.windows.win_pester:
    path: C:\Pester\TestScript.tests
    tags: CI,UnitTests

# Run pesters tests files that are present in the specified folder
# ensure that the pester module version available is greater or equal to the version parameter.
- name: Run the pester test present in a folder and check the Pester module version.
  community.windows.win_pester:
    path: C:\Pester\test01.test.ps1
    version: 4.1.0

- name: Run the pester test present in a folder with given script parameters.
  community.windows.win_pester:
    path: C:\Pester\test04.test.ps1
    test_parameters:
      Process: lsass
      Service: bits

- name: Run the pester test present in a folder and generate NunitXML test result..
  community.windows.win_pester:
    path: C:\Pester\test04.test.ps1
    output_file: c:\Pester\resullt\testresult.xml
'''

RETURN = r'''
pester_version:
    description: Version of the pester module found on the remote host.
    returned: always
    type: str
    sample: 4.3.1
output:
    description: Results of the Pester tests.
    returned: success
    type: list
    sample: false
'''
