require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_SYS_SYSTM_H_)) {
    eval 'sub _SYS_SYSTM_H_ () {1;}' unless defined(&_SYS_SYSTM_H_);
    require 'sys/cdefs.ph';
    require 'machine/atomic.ph';
    require 'machine/cpufunc.ph';
    require 'sys/callout.ph';
    require 'sys/queue.ph';
    require 'sys/stdint.ph';
    if(defined(&_KERNEL)) {
	eval 'sub KERNEL_PANICKED () {
	    eval q( &__predict_false( &panicked));
	}' unless defined(&KERNEL_PANICKED);
	eval("sub VM_GUEST_NO () { 0; }") unless defined(&VM_GUEST_NO);
	eval("sub VM_GUEST_VM () { 1; }") unless defined(&VM_GUEST_VM);
	eval("sub VM_GUEST_XEN () { 2; }") unless defined(&VM_GUEST_XEN);
	eval("sub VM_GUEST_HV () { 3; }") unless defined(&VM_GUEST_HV);
	eval("sub VM_GUEST_VMWARE () { 4; }") unless defined(&VM_GUEST_VMWARE);
	eval("sub VM_GUEST_KVM () { 5; }") unless defined(&VM_GUEST_KVM);
	eval("sub VM_GUEST_BHYVE () { 6; }") unless defined(&VM_GUEST_BHYVE);
	eval("sub VM_GUEST_VBOX () { 7; }") unless defined(&VM_GUEST_VBOX);
	eval("sub VM_GUEST_PARALLELS () { 8; }") unless defined(&VM_GUEST_PARALLELS);
	eval("sub VM_LAST () { 9; }") unless defined(&VM_LAST);
	if(defined(&INVARIANTS)) {
	    eval 'sub VNASSERT {
	        my($exp, $vp, $msg) = @_;
    		eval q( &do {  &if ( &__predict_false(!($exp))) {  &vn_printf($vp, \\"VNASSERT failed: %s not true at %s:%d (%s)\\\\n\\", $exp,  &__FILE__,  &__LINE__,  &__func__);  &kassert_panic $msg; } }  &while (0));
	    }' unless defined(&VNASSERT);
	    eval 'sub VNPASS {
	        my($exp, $vp) = @_;
    		eval q( &do {  &const \'char\' * &_exp = $exp;  &VNASSERT($exp, $vp, (\\"condition %s not met at %s:%d (%s)\\",  &_exp,  &__FILE__,  &__LINE__,  &__func__)); }  &while (0));
	    }' unless defined(&VNPASS);
	    eval 'sub __assert_unreachable () {
	        eval q( &panic(\\"executing segment marked as unreachable at %s:%d (%s)\\\\n\\",  &__FILE__,  &__LINE__,  &__func__));
	    }' unless defined(&__assert_unreachable);
	} else {
	    eval 'sub VNASSERT {
	        my($exp, $vp, $msg) = @_;
    		eval q( &do { }  &while (0));
	    }' unless defined(&VNASSERT);
	    eval 'sub VNPASS {
	        my($exp, $vp) = @_;
    		eval q( &do { }  &while (0));
	    }' unless defined(&VNPASS);
	    eval 'sub __assert_unreachable () {
	        eval q( &__unreachable());
	    }' unless defined(&__assert_unreachable);
	}
	unless(defined(&CTASSERT)) {
	    eval 'sub CTASSERT {
	        my($x) = @_;
    		eval q( &_Static_assert($x, \\"compile-time assertion failed\\"));
	    }' unless defined(&CTASSERT);
	}
    }
    if(defined(&_STANDALONE)) {
	eval 'sub kassert_panic () { &printf;}' unless defined(&kassert_panic);
    } else {
	if(defined(&WITNESS) || defined(&INVARIANT_SUPPORT)) {
	    if(defined(&KASSERT_PANIC_OPTIONAL)) {
	    } else {
		eval 'sub kassert_panic () { &panic;}' unless defined(&kassert_panic);
	    }
	}
    }
    if(defined(&INVARIANTS) || defined(&_STANDALONE)) {
	eval 'sub KASSERT {
	    my($exp,$msg) = @_;
    	    eval q( &do {  &if ( &__predict_false(!($exp)))  &kassert_panic $msg; }  &while (0));
	}' unless defined(&KASSERT);
    } else {
	eval 'sub KASSERT {
	    my($exp,$msg) = @_;
    	    eval q( &do { }  &while (0));
	}' unless defined(&KASSERT);
    }
    eval 'sub MPASS {
        my($ex) = @_;
	    eval q( &MPASS4($ex, $ex,  &__FILE__,  &__LINE__));
    }' unless defined(&MPASS);
    eval 'sub MPASS2 {
        my($ex, $what) = @_;
	    eval q( &MPASS4($ex, $what,  &__FILE__,  &__LINE__));
    }' unless defined(&MPASS2);
    eval 'sub MPASS3 {
        my($ex, $file, $line) = @_;
	    eval q( &MPASS4($ex, $ex, $file, $line));
    }' unless defined(&MPASS3);
    eval 'sub MPASS4 {
        my($ex, $what, $file, $line) = @_;
	    eval q( &KASSERT(($ex), (\\"Assertion %s failed at %s:%d\\", $what, $file, $line)));
    }' unless defined(&MPASS4);
    eval 'sub __read_mostly () { &__section(".data.read_mostly");}' unless defined(&__read_mostly);
    eval 'sub __read_frequently () { &__section(".data.read_frequently");}' unless defined(&__read_frequently);
    eval 'sub __exclusive_cache_line () { &__aligned( &CACHE_LINE_SIZE)  &__section(".data.exclusive_cache_line");}' unless defined(&__exclusive_cache_line);
    if(defined(&_KERNEL)) {
	require 'sys/param.ph';
	require 'sys/pcpu.ph';
	require 'sys/kpilite.ph';
	eval 'sub ASSERT_ATOMIC_LOAD_PTR {
	    my($var, $msg) = @_;
    	    eval q( &KASSERT($sizeof{$var} == $sizeof{ &void }  && (( &uintptr_t)($var) & ($sizeof{ &void } - 1)) == 0, $msg));
	}' unless defined(&ASSERT_ATOMIC_LOAD_PTR);
	eval 'sub CRITICAL_ASSERT {
	    my($td) = @_;
    	    eval q( &KASSERT(($td)-> &td_critnest >= 1, (\\"Not in critical section\\")));
	}' unless defined(&CRITICAL_ASSERT);
	eval 'sub SCHEDULER_STOPPED_TD {
	    my($td) = @_;
    	    eval q(({  &MPASS(($td) ==  &curthread);  &__predict_false(($td)-> &td_stopsched); }));
	}' unless defined(&SCHEDULER_STOPPED_TD);
	eval 'sub SCHEDULER_STOPPED () {
	    eval q( &SCHEDULER_STOPPED_TD( &curthread));
	}' unless defined(&SCHEDULER_STOPPED);
	if(defined(&__LP64__)) {
	    eval 'sub IOSIZE_MAX () { &iosize_max();}' unless defined(&IOSIZE_MAX);
	    eval 'sub DEVFS_IOSIZE_MAX () { &devfs_iosize_max();}' unless defined(&DEVFS_IOSIZE_MAX);
	} else {
	    eval 'sub IOSIZE_MAX () { &SSIZE_MAX;}' unless defined(&IOSIZE_MAX);
	    eval 'sub DEVFS_IOSIZE_MAX () { &SSIZE_MAX;}' unless defined(&DEVFS_IOSIZE_MAX);
	}
	eval 'sub HASH_NOWAIT () {0x1;}' unless defined(&HASH_NOWAIT);
	eval 'sub HASH_WAITOK () {0x2;}' unless defined(&HASH_WAITOK);
	if(defined(&KLD_MODULE) || defined(&KTR_CRITICAL) || !defined(&_KERNEL) || defined(&GENOFFSET)) {
	    eval 'sub critical_enter () {
	        eval q( &critical_enter_KBI());
	    }' unless defined(&critical_enter);
	    eval 'sub critical_exit () {
	        eval q( &critical_exit_KBI());
	    }' unless defined(&critical_exit);
	} else {
	    eval 'sub critical_enter {
	        my($void) = @_;
    		eval q({ \'struct thread_lite\' * &td;  &td =  &curthread;  ($td->{td_critnest})++;  &atomic_interrupt_fence(); });
	    }' unless defined(&critical_enter);
	    eval 'sub critical_exit {
	        my($void) = @_;
    		eval q({ \'struct thread_lite\' * &td;  &td =  &curthread;  &KASSERT( ($td->{td_critnest}) != 0, (\\"critical_exit: td_critnest == 0\\"));  &atomic_interrupt_fence();  ($td->{td_critnest})--;  &atomic_interrupt_fence();  &if ( &__predict_false( ($td->{td_owepreempt})))  &critical_exit_preempt(); });
	    }' unless defined(&critical_exit);
	}
	if(defined(&EARLY_PRINTF)) {
	}
	eval 'sub HD_COLUMN_MASK () {0xff;}' unless defined(&HD_COLUMN_MASK);
	eval 'sub HD_DELIM_MASK () {0xff00;}' unless defined(&HD_DELIM_MASK);
	eval 'sub HD_OMIT_COUNT () {(1<< 16);}' unless defined(&HD_OMIT_COUNT);
	eval 'sub HD_OMIT_HEX () {(1<< 17);}' unless defined(&HD_OMIT_HEX);
	eval 'sub HD_OMIT_CHARS () {(1<< 18);}' unless defined(&HD_OMIT_CHARS);
	eval 'sub ovbcopy {
	    my($f, $t, $l) = @_;
    	    eval q( &bcopy(($f), ($t), ($l)));
	}' unless defined(&ovbcopy);
	if(defined(&KASAN)) {
	    eval 'sub SAN_PREFIX () { &kasan_;}' unless defined(&SAN_PREFIX);
	}
 elsif(defined(&KCSAN)) {
	    eval 'sub SAN_PREFIX () { &kcsan_;}' unless defined(&SAN_PREFIX);
	}
	if(defined(&SAN_PREFIX)) {
	    eval 'sub SAN_INTERCEPTOR {
	        my($func) = @_;
    		eval q( &__CONCAT( &SAN_PREFIX, $func));
	    }' unless defined(&SAN_INTERCEPTOR);
	    unless(defined(&SAN_RUNTIME)) {
		eval 'sub bcopy {
		    my($from, $to, $len) = @_;
    		    eval q( &SAN_INTERCEPTOR( &memmove)(($to), ($from), ($len)));
		}' unless defined(&bcopy);
		eval 'sub bzero {
		    my($buf, $len) = @_;
    		    eval q( &SAN_INTERCEPTOR( &memset)(($buf), 0, ($len)));
		}' unless defined(&bzero);
		eval 'sub bcmp {
		    my($b1, $b2, $len) = @_;
    		    eval q( &SAN_INTERCEPTOR( &memcmp)(($b1), ($b2), ($len)));
		}' unless defined(&bcmp);
		eval 'sub memset {
		    my($buf, $c, $len) = @_;
    		    eval q( &SAN_INTERCEPTOR( &memset)(($buf), ($c), ($len)));
		}' unless defined(&memset);
		eval 'sub memcpy {
		    my($to, $from, $len) = @_;
    		    eval q( &SAN_INTERCEPTOR( &memcpy)(($to), ($from), ($len)));
		}' unless defined(&memcpy);
		eval 'sub memmove {
		    my($dest, $src, $n) = @_;
    		    eval q( &SAN_INTERCEPTOR( &memmove)(($dest), ($src), ($n)));
		}' unless defined(&memmove);
		eval 'sub memcmp {
		    my($b1, $b2, $len) = @_;
    		    eval q( &SAN_INTERCEPTOR( &memcmp)(($b1), ($b2), ($len)));
		}' unless defined(&memcmp);
	    }
	} else {
	    eval 'sub bcopy {
	        my($from, $to, $len) = @_;
    		eval q( &__builtin_memmove(($to), ($from), ($len)));
	    }' unless defined(&bcopy);
	    eval 'sub bzero {
	        my($buf, $len) = @_;
    		eval q( &__builtin_memset(($buf), 0, ($len)));
	    }' unless defined(&bzero);
	    eval 'sub bcmp {
	        my($b1, $b2, $len) = @_;
    		eval q( &__builtin_memcmp(($b1), ($b2), ($len)));
	    }' unless defined(&bcmp);
	    eval 'sub memset {
	        my($buf, $c, $len) = @_;
    		eval q( &__builtin_memset(($buf), ($c), ($len)));
	    }' unless defined(&memset);
	    eval 'sub memcpy {
	        my($to, $from, $len) = @_;
    		eval q( &__builtin_memcpy(($to), ($from), ($len)));
	    }' unless defined(&memcpy);
	    eval 'sub memmove {
	        my($dest, $src, $n) = @_;
    		eval q( &__builtin_memmove(($dest), ($src), ($n)));
	    }' unless defined(&memmove);
	    eval 'sub memcmp {
	        my($b1, $b2, $len) = @_;
    		eval q( &__builtin_memcmp(($b1), ($b2), ($len)));
	    }' unless defined(&memcmp);
	}
	eval 'sub bzero_early {
	    my($buf, $len) = @_;
    	    eval q( &memset_early(($buf), 0, ($len)));
	}' unless defined(&bzero_early);
	eval 'sub bcopy_early {
	    my($from, $to, $len) = @_;
    	    eval q( &memmove_early(($to), ($from), ($len)));
	}' unless defined(&bcopy_early);
	eval 'sub copystr {
	    my($src, $dst, $len, $outlen) = @_;
    	    eval q(({ \'size_t\'  &__r,  &__len, * &__outlen;  &__len = ($len);  &__outlen = ($outlen);  &__r =  &strlcpy(($dst), ($src),  &__len);  &if ( &__outlen !=  &NULL) * &__outlen = (( &__r >=  &__len) ?  &__len :  &__r + 1); (( &__r >=  &__len) ?  &ENAMETOOLONG : 0); }));
	}' unless defined(&copystr);
	if(defined(&SAN_PREFIX)) {
	    unless(defined(&SAN_RUNTIME)) {
		eval 'sub copyin {
		    my($u, $k, $l) = @_;
    		    eval q( &SAN_INTERCEPTOR( &copyin)(($u), ($k), ($l)));
		}' unless defined(&copyin);
		eval 'sub copyinstr {
		    my($u, $k, $l, $lc) = @_;
    		    eval q( &SAN_INTERCEPTOR( &copyinstr)(($u), ($k), ($l), ($lc)));
		}' unless defined(&copyinstr);
		eval 'sub copyout {
		    my($k, $u, $l) = @_;
    		    eval q( &SAN_INTERCEPTOR( &copyout)(($k), ($u), ($l)));
		}' unless defined(&copyout);
	    }
	}
	eval 'sub GETENV_UNSIGNED () { &false;}' unless defined(&GETENV_UNSIGNED);
	eval 'sub GETENV_SIGNED () { &true;}' unless defined(&GETENV_SIGNED);
	require 'sys/libkern.ph';
	eval 'sub msleep {
	    my($chan, $mtx, $pri, $wmesg, $timo) = @_;
    	    eval q( &_sleep(($chan), ($mtx)-> &lock_object, ($pri), ($wmesg),  &tick_sbt * ($timo), 0,  &C_HARDCLOCK));
	}' unless defined(&msleep);
	eval 'sub msleep_sbt {
	    my($chan, $mtx, $pri, $wmesg, $bt, $pr, $flags) = @_;
    	    eval q( &_sleep(($chan), ($mtx)-> &lock_object, ($pri), ($wmesg), ($bt), ($pr), ($flags)));
	}' unless defined(&msleep_sbt);
	eval 'sub msleep_spin {
	    my($chan, $mtx, $wmesg, $timo) = @_;
    	    eval q( &msleep_spin_sbt(($chan), ($mtx), ($wmesg),  &tick_sbt * ($timo), 0,  &C_HARDCLOCK));
	}' unless defined(&msleep_spin);
	eval 'sub pause {
	    my($wmesg, $timo) = @_;
    	    eval q( &pause_sbt(($wmesg),  &tick_sbt * ($timo), 0,  &C_HARDCLOCK));
	}' unless defined(&pause);
	eval 'sub pause_sig {
	    my($wmesg, $timo) = @_;
    	    eval q( &pause_sbt(($wmesg),  &tick_sbt * ($timo), 0,  &C_HARDCLOCK |  &C_CATCH));
	}' unless defined(&pause_sig);
	eval 'sub tsleep {
	    my($chan, $pri, $wmesg, $timo) = @_;
    	    eval q( &_sleep(($chan),  &NULL, ($pri), ($wmesg),  &tick_sbt * ($timo), 0,  &C_HARDCLOCK));
	}' unless defined(&tsleep);
	eval 'sub tsleep_sbt {
	    my($chan, $pri, $wmesg, $bt, $pr, $flags) = @_;
    	    eval q( &_sleep(($chan),  &NULL, ($pri), ($wmesg), ($bt), ($pr), ($flags)));
	}' unless defined(&tsleep_sbt);
	if(defined(&__LP64__)) {
	}
	unless(defined(&__LP64__)) {
	    eval 'sub UNR64_LOCKED () {1;}' unless defined(&UNR64_LOCKED);
	}
	eval 'sub new_unrhdr64 {
	    my($unr64,$low) = @_;
    	    eval q({  ($unr64->{counter}) = $low; });
	}' unless defined(&new_unrhdr64);
	if(defined(&UNR64_LOCKED)) {
	} else {
	    eval 'sub alloc_unr64 {
	        my($unr64) = @_;
    		eval q({ ( &atomic_fetchadd_64( ($unr64->{counter}), 1)); });
	    }' unless defined(&alloc_unr64);
	}
	if(defined(&NO_OBSOLETE_CODE)) {
	    eval 'sub __gone_ok {
	        my($m, $msg) = @_;
    		eval q( &_Static_assert($m <  &P_OSREL_MAJOR( &__FreeBSD_version)), \\"Obsolete code: \\" $msg););
	    }' unless defined(&__gone_ok);
	} else {
	    eval 'sub __gone_ok {
	        my($m, $msg) = @_;
    		eval q();
	    }' unless defined(&__gone_ok);
	}
	eval 'sub gone_in {
	    my($major, $msg) = @_;
    	    eval q( &__gone_ok($major, $msg)  &_gone_in($major, $msg));
	}' unless defined(&gone_in);
	eval 'sub gone_in_dev {
	    my($dev, $major, $msg) = @_;
    	    eval q( &__gone_ok($major, $msg)  &_gone_in_dev($dev, $major, $msg));
	}' unless defined(&gone_in_dev);
	if(defined(&INVARIANTS) || defined(&WITNESS)) {
	    eval 'sub __diagused () {1;}' unless defined(&__diagused);
	} else {
	    eval 'sub __diagused () { &__unused;}' unless defined(&__diagused);
	}
    }
}
1;
