# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#
# Code generated by aaz-dev-tools
# --------------------------------------------------------------------------------------------

# pylint: skip-file
# flake8: noqa

from azure.cli.core.aaz import *


class Show(AAZCommand):
    """Get operation to get the run command.
    """

    _aaz_info = {
        "version": "2024-11-01",
        "resources": [
            ["mgmt-plane", "/subscriptions/{}/resourcegroups/{}/providers/microsoft.compute/virtualmachines/{}/runcommands/{}", "2024-11-01"],
        ]
    }

    def _handler(self, command_args):
        super()._handler(command_args)
        self._execute_operations()
        return self._output()

    _args_schema = None

    @classmethod
    def _build_arguments_schema(cls, *args, **kwargs):
        if cls._args_schema is not None:
            return cls._args_schema
        cls._args_schema = super()._build_arguments_schema(*args, **kwargs)

        # define Arg Group ""

        _args_schema = cls._args_schema
        _args_schema.resource_group = AAZResourceGroupNameArg(
            required=True,
        )
        _args_schema.run_command_name = AAZStrArg(
            options=["-n", "--name", "--run-command-name"],
            help="The name of the VirtualMachineRunCommand",
            required=True,
            id_part="child_name_1",
        )
        _args_schema.vm_name = AAZStrArg(
            options=["--vm-name"],
            help="The name of the VirtualMachine",
            required=True,
            id_part="name",
        )
        _args_schema.expand = AAZStrArg(
            options=["--expand"],
            help="The expand expression to apply on the operation.",
        )
        return cls._args_schema

    def _execute_operations(self):
        self.pre_operations()
        self.VirtualMachineRunCommandsGetByVirtualMachine(ctx=self.ctx)()
        self.post_operations()

    @register_callback
    def pre_operations(self):
        pass

    @register_callback
    def post_operations(self):
        pass

    def _output(self, *args, **kwargs):
        result = self.deserialize_output(self.ctx.vars.instance, client_flatten=True)
        return result

    class VirtualMachineRunCommandsGetByVirtualMachine(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [200]:
                return self.on_200(session)

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/runCommands/{runCommandName}",
                **self.url_parameters
            )

        @property
        def method(self):
            return "GET"

        @property
        def error_format(self):
            return "ODataV4Format"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "resourceGroupName", self.ctx.args.resource_group,
                    required=True,
                ),
                **self.serialize_url_param(
                    "runCommandName", self.ctx.args.run_command_name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
                **self.serialize_url_param(
                    "vmName", self.ctx.args.vm_name,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "$expand", self.ctx.args.expand,
                ),
                **self.serialize_query_param(
                    "api-version", "2024-11-01",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        def on_200(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200
            )

        _schema_on_200 = None

        @classmethod
        def _build_schema_on_200(cls):
            if cls._schema_on_200 is not None:
                return cls._schema_on_200

            cls._schema_on_200 = AAZObjectType()

            _schema_on_200 = cls._schema_on_200
            _schema_on_200.id = AAZStrType(
                flags={"read_only": True},
            )
            _schema_on_200.location = AAZStrType(
                flags={"required": True},
            )
            _schema_on_200.name = AAZStrType(
                flags={"read_only": True},
            )
            _schema_on_200.properties = AAZObjectType(
                flags={"client_flatten": True},
            )
            _schema_on_200.system_data = AAZObjectType(
                serialized_name="systemData",
                flags={"read_only": True},
            )
            _schema_on_200.tags = AAZDictType()
            _schema_on_200.type = AAZStrType(
                flags={"read_only": True},
            )

            properties = cls._schema_on_200.properties
            properties.async_execution = AAZBoolType(
                serialized_name="asyncExecution",
            )
            properties.error_blob_managed_identity = AAZObjectType(
                serialized_name="errorBlobManagedIdentity",
            )
            _ShowHelper._build_schema_run_command_managed_identity_read(properties.error_blob_managed_identity)
            properties.error_blob_uri = AAZStrType(
                serialized_name="errorBlobUri",
            )
            properties.instance_view = AAZObjectType(
                serialized_name="instanceView",
                flags={"read_only": True},
            )
            properties.output_blob_managed_identity = AAZObjectType(
                serialized_name="outputBlobManagedIdentity",
            )
            _ShowHelper._build_schema_run_command_managed_identity_read(properties.output_blob_managed_identity)
            properties.output_blob_uri = AAZStrType(
                serialized_name="outputBlobUri",
            )
            properties.parameters = AAZListType()
            properties.protected_parameters = AAZListType(
                serialized_name="protectedParameters",
            )
            properties.provisioning_state = AAZStrType(
                serialized_name="provisioningState",
                flags={"read_only": True},
            )
            properties.run_as_password = AAZStrType(
                serialized_name="runAsPassword",
            )
            properties.run_as_user = AAZStrType(
                serialized_name="runAsUser",
            )
            properties.source = AAZObjectType()
            properties.timeout_in_seconds = AAZIntType(
                serialized_name="timeoutInSeconds",
            )
            properties.treat_failure_as_deployment_failure = AAZBoolType(
                serialized_name="treatFailureAsDeploymentFailure",
            )

            instance_view = cls._schema_on_200.properties.instance_view
            instance_view.end_time = AAZStrType(
                serialized_name="endTime",
            )
            instance_view.error = AAZStrType()
            instance_view.execution_message = AAZStrType(
                serialized_name="executionMessage",
            )
            instance_view.execution_state = AAZStrType(
                serialized_name="executionState",
            )
            instance_view.exit_code = AAZIntType(
                serialized_name="exitCode",
            )
            instance_view.output = AAZStrType()
            instance_view.start_time = AAZStrType(
                serialized_name="startTime",
            )
            instance_view.statuses = AAZListType()

            statuses = cls._schema_on_200.properties.instance_view.statuses
            statuses.Element = AAZObjectType()

            _element = cls._schema_on_200.properties.instance_view.statuses.Element
            _element.code = AAZStrType()
            _element.display_status = AAZStrType(
                serialized_name="displayStatus",
            )
            _element.level = AAZStrType()
            _element.message = AAZStrType()
            _element.time = AAZStrType()

            parameters = cls._schema_on_200.properties.parameters
            parameters.Element = AAZObjectType()
            _ShowHelper._build_schema_run_command_input_parameter_read(parameters.Element)

            protected_parameters = cls._schema_on_200.properties.protected_parameters
            protected_parameters.Element = AAZObjectType()
            _ShowHelper._build_schema_run_command_input_parameter_read(protected_parameters.Element)

            source = cls._schema_on_200.properties.source
            source.command_id = AAZStrType(
                serialized_name="commandId",
            )
            source.script = AAZStrType()
            source.script_uri = AAZStrType(
                serialized_name="scriptUri",
            )
            source.script_uri_managed_identity = AAZObjectType(
                serialized_name="scriptUriManagedIdentity",
            )
            _ShowHelper._build_schema_run_command_managed_identity_read(source.script_uri_managed_identity)

            system_data = cls._schema_on_200.system_data
            system_data.created_at = AAZStrType(
                serialized_name="createdAt",
            )
            system_data.created_by = AAZStrType(
                serialized_name="createdBy",
            )
            system_data.created_by_type = AAZStrType(
                serialized_name="createdByType",
            )
            system_data.last_modified_at = AAZStrType(
                serialized_name="lastModifiedAt",
            )
            system_data.last_modified_by = AAZStrType(
                serialized_name="lastModifiedBy",
            )
            system_data.last_modified_by_type = AAZStrType(
                serialized_name="lastModifiedByType",
            )

            tags = cls._schema_on_200.tags
            tags.Element = AAZStrType()

            return cls._schema_on_200


class _ShowHelper:
    """Helper class for Show"""

    _schema_run_command_input_parameter_read = None

    @classmethod
    def _build_schema_run_command_input_parameter_read(cls, _schema):
        if cls._schema_run_command_input_parameter_read is not None:
            _schema.name = cls._schema_run_command_input_parameter_read.name
            _schema.value = cls._schema_run_command_input_parameter_read.value
            return

        cls._schema_run_command_input_parameter_read = _schema_run_command_input_parameter_read = AAZObjectType()

        run_command_input_parameter_read = _schema_run_command_input_parameter_read
        run_command_input_parameter_read.name = AAZStrType(
            flags={"required": True},
        )
        run_command_input_parameter_read.value = AAZStrType(
            flags={"required": True},
        )

        _schema.name = cls._schema_run_command_input_parameter_read.name
        _schema.value = cls._schema_run_command_input_parameter_read.value

    _schema_run_command_managed_identity_read = None

    @classmethod
    def _build_schema_run_command_managed_identity_read(cls, _schema):
        if cls._schema_run_command_managed_identity_read is not None:
            _schema.client_id = cls._schema_run_command_managed_identity_read.client_id
            _schema.object_id = cls._schema_run_command_managed_identity_read.object_id
            return

        cls._schema_run_command_managed_identity_read = _schema_run_command_managed_identity_read = AAZObjectType()

        run_command_managed_identity_read = _schema_run_command_managed_identity_read
        run_command_managed_identity_read.client_id = AAZStrType(
            serialized_name="clientId",
        )
        run_command_managed_identity_read.object_id = AAZStrType(
            serialized_name="objectId",
        )

        _schema.client_id = cls._schema_run_command_managed_identity_read.client_id
        _schema.object_id = cls._schema_run_command_managed_identity_read.object_id


__all__ = ["Show"]
