/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import java.io.File;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.AbstractFileCollection;
import org.gradle.api.internal.file.AbstractOpaqueFileCollection;
import org.gradle.api.internal.file.FileCollectionExecutionTimeValue;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;

public class SubtractingFileCollection
extends AbstractOpaqueFileCollection {
    private final AbstractFileCollection left;
    private final FileCollection right;

    public SubtractingFileCollection(AbstractFileCollection left, FileCollection right) {
        super(left.taskDependencyFactory, left.patternSetFactory);
        this.left = left;
        this.right = right;
    }

    public AbstractFileCollection getLeft() {
        return this.left;
    }

    public FileCollection getRight() {
        return this.right;
    }

    @Override
    public String getDisplayName() {
        return "file collection";
    }

    @Override
    public void visitDependencies(TaskDependencyResolveContext context) {
        this.left.visitDependencies(context);
    }

    @Override
    protected Set<File> getIntrinsicFiles() {
        LinkedHashSet<File> files = new LinkedHashSet<File>(this.left.getFiles());
        files.removeAll(this.right.getFiles());
        return files;
    }

    @Override
    public Optional<FileCollectionExecutionTimeValue> calculateExecutionTimeValue() {
        return this.left.calculateExecutionTimeValue().flatMap(leftEtv -> ((FileCollectionInternal)this.right).calculateExecutionTimeValue().map(rightEtv -> new SubtractingExecutionTimeValue((FileCollectionExecutionTimeValue)leftEtv, (FileCollectionExecutionTimeValue)rightEtv)));
    }

    @Override
    public boolean contains(File file) {
        return this.left.contains(file) && !this.right.contains(file);
    }

    private static class SubtractingExecutionTimeValue
    implements FileCollectionExecutionTimeValue {
        private final FileCollectionExecutionTimeValue left;
        private final FileCollectionExecutionTimeValue right;

        private SubtractingExecutionTimeValue(FileCollectionExecutionTimeValue left, FileCollectionExecutionTimeValue right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public FileCollectionInternal toFileCollection(FileCollectionFactory fileCollectionFactory) {
            return (FileCollectionInternal)this.left.toFileCollection(fileCollectionFactory).minus(this.right.toFileCollection(fileCollectionFactory));
        }
    }
}

