/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.results.serializable;

import com.google.common.collect.ImmutableList;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import org.gradle.api.file.RegularFile;

public final class SerializedMetadata {
    private final long logTime;
    private final ImmutableList<SerializedMetadataElement> metadatas;

    public SerializedMetadata(long logTime, Map<String, Object> metadata) {
        this.logTime = logTime;
        ImmutableList.Builder builder = ImmutableList.builder();
        metadata.forEach((key, value) -> builder.add((Object)new SerializedMetadataElement((String)key, SerializedMetadataElement.toBytes(value), value.getClass().getName())));
        this.metadatas = builder.build();
    }

    public SerializedMetadata(long logTime, ImmutableList<SerializedMetadataElement> metadatas) {
        this.logTime = logTime;
        this.metadatas = metadatas;
    }

    public long getLogTime() {
        return this.logTime;
    }

    public ImmutableList<SerializedMetadataElement> getEntries() {
        return this.metadatas;
    }

    public static final class SerializedMetadataElement {
        private final String key;
        private final byte[] value;
        private final String valueType;

        public SerializedMetadataElement(String key, byte[] value, String valueType) {
            this.key = key;
            this.value = value;
            this.valueType = valueType;
        }

        public String getKey() {
            return this.key;
        }

        public byte[] getSerializedValue() {
            return this.value;
        }

        public Object getValue() {
            return this.fromBytes(this.value);
        }

        public String getValueType() {
            return this.valueType;
        }

        /*
         * Enabled aggressive exception aggregation
         */
        private static byte[] toBytes(Object obj) {
            if (obj instanceof byte[]) {
                return (byte[])obj;
            }
            Object toSerialize = obj instanceof File ? ((File)obj).toURI() : (obj instanceof RegularFile ? ((RegularFile)obj).getAsFile().toURI() : obj);
            if (toSerialize instanceof Serializable) {
                try (ByteArrayOutputStream byteStream = new ByteArrayOutputStream();){
                    byte[] byArray;
                    try (ObjectOutputStream objectStream = new ObjectOutputStream(byteStream);){
                        objectStream.writeObject(toSerialize);
                        byArray = byteStream.toByteArray();
                    }
                    return byArray;
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to serialize metadata entry: " + toSerialize, e);
                }
            }
            throw new IllegalArgumentException("Object must be Serializable");
        }

        /*
         * Enabled aggressive exception aggregation
         */
        private Object fromBytes(byte[] bytes) {
            try (ByteArrayInputStream byteStream = new ByteArrayInputStream(bytes);){
                Object object;
                try (ObjectInputStream objectStream = new ObjectInputStream(byteStream);){
                    object = objectStream.readObject();
                }
                return object;
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to deserialize metadata entry: " + this.key, e);
            }
        }
    }
}

