/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.gosen.tokenAttributes;

import net.java.sen.dictionary.Morpheme;
import org.apache.lucene.analysis.gosen.ToStringUtil;
import org.apache.lucene.analysis.gosen.tokenAttributes.PartOfSpeechAttribute;
import org.apache.lucene.util.AttributeImpl;
import org.apache.lucene.util.AttributeReflector;

public class PartOfSpeechAttributeImpl
extends AttributeImpl
implements PartOfSpeechAttribute,
Cloneable {
    private static final long serialVersionUID = 1L;
    private transient Morpheme morpheme;

    @Override
    public String getPartOfSpeech() {
        return this.morpheme == null ? null : this.morpheme.getPartOfSpeech();
    }

    @Override
    public void setMorpheme(Morpheme morpheme) {
        this.morpheme = morpheme;
    }

    public void clear() {
        this.morpheme = null;
    }

    public void copyTo(AttributeImpl target) {
        PartOfSpeechAttribute t = (PartOfSpeechAttribute)target;
        t.setMorpheme(this.morpheme);
    }

    public void reflectWith(AttributeReflector reflector) {
        String partOfSpeech = this.getPartOfSpeech();
        String en = partOfSpeech == null ? null : ToStringUtil.getPOSTranslation(partOfSpeech);
        reflector.reflect(PartOfSpeechAttribute.class, "partOfSpeech", (Object)partOfSpeech);
        reflector.reflect(PartOfSpeechAttribute.class, "partOfSpeech (en)", (Object)en);
    }
}

