/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib1;

import net.jcip.annotations.Immutable;
import ucar.nc2.grib.GribNumbers;
import ucar.nc2.grib.GribStatType;
import ucar.nc2.grib.grib1.Grib1SectionProductDefinition;
import ucar.nc2.grib.grib1.tables.Grib1Customizer;

@Immutable
public class Grib1ParamTime {
    private final Grib1Customizer cust;
    private final int timeRangeIndicator;
    private final int p1;
    private final int p2;
    private final boolean isInterval;
    private final int start;
    private final int end;
    private final int forecastTime;

    public Grib1ParamTime(Grib1Customizer cust, Grib1SectionProductDefinition pds) {
        this.cust = cust;
        this.timeRangeIndicator = pds.getTimeRangeIndicator();
        this.p1 = pds.getTimeValue1();
        this.p2 = pds.getTimeValue2();
        int n = pds.getNincluded();
        switch (this.timeRangeIndicator) {
            case 0: {
                this.forecastTime = this.p1;
                this.end = 0;
                this.start = 0;
                this.isInterval = false;
                break;
            }
            case 1: {
                this.forecastTime = 0;
                this.end = 0;
                this.start = 0;
                this.isInterval = false;
                break;
            }
            case 2: {
                this.start = this.p1;
                this.end = this.p2;
                this.forecastTime = 0;
                this.isInterval = true;
                break;
            }
            case 3: {
                this.start = this.p1;
                this.end = this.p2;
                this.forecastTime = 0;
                this.isInterval = true;
                break;
            }
            case 4: {
                this.start = this.p1;
                this.end = this.p2;
                this.forecastTime = 0;
                this.isInterval = true;
                break;
            }
            case 5: {
                this.start = this.p1;
                this.end = this.p2;
                this.forecastTime = 0;
                this.isInterval = true;
                break;
            }
            case 6: {
                this.start = -this.p1;
                this.end = -this.p2;
                this.forecastTime = 0;
                this.isInterval = true;
                break;
            }
            case 7: {
                this.start = -this.p1;
                this.end = this.p2;
                this.forecastTime = 0;
                this.isInterval = true;
                break;
            }
            case 10: {
                this.forecastTime = GribNumbers.int2(this.p1, this.p2);
                this.end = 0;
                this.start = 0;
                this.isInterval = false;
                break;
            }
            case 51: {
                this.forecastTime = this.p2;
                this.end = 0;
                this.start = 0;
                this.isInterval = false;
                break;
            }
            case 113: {
                this.start = 0;
                this.end = this.p1 + n * this.p2;
                this.forecastTime = 0;
                this.isInterval = true;
                break;
            }
            case 114: {
                this.start = 0;
                this.end = this.p1 + n * this.p2;
                this.forecastTime = 0;
                this.isInterval = true;
                break;
            }
            case 115: {
                this.start = 0;
                this.end = this.p1 + n * this.p2;
                this.forecastTime = 0;
                this.isInterval = true;
                break;
            }
            case 116: {
                this.start = 0;
                this.end = this.p1 + n * this.p2;
                this.forecastTime = 0;
                this.isInterval = true;
                break;
            }
            case 117: {
                this.start = 0;
                this.end = this.p1;
                this.forecastTime = 0;
                this.isInterval = true;
                break;
            }
            case 118: {
                this.start = 0;
                this.end = n * this.p2;
                this.forecastTime = 0;
                this.isInterval = true;
                break;
            }
            case 119: {
                this.start = this.p1;
                this.end = this.p1 + n * this.p2;
                this.forecastTime = 0;
                this.isInterval = true;
                break;
            }
            case 123: {
                this.start = 0;
                this.end = n * this.p2;
                this.forecastTime = 0;
                this.isInterval = true;
                break;
            }
            case 124: {
                this.start = 0;
                this.end = n * this.p2;
                this.forecastTime = 0;
                this.isInterval = true;
                break;
            }
            case 125: {
                this.start = 0;
                this.end = this.p1 + n * this.p2;
                this.forecastTime = 0;
                this.isInterval = true;
                break;
            }
            default: {
                throw new IllegalArgumentException("PDS: Unknown Time Range Indicator " + this.timeRangeIndicator);
            }
        }
    }

    public int[] getInterval() {
        int[] nArray;
        if (this.isInterval) {
            int[] nArray2 = new int[2];
            nArray2[0] = this.start;
            nArray = nArray2;
            nArray2[1] = this.end;
        } else {
            nArray = null;
        }
        return nArray;
    }

    public int getIntervalSize() {
        return this.isInterval ? this.end - this.start : 0;
    }

    public boolean isInterval() {
        return this.isInterval;
    }

    public int getForecastTime() {
        return this.forecastTime;
    }

    public String getTimeTypeName() {
        return this.cust.getTimeTypeName(this.timeRangeIndicator);
    }

    public GribStatType getStatType() {
        return this.cust.getStatType(this.timeRangeIndicator);
    }

    public String getTimeCoord() {
        if (this.isInterval()) {
            int[] intv = this.getInterval();
            return intv[0] + "-" + intv[1];
        }
        return Integer.toString(this.getForecastTime());
    }
}

