/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.branding.desktop.reporter;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.Callable;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.JButton;
import org.gephi.branding.desktop.reporter.Report;
import org.gephi.branding.desktop.reporter.ReportPanel;
import org.openide.DialogDisplayer;
import org.openide.LifecycleManager;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class ReporterHandler
extends Handler
implements Callable<JButton>,
ActionListener {
    private Throwable throwable;
    private final String MEMORY_ERROR = NbBundle.getMessage(ReporterHandler.class, (String)"OutOfMemoryError.message");

    protected static String createMessage(Throwable thr) {
        int indexClassName;
        while (thr.getCause() != null && thr.getCause().getStackTrace().length != 0) {
            thr = thr.getCause();
        }
        String message = thr.toString();
        if (message.startsWith("java.lang.")) {
            message = message.substring(10);
        }
        if ((indexClassName = message.indexOf(58)) == -1 && thr.getStackTrace().length != 0) {
            StackTraceElement elem = thr.getStackTrace()[0];
            return message + " at " + elem.getClassName() + "." + elem.getMethodName();
        }
        return message;
    }

    @Override
    public void publish(LogRecord record) {
        if (record.getThrown() == null) {
            return;
        }
        this.throwable = record.getThrown();
        if (this.throwable != null && this.throwable instanceof OutOfMemoryError) {
            Handler[] handlers = Logger.getLogger("").getHandlers();
            for (int i = 0; i < handlers.length; ++i) {
                Handler h = handlers[i];
                h.close();
            }
            NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)this.MEMORY_ERROR, 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
            LifecycleManager.getDefault().exit();
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
        this.throwable = null;
    }

    @Override
    public JButton call() throws Exception {
        JButton btn = new JButton(NbBundle.getMessage(ReporterHandler.class, (String)"ReportHandler.button"));
        btn.addActionListener(this);
        return btn;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Report report = new Report();
        report.setThrowable(this.throwable);
        report.setSummary(ReporterHandler.createMessage(this.throwable));
        ReportPanel panel = new ReportPanel(report);
        panel.showDialog();
    }
}

