/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.io.export;

import java.io.IOException;
import java.util.Collection;
import org.gephi.desktop.io.export.ExportControllerUI;
import org.gephi.io.exporter.api.ExportController;
import org.gephi.io.exporter.spi.Exporter;
import org.gephi.project.api.Project;
import org.gephi.project.api.ProjectController;
import org.gephi.project.api.Workspace;
import org.gephi.utils.longtask.api.LongTaskErrorHandler;
import org.gephi.utils.longtask.api.LongTaskExecutor;
import org.gephi.utils.longtask.spi.LongTask;
import org.gephi.utils.progress.Progress;
import org.gephi.utils.progress.ProgressTicket;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class DesktopExportController
implements ExportControllerUI {
    private final LongTaskExecutor executor;
    private final LongTaskErrorHandler errorHandler;
    private final ExportController controller = (ExportController)Lookup.getDefault().lookup(ExportController.class);

    public DesktopExportController() {
        this.errorHandler = new LongTaskErrorHandler(){

            public void fatalError(Throwable t) {
                Exceptions.printStackTrace((Throwable)t);
            }
        };
        this.executor = new LongTaskExecutor(true, "Exporter", 10);
    }

    @Override
    public void exportFiles(FileObject folder, Exporter exporter, String extension) {
        this.checkExporter(exporter);
        MultipleWorkspacesExporter task = new MultipleWorkspacesExporter(exporter, folder, extension);
        this.executor.execute((LongTask)task, (Runnable)task);
    }

    @Override
    public void exportFile(final FileObject fileObject, final Exporter exporter) {
        this.checkExporter(exporter);
        LongTask task = null;
        if (exporter instanceof LongTask) {
            task = (LongTask)exporter;
        }
        String taskmsg = NbBundle.getMessage(DesktopExportController.class, (String)"DesktopExportController.exportTaskName", (Object)fileObject.getNameExt());
        this.executor.execute(task, new Runnable(){

            @Override
            public void run() {
                try {
                    DesktopExportController.this.controller.exportFile(FileUtil.toFile((FileObject)fileObject), exporter);
                    StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(DesktopExportController.class, (String)"DesktopExportController.status.exportSuccess", (Object)fileObject.getNameExt()));
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
        }, taskmsg, this.errorHandler);
    }

    @Override
    public ExportController getExportController() {
        return this.controller;
    }

    private void checkExporter(Exporter exporter) {
        if (exporter == null) {
            throw new RuntimeException(NbBundle.getMessage(this.getClass(), (String)"error_no_matching_file_exporter"));
        }
    }

    private class MultipleWorkspacesExporter
    implements Runnable,
    LongTask {
        private final Exporter exporter;
        private final FileObject folder;
        private final String extension;
        private boolean cancel = false;
        private ProgressTicket progressTicket;

        public MultipleWorkspacesExporter(Exporter exporter, FileObject folder, String extension) {
            this.exporter = exporter;
            this.folder = folder;
            this.extension = extension.replace(".", "");
        }

        @Override
        public void run() {
            Project project = ((ProjectController)Lookup.getDefault().lookup(ProjectController.class)).getCurrentProject();
            if (project != null) {
                Collection workspaceCollection = project.getWorkspaces();
                Progress.start((ProgressTicket)this.progressTicket, (int)workspaceCollection.size());
                for (Workspace workspace : workspaceCollection) {
                    if (this.cancel) break;
                    try {
                        String workspaceName = workspace.getName().replaceAll("[\\\\/:*?\"<>|]", "_");
                        FileObject file = this.folder.getFileObject(workspaceName, this.extension) == null ? this.folder.createData(workspaceName, this.extension) : this.folder.getFileObject(workspaceName, this.extension);
                        String taskmsg = NbBundle.getMessage(DesktopExportController.class, (String)"DesktopExportController.exportTaskName", (Object)file.getNameExt());
                        Progress.setDisplayName((ProgressTicket)this.progressTicket, (String)taskmsg);
                        this.exporter.setWorkspace(workspace);
                        DesktopExportController.this.controller.exportFile(FileUtil.toFile((FileObject)file), this.exporter);
                        Progress.progress((ProgressTicket)this.progressTicket);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                Progress.finish((ProgressTicket)this.progressTicket);
                if (!this.cancel) {
                    StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(DesktopExportController.class, (String)"DesktopExportController.status.exportAllSuccess", (Object)workspaceCollection.size(), (Object)this.folder.getPath()));
                }
            }
        }

        public boolean cancel() {
            this.cancel = true;
            return true;
        }

        public void setProgressTicket(ProgressTicket progressTicket) {
            this.progressTicket = progressTicket;
        }
    }
}

