/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.gui.map.tile;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import tim.prune.gui.map.tile.Coordinator;
import tim.prune.gui.map.tile.TileBytes;
import tim.prune.gui.map.tile.TileDef;
import tim.prune.gui.map.tile.TileManager;
import tim.prune.gui.map.tile.TileWorkerBuilder;

public class TileWorkerCoordinator
implements Coordinator {
    private final TileManager _parent;
    private final TileWorkerBuilder _builder;
    private final LinkedList<TileDef> _waitingDefs = new LinkedList();
    private final HashSet<TileDef> _processingDefs = new HashSet();
    private final ArrayList<Thread> _threads = new ArrayList();
    private int _previousZoom = -1;
    private final int _maxNumThreads;
    private static final int DEFAULT_MAX_THREADS = 20;

    public TileWorkerCoordinator(TileManager tileManager, TileWorkerBuilder tileWorkerBuilder) {
        this(tileManager, tileWorkerBuilder, 20);
    }

    public TileWorkerCoordinator(TileManager tileManager, TileWorkerBuilder tileWorkerBuilder, int n) {
        this._parent = tileManager;
        this._builder = tileWorkerBuilder;
        this._maxNumThreads = n;
    }

    public synchronized void triggerDownload(TileDef tileDef) {
        for (TileDef object : this._waitingDefs) {
            if (!object.equals(tileDef)) continue;
            return;
        }
        if (this._processingDefs.contains(tileDef)) {
            return;
        }
        this._waitingDefs.add(tileDef);
        if (this._threads.size() < this._maxNumThreads) {
            Thread thread = new Thread(this._builder.createWorker(this));
            this._threads.add(thread);
            thread.start();
        }
    }

    @Override
    public synchronized TileDef getNextDefinition() {
        TileDef tileDef;
        TileDef tileDef2 = tileDef = this._waitingDefs.isEmpty() ? null : this._waitingDefs.pop();
        if (tileDef == null) {
            return null;
        }
        int n = tileDef._zoom;
        if (n != this._previousZoom) {
            this._processingDefs.clear();
            this._previousZoom = n;
        }
        this._processingDefs.add(tileDef);
        return tileDef;
    }

    @Override
    public synchronized void finishedTile(TileDef tileDef, TileBytes tileBytes) {
        if (this._parent != null) {
            this._parent.returnTile(tileDef, tileBytes);
        }
        this._processingDefs.remove(tileDef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void threadFinished() {
        TileWorkerCoordinator tileWorkerCoordinator = this;
        synchronized (tileWorkerCoordinator) {
            ArrayList<Thread> arrayList = new ArrayList<Thread>();
            for (Thread thread : this._threads) {
                if (!thread.isAlive() || thread == Thread.currentThread()) continue;
                arrayList.add(thread);
            }
            this._threads.clear();
            this._threads.addAll(arrayList);
        }
    }
}

