#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 generics-sop
version:              0.5.1.1
visibility:           public
id:                   generics-sop-0.5.1.1-BdZcgVYrdgu1jUqog1oVKC
key:                  generics-sop-0.5.1.1-BdZcgVYrdgu1jUqog1oVKC
license:              BSD-3-Clause
maintainer:           andres@well-typed.com
author:
    Edsko de Vries <edsko@well-typed.com>, Andres Löh <andres@well-typed.com>

synopsis:             Generic Programming using True Sums of Products
description:
    A library to support the definition of generic functions.
    Datatypes are viewed in a uniform, structured way:
    the choice between constructors is represented using an n-ary
    sum, and the arguments of each constructor are represented using
    an n-ary product.

    The module "Generics.SOP" is the main module of this library and contains
    more detailed documentation.

    Since version 0.4.0.0, this package is now based on
    @<https://hackage.haskell.org/package/sop-core sop-core>@. The core package
    contains all the functionality of n-ary sums and products, whereas this
    package provides the datatype-generic programming support on top.

    Examples of using this library are provided by the following
    packages:

    * @<https://hackage.haskell.org/package/basic-sop basic-sop>@ basic examples,

    * @<https://hackage.haskell.org/package/pretty-sop pretty-sop>@ generic pretty printing,

    * @<https://hackage.haskell.org/package/lens-sop lens-sop>@ generically computed lenses,

    * @<https://hackage.haskell.org/package/json-sop json-sop>@ generic JSON conversions.

    A detailed description of the ideas behind this library is provided by
    the paper:

    * Edsko de Vries and Andres Löh.
    <http://www.andres-loeh.de/TrueSumsOfProducts True Sums of Products>.
    Workshop on Generic Programming (WGP) 2014.

category:             Generics
abi:                  ff2991ee68e5efa5e03283ed58fad9a3
exposed:              True
exposed-modules:
    Generics.SOP Generics.SOP.BasicFunctors Generics.SOP.Classes
    Generics.SOP.Constraint Generics.SOP.Dict Generics.SOP.GGP
    Generics.SOP.Instances Generics.SOP.Metadata Generics.SOP.NP
    Generics.SOP.NS Generics.SOP.Sing Generics.SOP.TH
    Generics.SOP.Type.Metadata Generics.SOP.Universe

import-dirs:          /usr/lib/ghc-8.10.5/site-local/generics-sop-0.5.1.1
library-dirs:         /usr/lib/ghc-8.10.5/site-local/generics-sop-0.5.1.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/generics-sop-0.5.1.1
hs-libraries:         HSgenerics-sop-0.5.1.1-BdZcgVYrdgu1jUqog1oVKC
depends:
    base-4.14.2.0 ghc-prim-0.6.1
    sop-core-0.5.0.1-DRjYElI1EPTKAV573Fpd8I template-haskell-2.16.0.0
    th-abstraction-0.4.3.0-5HX1AugCZKLKm3ZYKErCAM

haddock-interfaces:
    /usr/share/doc/haskell-generics-sop/html/generics-sop.haddock

haddock-html:         /usr/share/doc/haskell-generics-sop/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

