#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 hledger-lib
version:              1.21
visibility:           public
id:                   hledger-lib-1.21-8ytT3IrIkIVI6LZxX1SghF
key:                  hledger-lib-1.21-8ytT3IrIkIVI6LZxX1SghF
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:
    A reusable library providing the core functionality of hledger

description:
    A reusable library containing hledger'\''s core functionality.
    This is used by most hledger* packages so that they support the same
    common file formats, command line options, reports etc.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance
abi:                  a0b2a181d9866cf640de051e3a346cfc
exposed:              True
exposed-modules:
    Hledger Hledger.Data Hledger.Data.Account Hledger.Data.AccountName
    Hledger.Data.Amount Hledger.Data.Commodity Hledger.Data.Dates
    Hledger.Data.Journal Hledger.Data.Json Hledger.Data.Ledger
    Hledger.Data.Period Hledger.Data.PeriodicTransaction
    Hledger.Data.Posting Hledger.Data.RawOptions
    Hledger.Data.StringFormat Hledger.Data.Timeclock
    Hledger.Data.Transaction Hledger.Data.TransactionModifier
    Hledger.Data.Types Hledger.Data.Valuation Hledger.Query
    Hledger.Read Hledger.Read.Common Hledger.Read.CsvReader
    Hledger.Read.JournalReader Hledger.Read.TimeclockReader
    Hledger.Read.TimedotReader Hledger.Reports
    Hledger.Reports.AccountTransactionsReport
    Hledger.Reports.BalanceReport Hledger.Reports.BudgetReport
    Hledger.Reports.EntriesReport Hledger.Reports.MultiBalanceReport
    Hledger.Reports.PostingsReport Hledger.Reports.ReportOptions
    Hledger.Reports.ReportTypes Hledger.Reports.TransactionsReport
    Hledger.Utils Hledger.Utils.Color Hledger.Utils.Debug
    Hledger.Utils.Parse Hledger.Utils.Regex Hledger.Utils.String
    Hledger.Utils.Test Hledger.Utils.Text Hledger.Utils.Tree
    Hledger.Utils.UTF8IOCompat Text.Tabular.AsciiWide

hidden-modules:
    Text.Megaparsec.Custom Text.WideString Paths_hledger_lib

import-dirs:          /usr/lib/ghc-8.10.5/site-local/hledger-lib-1.21
library-dirs:         /usr/lib/ghc-8.10.5/site-local/hledger-lib-1.21
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/hledger-lib-1.21
hs-libraries:         HShledger-lib-1.21-8ytT3IrIkIVI6LZxX1SghF
depends:
    Decimal-0.5.2-7GheH0MVLCjHIokMpQ8dlu
    Glob-0.10.1-4GQgpbyIjcQ4yYCoQ2ZkFz
    aeson-1.5.6.0-IA546NaLWlLGqcowhw6tTs
    aeson-pretty-0.8.8-7Y85LeXJfbRBFaLbPECV89
    ansi-terminal-0.11-366lZebL4UKAFopo4Q1x1i array-0.5.4.0
    base-4.14.2.0 base-compat-batteries-0.11.2-Adi2U3TFDt9D7s2pHONdZC
    blaze-markup-0.8.2.8-3vU6uXP6yL6HskSuj4A8TX bytestring-0.10.12.0
    call-stack-0.3.0-HaJG5jRa2XM74od97nDj56
    cassava-0.5.2.0-DEdUjMttIof4W7I5xu88R4
    cassava-megaparsec-2.0.2-54ARpO3jYOTA3SZs5lNjuR
    cmdargs-0.10.21-Gp5sk8nLdQ1LCjZIDntuGG containers-0.6.4.1
    data-default-0.7.1.1-FiQ1o71Il6AF4wrr19xinj directory-1.3.6.0
    extra-1.7.9-HHsi7iW1l3L1a3O3w2D3UA
    file-embed-0.0.14.0-GfeXRY82mmWF3g3U2v7jH5 filepath-1.4.2.1
    hashtables-1.2.4.1-42Uu2tMM0gKL5YQT67BKGp
    megaparsec-9.0.1-IyAio6GA8vt39fw1sjLrjI mtl-2.2.2
    old-time-1.1.0.3-L4487sR2g8B3hwiiVWHb93
    parser-combinators-1.3.0-I56cvBuZMEG2VbjtPZAqZY
    pretty-simple-4.0.0.0-4rmXCdoD1mXINKFmCosdsr
    regex-tdfa-1.3.1.1-GKHvEQcFLVkJ8X6kzhWyIo
    safe-0.3.19-DlKvqLTtraZKItu5PR3KBM
    tabular-0.2.2.8-Hcf2VtEmwf82qKCXc6kljp
    tasty-1.4.1-o6GqK7uhQW6VZVrPJnWQG
    tasty-hunit-0.10.0.3-GsPefJbYmyR3dJXgW01qbC
    template-haskell-2.16.0.0 text-1.2.4.1 time-1.9.3
    timeit-2.0-9v31DY9p9ojLe6jxDFX4lL transformers-0.5.6.2
    uglymemo-0.1.0.1-HKV10OmQmu17xB3HkisM7k
    unordered-containers-0.2.14.0-D9MLkVL2jXfKIhE8RrmI8O
    utf8-string-1.0.2-DMovLmOdbFr3ZT2kNNb9Du

haddock-interfaces:   /usr/share/doc/haskell-hledger-lib/html/hledger-lib.haddock
haddock-html:         /usr/share/doc/haskell-hledger-lib/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

