#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 servant-swagger
version:              1.1.10
visibility:           public
id:                   servant-swagger-1.1.10-AulgTDqOIJ2GubNkNDlWNF
key:                  servant-swagger-1.1.10-AulgTDqOIJ2GubNkNDlWNF
license:              BSD-3-Clause
copyright:            (c) 2015-2018, Servant contributors
maintainer:           nickolay.kudasov@gmail.com
author:               David Johnson, Nickolay Kudasov
homepage:             https://github.com/haskell-servant/servant-swagger
synopsis:
    Generate a Swagger/OpenAPI/OAS 2.0 specification for your servant API.

description:
    Swagger is a project used to describe and document RESTful APIs. The core of the
    project is the [OpenAPI Specification (OAS)](https://swagger.io/docs/specification/about/).
    This library implements v2.0 of the spec. Unlike Servant it is language-agnostic and thus is
    quite popular among developers in different languages. It has also existed for a longer time
    and has more helpful tooling.

    This package provides means to generate a Swagger/OAS specification for a Servant API
    and also to partially test whether an API conforms with its specification.

    Generated Swagger specification then can be used for many things such as

    * displaying interactive documentation using [Swagger UI](http://swagger.io/swagger-ui/);

    * generating clients and servers in many languages using [Swagger Codegen](http://swagger.io/swagger-codegen/);

    * and [many others](http://swagger.io/open-source-integrations/).

category:             Web, Servant, Swagger
abi:                  6abff0f191d9f2d3e5e86aa79d1f5fb8
exposed:              True
exposed-modules:
    Servant.Swagger Servant.Swagger.Internal
    Servant.Swagger.Internal.Orphans Servant.Swagger.Internal.Test
    Servant.Swagger.Internal.TypeLevel
    Servant.Swagger.Internal.TypeLevel.API
    Servant.Swagger.Internal.TypeLevel.Every
    Servant.Swagger.Internal.TypeLevel.TMap Servant.Swagger.Test
    Servant.Swagger.TypeLevel

import-dirs:          /usr/lib/ghc-8.10.5/site-local/servant-swagger-1.1.10
library-dirs:         /usr/lib/ghc-8.10.5/site-local/servant-swagger-1.1.10
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/servant-swagger-1.1.10
hs-libraries:         HSservant-swagger-1.1.10-AulgTDqOIJ2GubNkNDlWNF
depends:
    QuickCheck-2.14.2-LYkEXWaccd95SoKseYSYTk
    aeson-1.5.6.0-IA546NaLWlLGqcowhw6tTs
    aeson-pretty-0.8.8-7Y85LeXJfbRBFaLbPECV89 base-4.14.2.0
    base-compat-0.11.2-Eyusxyk2CrTGloLdon9bIK bytestring-0.10.12.0
    hspec-2.8.2-HK9g9sLkinxIQHVOkGJsHm
    http-media-0.8.0.0-LqcSk1mG0Ue6jNPSZJ0rHq
    insert-ordered-containers-0.2.5-D88bOCBnkNV8LzeZqdjxBx
    lens-5.0.1-7XUkI0pM5Tr3OUSblTWRuC
    servant-0.18.2-8nC7BHdls2ZGH0w3L9LXip
    singleton-bool-0.1.6-CqpqgTc3TpQ3PWrHZH4aII
    swagger2-2.6-84xA3x5mlUjBhJuTjdw3Bh text-1.2.4.1
    unordered-containers-0.2.14.0-D9MLkVL2jXfKIhE8RrmI8O

haddock-interfaces:
    /usr/share/doc/haskell-servant-swagger/html/servant-swagger.haddock

haddock-html:         /usr/share/doc/haskell-servant-swagger/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

