#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 vector
version:              0.12.3.0
visibility:           public
id:                   vector-0.12.3.0-K9OZS5OCy7cE2QKQqSO9mp
key:                  vector-0.12.3.0-K9OZS5OCy7cE2QKQqSO9mp
license:              BSD-3-Clause
copyright:            (c) Roman Leshchinskiy 2008-2012
maintainer:           Haskell Libraries Team <libraries@haskell.org>
author:               Roman Leshchinskiy <rl@cse.unsw.edu.au>
homepage:             https://github.com/haskell/vector
synopsis:             Efficient Arrays
description:

    An efficient implementation of Int-indexed arrays (both mutable
    and immutable), with a powerful loop optimisation framework .

    It is structured as follows:

    ["Data.Vector"] Boxed vectors of arbitrary types.

    ["Data.Vector.Unboxed"] Unboxed vectors with an adaptive
    representation based on data type families.

    ["Data.Vector.Storable"] Unboxed vectors of '\''Storable'\'' types.

    ["Data.Vector.Primitive"] Unboxed vectors of primitive types as
    defined by the @primitive@ package. "Data.Vector.Unboxed" is more
    flexible at no performance cost.

    ["Data.Vector.Generic"] Generic interface to the vector types.

    There is also a (draft) tutorial on common uses of vector.

    * <http://haskell.org/haskellwiki/Numeric_Haskell:_A_Vector_Tutorial>

category:             Data, Data Structures
abi:                  9a465231d17f005e6eece27559fcea41
exposed:              True
exposed-modules:
    Data.Vector Data.Vector.Fusion.Bundle
    Data.Vector.Fusion.Bundle.Monadic Data.Vector.Fusion.Bundle.Size
    Data.Vector.Fusion.Stream.Monadic Data.Vector.Fusion.Util
    Data.Vector.Generic Data.Vector.Generic.Base
    Data.Vector.Generic.Mutable Data.Vector.Generic.Mutable.Base
    Data.Vector.Generic.New Data.Vector.Internal.Check
    Data.Vector.Mutable Data.Vector.Primitive
    Data.Vector.Primitive.Mutable Data.Vector.Storable
    Data.Vector.Storable.Internal Data.Vector.Storable.Mutable
    Data.Vector.Unboxed Data.Vector.Unboxed.Base
    Data.Vector.Unboxed.Mutable

import-dirs:          /usr/lib/ghc-8.10.5/site-local/vector-0.12.3.0
library-dirs:         /usr/lib/ghc-8.10.5/site-local/vector-0.12.3.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/vector-0.12.3.0
hs-libraries:         HSvector-0.12.3.0-K9OZS5OCy7cE2QKQqSO9mp
include-dirs:         /usr/lib/ghc-8.10.5/site-local/vector-0.12.3.0/include
depends:
    base-4.14.2.0 deepseq-1.4.4.0 ghc-prim-0.6.1
    primitive-0.7.1.0-H44eQ1j8hQJ3Kj2SFx0Ivh

haddock-interfaces:   /usr/share/doc/haskell-vector/html/vector.haddock
haddock-html:         /usr/share/doc/haskell-vector/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

