/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.asm.sparc;

import sun.jvm.hotspot.asm.sparc.SPARCRegister;
import sun.jvm.hotspot.asm.sparc.SPARCSpecialRegisterInstruction;
import sun.jvm.hotspot.utilities.Assert;

public class SPARCReadInstruction
extends SPARCSpecialRegisterInstruction {
    private final int specialReg;
    private final int asrRegNum;
    private final SPARCRegister rd;

    public SPARCReadInstruction(int specialReg, int asrRegNum, SPARCRegister rd) {
        super("rd");
        this.specialReg = specialReg;
        this.asrRegNum = asrRegNum;
        this.rd = rd;
    }

    public int getSpecialRegister() {
        return this.specialReg;
    }

    public int getAncillaryRegister() {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(this.specialReg == 4, "not an ancillary register");
        }
        return this.asrRegNum;
    }

    @Override
    protected String getDescription() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getName());
        buf.append(spaces);
        if (this.specialReg == 4) {
            buf.append("%asr" + this.asrRegNum);
        } else {
            buf.append(SPARCReadInstruction.getSpecialRegisterName(this.specialReg));
        }
        buf.append(comma);
        buf.append(this.rd.toString());
        return buf.toString();
    }
}

