"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.markdownLinkValidator = markdownLinkValidator;
exports.mutateLinkToText = mutateLinkToText;
exports.validateUrl = validateUrl;

var _unistUtilVisit = _interopRequireDefault(require("unist-util-visit"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
// @ts-ignore fixed in future versions, this is a backport
function markdownLinkValidator() {
  return function (ast) {
    (0, _unistUtilVisit.default)(ast, 'link', function (_node) {
      var node = _node;

      if (!validateUrl(node.url)) {
        mutateLinkToText(node);
      }
    });
  };
}

function mutateLinkToText(node) {
  var _;

  node.type = 'text';
  node.value = "[".concat(((_ = node.children[0]) === null || _ === void 0 ? void 0 : _.value) || '', "](").concat(node.url, ")");
  delete node.children;
  delete node.title;
  delete node.url;
  return node;
}

function validateUrl(url) {
  // A link is valid if it starts with http:, https:, or /
  return /^(https?:|\/)/.test(url);
}