/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.aether.internal.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Properties;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.DefaultTrackingFileManager$$Lambda$0;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.TrackingFileManager;
import org.jetbrains.kotlin.org.eclipse.aether.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Named
public final class DefaultTrackingFileManager
implements TrackingFileManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultTrackingFileManager.class);

    @Override
    public Properties read(File file) {
        Path filePath = file.toPath();
        if (Files.isRegularFile(filePath, new LinkOption[0])) {
            Properties properties;
            block9: {
                InputStream stream = Files.newInputStream(filePath, new OpenOption[0]);
                try {
                    Properties props = new Properties();
                    props.load(stream);
                    properties = props;
                    if (stream == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        LOGGER.warn("Failed to read tracking file '{}'", (Object)file, (Object)e);
                        throw new UncheckedIOException(e);
                    }
                }
                stream.close();
            }
            return properties;
        }
        return null;
    }

    @Override
    public Properties update(File file, Map<String, String> updates) {
        Path filePath = file.toPath();
        Properties props = new Properties();
        try {
            Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            LOGGER.warn("Failed to create tracking file parent '{}'", (Object)file, (Object)e);
            throw new UncheckedIOException(e);
        }
        try {
            if (Files.isReadable(filePath)) {
                try (InputStream stream = Files.newInputStream(filePath, new OpenOption[0]);){
                    props.load(stream);
                }
            }
            for (Map.Entry entry : updates.entrySet()) {
                if (entry.getValue() == null) {
                    props.remove(entry.getKey());
                    continue;
                }
                props.setProperty((String)entry.getKey(), (String)entry.getValue());
            }
            Properties properties = props;
            File file2 = file;
            FileUtils.writeFile(filePath, new DefaultTrackingFileManager$$Lambda$0(file2, properties));
        }
        catch (IOException e) {
            LOGGER.warn("Failed to write tracking file '{}'", (Object)file, (Object)e);
            throw new UncheckedIOException(e);
        }
        return props;
    }

    private static /* synthetic */ void lambda$update$0(File file, Properties props, Path p) throws IOException {
        try (OutputStream stream = Files.newOutputStream(p, new OpenOption[0]);){
            LOGGER.debug("Writing tracking file '{}'", (Object)file);
            props.store(stream, "NOTE: This is a Maven Resolver internal implementation file, its format can be changed without prior notice.");
        }
    }

    static /* synthetic */ void accessor$DefaultTrackingFileManager$lambda0(File file, Properties properties, Path path) {
        DefaultTrackingFileManager.lambda$update$0(file, properties, path);
    }
}

