var levelup = require('levelup')
var encode = require('encoding-down')

function packager (leveldown) {
  function Level (location, options, callback) {
    if (typeof location === 'function') {
      callback = location
    } else if (typeof options === 'function') {
      callback = options
    }

    if (!isObject(options)) {
      options = isObject(location) ? location : {}
    }

    return levelup(encode(leveldown(location), options), options, callback)
  }

  function isObject (o) {
    return typeof o === 'object' && o !== null
  }

  ['destroy', 'repair'].forEach(function (m) {
    if (typeof leveldown[m] === 'function') {
      Level[m] = function () {
        leveldown[m].apply(leveldown, arguments)
      }
    }
  })

  Level.errors = levelup.errors

  return Level
}

module.exports = packager
