/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.java.util;

import java.lang.reflect.Array;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.exceptions.RaiseException;
import org.jruby.java.proxies.ArrayJavaProxy;
import org.jruby.javasupport.JavaArray;
import org.jruby.javasupport.JavaClass;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class ArrayUtils {
    private ArrayUtils() {
    }

    public static IRubyObject arefDirect(Ruby runtime2, Object array2, JavaUtil.JavaConverter javaConverter, int index2) {
        try {
            return JavaUtil.convertJavaArrayElementToRuby(runtime2, javaConverter, array2, index2);
        }
        catch (IndexOutOfBoundsException e) {
            throw ArrayUtils.mapIndexOutOfBoundsException(runtime2, array2, index2);
        }
    }

    public static IRubyObject concatArraysDirect(ThreadContext context, Object original, Object additional) {
        int oldLength = Array.getLength(original);
        int addLength = Array.getLength(additional);
        ArrayJavaProxy proxy2 = ArrayUtils.newProxiedArray(context.runtime, original.getClass().getComponentType(), oldLength + addLength);
        Object newArray = proxy2.getObject();
        System.arraycopy(original, 0, newArray, 0, oldLength);
        System.arraycopy(additional, 0, newArray, oldLength, addLength);
        return proxy2;
    }

    public static ArrayJavaProxy newProxiedArray(Ruby runtime2, Class<?> componentType, int size2) {
        return ArrayUtils.newProxiedArray(runtime2, componentType, JavaUtil.getJavaConverter(componentType), size2);
    }

    public static ArrayJavaProxy newProxiedArray(Ruby runtime2, Class<?> componentType, JavaUtil.JavaConverter converter, int size2) {
        Object array2 = Array.newInstance(componentType, size2);
        RubyClass proxyClass = JavaClass.get(runtime2, array2.getClass()).getProxyClass();
        return new ArrayJavaProxy(runtime2, proxyClass, array2, converter);
    }

    public static IRubyObject emptyJavaArrayDirect(ThreadContext context, Class componentType) {
        return ArrayUtils.newProxiedArray(context.runtime, componentType, 0);
    }

    public static IRubyObject javaArraySubarrayDirect(ThreadContext context, Object fromArray, int index2, int size2) {
        int actualLength = Array.getLength(fromArray);
        if (index2 >= actualLength) {
            return context.nil;
        }
        if (index2 + size2 > actualLength) {
            size2 = actualLength - index2;
        }
        ArrayJavaProxy proxy2 = ArrayUtils.newProxiedArray(context.runtime, fromArray.getClass().getComponentType(), size2);
        Object newArray = proxy2.getObject();
        System.arraycopy(fromArray, index2, newArray, 0, size2);
        return proxy2;
    }

    public static IRubyObject concatArraysDirect(ThreadContext context, Object original, IRubyObject additional) {
        Ruby runtime2 = context.runtime;
        int oldLength = Array.getLength(original);
        int addLength = RubyFixnum.fix2int(Helpers.invoke(context, additional, "length"));
        ArrayJavaProxy proxy2 = ArrayUtils.newProxiedArray(runtime2, original.getClass().getComponentType(), oldLength + addLength);
        System.arraycopy(original, 0, proxy2.getObject(), 0, oldLength);
        for (int i2 = 0; i2 < addLength; ++i2) {
            IRubyObject val = Helpers.invoke(context, additional, "[]", (IRubyObject)runtime2.newFixnum(i2));
            proxy2.setValue(runtime2, oldLength + i2, val);
        }
        return proxy2;
    }

    public static IRubyObject asetDirect(Ruby runtime2, Object array2, JavaUtil.JavaConverter javaConverter, int index2, IRubyObject value2) {
        try {
            javaConverter.set(runtime2, array2, index2, value2);
        }
        catch (IndexOutOfBoundsException e) {
            throw ArrayUtils.mapIndexOutOfBoundsException(runtime2, array2, index2);
        }
        catch (ArrayStoreException e) {
            throw ArrayUtils.mapArrayStoreException(runtime2, array2, value2.getClass());
        }
        catch (IllegalArgumentException e) {
            throw ArrayUtils.mapIllegalArgumentException(runtime2, array2, value2.getClass());
        }
        return value2;
    }

    public static void setWithExceptionHandlingDirect(Ruby runtime2, Object array2, int index2, Object javaValue) {
        try {
            Array.set(array2, index2, javaValue);
        }
        catch (IndexOutOfBoundsException e) {
            throw ArrayUtils.mapIndexOutOfBoundsException(runtime2, array2, index2);
        }
        catch (ArrayStoreException e) {
            throw ArrayUtils.mapArrayStoreException(runtime2, array2, javaValue.getClass());
        }
        catch (IllegalArgumentException e) {
            throw ArrayUtils.mapIllegalArgumentException(runtime2, array2, javaValue.getClass());
        }
    }

    private static RaiseException mapIndexOutOfBoundsException(Ruby runtime2, Object array2, int index2) {
        return runtime2.newIndexError("index out of bounds for java array (" + index2 + " for length " + Array.getLength(array2) + ')');
    }

    private static RaiseException mapArrayStoreException(Ruby runtime2, Object array2, Class<?> type2) {
        return runtime2.newTypeError("wrong element type " + type2.getName() + " (array contains " + array2.getClass().getComponentType().getName() + ')');
    }

    private static RaiseException mapIllegalArgumentException(Ruby runtime2, Object array2, Class<?> type2) {
        return runtime2.newArgumentError("wrong element type " + type2.getName() + " (array contains " + array2.getClass().getComponentType().getName() + ')');
    }

    @Deprecated
    public static void copyDataToJavaArrayDirect(ThreadContext context, RubyArray rubyArray, Object javaArray) {
        ArrayUtils.copyDataToJavaArrayDirect(rubyArray, javaArray);
    }

    public static void copyDataToJavaArrayDirect(RubyArray rubyArray, Object javaArray) {
        Class<?> targetType = javaArray.getClass().getComponentType();
        if (!targetType.isPrimitive()) {
            ArrayUtils.copyDataToJavaArrayDirect(targetType, rubyArray, (Object[])javaArray);
            return;
        }
        if (Integer.TYPE == targetType) {
            ArrayUtils.copyDataToJavaArrayDirect(targetType, rubyArray, (int[])javaArray);
            return;
        }
        if (Long.TYPE == targetType) {
            ArrayUtils.copyDataToJavaArrayDirect(targetType, rubyArray, (long[])javaArray);
            return;
        }
        if (Byte.TYPE == targetType) {
            ArrayUtils.copyDataToJavaArrayDirect(targetType, rubyArray, (byte[])javaArray);
            return;
        }
        int length2 = rubyArray.getLength();
        int javaLength = Array.getLength(javaArray);
        if (javaLength < length2) {
            length2 = javaLength;
        }
        for (int i2 = 0; i2 < length2; ++i2) {
            Array.set(javaArray, i2, rubyArray.eltInternal(i2).toJava(targetType));
        }
    }

    private static void copyDataToJavaArrayDirect(Class<?> targetType, RubyArray rubyArray, Object[] javaArray) {
        int javaLength = javaArray.length;
        int length2 = rubyArray.getLength();
        if (javaLength < length2) {
            length2 = javaLength;
        }
        for (int i2 = 0; i2 < length2; ++i2) {
            javaArray[i2] = rubyArray.eltInternal(i2).toJava(targetType);
        }
    }

    private static void copyDataToJavaArrayDirect(Class<?> targetType, RubyArray rubyArray, int[] javaArray) {
        int javaLength = javaArray.length;
        int length2 = rubyArray.getLength();
        if (javaLength < length2) {
            length2 = javaLength;
        }
        for (int i2 = 0; i2 < length2; ++i2) {
            javaArray[i2] = (Integer)rubyArray.eltInternal(i2).toJava(targetType);
        }
    }

    private static void copyDataToJavaArrayDirect(Class<?> targetType, RubyArray rubyArray, long[] javaArray) {
        int javaLength = javaArray.length;
        int length2 = rubyArray.getLength();
        if (javaLength < length2) {
            length2 = javaLength;
        }
        for (int i2 = 0; i2 < length2; ++i2) {
            javaArray[i2] = (Long)rubyArray.eltInternal(i2).toJava(targetType);
        }
    }

    private static void copyDataToJavaArrayDirect(Class<?> targetType, RubyArray rubyArray, byte[] javaArray) {
        int javaLength = javaArray.length;
        int length2 = rubyArray.getLength();
        if (javaLength < length2) {
            length2 = javaLength;
        }
        for (int i2 = 0; i2 < length2; ++i2) {
            javaArray[i2] = (Byte)rubyArray.eltInternal(i2).toJava(targetType);
        }
    }

    public static void copyDataToJavaArray(ThreadContext context, RubyArray rubyArray, int src, JavaArray javaArray, int dest, int length2) {
        Class targetType = javaArray.getComponentType();
        int destLength = (int)javaArray.length().getLongValue();
        int srcLength = rubyArray.getLength();
        for (int i2 = 0; src + i2 < srcLength && dest + i2 < destLength && i2 < length2; ++i2) {
            javaArray.setWithExceptionHandling(dest + i2, rubyArray.entry(src + i2).toJava(targetType));
        }
    }
}

