# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.tree_algorithm import TreeAlgorithm


class BoostBreadthFirstSearchTree(TreeAlgorithm):
    """
    BoostBreadthFirstSearchTree - Constructs a BFS tree from a graph
    
    Superclass: TreeAlgorithm
    
    This vtk class uses the Boost breadth_first_search generic algorithm
    to perform a breadth first search from a given a 'source' vertex on
    the input graph (a Graph). The result is a tree with root node
    corresponding to the start node of the search.
    
    @sa
    Graph BoostGraphAdapter
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkBoostBreadthFirstSearchTree, obj, update, **traits)
    
    create_graph_vertex_id_array = tvtk_base.false_bool_trait(desc=\
        """
        Stores the graph vertex ids for the tree vertices in an array
        named "_graph_vertex_id".  Default is off.
        """
    )

    def _create_graph_vertex_id_array_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCreateGraphVertexIdArray,
                        self.create_graph_vertex_id_array_)

    reverse_edges = tvtk_base.false_bool_trait(desc=\
        """
        Turn on this option to reverse the edges in the graph.
        """
    )

    def _reverse_edges_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetReverseEdges,
                        self.reverse_edges_)

    def set_origin_vertex(self, *args):
        """
        V.set_origin_vertex(int)
        C++: void SetOriginVertex(IdType index)
        V.set_origin_vertex(string, Variant)
        C++: void SetOriginVertex(StdString arrayName,
            Variant value)
        Set the index (into the vertex array) of the breadth first search
        'origin' vertex.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetOriginVertex, *my_args)
        return ret

    _updateable_traits_ = \
    (('create_graph_vertex_id_array', 'GetCreateGraphVertexIdArray'),
    ('reverse_edges', 'GetReverseEdges'), ('abort_execute',
    'GetAbortExecute'), ('release_data_flag', 'GetReleaseDataFlag'),
    ('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('progress', 'GetProgress'),
    ('progress_text', 'GetProgressText'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'create_graph_vertex_id_array', 'debug',
    'global_warning_display', 'release_data_flag', 'reverse_edges',
    'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(BoostBreadthFirstSearchTree, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit BoostBreadthFirstSearchTree properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['create_graph_vertex_id_array', 'reverse_edges'], [], []),
            title='Edit BoostBreadthFirstSearchTree properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit BoostBreadthFirstSearchTree properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

