# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class SurfaceLICComposite(Object):
    """
    SurfaceLICComposite - This class decomposes the image space and
    shuffles image space data onto the new decomposition with the
    necessary guard cells to prevent artifacts at the decomposition
    boundaries.
    
    Superclass: Object
    
    After the image LIC is computed on the new decomposition this class
    will un-shuffle the computed LIC back onto the original decomposition
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkSurfaceLICComposite, obj, update, **traits)
    
    def _get_context(self):
        return wrap_vtk(self._vtk_obj.GetContext())
    def _set_context(self, arg):
        old_val = self._get_context()
        self._wrap_call(self._vtk_obj.SetContext,
                        deref_vtk(arg))
        self.trait_property_changed('context', old_val, arg)
    context = traits.Property(_get_context, _set_context, desc=\
        """
        
        """
    )

    strategy = traits.Int(3, enter_set=True, auto_set=False, desc=\
        """
        
        """
    )

    def _strategy_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetStrategy,
                        self.strategy)

    def get_composite_extent(self, *args):
        """
        V.get_composite_extent(int) -> PixelExtent
        C++: const PixelExtent &GetCompositeExtent(int i=0)
        Get the extent of the domain over which to compute the LIC. This
        can be querried only after the Composite takes place.
        """
        ret = self._wrap_call(self._vtk_obj.GetCompositeExtent, *args)
        return wrap_vtk(ret)

    def _get_data_set_extent(self):
        return wrap_vtk(self._vtk_obj.GetDataSetExtent())
    data_set_extent = traits.Property(_get_data_set_extent, desc=\
        """
        Get the whole dataset extent (all blocks).
        """
    )

    def get_disjoint_guard_extent(self, *args):
        """
        V.get_disjoint_guard_extent(int) -> PixelExtent
        C++: const PixelExtent &GetDisjointGuardExtent(int i=0)
        Get the extent of the domain over which to compute the LIC. This
        can be querried only after the Composite takes place.
        """
        ret = self._wrap_call(self._vtk_obj.GetDisjointGuardExtent, *args)
        return wrap_vtk(ret)

    def get_guard_extent(self, *args):
        """
        V.get_guard_extent(int) -> PixelExtent
        C++: const PixelExtent &GetGuardExtent(int i=0)
        Get the extent of the domain over which to compute the LIC. This
        can be querried only after the Composite takes place.
        """
        ret = self._wrap_call(self._vtk_obj.GetGuardExtent, *args)
        return wrap_vtk(ret)

    def _get_number_of_composite_extents(self):
        return self._vtk_obj.GetNumberOfCompositeExtents()
    number_of_composite_extents = traits.Property(_get_number_of_composite_extents, desc=\
        """
        Get the number of new extents assigned to this rank after the
        decomposition.
        """
    )

    def _get_window_extent(self):
        return wrap_vtk(self._vtk_obj.GetWindowExtent())
    window_extent = traits.Property(_get_window_extent, desc=\
        """
        Get the whole window extent.
        """
    )

    def build_program(self, *args):
        """
        V.build_program([float, ...]) -> int
        C++: virtual int BuildProgram(float *)
        Build programs to move data to the new decomp In parallel THIS IS
        A COLLECTIVE OPERATION
        """
        ret = self._wrap_call(self._vtk_obj.BuildProgram, *args)
        return ret

    def initialize_composite_extents(self, *args):
        """
        V.initialize_composite_extents([float, ...]) -> int
        C++: int InitializeCompositeExtents(float *vectors)
        Set up for a serial run, makes the decomp disjoint and adds
        requisite guard pixles.
        """
        ret = self._wrap_call(self._vtk_obj.InitializeCompositeExtents, *args)
        return ret

    def restore_default_communicator(self):
        """
        V.restore_default_communicator()
        C++: virtual void RestoreDefaultCommunicator()
        Set the communicator to the default communicator
        """
        ret = self._vtk_obj.RestoreDefaultCommunicator()
        return ret
        

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('strategy', 'GetStrategy'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'strategy'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(SurfaceLICComposite, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit SurfaceLICComposite properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['strategy']),
            title='Edit SurfaceLICComposite properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit SurfaceLICComposite properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

