/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.tools;

import eu.hansolo.tilesfx.chart.ChartData;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class Statistics {
    public static final double getChartDataMean(List<ChartData> DATA) {
        return Statistics.getMean(DATA.stream().map(ChartData::getValue).collect(Collectors.toList()));
    }

    public static final double getMean(List<Double> DATA) {
        return DATA.stream().mapToDouble(v -> v).sum() / (double)DATA.size();
    }

    public static final double getChartDataVariance(List<ChartData> DATA) {
        return Statistics.getVariance(DATA.stream().map(ChartData::getValue).collect(Collectors.toList()));
    }

    public static final double getVariance(List<Double> DATA) {
        double mean = Statistics.getMean(DATA);
        double temp = 0.0;
        for (double a : DATA) {
            temp += (a - mean) * (a - mean);
        }
        return temp / (double)DATA.size();
    }

    public static final double getChartDataStdDev(List<ChartData> DATA) {
        return Statistics.getStdDev(DATA.stream().map(ChartData::getValue).collect(Collectors.toList()));
    }

    public static final double getStdDev(List<Double> DATA) {
        return Math.sqrt(Statistics.getVariance(DATA));
    }

    public static final double getChartDataMedian(List<ChartData> DATA) {
        return Statistics.getMedian(DATA.stream().map(ChartData::getValue).collect(Collectors.toList()));
    }

    public static final double getMedian(List<Double> DATA) {
        int size = DATA.size();
        Collections.sort(DATA);
        return size % 2 == 0 ? (DATA.get(size / 2 - 1) + DATA.get(size / 2)) / 2.0 : DATA.get(size / 2);
    }

    public static final double getChartDataMin(List<ChartData> DATA) {
        return Statistics.getMin(DATA.stream().map(ChartData::getValue).collect(Collectors.toList()));
    }

    public static final double getMin(List<Double> DATA) {
        return DATA.stream().mapToDouble(v -> v).min().orElse(0.0);
    }

    public static final double getChartDataMax(List<ChartData> DATA) {
        return Statistics.getMax(DATA.stream().map(ChartData::getValue).collect(Collectors.toList()));
    }

    public static final double getMax(List<Double> DATA) {
        return DATA.stream().mapToDouble(v -> v).max().orElse(0.0);
    }

    public static final double getChartDataAverage(List<ChartData> DATA) {
        return Statistics.getAverage(DATA.stream().map(ChartData::getValue).collect(Collectors.toList()));
    }

    public static final double getAverage(List<Double> DATA) {
        return DATA.stream().mapToDouble(data -> data).average().orElse(-1.0);
    }
}

