from abc import ABC, ABCMeta, abstractmethod

class ConnectionCharacteristic(ABC, metaclass=ABCMeta):
    transactional: bool
    @abstractmethod
    def reset_characteristic(self, dialect, dbapi_conn): ...
    @abstractmethod
    def set_characteristic(self, dialect, dbapi_conn, value): ...
    @abstractmethod
    def get_characteristic(self, dialect, dbapi_conn): ...

class IsolationLevelCharacteristic(ConnectionCharacteristic):
    transactional: bool
    def reset_characteristic(self, dialect, dbapi_conn) -> None: ...
    def set_characteristic(self, dialect, dbapi_conn, value) -> None: ...
    def get_characteristic(self, dialect, dbapi_conn): ...
