/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.text;

import java.util.HashMap;
import java.util.Map;
import net.sf.sdedit.diagram.MessageData;
import net.sf.sdedit.error.SyntaxError;
import net.sf.sdedit.text.MessageType;
import net.sf.sdedit.util.Grep;

public class TextBasedMessageData
extends MessageData {
    private String string;
    private final Map<String, Grep.Region> regions;

    public TextBasedMessageData(String string, Grep grep) throws SyntaxError {
        this.string = string;
        this.regions = new HashMap<String, Grep.Region>();
        this.parse(grep);
    }

    private void parse(Grep grep) throws SyntaxError {
        boolean success = false;
        if (this.string.indexOf(58) == -1) {
            throw new SyntaxError(null, "not a valid message - ':' missing");
        }
        for (MessageType type : MessageType.values()) {
            success = grep.parseAndSetProperties((Object)this, type.getPattern(), this.string, this.regions, type.getProperties());
            if (!success) continue;
            return;
        }
        throw new SyntaxError(null, "not a valid message");
    }

    @Override
    public void setMessage(String message) {
        if (message.endsWith("&")) {
            this.setReturnsInstantly(true);
            message = message.substring(0, message.length() - 1);
        }
        super.setMessage(message);
    }

    @Override
    public void setCallee(String callee) {
        if (callee.length() >= 2 && callee.charAt(0) == '{' && callee.charAt(callee.length() - 1) == '}') {
            this.setCallees(callee.substring(1, callee.length() - 1).split(","));
        } else {
            super.setCallee(callee);
        }
    }

    public void setSpawner(String spawner) {
        this.setSpawnMessage(true);
        this.setCaller(spawner);
    }

    public void setLevelString(String level) {
        if (!level.equals("")) {
            this.setLevel(Integer.parseInt(level));
        }
    }

    public void setThreadString(String thread) {
        if (!thread.equals("")) {
            this.setThread(Integer.parseInt(thread));
        }
    }

    public void setDummy(String dummy) {
    }

    public void setNoteId(String noteId) {
        if (!(noteId = noteId.trim()).equals("")) {
            String[] ids = (noteId = noteId.substring(1, noteId.length() - 1)).split(",");
            if (ids[0].length() > 0) {
                this.setNoteNumber(Integer.parseInt(ids[0]));
            }
            if (ids.length > 1) {
                this.setAnswerNoteNumber(Integer.parseInt(ids[1]));
            }
        }
    }

    public Grep.Region getRegion(String property) {
        return this.regions.get(property);
    }
}

