/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.generator;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.FreeColException;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Region;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileItemContainer;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.generator.MapLoader;
import net.sf.freecol.server.model.ServerIndianSettlement;
import net.sf.freecol.server.model.ServerPlayer;
import net.sf.freecol.server.model.ServerRegion;

public class FreeColMapLoader
implements MapLoader {
    private static final Logger logger = Logger.getLogger(FreeColMapLoader.class.getName());
    private Map importMap = null;

    public FreeColMapLoader(File file) throws FreeColException, IOException, XMLStreamException {
        this.importMap = FreeColServer.readMap(file, null);
    }

    @Override
    public Map.Layer loadMap(Game game, Map.Layer layer) {
        Map.Layer highestLayer = layer.compareTo(this.importMap.getLayer()) < 0 ? layer : this.importMap.getLayer();
        int width = this.importMap.getWidth();
        int height = this.importMap.getHeight();
        HashMap regions = new HashMap();
        Map map = new Map(game, width, height);
        if (highestLayer == Map.Layer.LAND) {
            map.populateTiles((x, y) -> new Tile(game, this.importMap.getTile((int)x, (int)y).getType().isWater() ? TileType.WATER : TileType.LAND, (int)x, (int)y));
        } else {
            map.populateTiles((x, y) -> {
                Tile template = this.importMap.getTile((int)x, (int)y);
                Tile tile = new Tile(game, null, (int)x, (int)y);
                tile.setType(game.getSpecification().getTileType(template.getType().getId()));
                tile.setMoveToEurope(template.getMoveToEurope());
                if (highestLayer.compareTo(Map.Layer.REGIONS) >= 0) {
                    Region region = template.getRegion();
                    if (region != null) {
                        ServerRegion ours = (ServerRegion)regions.get(region.getId());
                        if (ours == null) {
                            ours = new ServerRegion(game, region);
                            regions.put(region.getId(), ours);
                        }
                        tile.setRegion(ours);
                        ours.addTile(tile);
                    }
                    if (highestLayer.compareTo(Map.Layer.RIVERS) >= 0) {
                        TileItemContainer newTic = new TileItemContainer(game, tile);
                        newTic.copyFrom(template.getTileItemContainer(), layer);
                        tile.setTileItemContainer(newTic);
                        if (layer.compareTo(Map.Layer.NATIVES) >= 0 && template.getOwner() != null) {
                            String nationId = template.getOwner().getNationId();
                            Player player = game.getPlayerByNationId(nationId);
                            if (player == null) {
                                Nation nation = game.getSpecification().getNation(nationId);
                                player = new ServerPlayer(game, false, nation);
                                game.addPlayer(player);
                            }
                            tile.setOwner(player);
                            if (template.getOwningSettlement() != null) {
                                IndianSettlement is = (IndianSettlement)template.getOwningSettlement();
                                tile.setOwningSettlement(new ServerIndianSettlement(game, player, tile, is));
                            }
                        }
                    }
                }
                return tile;
            });
        }
        for (Region region : regions.values()) {
            map.addRegion(region);
        }
        map.setLayer(highestLayer);
        game.setMap(map);
        return highestLayer;
    }

    @Override
    public Map.Layer getHighestLayer() {
        return Map.Layer.NATIVES;
    }
}

