/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.lang;

import com.tngtech.archunit.ArchConfiguration;
import com.tngtech.archunit.base.HasDescription;
import com.tngtech.archunit.base.MayResolveTypesViaReflection;
import com.tngtech.archunit.base.ReflectionUtils;
import com.tngtech.archunit.lang.FailureDisplayFormat;
import com.tngtech.archunit.lang.FailureDisplayFormatInitializationFailedException;
import com.tngtech.archunit.lang.FailureMessages;
import com.tngtech.archunit.lang.Priority;
import com.tngtech.archunit.thirdparty.com.google.common.base.Joiner;

class FailureDisplayFormatFactory {
    private static final String FAILURE_DISPLAY_FORMAT_PROPERTY = "failureDisplayFormat";
    private static final FailureDisplayFormat DEFAULT_FAILURE_DISPLAY_FORMAT = new DefaultFailureDisplayFormat();

    FailureDisplayFormatFactory() {
    }

    static FailureDisplayFormat create() {
        return ArchConfiguration.get().containsProperty(FAILURE_DISPLAY_FORMAT_PROPERTY) ? FailureDisplayFormatFactory.createInstance(ArchConfiguration.get().getProperty(FAILURE_DISPLAY_FORMAT_PROPERTY)) : DEFAULT_FAILURE_DISPLAY_FORMAT;
    }

    @MayResolveTypesViaReflection(reason="This is not part of the import process")
    private static FailureDisplayFormat createInstance(String failureDisplayFormatClassName) {
        try {
            return (FailureDisplayFormat)ReflectionUtils.newInstanceOf(Class.forName(failureDisplayFormatClassName), new Object[0]);
        }
        catch (Exception e) {
            String message = String.format("Could not instantiate %s of configured type '%s=%s'", FailureDisplayFormat.class.getSimpleName(), FAILURE_DISPLAY_FORMAT_PROPERTY, failureDisplayFormatClassName);
            throw new FailureDisplayFormatInitializationFailedException(message, e);
        }
    }

    private static class DefaultFailureDisplayFormat
    implements FailureDisplayFormat {
        private DefaultFailureDisplayFormat() {
        }

        @Override
        public String formatFailure(HasDescription rule, FailureMessages failureMessages, Priority priority) {
            String violationTexts = Joiner.on(System.lineSeparator()).join(failureMessages);
            return String.format("Architecture Violation [Priority: %s] - Rule '%s' was violated (%s):%n%s", priority.asString(), rule.getDescription(), failureMessages.getInformationAboutNumberOfViolations(), violationTexts);
        }
    }
}

