/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsBreak;
import org.jetbrains.kotlin.js.backend.ast.JsCatch;
import org.jetbrains.kotlin.js.backend.ast.JsContinue;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsLabel;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.RecursiveJsVisitor;
import org.jetbrains.kotlin.js.inline.util.FunctionWithWrapper;
import org.jetbrains.kotlin.js.inline.util.collectors.InstanceCollector;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u001c\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0010\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\t\u001a\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\t2\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u001a\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\t0\f2\u0006\u0010\u0003\u001a\u00020\u0004\u001a(\u0010\r\u001a\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e0\f2\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0012\u001a\u00020\u0010H\u0002\u001a6\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00150\u0014\"\b\b\u0000\u0010\u0015*\u00020\u00042\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00150\u00172\u0006\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0018\u001a\u00020\u0007\u00a8\u0006\u0019"}, d2={"collectUsedNames", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "scope", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "collectDefinedNames", "skipLabelsAndCatches", "", "collectFreeVariables", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "collectLocalVariables", "collectNamedFunctions", "", "collectNamedFunctionsAndMetadata", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/js/inline/util/FunctionWithWrapper;", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "extractFunction", "expression", "collectInstances", "", "T", "klass", "Ljava/lang/Class;", "visitNestedDeclarations", "js.translator"})
@SourceDebugExtension(value={"SMAP\ncollectUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 collectUtils.kt\norg/jetbrains/kotlin/js/inline/util/CollectUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,164:1\n1563#2:165\n1634#2,3:166\n1563#2:169\n1634#2,3:170\n1252#2,4:175\n463#3:173\n413#3:174\n*S KotlinDebug\n*F\n+ 1 collectUtils.kt\norg/jetbrains/kotlin/js/inline/util/CollectUtilsKt\n*L\n101#1:165\n101#1:166,3\n103#1:169\n103#1:170,3\n105#1:175,4\n105#1:173\n105#1:174\n*E\n"})
public final class CollectUtilsKt {
    @NotNull
    public static final Set<JsName> collectUsedNames(@NotNull JsNode scope2) {
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Set references = new LinkedHashSet();
        new RecursiveJsVisitor(references){
            final /* synthetic */ Set<JsName> $references;
            {
                this.$references = $references;
            }

            public void visitBreak(JsBreak x2) {
                Intrinsics.checkNotNullParameter((Object)x2, (String)"x");
            }

            public void visitContinue(JsContinue x2) {
                Intrinsics.checkNotNullParameter((Object)x2, (String)"x");
            }

            public void visit(JsVars.JsVar x2) {
                Intrinsics.checkNotNullParameter((Object)x2, (String)"x");
                JsExpression initializer = x2.getInitExpression();
                if (initializer != null) {
                    this.accept((JsNode)initializer);
                }
            }

            public void visitNameRef(JsNameRef nameRef) {
                Intrinsics.checkNotNullParameter((Object)nameRef, (String)"nameRef");
                super.visitNameRef(nameRef);
                JsName name2 = nameRef.getName();
                if (name2 != null && nameRef.getQualifier() == null) {
                    this.$references.add(name2);
                }
            }

            public void visitFunction(JsFunction x2) {
                Intrinsics.checkNotNullParameter((Object)x2, (String)"x");
                CollectionsKt.addAll((Collection)this.$references, (Iterable)CollectUtilsKt.collectFreeVariables(x2));
            }
        }.accept(scope2);
        return references;
    }

    @NotNull
    public static final Set<JsName> collectDefinedNames(@NotNull JsNode scope2) {
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        return CollectUtilsKt.collectDefinedNames(scope2, false);
    }

    @NotNull
    public static final Set<JsName> collectDefinedNames(@NotNull JsNode scope2, boolean skipLabelsAndCatches) {
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Set names = new LinkedHashSet();
        new RecursiveJsVisitor(names, skipLabelsAndCatches){
            final /* synthetic */ Set<JsName> $names;
            final /* synthetic */ boolean $skipLabelsAndCatches;
            {
                this.$names = $names;
                this.$skipLabelsAndCatches = $skipLabelsAndCatches;
            }

            public void visit(JsVars.JsVar x2) {
                Intrinsics.checkNotNullParameter((Object)x2, (String)"x");
                JsExpression initializer = x2.getInitExpression();
                if (initializer != null) {
                    this.accept((JsNode)initializer);
                }
                ((Collection)this.$names).add(x2.getName());
            }

            public void visitExpressionStatement(JsExpressionStatement x2) {
                JsName name2;
                Intrinsics.checkNotNullParameter((Object)x2, (String)"x");
                JsExpression jsExpression = x2.getExpression();
                Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"getExpression(...)");
                JsExpression expression2 = jsExpression;
                if (expression2 instanceof JsFunction && (name2 = ((JsFunction)expression2).getName()) != null) {
                    ((Collection)this.$names).add(name2);
                }
                super.visitExpressionStatement(x2);
            }

            public void visitLabel(JsLabel x2) {
                Intrinsics.checkNotNullParameter((Object)x2, (String)"x");
                if (!this.$skipLabelsAndCatches) {
                    JsName jsName = x2.getName();
                    if (jsName != null) {
                        JsName jsName2 = jsName;
                        Set<JsName> set = this.$names;
                        JsName it = jsName2;
                        boolean bl = false;
                        ((Collection)set).add(it);
                    }
                }
                super.visitLabel(x2);
            }

            public void visitCatch(JsCatch x2) {
                Intrinsics.checkNotNullParameter((Object)x2, (String)"x");
                if (!this.$skipLabelsAndCatches) {
                    ((Collection)this.$names).add(x2.getParameter().getName());
                }
                super.visitCatch(x2);
            }

            public void visitFunction(JsFunction x2) {
                Intrinsics.checkNotNullParameter((Object)x2, (String)"x");
            }
        }.accept(scope2);
        return names;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<JsName> collectFreeVariables(@NotNull JsFunction $this$collectFreeVariables) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)$this$collectFreeVariables, (String)"<this>");
        JsBlock jsBlock = $this$collectFreeVariables.getBody();
        Intrinsics.checkNotNullExpressionValue((Object)jsBlock, (String)"getBody(...)");
        Set<JsName> set = CollectUtilsKt.collectUsedNames(jsBlock);
        JsBlock jsBlock2 = $this$collectFreeVariables.getBody();
        Intrinsics.checkNotNullExpressionValue((Object)jsBlock2, (String)"getBody(...)");
        Set set2 = SetsKt.minus(set, (Iterable)CollectUtilsKt.collectDefinedNames(jsBlock2));
        List<JsParameter> list = $this$collectFreeVariables.getParameters();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getParameters(...)");
        Iterable iterable = list;
        Set set3 = set2;
        boolean $i$f$map = false;
        void var3_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JsParameter jsParameter = (JsParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            JsName jsName = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)jsName, (String)"getName(...)");
            collection.add(jsName);
        }
        return SetsKt.minus((Set)set3, (Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<JsName> collectLocalVariables(@NotNull JsFunction $this$collectLocalVariables, boolean skipLabelsAndCatches) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)$this$collectLocalVariables, (String)"<this>");
        JsBlock jsBlock = $this$collectLocalVariables.getBody();
        Intrinsics.checkNotNullExpressionValue((Object)jsBlock, (String)"getBody(...)");
        Set<JsName> set = CollectUtilsKt.collectDefinedNames(jsBlock, skipLabelsAndCatches);
        List<JsParameter> list = $this$collectLocalVariables.getParameters();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getParameters(...)");
        Iterable iterable = list;
        Set<JsName> set2 = set;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JsParameter jsParameter = (JsParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            JsName jsName = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)jsName, (String)"getName(...)");
            collection.add(jsName);
        }
        return SetsKt.plus(set2, (Iterable)((List)destination$iv$iv));
    }

    public static /* synthetic */ Set collectLocalVariables$default(JsFunction jsFunction, boolean bl, int n2, Object object) {
        if ((n2 & 1) != 0) {
            bl = false;
        }
        return CollectUtilsKt.collectLocalVariables(jsFunction, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<JsName, JsFunction> collectNamedFunctions(@NotNull JsNode scope2) {
        void $this$associateByTo$iv$iv$iv;
        void $this$mapValuesTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Map<JsName, Pair<FunctionWithWrapper, JsExpression>> $this$mapValues$iv = CollectUtilsKt.collectNamedFunctionsAndMetadata(scope2);
        boolean $i$f$mapValues = false;
        Map<JsName, Pair<FunctionWithWrapper, JsExpression>> map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable iterable = $this$mapValuesTo$iv$iv.entrySet();
        Map destination$iv$iv$iv = destination$iv$iv;
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k2 = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            JsFunction jsFunction = ((FunctionWithWrapper)((Pair)it.getValue()).getFirst()).getFunction();
            map3.put(k2, jsFunction);
        }
        return destination$iv$iv$iv;
    }

    private static final Map<JsName, Pair<FunctionWithWrapper, JsExpression>> collectNamedFunctionsAndMetadata(JsNode scope2) {
        Map namedFunctions = new LinkedHashMap();
        scope2.accept(new RecursiveJsVisitor(namedFunctions){
            final /* synthetic */ Map<JsName, Pair<FunctionWithWrapper, JsExpression>> $namedFunctions;
            {
                this.$namedFunctions = $namedFunctions;
            }

            public void visitBinaryExpression(JsBinaryOperation x2) {
                Intrinsics.checkNotNullParameter((Object)x2, (String)"x");
                Pair<JsExpression, JsExpression> assignment = JsAstUtils.decomposeAssignment(x2);
                if (assignment != null) {
                    JsName name2;
                    Pair<JsExpression, JsExpression> pair = assignment;
                    JsExpression left = (JsExpression)pair.component1();
                    JsExpression right = (JsExpression)pair.component2();
                    if (left instanceof JsNameRef && (name2 = ((JsNameRef)left).getName()) != null) {
                        Intrinsics.checkNotNull((Object)right);
                        FunctionWithWrapper functionWithWrapper = CollectUtilsKt.access$extractFunction(right);
                        if (functionWithWrapper != null) {
                            FunctionWithWrapper functionWithWrapper2 = functionWithWrapper;
                            Map<JsName, Pair<FunctionWithWrapper, JsExpression>> map = this.$namedFunctions;
                            FunctionWithWrapper functionWithWrapper3 = functionWithWrapper2;
                            boolean bl = false;
                            JsFunction function2 = functionWithWrapper3.component1();
                            JsBlock wrapper = functionWithWrapper3.component2();
                            map.put(name2, (Pair<FunctionWithWrapper, JsExpression>)new Pair((Object)new FunctionWithWrapper(function2, wrapper), (Object)right));
                        }
                    }
                }
                super.visitBinaryExpression(x2);
            }

            public void visit(JsVars.JsVar x2) {
                Intrinsics.checkNotNullParameter((Object)x2, (String)"x");
                JsExpression initializer = x2.getInitExpression();
                JsName name2 = x2.getName();
                if (initializer != null && name2 != null) {
                    FunctionWithWrapper functionWithWrapper = CollectUtilsKt.access$extractFunction(initializer);
                    if (functionWithWrapper != null) {
                        FunctionWithWrapper functionWithWrapper2 = functionWithWrapper;
                        Map<JsName, Pair<FunctionWithWrapper, JsExpression>> map = this.$namedFunctions;
                        FunctionWithWrapper function2 = functionWithWrapper2;
                        boolean bl = false;
                        map.put(name2, (Pair<FunctionWithWrapper, JsExpression>)new Pair((Object)function2, (Object)initializer));
                    }
                }
                super.visit(x2);
            }

            public void visitFunction(JsFunction x2) {
                Intrinsics.checkNotNullParameter((Object)x2, (String)"x");
                JsName name2 = x2.getName();
                if (name2 != null) {
                    this.$namedFunctions.put(name2, (Pair<FunctionWithWrapper, JsExpression>)new Pair((Object)new FunctionWithWrapper(x2, null), (Object)x2));
                }
                super.visitFunction(x2);
            }
        });
        return namedFunctions;
    }

    private static final FunctionWithWrapper extractFunction(JsExpression expression2) {
        return expression2 instanceof JsFunction ? new FunctionWithWrapper((JsFunction)expression2, null) : null;
    }

    @NotNull
    public static final <T extends JsNode> List<T> collectInstances(@NotNull Class<T> klass, @NotNull JsNode scope2, boolean visitNestedDeclarations) {
        Intrinsics.checkNotNullParameter(klass, (String)"klass");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        InstanceCollector<JsNode> $this$collectInstances_u24lambda_u240 = new InstanceCollector<JsNode>(klass, visitNestedDeclarations);
        boolean bl = false;
        $this$collectInstances_u24lambda_u240.accept(scope2);
        return $this$collectInstances_u24lambda_u240.getCollected();
    }

    public static /* synthetic */ List collectInstances$default(Class clazz, JsNode jsNode, boolean bl, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bl = false;
        }
        return CollectUtilsKt.collectInstances(clazz, jsNode, bl);
    }

    public static final /* synthetic */ FunctionWithWrapper access$extractFunction(JsExpression expression2) {
        return CollectUtilsKt.extractFunction(expression2);
    }
}

