/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.internal.component.local.model.LocalFileDependencyMetadata;
import org.gradle.internal.component.local.model.LocalVariantGraphResolveState;
import org.gradle.internal.component.model.ExcludeMetadata;
import org.gradle.internal.component.model.LocalOriginDependencyMetadata;
import org.gradle.internal.model.CalculatedValueContainerFactory;
import org.gradle.internal.model.ModelContainer;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;

@ServiceScope(value={Scope.BuildTree.class})
public interface LocalVariantGraphResolveStateBuilder {
    public LocalVariantGraphResolveState createRootVariantState(ConfigurationInternal var1, ComponentIdentifier var2, DependencyCache var3, ModelContainer<?> var4, CalculatedValueContainerFactory var5);

    public LocalVariantGraphResolveState createConsumableVariantState(ConfigurationInternal var1, ComponentIdentifier var2, DependencyCache var3, ModelContainer<?> var4, CalculatedValueContainerFactory var5);

    public static class DependencyState {
        public final ImmutableList<LocalOriginDependencyMetadata> dependencies;
        public final ImmutableSet<LocalFileDependencyMetadata> files;
        public final ImmutableList<ExcludeMetadata> excludes;

        public DependencyState(ImmutableList<LocalOriginDependencyMetadata> dependencies, ImmutableSet<LocalFileDependencyMetadata> files, ImmutableList<ExcludeMetadata> excludes) {
            this.dependencies = dependencies;
            this.files = files;
            this.excludes = excludes;
        }
    }

    public static class DependencyCache {
        private final Map<String, DependencyState> cache = new HashMap<String, DependencyState>();

        public DependencyState computeIfAbsent(ConfigurationInternal configuration, Function<ConfigurationInternal, DependencyState> factory) {
            DependencyState state = this.cache.get(configuration.getName());
            if (state == null) {
                state = factory.apply(configuration);
                this.cache.put(configuration.getName(), state);
            }
            return state;
        }

        public void invalidate() {
            this.cache.clear();
        }
    }
}

