/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Fast binary dilation of a single intensity value in the image.


BinaryDilateImageFilter is a binary dilation morphologic operation on the foreground of an
image. Only the value designated by the intensity value
"SetForegroundValue()" (alias as SetDilateValue() ) is considered as
foreground, and other intensity values are considered background.

Grayscale images can be processed as binary images by selecting a
"ForegroundValue" (alias "DilateValue"). Pixel values matching the
dilate value are considered the "foreground" and all other pixels
are "background". This is useful in processing segmented images
where all pixels in segment #1 have value 1 and pixels in segment #2
have value 2, etc. A particular "segment number" can be processed.
ForegroundValue defaults to the maximum possible value of the
PixelType.

The structuring element is assumed to be composed of binary values
(zero or one). Only elements of the structuring element having values
&gt; 0 are candidates for affecting the center pixel. A reasonable
choice of structuring element is itk::BinaryBallStructuringElement .

This implementation is based on the papers:

L.Vincent "Morphological transformations of binary images with
arbitrary structuring elements", and

N.Nikopoulos et al. "An efficient algorithm for 3d binary
morphological transformations with 3d structuring elements for
arbitrary size and shape". IEEE Transactions on Image Processing. Vol. 9. No. 3. 2000. pp. 283-286.


See:
 ImageToImageFilter BinaryErodeImageFilter BinaryMorphologyImageFilter

 itk::simple::BinaryDilate for the procedural interface

 itk::BinaryDilateImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkBinaryDilateImageFilter.h
*/
public class BinaryDilateImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected BinaryDilateImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.BinaryDilateImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(BinaryDilateImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(BinaryDilateImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::BinaryDilateImageFilter::~BinaryDilateImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_BinaryDilateImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::BinaryDilateImageFilter::BinaryDilateImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  BinaryDilateImageFilter() {
    this(SimpleITKJNI.new_BinaryDilateImageFilter(), true);
  }

  /**
Self&amp; itk::simple::BinaryDilateImageFilter::SetKernelRadius(unsigned int value)

Set the values of the KernelRadius vector all to value

*/
public  void setKernelRadius(VectorUInt32 KernelRadius) {
    SimpleITKJNI.BinaryDilateImageFilter_setKernelRadius__SWIG_0(swigCPtr, this, VectorUInt32.getCPtr(KernelRadius), KernelRadius);
  }

  /**
Self&amp; itk::simple::BinaryDilateImageFilter::SetKernelRadius(unsigned int value)

Set the values of the KernelRadius vector all to value

*/
public  void setKernelRadius(long value) {
    SimpleITKJNI.BinaryDilateImageFilter_setKernelRadius__SWIG_1(swigCPtr, this, value);
  }

  /**
std::vector&lt;unsigned int&gt; itk::simple::BinaryDilateImageFilter::GetKernelRadius() const

Get the radius of the kernel structuring element.

*/
public  VectorUInt32 getKernelRadius() {
    return new VectorUInt32(SimpleITKJNI.BinaryDilateImageFilter_getKernelRadius(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::BinaryDilateImageFilter::SetKernelType(KernelEnum KernelType)

Set the kernel or structuring element used for the morphology.

*/
public  void setKernelType(KernelEnum KernelType) {
    SimpleITKJNI.BinaryDilateImageFilter_setKernelType(swigCPtr, this, KernelType.swigValue());
  }

  /**
KernelEnum itk::simple::BinaryDilateImageFilter::GetKernelType() const

Get the kernel or structuring element used for the morphology.

*/
public  KernelEnum getKernelType() {
    return KernelEnum.swigToEnum(SimpleITKJNI.BinaryDilateImageFilter_getKernelType(swigCPtr, this));
  }

  /**
Self&amp; itk::simple::BinaryDilateImageFilter::SetBackgroundValue(double BackgroundValue)
*/
public  void setBackgroundValue(double BackgroundValue) {
    SimpleITKJNI.BinaryDilateImageFilter_setBackgroundValue(swigCPtr, this, BackgroundValue);
  }

  /**
double itk::simple::BinaryDilateImageFilter::GetBackgroundValue() const
*/
public  double getBackgroundValue() {
    return SimpleITKJNI.BinaryDilateImageFilter_getBackgroundValue(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::BinaryDilateImageFilter::SetForegroundValue(double ForegroundValue)
*/
public  void setForegroundValue(double ForegroundValue) {
    SimpleITKJNI.BinaryDilateImageFilter_setForegroundValue(swigCPtr, this, ForegroundValue);
  }

  /**
double itk::simple::BinaryDilateImageFilter::GetForegroundValue() const
*/
public  double getForegroundValue() {
    return SimpleITKJNI.BinaryDilateImageFilter_getForegroundValue(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::BinaryDilateImageFilter::SetBoundaryToForeground(bool BoundaryToForeground)
*/
public  void setBoundaryToForeground(boolean BoundaryToForeground) {
    SimpleITKJNI.BinaryDilateImageFilter_setBoundaryToForeground(swigCPtr, this, BoundaryToForeground);
  }

  /**
Self&amp; itk::simple::BinaryDilateImageFilter::BoundaryToForegroundOn()

Set the value of BoundaryToForeground to true or false respectfully.

*/
public  void boundaryToForegroundOn() {
    SimpleITKJNI.BinaryDilateImageFilter_boundaryToForegroundOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::BinaryDilateImageFilter::BoundaryToForegroundOff()
*/
public  void boundaryToForegroundOff() {
    SimpleITKJNI.BinaryDilateImageFilter_boundaryToForegroundOff(swigCPtr, this);
  }

  /**
bool itk::simple::BinaryDilateImageFilter::GetBoundaryToForeground() const
*/
public  boolean getBoundaryToForeground() {
    return SimpleITKJNI.BinaryDilateImageFilter_getBoundaryToForeground(swigCPtr, this);
  }

  /**
std::string itk::simple::BinaryDilateImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.BinaryDilateImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::BinaryDilateImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.BinaryDilateImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::BinaryDilateImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.BinaryDilateImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
