/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.core.xml.persist;

import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.collection.Pair;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.persist.AbstractConditionalLoadXMLObjectLoadSaveManager;
import org.slf4j.Logger;

@NotThreadSafe
public class MapLoadSaveManager<T extends XMLObject>
extends AbstractConditionalLoadXMLObjectLoadSaveManager<T> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(MapLoadSaveManager.class);
    @Nonnull
    private Map<String, T> backingMap;
    @Nonnull
    private Map<String, Instant> dataLastModified;

    public MapLoadSaveManager() {
        this(new HashMap(), new HashMap<String, Instant>(), false);
    }

    public MapLoadSaveManager(@ParameterName(name="conditionalLoad") boolean conditionalLoad) {
        this(new HashMap(), new HashMap<String, Instant>(), conditionalLoad);
    }

    public MapLoadSaveManager(@ParameterName(name="map") @Nonnull Map<String, T> map) {
        this(map, new HashMap<String, Instant>(), false);
    }

    protected MapLoadSaveManager(@ParameterName(name="map") @Nonnull Map<String, T> map, @ParameterName(name="dataLastModified") @Nonnull Map<String, Instant> lastModifiedMap, @ParameterName(name="conditionalLoad") boolean conditionalLoad) {
        super(conditionalLoad);
        this.backingMap = Constraint.isNotNull(map, "Backing map was null");
        this.dataLastModified = Constraint.isNotNull(lastModifiedMap, "Data last modified map was null");
    }

    @Override
    @Nonnull
    @NotLive
    @Unmodifiable
    public Set<String> listKeys() throws IOException {
        return CollectionSupport.copyToSet(this.backingMap.keySet());
    }

    @Override
    @Nonnull
    @NotLive
    @Unmodifiable
    public Iterable<Pair<String, T>> listAll() throws IOException {
        ArrayList<Pair<String, T>> list = new ArrayList<Pair<String, T>>();
        for (String key : this.listKeys()) {
            assert (key != null);
            list.add(new Pair<String, T>(key, this.load(key)));
        }
        return CollectionSupport.copyToList(list);
    }

    @Override
    public boolean exists(@Nonnull String key) throws IOException {
        return this.backingMap.containsKey(key);
    }

    @Override
    public T load(@Nonnull String key) throws IOException {
        if (!this.exists(key)) {
            this.log.debug("Target data with key '{}' does not exist", (Object)key);
            this.clearLoadLastModified(key);
            return null;
        }
        if (this.isLoadConditionally() && this.isUnmodifiedSinceLastLoad(key)) {
            this.log.debug("Target data with key '{}' has not been modified since the last request, returning null", (Object)key);
            return null;
        }
        this.updateLoadLastModified(key, this.dataLastModified.get(key));
        return (T)((XMLObject)this.backingMap.get(key));
    }

    @Override
    public void save(@Nonnull String key, @Nonnull T xmlObject) throws IOException {
        this.save(key, xmlObject, false);
    }

    @Override
    public void save(@Nonnull String key, @Nonnull T xmlObject, boolean overwrite) throws IOException {
        if (!overwrite && this.exists(key)) {
            throw new IOException(String.format("Value already exists for key '%s'", key));
        }
        this.backingMap.put(key, xmlObject);
        this.dataLastModified.put(key, Instant.now());
    }

    @Override
    public boolean remove(@Nonnull String key) throws IOException {
        XMLObject removed = (XMLObject)this.backingMap.remove(key);
        this.dataLastModified.remove(key);
        this.clearLoadLastModified(key);
        return removed != null;
    }

    @Override
    public boolean updateKey(@Nonnull String currentKey, @Nonnull String newKey) throws IOException {
        XMLObject value = (XMLObject)this.backingMap.get(currentKey);
        if (value == null) {
            return false;
        }
        if (this.backingMap.containsKey(newKey)) {
            throw new IOException(String.format("Specified new key already exists: %s", newKey));
        }
        this.backingMap.put(newKey, value);
        this.backingMap.remove(currentKey);
        this.dataLastModified.put(newKey, this.dataLastModified.get(currentKey));
        this.dataLastModified.remove(currentKey);
        this.updateLoadLastModified(newKey, this.getLoadLastModified(currentKey));
        this.clearLoadLastModified(currentKey);
        return true;
    }

    @Override
    protected boolean isUnmodifiedSinceLastLoad(@Nonnull String key) throws IOException {
        Instant lastModified = this.dataLastModified.get(key);
        this.log.trace("Key '{}' last modified was: {}", (Object)key, (Object)lastModified);
        return this.getLoadLastModified(key) != null && lastModified != null && !lastModified.isAfter(this.getLoadLastModified(key));
    }
}

