/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.breadcrumb;

import com.google.common.base.Preconditions;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.protege.editor.core.util.ClickHandler;
import org.protege.editor.core.util.HandlerRegistration;
import org.protege.editor.owl.model.OWLWorkspace;
import org.protege.editor.owl.ui.breadcrumb.Breadcrumb;
import org.protege.editor.owl.ui.breadcrumb.BreadcrumbTrailProvider;
import org.protege.editor.owl.ui.breadcrumb.BreadcrumbTrailView;

public class BreadcrumbTrailPresenter {
    @Nonnull
    private final OWLWorkspace workspace;
    @Nonnull
    private final BreadcrumbTrailView breadcrumbTrailView;
    private HandlerRegistration handlerRegistration = () -> {};

    public BreadcrumbTrailPresenter(@Nonnull OWLWorkspace workspace, @Nonnull BreadcrumbTrailView breadcrumbTrailView) {
        this.workspace = (OWLWorkspace)Preconditions.checkNotNull((Object)workspace);
        this.breadcrumbTrailView = (BreadcrumbTrailView)Preconditions.checkNotNull((Object)breadcrumbTrailView);
    }

    @Nonnull
    public BreadcrumbTrailView getBreadcrumbTrailView() {
        return this.breadcrumbTrailView;
    }

    public void start() {
        this.handlerRegistration = this.workspace.addBreadcrumbTrailChangedHandler(this::updateDisplayedBreadcrumbTrail);
        this.breadcrumbTrailView.setBreadcrumbClickedHandler((ClickHandler<Breadcrumb>)((ClickHandler)clickedBreadcrumb -> this.workspace.getBreadcrumbTrailProvider().ifPresent(p -> p.goToBreadcrumb((Breadcrumb)clickedBreadcrumb))));
        this.updateDisplayedBreadcrumbTrail();
    }

    private void updateDisplayedBreadcrumbTrail() {
        Optional<BreadcrumbTrailProvider> provider = this.workspace.getBreadcrumbTrailProvider();
        provider.ifPresent(p -> this.breadcrumbTrailView.setDisplayedBreadcrumbTrail(p.getBreadcrumbTrail()));
        if (!provider.isPresent()) {
            this.breadcrumbTrailView.clearDisplayedBreadcrumbTrail();
        }
    }

    public void dispose() {
        this.handlerRegistration.removeHandler();
    }
}

