/*
 * Decompiled with CFR 0.152.
 */
package org.coode.mdock;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.coode.mdock.Node;
import org.coode.mdock.SplitterNode;

public abstract class Splitter
extends JPanel {
    public static final int SPLITTER_WIDTH = 6;
    private SplitterNode node;
    private Node child0;
    private Node child1;
    Point startPoint;
    Point endPoint;
    private boolean mouseDown;
    private Cursor defaultCursor;

    protected Splitter(SplitterNode node, Node child0, Node child1) {
        this.node = node;
        this.child0 = child0;
        this.child1 = child1;
        this.setOpaque(true);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Splitter.this.setBackground(Color.GRAY);
                Splitter.this.mouseDown = true;
                Splitter.this.startDragging(e.getPoint());
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                Splitter.this.setBackground(null);
                Splitter.this.mouseDown = false;
                Splitter.this.endDragging(e.getPoint());
                if (Splitter.this.getMousePosition() == null) {
                    Splitter.this.restoreDefaultCursor();
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                Splitter.this.defaultCursor = Splitter.this.getCursor();
                Splitter.this.setSplitterCursor();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (!Splitter.this.mouseDown) {
                    Splitter.this.restoreDefaultCursor();
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                Point p = SwingUtilities.convertPoint(Splitter.this, e.getPoint(), Splitter.this.getParent());
                Splitter.this.setLocation(p);
            }
        });
    }

    protected abstract void setSplitterCursor();

    protected void restoreDefaultCursor() {
        this.setCursor(this.defaultCursor);
    }

    @Override
    public void setLocation(int x, int y) {
        Point minLoc = this.getMinLocation();
        Point maxLoc = this.getMaxLocation();
        if (x < minLoc.x) {
            x = minLoc.x;
        }
        if (y < minLoc.y) {
            y = minLoc.y;
        }
        if (x > maxLoc.x) {
            x = maxLoc.x;
        }
        if (y > maxLoc.y) {
            y = maxLoc.y;
        }
        super.setLocation(x, y);
    }

    public SplitterNode getNode() {
        return this.node;
    }

    public Node getChild0() {
        return this.child0;
    }

    public Node getChild1() {
        return this.child1;
    }

    public abstract void resetBounds();

    public abstract Point getMaxLocation();

    public abstract Point getMinLocation();

    public void startDragging(Point pt) {
        this.startPoint = this.getLocation();
    }

    protected abstract int convertToLocation(Point var1);

    protected abstract int getSpan(Node var1, Component var2, boolean var3);

    public void endDragging(Point pt) {
        this.endPoint = this.getLocation();
        int delta = this.convertToLocation(this.endPoint) - this.convertToLocation(this.startPoint);
        int totalChildSpan = this.getSpan(this.getChild0(), this.getParent(), false) + this.getSpan(this.getChild1(), this.getParent(), false);
        double span = this.getNode().getSplit(this.getChild0()) + this.getNode().getSplit(this.getChild1());
        double splitterDelta = span * (double)delta / (double)totalChildSpan;
        double split0 = this.getNode().getSplit(this.getChild0()) + splitterDelta;
        double split1 = this.getNode().getSplit(this.getChild1()) - splitterDelta;
        this.getNode().setSplit(this.getChild0(), split0);
        this.getNode().setSplit(this.getChild1(), split1);
        this.getParent().validate();
    }
}

