# This file has been autogenerated by the pywayland scanner

# Copyright © 2024 Xaver Hugl
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice (including the next
# paragraph) shall be included in all copies or substantial portions of the
# Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.

from __future__ import annotations

import enum

from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)

from ..wayland import WlSurface
from .wp_alpha_modifier_surface_v1 import WpAlphaModifierSurfaceV1


class WpAlphaModifierV1(Interface):
    """Surface alpha modifier manager

    This interface allows a client to set a factor for the alpha values on a
    surface, which can be used to offload such operations to the compositor,
    which can in turn for example offload them to KMS.

    Warning! The protocol described in this file is currently in the testing
    phase. Backward compatible changes may be added together with the
    corresponding interface version bump. Backward incompatible changes can
    only be done by creating a new major version of the extension.
    """

    name = "wp_alpha_modifier_v1"
    version = 1

    class error(enum.IntEnum):
        already_constructed = 0


class WpAlphaModifierV1Proxy(Proxy[WpAlphaModifierV1]):
    interface = WpAlphaModifierV1

    @WpAlphaModifierV1.request()
    def destroy(self) -> None:
        """Destroy the alpha modifier manager object

        Destroy the alpha modifier manager. This doesn't destroy objects
        created with the manager.
        """
        self._marshal(0)
        self._destroy()

    @WpAlphaModifierV1.request(
        Argument(ArgumentType.NewId, interface=WpAlphaModifierSurfaceV1),
        Argument(ArgumentType.Object, interface=WlSurface),
    )
    def get_surface(self, surface: WlSurface) -> Proxy[WpAlphaModifierSurfaceV1]:
        """Create a new alpha modifier surface object

        Create a new alpha modifier surface object associated with the given
        :class:`~pywayland.protocol.wayland.WlSurface`. If there is already
        such an object associated with the
        :class:`~pywayland.protocol.wayland.WlSurface`, the already_constructed
        error will be raised.

        :param surface:
        :type surface:
            :class:`~pywayland.protocol.wayland.WlSurface`
        :returns:
            :class:`~pywayland.protocol.alpha_modifier_v1.WpAlphaModifierSurfaceV1`
        """
        id = self._marshal_constructor(1, WpAlphaModifierSurfaceV1, surface)
        return id


class WpAlphaModifierV1Resource(Resource):
    interface = WpAlphaModifierV1


class WpAlphaModifierV1Global(Global):
    interface = WpAlphaModifierV1


WpAlphaModifierV1._gen_c()
WpAlphaModifierV1.proxy_class = WpAlphaModifierV1Proxy
WpAlphaModifierV1.resource_class = WpAlphaModifierV1Resource
WpAlphaModifierV1.global_class = WpAlphaModifierV1Global
